package com.xdja.poc.sdk.dameon;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.os.SystemClock;
import android.support.annotation.Nullable;

import com.xdja.poc.sdk.business.POCService;

import static com.xdja.poc.sdk.business.PocNotificationService.NOTIFY_ID;

public class CancelNoticeService extends Service {
    @Nullable
    @Override
    public IBinder onBind(Intent intent) {
        return null;  
    }  
   
    @Override
    public void onCreate() {  
        super.onCreate();  
    }  
   
    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        if(Build.VERSION.SDK_INT > Build.VERSION_CODES.JELLY_BEAN_MR2){
            Notification.Builder builder = new Notification.Builder(this);
            // 开启一条线程,去移除DaemonService弹出的通知
            new Thread(new Runnable() {
                @Override
                public void run() {  
                    // 延迟1s  
                    SystemClock.sleep(1000);
                    // 取消CancelNoticeService的前台  
                    stopForeground(true);  
                    // 移除DaemonService弹出的通知  
                    NotificationManager manager = (NotificationManager)getSystemService(NOTIFICATION_SERVICE);
                    assert manager != null;
                    manager.cancel(NOTIFY_ID);
                    // 任务完成,终止自己
                    stopSelf();
                }  
            }).start();  
        }  
        return super.onStartCommand(intent, flags, startId);  
    }  
   
   
    @Override
    public void onDestroy() {  
        super.onDestroy();  
    }  
}