package com.xdja.poc.sdk.greendao.dao;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import com.xdja.poc.sdk.record.RecordMessage;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "record_table".
*/
public class RecordBeanDao extends AbstractDao<RecordMessage, String> {

    public static final String TABLENAME = "record_table";

    /**
     * Properties of entity RecordMessage.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property RecordUri = new Property(0, String.class, "recordUri", true, "RECORD_URI");
        public final static Property RecordRemoteUrl = new Property(1, String.class, "recordRemoteUrl", false, "RECORD_REMOTE_URL");
        public final static Property RecordRoom = new Property(2, String.class, "recordRoom", false, "RECORD_ROOM");
        public final static Property RecordName = new Property(3, String.class, "recordName", false, "RECORD_NAME");
        public final static Property RecordSize = new Property(4, String.class, "recordSize", false, "RECORD_SIZE");
        public final static Property RecordTimeLen = new Property(5, String.class, "recordTimeLen", false, "RECORD_TIME_LEN");
        public final static Property RecordMessageId = new Property(6, String.class, "recordMessageId", false, "RECORD_MESSAGE_ID");
    }


    public RecordBeanDao(DaoConfig config) {
        super(config);
    }
    
    public RecordBeanDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"record_table\" (" + //
                "\"RECORD_URI\" TEXT PRIMARY KEY NOT NULL ," + // 0: recordUri
                "\"RECORD_REMOTE_URL\" TEXT," + // 1: recordRemoteUrl
                "\"RECORD_ROOM\" TEXT," + // 2: recordRoom
                "\"RECORD_NAME\" TEXT," + // 3: recordName
                "\"RECORD_SIZE\" TEXT," + // 4: recordSize
                "\"RECORD_TIME_LEN\" TEXT," + // 5: recordTimeLen
                "\"RECORD_MESSAGE_ID\" TEXT);"); // 6: recordMessageId
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"record_table\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, RecordMessage entity) {
        stmt.clearBindings();
 
        String recordUri = entity.getRecordUri();
        if (recordUri != null) {
            stmt.bindString(1, recordUri);
        }
 
        String recordRemoteUrl = entity.getRecordRemoteUrl();
        if (recordRemoteUrl != null) {
            stmt.bindString(2, recordRemoteUrl);
        }
 
        String recordRoom = entity.getRecordRoom();
        if (recordRoom != null) {
            stmt.bindString(3, recordRoom);
        }
 
        String recordName = entity.getRecordName();
        if (recordName != null) {
            stmt.bindString(4, recordName);
        }
 
        String recordSize = entity.getRecordSize();
        if (recordSize != null) {
            stmt.bindString(5, recordSize);
        }
 
        String recordTimeLen = entity.getRecordTimeLen();
        if (recordTimeLen != null) {
            stmt.bindString(6, recordTimeLen);
        }
 
        String recordMessageId = entity.getRecordMessageId();
        if (recordMessageId != null) {
            stmt.bindString(7, recordMessageId);
        }
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, RecordMessage entity) {
        stmt.clearBindings();
 
        String recordUri = entity.getRecordUri();
        if (recordUri != null) {
            stmt.bindString(1, recordUri);
        }
 
        String recordRemoteUrl = entity.getRecordRemoteUrl();
        if (recordRemoteUrl != null) {
            stmt.bindString(2, recordRemoteUrl);
        }
 
        String recordRoom = entity.getRecordRoom();
        if (recordRoom != null) {
            stmt.bindString(3, recordRoom);
        }
 
        String recordName = entity.getRecordName();
        if (recordName != null) {
            stmt.bindString(4, recordName);
        }
 
        String recordSize = entity.getRecordSize();
        if (recordSize != null) {
            stmt.bindString(5, recordSize);
        }
 
        String recordTimeLen = entity.getRecordTimeLen();
        if (recordTimeLen != null) {
            stmt.bindString(6, recordTimeLen);
        }
 
        String recordMessageId = entity.getRecordMessageId();
        if (recordMessageId != null) {
            stmt.bindString(7, recordMessageId);
        }
    }

    @Override
    public String readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset) ? null : cursor.getString(offset);
    }    

    @Override
    public RecordMessage readEntity(Cursor cursor, int offset) {
        RecordMessage entity = new RecordMessage( //
            cursor.isNull(offset) ? null : cursor.getString(offset), // recordUri
            cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1), // recordRemoteUrl
            cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), // recordRoom
            cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3), // recordName
            cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4), // recordSize
            cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5), // recordTimeLen
            cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6) // recordMessageId
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, RecordMessage entity, int offset) {
        entity.setRecordUri(cursor.isNull(offset) ? null : cursor.getString(offset));
        entity.setRecordRemoteUrl(cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1));
        entity.setRecordRoom(cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2));
        entity.setRecordName(cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3));
        entity.setRecordSize(cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4));
        entity.setRecordTimeLen(cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5));
        entity.setRecordMessageId(cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6));
     }
    
    @Override
    protected final String updateKeyAfterInsert(RecordMessage entity, long rowId) {
        return entity.getRecordUri();
    }
    
    @Override
    public String getKey(RecordMessage entity) {
        if(entity != null) {
            return entity.getRecordUri();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(RecordMessage entity) {
        return entity.getRecordUri() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
