package com.xdja.poc.sdk.manager;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.PowerManager;

/**
 * 
 * @author xdjaxa mgg
 * 监听屏幕锁屏
 */
public class ScreenObserverManager {

	private OnScreenStateUpdateListener mOnScreenStateUpdateListener;
	private ScreenBroadcastReceiver mScreenBroadcastReceiver;
	private Context mContext;
	
	
	public  ScreenObserverManager(Context context){
		this.mContext=context;
		mScreenBroadcastReceiver=new ScreenBroadcastReceiver();
	}
	
	private class ScreenBroadcastReceiver extends BroadcastReceiver{

		@Override
		public void onReceive(Context context, Intent intent) {
			if(Intent.ACTION_SCREEN_ON.equals(intent.getAction())){
				mOnScreenStateUpdateListener.onScreenOn();
			}else if(Intent.ACTION_SCREEN_OFF.equals(intent.getAction())){
				mOnScreenStateUpdateListener.onScreenOff();
			}else if(Intent.ACTION_USER_PRESENT.equals(intent.getAction())){
				mOnScreenStateUpdateListener.onUserPresent();
			}
		}
	}
	
	public interface OnScreenStateUpdateListener{
		public void onScreenOn();
		public void onScreenOff();
		public void onUserPresent();
	}
	
	public void register(OnScreenStateUpdateListener listener){
		registerListener();
		mOnScreenStateUpdateListener=listener;
		getScreenState();
	}
	
	public void unregister(OnScreenStateUpdateListener listener){
		try {
			mContext.getApplicationContext().unregisterReceiver(mScreenBroadcastReceiver);
			mOnScreenStateUpdateListener=null;
		}catch (Exception e){

		}
	}
	private void getScreenState() {
		PowerManager mPowerManager=(PowerManager)mContext.getSystemService(Context.POWER_SERVICE);
		assert mPowerManager != null;
		if(mPowerManager.isScreenOn()){
			if(mOnScreenStateUpdateListener!=null){
				mOnScreenStateUpdateListener.onScreenOn();
			}
		}else{
			if(mOnScreenStateUpdateListener!=null){
				mOnScreenStateUpdateListener.onScreenOff();
			}
		}
	}

	private void registerListener() {
		try {
			if(mOnScreenStateUpdateListener!=null){
				unregister(null);
			}
			IntentFilter mIntentFilter=new IntentFilter();
			mIntentFilter.addAction(Intent.ACTION_SCREEN_ON);
			mIntentFilter.addAction(Intent.ACTION_SCREEN_OFF);
			mIntentFilter.addAction(Intent.ACTION_USER_PRESENT);
			mContext.getApplicationContext().registerReceiver(mScreenBroadcastReceiver, mIntentFilter);
		}catch (Exception e){

		}

	}
}
