package com.xdja.poc.sdk.proxy;

/**
 * 对讲录音回调
 * Created by xdjaxa on 2019/1/10.
 */

public interface IPOCRecordCallBack {

    /**
     * 录音完成
     *
     * @param roomId
     * @param mp3RecordUri
     */
    void onRecordCompleted(String roomId, String mp3RecordUri);

    /**
     * 上传录音完成
     *
     * @param mp3RecordUri
     * @param fileId
     * @param errorCode
     */
    void onRecordUploadResult(String mp3RecordUri, String fileId, int errorCode);

    /**
     * 提交录音记录完成
     *
     * @param mp3RecordUri
     * @param errorCode
     */
    void onRecordCommitResult(String mp3RecordUri, int errorCode);
}
