package com.xdja.poc.sdk.record.api;

import com.xdja.net.RetrofitUtil;
import com.xdja.poc.sdk.BuildConfig;
import com.xdja.poc.sdk.utils.IPHost;

/**
 * RecordApi工厂类，简单封装
 * Created by xdjaxa on 2019/1/10.
 */

public class RecordApiFactory {

    private static IRecordApi recordApi;

    public static IRecordApi getRecordApi() {
        if (recordApi == null) {
            synchronized (RecordApiFactory.class) {
                if (recordApi == null) {
                    recordApi = RetrofitUtil.getApiService(IRecordApi.class, IPHost.getMisServer());
                }
            }
        }
        return recordApi;
    }
}
