package com.xdja.poc.sdk.ui.conversion.audioview;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.util.Log;
import android.widget.ImageView;

import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.R;

import java.lang.ref.WeakReference;

/**
 * PoliceLauncher
 * 功能
 * 描述
 * created by Wwq : 2019/4/1
 */

public class AudioEffectPresenter implements Drawable.Callback {
    private VolumeDrawable volumeDrawable;
    private String TAG = "AudioEffect";
    private String mRoomId;
    private Context mContext;
    private WeakReference weakReference;
    private THandler handler;
     /**/

    public AudioEffectPresenter(Context context, ImageView imageView, String roomId) {
        this.mContext = context;
        this.mRoomId = roomId;
        this.volumeDrawable = new VolumeDrawable();
        this.volumeDrawable.setCallback(this);
        this.volumeDrawable.setLineWidth(GlobalContext.getContext().getResources().getInteger(R.integer.poc_audio_effect_line_width));
        this.volumeDrawable.setMinHeight(3);
        this.volumeDrawable.setStepWidth(GlobalContext.getContext().getResources().getInteger(R.integer.poc_audio_effect_step_width));
        imageView.setImageDrawable(volumeDrawable);
        handler = new THandler(this);
    }

    public void start() {
        handler.removeCallbacks(null);
        handler.removeMessages(0);
        volumeDrawable.start();
        handler.sendEmptyMessageDelayed(0, 200);
    }

    public void stop() {
        handler.removeMessages(0);
        handler.removeCallbacks(null);
        volumeDrawable.setVolume(0);
        volumeDrawable.stop();
    }

    @Override
    public void scheduleDrawable(@NonNull Drawable drawable, @NonNull Runnable runnable, long when) {
        this.handler.postAtTime(runnable, when);
    }

    @Override
    public void invalidateDrawable(@NonNull Drawable drawable) {
        drawable.invalidateSelf();

    }

    @Override
    public void unscheduleDrawable(@NonNull Drawable drawable, @NonNull Runnable runnable) {
        this.handler.removeCallbacks(runnable);
    }

    public void init() {
    }

    public void release() {
        volumeDrawable.release();
        volumeDrawable = null;
    }

    public static class THandler extends Handler {
        private final WeakReference<AudioEffectPresenter> mAudioPreseter;

        public THandler(AudioEffectPresenter audioEffectPresenter) {
            mAudioPreseter = new WeakReference<>(audioEffectPresenter);
        }

        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (mAudioPreseter.get() != null) {
                AudioEffectPresenter audioEffectPresenter = mAudioPreseter.get();
                if (audioEffectPresenter.volumeDrawable == null) {
                    return;
                }
                int value = (int) (POCClient.getAudioVolumn(audioEffectPresenter.mRoomId) / 10);
                int minValue = audioEffectPresenter.mContext.getResources().getInteger(R.integer.poc_audio_volumn_min_value);
                LogUtils.ILog(audioEffectPresenter.TAG, "value: " + value + " minValue:" + minValue);
                value = value < minValue ? 0 : value;
                audioEffectPresenter.volumeDrawable.setVolume(value);
                audioEffectPresenter.handler.sendEmptyMessageDelayed(0, 50);
            }
        }
    }
}
