package com.xdja.poc.sdk.ui.conversion.audioview;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;

import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.R;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class VolumeDrawable extends Drawable implements ISwitcher, Runnable {
    public float DRAW_INTERVAL = 0.016f;
    private static final String TAG = VolumeDrawable.class.getSimpleName();
    static Random random;
    private List<LineData> mDatas;
    private double mDenominator;
    private RectF mDrawRect;
    private float[] mEh;
    private boolean mEnable = true;
    private FrameUnitPool mFrameUnitPool;
    private SparseArray<Double> mHeightCaches;
    private boolean mInited;
    private boolean mIsRunning;
    private int mLineCount;
    private int mLineWidth;
    private int[] mLoc;
    private int mLowMode;
    private int mMinHeight;
    private Paint mPaint = new Paint();
    private SparseArray<Double> mRandomCaches;
    private int mStepWidth;
    private boolean[] mSv;
    private int mViewHeight;
    private int mViewWidth;

    public class FrameUnit   {
        public float b;
        public float c;
        public float d;
        public float t;
    }

    public class FrameUnitPool extends ObjectPool<FrameUnit> {

        protected FrameUnit createNewObject() {
            return new FrameUnit();
        }
    }

    public class LineData {
        public int height;
        public float lastHeight;
        public List<FrameUnit> timelist;
        public int width;
        public int x;
        public int y;
    }

    public VolumeDrawable() {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(GlobalContext.getContext().getResources().getColor(R.color.common_main_color));
        this.mDrawRect = new RectF();
        this.mRandomCaches = new SparseArray();
        this.mHeightCaches = new SparseArray();
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        canvas.save();
        canvas.clipRect(getBounds());
        long currentTimeMillis;
        currentTimeMillis = System.currentTimeMillis();
        drawVolume(canvas);
        LogUtils.ILog(TAG, "draw volume: " + (System.currentTimeMillis() - currentTimeMillis) + " ms");
        canvas.restore();
    }

    @Override
    public int getOpacity() {
        return 0;
    }

    @Override
    public void setBounds(int left, int top, int right, int bottom) {
        super.setBounds(left, top, right, bottom);
        if (right - left != this.mViewWidth || bottom - top != this.mViewHeight) {
            this.mViewWidth = right - left;
            this.mViewHeight = bottom - top;
            this.mInited = false;
            init();
        }
    }

    @Override
    public void setAlpha(int alpha) {

    }
    @Override
    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }
    public void setStepWidth(int i) {
        this.mStepWidth = i;
    }
    public void setLineWidth(int i) {
        this.mLineWidth = i;
    }

    public void setMinHeight(int i) {
        this.mMinHeight = i;
    }

    private void init() {
        if (!this.mInited) {
            int i;
            this.mLineCount = this.mViewWidth / (this.mLineWidth + this.mStepWidth);
            this.mFrameUnitPool = new FrameUnitPool();
            this.mDenominator = Math.pow((double) this.mLineCount, 4.0d);
            int i2 = (this.mViewWidth - ((this.mLineWidth + this.mStepWidth) * this.mLineCount)) / 2;
            this.mDatas = new ArrayList();
            for (i = 0; i < this.mLineCount; i++) {
                LineData lineData = new LineData();
                lineData.x = i2;
                lineData.y = this.mViewHeight / 2;
                lineData.width = this.mLineWidth;
                lineData.height = this.mMinHeight;
                lineData.timelist = new ArrayList();
                this.mDatas.add(lineData);
                i2 += this.mLineWidth + this.mStepWidth;
            }
            this.mSv = new boolean[this.mLineCount];
            i = this.mLineCount;
            if (i < 62) {
                i = 62;
            }
            this.mEh = new float[i];
            this.mLoc = new int[i];
            this.mInited = true;
            LogUtils.ILog(TAG, "init w: " + this.mLineWidth + " h: " + this.mMinHeight + " s: " + this.mStepWidth);
        }
    }

    private double getRandomValue(int i) {
        if (this.mRandomCaches.indexOfKey(i) >= 0) {
            return this.mRandomCaches.get(i);
        }
        double pow = 18.0d * Math.pow((double) i, 4.0d);
        this.mRandomCaches.put(i, pow);
        return pow;
    }

    private double getHeightValue(int i) {
        if (this.mHeightCaches.indexOfKey(i) >= 0) {
            return this.mHeightCaches.get(i);
        }
        double pow = Math.pow(0.5d, (double) i);
        this.mHeightCaches.put(i, pow);
        return pow;
    }

    public void setVolume(int i) {
        float f;
        int i2;
        int i3;
        int i4;
        int random;
        init();
        LogUtils.ILog(TAG, "vol: " + i);
        if (!this.mEnable) {
            this.mEnable = true;
            this.mPaint.setColor(GlobalContext.getContext().getResources().getColor(R.color.common_main_color));
        }
        float f2 = (float) (((double) i) / 8.0d);
        if (f2 > 0.6f) {
            f2 = 0.6f;
        }
        float f3 = (float) (this.mLineCount / 2);
        if (f2 >= 0.1f) {
            f = 2.0f + f2;
            this.mLowMode = 0;
        } else if (this.mLowMode <= 0 || this.mLowMode >= 3) {
            this.mLowMode = 0;
            this.mLowMode++;
            f2 = 0.1f;
            f = 0.05f;
        } else {
            this.mLowMode++;
            return;
        }
        for (i2 = 0; i2 < this.mLineCount; i2++) {
            if (((float) i2) < f3) {
                this.mSv[i2] = randomBool((int) ((((double) f2) * ((getRandomValue(i2) / this.mDenominator) + 0.05000000074505806d)) * 100.0d));
            } else {
                this.mSv[i2] = randomBool((int) ((((double) f2) * ((getRandomValue(i2 - this.mLineCount) / this.mDenominator) + 0.05000000074505806d)) * 100.0d));
            }
        }
        int random2 = (((int) (20.0f * f)) + (getRandom() % 3)) - 1;
        if (random2 <= 0) {
            random2 = 1;
        }
        float pow = 0.8f * (((float) Math.pow((double) f, 0.3330000042915344d)) * ((float) this.mViewHeight));
        for (i3 = 0; i3 < random2; i3++) {
            if (i3 >= mEh.length) {
                break;
            }
            if (((float) i3) < f3) {
                this.mEh[i3] = (float) ((((double) pow) * ((getRandomValue(i3) / this.mDenominator) + 0.05000000074505806d)) * 10.0d);
            } else {
                this.mEh[i3] = (float) ((((double) pow) * ((getRandomValue(i3 - this.mLineCount) / this.mDenominator) + 0.05000000074505806d)) * 10.0d);
            }
        }
        i2 = 0;
        for (i3 = 0; i3 < this.mLineCount; i3++) {
            if (this.mSv[i3]) {
                i4 = i2 + 1;
                this.mLoc[i2] = i3;
                i2 = i4;
            }
        }
        if (i2 > 1) {
            int min = Math.min(30, i2);
            for (i4 = 0; i4 < min; i4++) {
                random = getRandom() % i2;
                i3 = getRandom() % i2;
                if (random == i3) {
                    i3 = (i3 + 1) % i2;
                }
                int i5 = this.mLoc[random];
                this.mLoc[random] = this.mLoc[i3];
                this.mLoc[i3] = i5;
            }
        }
        random = Math.min(random2, i2);
        LogUtils.ILog(TAG, "factm: " + random);
        for (i2 = 0; i2 < this.mLineCount; i2++) {
            f2 = (float) this.mMinHeight;
            i3 = 0;
            while (i3 < random) {
                i3++;
                f2 = (float) (((double) f2) + (((double) this.mEh[i3]) * getHeightValue(Math.abs(this.mLoc[i3] - i2))));
            }
            if (f2 > ((float) this.mViewHeight)) {
                f3 = (float) this.mViewHeight;
            } else {
                f3 = f2;
            }
            LineData lineData = this.mDatas.get(i2);
            List list = lineData.timelist;
            if (Math.abs(f3 - lineData.lastHeight) >= 1.0f) {
                float f4;
                if (f3 < lineData.lastHeight) {
                    f4 = 0.3f;
                } else {
                    f4 = 0.135f;
                }
                FrameUnit frameUnit = this.mFrameUnitPool.getObject();
                frameUnit.c = f3 - lineData.lastHeight;
                frameUnit.d = f4;
                frameUnit.b = 0.0f;
                frameUnit.t = 0.0f;
                list.add(frameUnit);
            }
            lineData.lastHeight = f3;
        }
    }

    private void drawVolume(Canvas canvas) {
        Rect bounds = getBounds();
        for (int i = 0; i < this.mLineCount; i++) {
            LineData lineData =   this.mDatas.get(i);
            List<FrameUnit> list = lineData.timelist;
            int i2 = 0;
            float f = 0.0f;
            while (i2 < list.size()) {
                float f2;
                FrameUnit frameUnit =  list.get(i2);
                frameUnit.t += DRAW_INTERVAL;
                float f3;
                if (frameUnit.t > frameUnit.d) {
                    f3 = frameUnit.c - frameUnit.b;
                    this.mFrameUnitPool.removeObject(list.remove(i2));
                    i2--;
                    f2 = f3;
                } else {
                    f2 = (float) quartInOut((double) frameUnit.t, 0.0d, (double) frameUnit.c, (double) frameUnit.d);
                    f3 = frameUnit.b;
                    frameUnit.b = f2;
                    f2 -= f3;
                }
                i2++;
                f += f2;
            }
            if (f != 0.0f) {
                float f2 = ((float) lineData.height) + f;
                if (f2 < ((float) this.mMinHeight)) {
                    f2 = (float) this.mMinHeight;
                }
                lineData.height = (int) f2;
            } else if (list.size() == 0 && ((float) lineData.height) < ((float) this.mMinHeight)) {
                lineData.height = this.mMinHeight;
            }
            this.mDrawRect.left = (float) (lineData.x + bounds.left);
            this.mDrawRect.top = (float) ((lineData.y - (lineData.height / 2)) + bounds.top);
            this.mDrawRect.right = this.mDrawRect.left + ((float) this.mLineWidth);
            this.mDrawRect.bottom = this.mDrawRect.top + ((float) lineData.height);
            canvas.drawRect(this.mDrawRect, this.mPaint);
        }
    }

    private boolean randomBool(int i) {
        if (i <= 0) {
            return false;
        }
        return i >= 100 || getRandom() % 1000 < i * 10;
    }

    private double quartInOut(double d, double d2, double d3, double d4) {
        return (((-d3) / 2.0d) * (Math.cos((Math.PI * d) / d4) - 1.0d)) + d2;
    }
    public   int getRandom() {
        if (random == null) {
            random = new Random(System.currentTimeMillis());
        }
        return Math.abs(random.nextInt());
    }

    @Override
    public void run() {
        unscheduleSelf(this);
        if (this.mIsRunning) {
            invalidateSelf();
            scheduleSelf(this, SystemClock.uptimeMillis() + 16);
        }
    }

    @Override
    public void start() {
        stop();
        this.mIsRunning = true;
        run();
    }

    @Override
    public void stop() {
        this.mIsRunning = false;
        unscheduleSelf(this);
    }

    @Override
    public void release() {
        stop();
        if (mFrameUnitPool != null) {
            mFrameUnitPool.release();
        }
    }
}