package com.xdja.poc.sdk.ui.history;

/**
 * Created by xdjaxa on 2019/1/10.
 */

import android.content.Context;
import android.content.Intent;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.jude.easyrecyclerview.EasyRecyclerView;
import com.jude.easyrecyclerview.adapter.RecyclerArrayAdapter;
import com.xdja.poc.common.annotation.TitleViewAnnotation;
import com.xdja.poc.common.base.BaseActivity;
import com.xdja.poc.common.utils.DisplayUtil;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ToastUtils;
import com.xdja.poc.sdk.BuildConfig;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.sdk.ui.main.mvp.POCHistoryMessageContract;
import com.xdja.poc.sdk.ui.main.mvp.POCHistoryMessagePresenter;

import java.util.List;
import java.util.concurrent.TimeUnit;

import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;

/**
 * poc-历史消息
 * Created by xdjaxa on 2019/1/4.
 */

@TitleViewAnnotation
public class POCHistoryMessageActivity extends BaseActivity implements POCHistoryMessageContract.IView {

    private EasyRecyclerView mRecyclerView;
    private POCHistoryMessageAdapter mAdapter;
    private POCHistoryMessagePresenter pocHistoryMessagePresenter;

    private static final String ROOM_ID = "roomId";
    private String roomId;

    private int pageSize = 15;
    private long syncTime = 0;
    private LinearLayoutManager lm;
    private View moreView;
    private View errorView;

    private TextView tvMore;

    public static void startPOCHistoryMessageActivity(Context context, String roomId) {
        if (!PreferenceHelper.getBoolean(UserConfig.POC_IS_SAVE_RECORD, true)) {
            ToastUtils.showToast("暂不支持历史语音查看");
            return;
        }
        Intent target = new Intent(context, POCHistoryMessageActivity.class);
        target.putExtra(ROOM_ID, roomId);
        context.startActivity(target);
    }

    @Override
    protected int generateLayout() {
        return R.layout.poc_activity_history_message;
    }

    protected int getTranslucentStatusBarColor() {
        return getResources().getColor(R.color.common_main_color);
    }

    @Override
    protected void initView() {
        roomId = getIntent().getStringExtra(ROOM_ID);
        if (StringUtils.isEmpty(roomId)) {
            finish();
            return;
        }

        initTitleBar();

        mRecyclerView = findViewById(R.id.rv_history_message);
        lm = new LinearLayoutManager(this);
        mRecyclerView.setLayoutManager(lm);
        mRecyclerView.getSwipeToRefresh().setColorSchemeResources(R.color.common_main_color);
        mAdapter = new POCHistoryMessageAdapter(this, this);
        moreView = View.inflate(this, R.layout.poc_history_message_view_more, null);
        errorView = View.inflate(this, R.layout.poc_view_history_message_loadmore_error, null);
        tvMore = errorView.findViewById(R.id.tv_more);
        pocHistoryMessagePresenter = new POCHistoryMessagePresenter(this);
    }

    private void initTitleBar() {
        getTitleBarView().setTile("历史消息");
        getTitleBarView().setBackgroundRecource(R.color.common_main_color);
        getTitleBarView().setLeftViewRecource(R.mipmap.common_back_n);
        getTitleBarView().setTitleColor(getResources().getColor(R.color.common_white_color));
        getTitleBarView().setTextSize(18);
        getTitleBarView().setLeftViewClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
    }

    @Override
    protected void initEvent() {
        mRecyclerView.setRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
            @Override
            public void onRefresh() {
                if (mAdapter.getCount() > 0) {
                    POCHistoryMessage firstMessage = mAdapter.getAllData().get(0);
                    if (firstMessage != null) {
                        syncTime = Long.valueOf(firstMessage.getSyncTime());
                        pocHistoryMessagePresenter.loadUpMessage(roomId, pageSize, syncTime);
                        return;
                    }
                }
                syncTime = 0;
                pocHistoryMessagePresenter.loadUpMessage(roomId, pageSize, syncTime);
            }
        });
//        mAdapter.setNoMore();
        mAdapter.setMore(moreView, new RecyclerArrayAdapter.OnLoadMoreListener() {
            @Override
            public void onLoadMore() {
                List<POCHistoryMessage> temp = mAdapter.getAllData();
                if (temp != null) {
                    POCHistoryMessage lastMessage = temp.get(temp.size() - 1);
                    if (lastMessage != null) {
                        syncTime = Long.valueOf(lastMessage.getSyncTime());
                        pocHistoryMessagePresenter.loadMoreHistoryMessage(roomId, pageSize, syncTime);
                    }
                }
            }
        });
        mAdapter.setError(errorView, new RecyclerArrayAdapter.OnErrorListener() {
            @Override
            public void onErrorShow() {

            }

            @Override
            public void onErrorClick() {
                mAdapter.resumeMore();
            }
        });

        mRecyclerView.getErrorView().findViewById(R.id.reload_btn).setOnClickListener(v -> {
            mRecyclerView.showProgress();
            syncTime = 0;
            pocHistoryMessagePresenter.loadFirstMessage(roomId, pageSize, syncTime);
        });

        mRecyclerView.setAdapter(mAdapter);
        mRecyclerView.getSwipeToRefresh().setEnabled(true);

        mRecyclerView.showProgress();
        pocHistoryMessagePresenter.loadFirstMessage(roomId, pageSize, syncTime);
    }

    /**
     * @param historyMessages
     * @param totalRecord     -1：代表数据为缓存数据 other：数据总数
     */
    @Override
    public void loadMessageSuccess(List<POCHistoryMessage> historyMessages, int totalRecord) {
        if (historyMessages == null || historyMessages.size() == 0) {
            if (mAdapter.getCount() == 0 && mAdapter.getCount() == 0) {
                mRecyclerView.showEmpty();
            }
            if (totalRecord != -1) {
                mAdapter.pauseMore();
            }
            if (totalRecord == -1) {
                mRecyclerView.setRefreshing(false);
            }
            tvMore.setText("已加载全部");
            return;
        }
        //加载本地
        if (totalRecord == -1) {
            if (mAdapter.getCount() == 0) {
                mAdapter.insertAll(historyMessages, 0);

                mAdapter.pauseMore();
                mRecyclerView.scrollToPosition(mAdapter.getCount());
                syncTime = Long.valueOf(historyMessages.get(historyMessages.size() - 1).getSyncTime());
                pocHistoryMessagePresenter.loadMoreHistoryMessage(roomId, pageSize, syncTime);
                return;
            }
            mAdapter.insertAll(historyMessages, 0);
            mAdapter.pauseMore();
            mRecyclerView.scrollToPosition(mAdapter.getCount() );
            syncTime = Long.valueOf(historyMessages.get(historyMessages.size() - 1).getSyncTime());
            pocHistoryMessagePresenter.loadMoreHistoryMessage(roomId, pageSize, syncTime);
            return;
        }
        //加载网络数据
        mAdapter.addAll(historyMessages);
        mAdapter.pauseMore();
        mRecyclerView.scrollToPosition(mAdapter.getCount());
        syncTime = Long.valueOf(historyMessages.get(historyMessages.size() - 1).getSyncTime());
        pocHistoryMessagePresenter.loadMoreHistoryMessage(roomId, pageSize, syncTime);
    }

    @Override
    public void loadMessageFailed() {
        if (mAdapter.getCount() == 0) {
            mRecyclerView.showError();
            mAdapter.stopMore();
            return;
        }
        ToastUtils.showToast("加载失败，请重试");
        mAdapter.pauseMore();
    }

    @Override
    public boolean isExist() {
        return !isFinishing();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (mAdapter != null) {
            mAdapter.stopAnim();
        }
        HistoryVoicePlayer.getInstance().releasePlay();
    }
}
