package com.xdja.poc.sdk.ui.main.mvp;

import com.xdja.net.RetrofitUtil;
import com.xdja.net.observer.CommonObserver;
import com.xdja.net.throwable.HttpThrowable;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.greendao.HistoryMessageDBHelper;
import com.xdja.poc.sdk.record.api.RecordBusiness;
import com.xdja.poc.sdk.record.api.bean.BaseRecordResponse;
import com.xdja.poc.sdk.record.api.bean.PageMessageRequest;
import com.xdja.poc.sdk.record.api.bean.SynctimeMessageRequest;
import com.xdja.poc.sdk.ui.history.POCHistoryMessage;

import java.util.List;

/**
 * Created by xdjaxa on 2019/1/10.
 */

public class POCHistoryMessagePresenter implements POCHistoryMessageContract.IPresenter {

    private static final String TAG = POCHistoryMessagePresenter.class.getSimpleName();
    private POCHistoryMessageContract.IView view;

    public POCHistoryMessagePresenter(POCHistoryMessageContract.IView view) {
        this.view = view;
    }

    /**
     * 第一次进入加载
     *
     * @param pageSize
     * @param room
     * @param synctime
     */
    @Override
    public void loadFirstMessage(String room, int pageSize, long synctime) {
        //本地数据有数据加载本地数据
        if (HistoryMessageDBHelper.getInstance().count(room) > 0) {
            loadLocalMessage(room, pageSize, synctime);
            return;
        }
        //调用分页加载
        pageHistoryMessage(1, pageSize, room);
    }

    /**
     * 下拉刷新
     *
     * @param room
     * @param pageSize
     * @param synctime
     */
    @Override
    public void loadUpMessage(String room, int pageSize, long synctime) {
        if (HistoryMessageDBHelper.getInstance().count(room) > 0) {
            loadLocalMessage(room, pageSize, synctime);
            return;
        }
        if (view != null && view.isExist()) {
            view.loadMessageSuccess(null, -1);
        }
    }

    /**
     * 上拉加载
     *
     * @param pageSize
     * @param room
     * @param synctime
     */
    @Override
    public void loadMoreHistoryMessage(String room, int pageSize, long synctime) {
        syncHistoryMessage(1, pageSize, room, synctime);
    }

    /**
     * 本地加载
     *
     * @param room
     * @param pageSize
     * @param synctime
     */
    private void loadLocalMessage(String room, int pageSize, long synctime) {
        LogUtils.DLog(TAG, "loadLocalMessage");
        List<POCHistoryMessage> result = HistoryMessageDBHelper.getInstance().query(room, pageSize, synctime);
        if (view != null && view.isExist()) {
            view.loadMessageSuccess(result, -1);
        }
    }

    /**
     * 调用分页加载
     *
     * @param currentPage
     * @param pageSize
     * @param room
     */
    private void pageHistoryMessage(int currentPage, int pageSize, String room) {
        LogUtils.DLog(TAG, "pageHistoryMessage");
        PageMessageRequest request = new PageMessageRequest();
        request.setCurrentPage(currentPage);
        request.setPageSize(pageSize);
        request.setGroupUri(room);
        RetrofitUtil.request(RecordBusiness.gettTalkGroupMessageByPage(request), new CommonObserver<BaseRecordResponse<List<POCHistoryMessage>>>() {
            @Override
            public void onResult(BaseRecordResponse<List<POCHistoryMessage>> result) {
                if (Constants.RESPONSE_SUCCESS.equals(result.getResult())) {
                    HistoryMessageDBHelper.getInstance().insertOrUpdate(result.getData());
                    if (view != null && view.isExist()) {
                        view.loadMessageSuccess(result.getData(), result.getTotalRecord());
                    }
                    return;
                }
                if (view != null && view.isExist()) {
                    view.loadMessageFailed();
                }
            }

            @Override
            public void onError(HttpThrowable httpThrowable) {
                if (view != null && view.isExist()) {
                    view.loadMessageFailed();
                }
            }
        });
    }

    /**
     * 调用同步时间加载
     *
     * @param currentPage
     * @param pageSize
     * @param room
     * @param syncTime
     */
    private void syncHistoryMessage(int currentPage, int pageSize, String room, long syncTime) {
        LogUtils.DLog(TAG, "syncHistoryMessage");
        LogUtils.DLog(TAG, "room = " + room);
        SynctimeMessageRequest request = new SynctimeMessageRequest();
        request.setCurrentPage(currentPage);
        request.setPageSize(pageSize);
        request.setGroupUri(room);
        request.setSyncTime(syncTime);
        RetrofitUtil.request(RecordBusiness.gettTalkGroupMessageBySynctime(request), new CommonObserver<BaseRecordResponse<List<POCHistoryMessage>>>() {
            @Override
            public void onResult(BaseRecordResponse<List<POCHistoryMessage>> result) {
                if (Constants.RESPONSE_SUCCESS.equals(result.getResult())) {
                    HistoryMessageDBHelper.getInstance().insertOrUpdate(result.getData());
                    if (view != null && view.isExist()) {
                        view.loadMessageSuccess(result.getData(), result.getTotalRecord());
                    }
                    return;
                }
                if (view != null && view.isExist()) {
                    view.loadMessageFailed();
                }
            }

            @Override
            public void onError(HttpThrowable httpThrowable) {
                if (view != null && view.isExist()) {
                    view.loadMessageFailed();
                }
            }
        });
    }
}
