/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business.ringplay;

import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Vibrator;
import android.provider.Settings;
import android.text.TextUtils;
import com.xdja.poc.common.utils.DeviceUtils;
import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.ToastUtils;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.business.ringplay.IRingPlayer;
import com.xdja.poc.sdk.business.ringplay.PlayConfig;
import com.xdja.poc.sdk.business.ringplay.RxAudioPlayer;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;

public class RingPlayer
implements IRingPlayer {
    private static final String TAG = RingPlayer.class.getSimpleName();
    private static final long[] sVibratePattern = new long[]{0L, 1000L, 800L, 1000L, 800L};
    private Context context;
    private AudioManager audioManager;
    private Vibrator vibrator;
    private RingConfig currentRingConfig;
    private RxAudioPlayer rxAudioPlayer;
    private RingStateReceiver ringStateReceiver;
    private IRingPlayer.Callback callback;
    public boolean isNeedPlayRing = false;
    private int mLooping = 0;
    private static RingPlayer instance;
    private static final int STOP = 1;
    private static final int CHANGE_AUDIO_MODE = 2;
    private int flag;

    private RingPlayer(Context context) {
        this.init(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RingPlayer getInstance(Context context) {
        if (instance != null) return instance;
        Class<RingPlayer> clazz = RingPlayer.class;
        synchronized (RingPlayer.class) {
            if (instance != null) return instance;
            instance = new RingPlayer(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private void init(Context mContext) {
        this.context = mContext.getApplicationContext();
        this.audioManager = (AudioManager)this.context.getSystemService("audio");
        this.vibrator = (Vibrator)this.context.getSystemService("vibrator");
        this.rxAudioPlayer = RxAudioPlayer.getInstance();
        this.currentRingConfig = new RingConfig();
        this.registerRingStateReceiver();
        this.setFlag(true, 1);
    }

    private void registerRingStateReceiver() {
        this.ringStateReceiver = new RingStateReceiver();
        IntentFilter mIntentFilter = new IntentFilter();
        mIntentFilter.addAction("android.media.RINGER_MODE_CHANGED");
        this.context.registerReceiver((BroadcastReceiver)this.ringStateReceiver, mIntentFilter);
    }

    @Override
    public void playIncomingRing(boolean isOutGoing, boolean isVoice) {
        LogUtils.DLog((String)TAG, (String)"playIncomingRing");
        this.setFlag(false, 1);
        this.isNeedPlayRing = true;
        this.currentRingConfig.isOutgoing = isOutGoing;
        this.currentRingConfig.isVoice = isVoice;
        if (!isOutGoing && this.checkRingerMode()) {
            LogUtils.DLog((String)TAG, (String)"playIncomingRing: is silent or vibrate mode");
            return;
        }
        int vibrateRing = Settings.System.getInt((ContentResolver)GlobalContext.getContext().getContentResolver(), (String)"vibrate_when_ringing", (int)0);
        if (this.currentRingConfig.isOutgoing || vibrateRing != 0) {
            // empty if block
        }
        this.startVibrate();
        this.playRing(R.raw.ring, true, new RingObserverAdapter(){

            @Override
            public void onError(Throwable throwable) {
                LogUtils.ELog((String)TAG, (String)("playIncoming error: " + throwable.toString()));
                RingPlayer.this.stopRing();
            }
        });
    }

    private boolean checkRingerMode() {
        int ringerMode = this.audioManager.getRingerMode();
        if (ringerMode == 0) {
            LogUtils.DLog((String)TAG, (String)"checkRingerMode: RINGER_MODE_SILENT");
            return true;
        }
        if (ringerMode == 1) {
            LogUtils.DLog((String)TAG, (String)"checkRingerMode: RINGER_MODE_SILENT");
            this.startVibrate();
            return true;
        }
        return false;
    }

    @Override
    public void playNoAnswerRing() {
    }

    @Override
    public void playBusyRing() {
        ToastUtils.showToast((String)GlobalContext.getContext().getString(R.string.poc_user_is_calling));
    }

    @Override
    public void playErrorRing(String message) {
        if (!TextUtils.isEmpty((CharSequence)message)) {
            ToastUtils.showToast((String)message);
        }
    }

    private void playFinishRing(final int rawRes) {
        LogUtils.DLog((String)TAG, (String)"playFinishRing");
        if (this.isStop()) {
            LogUtils.DLog((String)TAG, (String)"playFinishRing: RingPlayer already stop");
            this.playFinishComplete();
            return;
        }
        this.isNeedPlayRing = false;
        this.currentRingConfig.isPlayErrorRing = true;
        this.rxAudioPlayer.stopPlay();
        this.playRing(rawRes, false, new RingObserverAdapter(){

            @Override
            public void onError(Throwable throwable) {
                LogUtils.DLog((String)TAG, (String)("playFinishRing error: " + throwable.toString()));
                RingPlayer.this.playFinishComplete();
            }

            @Override
            public void onNext(Boolean aBoolean) {
                RingPlayer.this.mLooping++;
            }

            @Override
            public void onComplete() {
                if (RingPlayer.this.mLooping < 2 && !RingPlayer.this.isStop()) {
                    RingPlayer.this.playFinishRing(rawRes);
                } else {
                    RingPlayer.this.playFinishComplete();
                }
            }
        });
    }

    private void playFinishComplete() {
        if (this.callback != null) {
            this.callback.playErrorRingFinish();
        }
    }

    public boolean isConnectedHeadsetOrBluetooth() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        int bluetoothState = adapter.getProfileConnectionState(1);
        return bluetoothState == 2 || bluetoothState == 1 || this.audioManager.isWiredHeadsetOn();
    }

    public void setAudioMode(boolean playMode) {
        if (this.audioManager != null) {
            this.audioManager.setSpeakerphoneOn(playMode);
        }
    }

    private void playRing(int rawRes, boolean isLooping, Observer<Boolean> observable) {
        if (!this.isStop()) {
            DeviceUtils.gainAudioFocus();
            int streamType = 2;
            this.audioManager.setMode(0);
            this.audioManager.setSpeakerphoneOn(true);
            if (this.isConnectedHeadsetOrBluetooth()) {
                LogUtils.DLog((String)TAG, (String)"playRing: from headset");
                if (this.currentRingConfig.isVoice && this.currentRingConfig.isOutgoing) {
                    LogUtils.DLog((String)TAG, (String)"playRing: from headset is voice outgoing");
                    this.setFlag(true, 2);
                    this.audioManager.setSpeakerphoneOn(false);
                    streamType = 0;
                }
            } else if (this.currentRingConfig.isVoice && this.currentRingConfig.isOutgoing) {
                LogUtils.DLog((String)TAG, (String)"playRing: from headphone");
                this.setFlag(true, 2);
                this.audioManager.setMode(3);
                this.audioManager.setSpeakerphoneOn(true);
                streamType = 0;
            }
            this.rxAudioPlayer.play(PlayConfig.uri(GlobalContext.getContext(), Uri.parse((String)("android.resource://" + GlobalContext.getContext().getPackageName() + "/" + rawRes))).streamType(streamType).looping(isLooping).build()).subscribe(observable);
        }
    }

    private void startVibrate() {
        this.vibrator.vibrate(sVibratePattern, 1);
    }

    private void stopVibrate() {
        if (this.vibrator.hasVibrator()) {
            this.vibrator.cancel();
        }
    }

    @Override
    public void stopRing() {
        if (this.isStop()) {
            LogUtils.ELog((String)TAG, (String)"stopRing: is not init or already stop");
            return;
        }
        LogUtils.DLog((String)TAG, (String)"stopRing");
        this.setFlag(true, 1);
        this.currentRingConfig.isPlayErrorRing = false;
        this.mLooping = 0;
        this.isNeedPlayRing = false;
        this.stopVibrate();
        this.rxAudioPlayer.stopPlay();
        this.resetAudioMode();
        DeviceUtils.releaseAudioFocus();
    }

    private void resetAudioMode() {
        if (this.getFlag(2)) {
            this.setFlag(false, 2);
            this.audioManager.setMode(0);
            this.audioManager.setSpeakerphoneOn(!this.isConnectedHeadsetOrBluetooth());
        }
    }

    public void resetAudioModeOn() {
        this.setFlag(false, 2);
        if (this.audioManager != null) {
            this.audioManager.setMode(0);
            this.audioManager.setSpeakerphoneOn(!this.isConnectedHeadsetOrBluetooth());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        RingPlayer ringPlayer = instance;
        synchronized (ringPlayer) {
            this.rxAudioPlayer.stopPlay();
            this.stopVibrate();
            this.unregisterRingStateReceiver();
            this.resetAudioMode();
            DeviceUtils.releaseAudioFocus();
            this.context = null;
            this.audioManager = null;
            this.vibrator = null;
            this.rxAudioPlayer = null;
            this.currentRingConfig = null;
            this.callback = null;
            this.flag = 0;
            instance = null;
        }
    }

    @Override
    public void setCallback(IRingPlayer.Callback callback) {
        this.callback = callback;
    }

    private void unregisterRingStateReceiver() {
        if (this.ringStateReceiver != null) {
            this.context.unregisterReceiver((BroadcastReceiver)this.ringStateReceiver);
            this.ringStateReceiver = null;
        }
    }

    public boolean isStop() {
        return this.getFlag(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getFlag(int mask) {
        Class<RingPlayer> clazz = RingPlayer.class;
        synchronized (RingPlayer.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (this.flag & mask) != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFlag(boolean value, int mask) {
        Class<RingPlayer> clazz = RingPlayer.class;
        synchronized (RingPlayer.class) {
            this.flag = value ? (this.flag |= mask) : (this.flag &= ~mask);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public RingConfig getCurrentRingConfig() {
        return this.currentRingConfig;
    }

    private class RingObserverAdapter
    implements Observer<Boolean> {
        private RingObserverAdapter() {
        }

        public void onSubscribe(Disposable disposable) {
        }

        public void onNext(Boolean aBoolean) {
        }

        public void onError(Throwable throwable) {
        }

        public void onComplete() {
        }
    }

    private class RingStateReceiver
    extends BroadcastReceiver {
        private RingStateReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (!RingPlayer.this.isNeedPlayRing || ((RingPlayer)RingPlayer.this).currentRingConfig.isOutgoing || intent == null || TextUtils.isEmpty((CharSequence)intent.getAction())) {
                LogUtils.DLog((String)TAG, (String)"RingStateReceiver: ignore event");
                return;
            }
            if (intent.getAction().equals("android.media.RINGER_MODE_CHANGED")) {
                int ringerMode = RingPlayer.this.audioManager.getRingerMode();
                LogUtils.DLog((String)TAG, (String)("RingStateReceiver: ringerMode is " + ringerMode));
                switch (ringerMode) {
                    case 2: {
                        RingPlayer.this.playIncomingRing(((RingPlayer)RingPlayer.this).currentRingConfig.isOutgoing, ((RingPlayer)RingPlayer.this).currentRingConfig.isVoice);
                        break;
                    }
                    case 1: {
                        RingPlayer.this.rxAudioPlayer.stopPlay();
                        RingPlayer.this.startVibrate();
                        break;
                    }
                    case 0: {
                        RingPlayer.this.stopVibrate();
                        RingPlayer.this.rxAudioPlayer.stopPlay();
                    }
                }
            }
        }
    }

    public class RingConfig {
        public boolean isOutgoing;
        public boolean isVoice;
        public boolean isPlayErrorRing = false;
    }
}

