/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business.webrtc.apprtc;

import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.Build;
import android.preference.PreferenceManager;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.business.webrtc.apprtc.AppRTCBluetoothManager;
import com.xdja.poc.sdk.business.webrtc.apprtc.AppRTCProximitySensor;
import com.xdja.poc.sdk.business.webrtc.apprtc.util.AppRTCUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.webrtc.ThreadUtils;

public class AppRTCAudioManager {
    private static final String TAG = "AppRTCAudioManager";
    private static final String SPEAKERPHONE_AUTO = "auto";
    private static final String SPEAKERPHONE_TRUE = "true";
    private static final String SPEAKERPHONE_FALSE = "false";
    private static AppRTCAudioManager mInstance;
    private final Context apprtcContext;
    private AudioManager audioManager;
    private AudioManagerEvents audioManagerEvents;
    private AudioManagerState amState;
    private int savedAudioMode = -2;
    private boolean savedIsSpeakerPhoneOn = false;
    private boolean savedIsMicrophoneMute = false;
    private boolean hasWiredHeadset = false;
    private AudioDevice defaultAudioDevice;
    private AudioDevice selectedAudioDevice;
    private AudioDevice userSelectedAudioDevice;
    private final String useSpeakerphone;
    private AppRTCProximitySensor proximitySensor = null;
    private AppRTCBluetoothManager bluetoothManager = null;
    private Set<AudioDevice> audioDevices = new HashSet<AudioDevice>();
    private BroadcastReceiver wiredHeadsetReceiver;
    private AudioManager.OnAudioFocusChangeListener audioFocusChangeListener;

    private void onProximitySensorChangedState() {
        if (!this.useSpeakerphone.equals(SPEAKERPHONE_AUTO)) {
            return;
        }
        if (this.audioDevices.size() == 2 && this.audioDevices.contains((Object)AudioDevice.EARPIECE) && this.audioDevices.contains((Object)AudioDevice.SPEAKER_PHONE)) {
            if (this.proximitySensor.sensorReportsNearState()) {
                this.setAudioDeviceInternal(AudioDevice.EARPIECE);
            } else {
                this.setAudioDeviceInternal(AudioDevice.SPEAKER_PHONE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppRTCAudioManager create(Context context) {
        if (mInstance != null) return mInstance;
        Class<AppRTCAudioManager> clazz = AppRTCAudioManager.class;
        synchronized (AppRTCAudioManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new AppRTCAudioManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private AppRTCAudioManager(Context context) {
        LogUtils.DLog((String)TAG, (String)"ctor");
        ThreadUtils.checkIsOnMainThread();
        this.apprtcContext = context.getApplicationContext();
        this.audioManager = (AudioManager)context.getSystemService("audio");
        if (BluetoothAdapter.getDefaultAdapter().isEnabled()) {
            this.bluetoothManager = AppRTCBluetoothManager.create(context, this);
        }
        this.wiredHeadsetReceiver = new WiredHeadsetReceiver();
        this.amState = AudioManagerState.UNINITIALIZED;
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.useSpeakerphone = SPEAKERPHONE_TRUE;
        LogUtils.DLog((String)TAG, (String)("useSpeakerphone: " + this.useSpeakerphone));
        this.defaultAudioDevice = this.useSpeakerphone.equals(SPEAKERPHONE_FALSE) ? AudioDevice.EARPIECE : AudioDevice.SPEAKER_PHONE;
        this.proximitySensor = AppRTCProximitySensor.create(context, new Runnable(){

            @Override
            public void run() {
                AppRTCAudioManager.this.onProximitySensorChangedState();
            }
        });
        LogUtils.DLog((String)TAG, (String)("defaultAudioDevice: " + (Object)((Object)this.defaultAudioDevice)));
        AppRTCUtils.logDeviceInfo(TAG);
    }

    public void start(AudioManagerEvents audioManagerEvents) {
        LogUtils.DLog((String)TAG, (String)"start");
        ThreadUtils.checkIsOnMainThread();
        if (this.amState == AudioManagerState.RUNNING) {
            LogUtils.ELog((String)TAG, (String)"AudioManager is already active");
            return;
        }
        LogUtils.DLog((String)TAG, (String)"AudioManager starts...");
        this.audioManagerEvents = audioManagerEvents;
        this.amState = AudioManagerState.RUNNING;
        this.savedAudioMode = this.audioManager.getMode();
        this.savedIsSpeakerPhoneOn = this.audioManager.isSpeakerphoneOn();
        this.savedIsMicrophoneMute = this.audioManager.isMicrophoneMute();
        this.hasWiredHeadset = this.hasWiredHeadset();
        this.audioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

            public void onAudioFocusChange(int focusChange) {
                String typeOfChange;
                switch (focusChange) {
                    case 1: {
                        typeOfChange = "AUDIOFOCUS_GAIN";
                        break;
                    }
                    case 2: {
                        typeOfChange = "AUDIOFOCUS_GAIN_TRANSIENT";
                        break;
                    }
                    case 4: {
                        typeOfChange = "AUDIOFOCUS_GAIN_TRANSIENT_EXCLUSIVE";
                        break;
                    }
                    case 3: {
                        typeOfChange = "AUDIOFOCUS_GAIN_TRANSIENT_MAY_DUCK";
                        break;
                    }
                    case -1: {
                        typeOfChange = "AUDIOFOCUS_LOSS";
                        break;
                    }
                    case -2: {
                        typeOfChange = "AUDIOFOCUS_LOSS_TRANSIENT";
                        break;
                    }
                    case -3: {
                        typeOfChange = "AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK";
                        break;
                    }
                    default: {
                        typeOfChange = "AUDIOFOCUS_INVALID";
                    }
                }
                LogUtils.DLog((String)AppRTCAudioManager.TAG, (String)("onAudioFocusChange: " + typeOfChange));
            }
        };
        int result = this.audioManager.requestAudioFocus(this.audioFocusChangeListener, 3, 2);
        if (result == 1) {
            LogUtils.DLog((String)TAG, (String)"Audio focus request granted for VOICE_CALL streams");
        } else {
            LogUtils.ELog((String)TAG, (String)"Audio focus request failed");
        }
        this.audioManager.setMode(0);
        this.setMicrophoneMute(false);
        this.userSelectedAudioDevice = AudioDevice.NONE;
        this.selectedAudioDevice = AudioDevice.NONE;
        this.audioDevices.clear();
        if (BluetoothAdapter.getDefaultAdapter().isEnabled()) {
            if (this.bluetoothManager == null) {
                this.bluetoothManager = AppRTCBluetoothManager.create(this.apprtcContext, this);
            }
            this.bluetoothManager.start();
        }
        this.updateAudioDeviceState();
        this.registerReceiver(this.wiredHeadsetReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
        LogUtils.DLog((String)TAG, (String)"AudioManager started");
    }

    public void stop() {
        LogUtils.DLog((String)TAG, (String)"stop");
        ThreadUtils.checkIsOnMainThread();
        if (this.amState != AudioManagerState.RUNNING) {
            LogUtils.ELog((String)TAG, (String)("Trying to stop AudioManager in incorrect state: " + (Object)((Object)this.amState)));
            return;
        }
        this.amState = AudioManagerState.UNINITIALIZED;
        this.unregisterReceiver(this.wiredHeadsetReceiver);
        if (BluetoothAdapter.getDefaultAdapter().isEnabled()) {
            this.bluetoothManager.stop();
        }
        this.setSpeakerphoneOn(this.savedIsSpeakerPhoneOn);
        this.setMicrophoneMute(this.savedIsMicrophoneMute);
        this.audioManager.setMode(this.savedAudioMode);
        this.audioManager.abandonAudioFocus(this.audioFocusChangeListener);
        this.audioFocusChangeListener = null;
        LogUtils.DLog((String)TAG, (String)"Abandoned audio focus for VOICE_CALL streams");
        if (this.proximitySensor != null) {
            this.proximitySensor.stop();
            this.proximitySensor = null;
        }
        this.audioManagerEvents = null;
        LogUtils.DLog((String)TAG, (String)"AudioManager stopped");
    }

    private void setAudioDeviceInternal(AudioDevice device) {
        LogUtils.DLog((String)TAG, (String)("setAudioDeviceInternal(device=" + (Object)((Object)device) + ")"));
        AppRTCUtils.assertIsTrue(this.audioDevices.contains((Object)device));
        switch (device) {
            case SPEAKER_PHONE: {
                this.setSpeakerphoneOn(true);
                break;
            }
            case EARPIECE: {
                this.setSpeakerphoneOn(false);
                break;
            }
            case WIRED_HEADSET: {
                this.setSpeakerphoneOn(false);
                break;
            }
            case BLUETOOTH: {
                this.setSpeakerphoneOn(false);
                break;
            }
            default: {
                LogUtils.ELog((String)TAG, (String)"Invalid audio device selection");
            }
        }
        this.selectedAudioDevice = device;
    }

    public void setDefaultAudioDevice(AudioDevice defaultDevice) {
        ThreadUtils.checkIsOnMainThread();
        switch (defaultDevice) {
            case SPEAKER_PHONE: {
                this.defaultAudioDevice = defaultDevice;
                break;
            }
            case EARPIECE: {
                if (this.hasEarpiece()) {
                    this.defaultAudioDevice = defaultDevice;
                    break;
                }
                this.defaultAudioDevice = AudioDevice.SPEAKER_PHONE;
                break;
            }
            default: {
                LogUtils.ELog((String)TAG, (String)"Invalid default audio device selection");
            }
        }
        LogUtils.DLog((String)TAG, (String)("setDefaultAudioDevice(device=" + (Object)((Object)this.defaultAudioDevice) + ")"));
        this.updateAudioDeviceState();
    }

    public void selectAudioDevice(AudioDevice device) {
        ThreadUtils.checkIsOnMainThread();
        if (!this.audioDevices.contains((Object)device)) {
            LogUtils.ELog((String)TAG, (String)("Can not select " + (Object)((Object)device) + " from available " + this.audioDevices));
        }
        this.userSelectedAudioDevice = device;
        this.updateAudioDeviceState();
    }

    public Set<AudioDevice> getAudioDevices() {
        ThreadUtils.checkIsOnMainThread();
        return Collections.unmodifiableSet(new HashSet<AudioDevice>(this.audioDevices));
    }

    public AudioDevice getSelectedAudioDevice() {
        ThreadUtils.checkIsOnMainThread();
        return this.selectedAudioDevice;
    }

    private void registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        this.apprtcContext.registerReceiver(receiver, filter);
    }

    private void unregisterReceiver(BroadcastReceiver receiver) {
        this.apprtcContext.unregisterReceiver(receiver);
    }

    private void setSpeakerphoneOn(boolean on) {
        boolean wasOn = this.audioManager.isSpeakerphoneOn();
        if (wasOn == on) {
            return;
        }
        this.audioManager.setSpeakerphoneOn(on);
    }

    private void setMicrophoneMute(boolean on) {
        boolean wasMuted = this.audioManager.isMicrophoneMute();
        if (wasMuted == on) {
            return;
        }
        this.audioManager.setMicrophoneMute(on);
    }

    private boolean hasEarpiece() {
        return this.apprtcContext.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    public boolean hasWiredHeadset() {
        AudioDeviceInfo[] devices;
        if (Build.VERSION.SDK_INT < 23) {
            return this.audioManager.isWiredHeadsetOn();
        }
        for (AudioDeviceInfo device : devices = this.audioManager.getDevices(3)) {
            int type = device.getType();
            if (type == 3) {
                LogUtils.DLog((String)TAG, (String)"hasWiredHeadset: found wired headset");
                return true;
            }
            if (type != 11) continue;
            LogUtils.DLog((String)TAG, (String)"hasWiredHeadset: found USB audio device");
            return true;
        }
        return false;
    }

    public void updateAudioDeviceState() {
        AudioDevice newAudioDevice;
        ThreadUtils.checkIsOnMainThread();
        LogUtils.DLog((String)TAG, (String)("--- updateAudioDeviceState: wired headset=" + this.hasWiredHeadset + ", BT state=" + (this.bluetoothManager != null ? this.bluetoothManager.getState() : "null")));
        LogUtils.DLog((String)TAG, (String)("Device status: available=" + this.audioDevices + ", selected=" + (Object)((Object)this.selectedAudioDevice) + ", user selected=" + (Object)((Object)this.userSelectedAudioDevice)));
        if (this.bluetoothManager != null && (this.bluetoothManager.getState() == AppRTCBluetoothManager.State.HEADSET_AVAILABLE || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.HEADSET_UNAVAILABLE || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_DISCONNECTING)) {
            this.bluetoothManager.updateDevice();
        }
        HashSet<AudioDevice> newAudioDevices = new HashSet<AudioDevice>();
        if (this.bluetoothManager != null && (this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTED || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTING || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.HEADSET_AVAILABLE)) {
            newAudioDevices.add(AudioDevice.BLUETOOTH);
        }
        if (this.hasWiredHeadset) {
            newAudioDevices.add(AudioDevice.WIRED_HEADSET);
        } else {
            newAudioDevices.add(AudioDevice.SPEAKER_PHONE);
            if (this.hasEarpiece()) {
                newAudioDevices.add(AudioDevice.EARPIECE);
            }
        }
        boolean audioDeviceSetUpdated = !this.audioDevices.equals(newAudioDevices);
        this.audioDevices = newAudioDevices;
        if (this.bluetoothManager != null && this.bluetoothManager.getState() == AppRTCBluetoothManager.State.HEADSET_UNAVAILABLE && this.userSelectedAudioDevice == AudioDevice.BLUETOOTH) {
            this.userSelectedAudioDevice = AudioDevice.NONE;
        }
        if (this.hasWiredHeadset && this.userSelectedAudioDevice == AudioDevice.SPEAKER_PHONE) {
            this.userSelectedAudioDevice = AudioDevice.WIRED_HEADSET;
        }
        if (!this.hasWiredHeadset && this.userSelectedAudioDevice == AudioDevice.WIRED_HEADSET) {
            this.userSelectedAudioDevice = AudioDevice.SPEAKER_PHONE;
        }
        boolean needBluetoothAudioStart = false;
        if (this.bluetoothManager != null) {
            needBluetoothAudioStart = this.bluetoothManager.getState() == AppRTCBluetoothManager.State.HEADSET_AVAILABLE && (this.userSelectedAudioDevice == AudioDevice.NONE || this.userSelectedAudioDevice == AudioDevice.BLUETOOTH);
        }
        boolean needBluetoothAudioStop = false;
        if (this.bluetoothManager != null) {
            boolean bl = needBluetoothAudioStop = (this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTED || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTING) && this.userSelectedAudioDevice != AudioDevice.NONE && this.userSelectedAudioDevice != AudioDevice.BLUETOOTH;
        }
        if (this.bluetoothManager != null && (this.bluetoothManager.getState() == AppRTCBluetoothManager.State.HEADSET_AVAILABLE || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTING || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTED)) {
            LogUtils.DLog((String)TAG, (String)("Need BT audio: start=" + needBluetoothAudioStart + ", stop=" + needBluetoothAudioStop + ", BT state=" + (Object)((Object)this.bluetoothManager.getState())));
        }
        if (needBluetoothAudioStop) {
            this.bluetoothManager.stopScoAudio();
            this.bluetoothManager.updateDevice();
        }
        if (needBluetoothAudioStart && !needBluetoothAudioStop && !this.bluetoothManager.startScoAudio()) {
            this.audioDevices.remove((Object)AudioDevice.BLUETOOTH);
            audioDeviceSetUpdated = true;
        }
        if ((newAudioDevice = this.bluetoothManager != null && this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTED ? AudioDevice.BLUETOOTH : (this.hasWiredHeadset ? AudioDevice.WIRED_HEADSET : this.defaultAudioDevice)) != this.selectedAudioDevice || audioDeviceSetUpdated) {
            this.setAudioDeviceInternal(newAudioDevice);
            LogUtils.DLog((String)TAG, (String)("New device status: available=" + this.audioDevices + ", selected=" + (Object)((Object)newAudioDevice)));
            if (this.audioManagerEvents != null) {
                this.audioManagerEvents.onAudioDeviceChanged(this.selectedAudioDevice, this.audioDevices);
            }
        }
        LogUtils.DLog((String)TAG, (String)"--- updateAudioDeviceState done");
    }

    private class WiredHeadsetReceiver
    extends BroadcastReceiver {
        private static final int STATE_UNPLUGGED = 0;
        private static final int STATE_PLUGGED = 1;
        private static final int HAS_NO_MIC = 0;
        private static final int HAS_MIC = 1;

        private WiredHeadsetReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            int state = intent.getIntExtra("state", 0);
            int microphone = intent.getIntExtra("microphone", 0);
            String name = intent.getStringExtra("name");
            LogUtils.DLog((String)AppRTCAudioManager.TAG, (String)("WiredHeadsetReceiver.onReceive" + AppRTCUtils.getThreadInfo() + ": a=" + intent.getAction() + ", s=" + (state == 0 ? "unplugged" : "plugged") + ", m=" + (microphone == 1 ? "mic" : "no mic") + ", n=" + name + ", sb=" + this.isInitialStickyBroadcast()));
            AppRTCAudioManager.this.hasWiredHeadset = state == 1;
            AppRTCAudioManager.this.updateAudioDeviceState();
        }
    }

    public static interface AudioManagerEvents {
        public void onAudioDeviceChanged(AudioDevice var1, Set<AudioDevice> var2);
    }

    public static enum AudioManagerState {
        UNINITIALIZED,
        PREINITIALIZED,
        RUNNING;

    }

    public static enum AudioDevice {
        SPEAKER_PHONE,
        WIRED_HEADSET,
        EARPIECE,
        BLUETOOTH,
        NONE;

    }
}

