/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business.webrtc.apprtc;

import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.business.webrtc.apprtc.AppRTCClient;
import com.xdja.poc.sdk.business.webrtc.apprtc.TCPChannelClient;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.IceCandidate;
import org.webrtc.PeerConnection;
import org.webrtc.SessionDescription;

public class DirectRTCClient
implements AppRTCClient,
TCPChannelClient.TCPChannelEvents {
    private static final String TAG = "DirectRTCClient";
    private static final int DEFAULT_PORT = 8888;
    static final Pattern IP_PATTERN = Pattern.compile("(((\\d+\\.){3}\\d+)|\\[((([0-9a-fA-F]{1,4}:)*[0-9a-fA-F]{1,4})?::(([0-9a-fA-F]{1,4}:)*[0-9a-fA-F]{1,4})?)\\]|\\[(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4})\\]|((([0-9a-fA-F]{1,4}:)*[0-9a-fA-F]{1,4})?::(([0-9a-fA-F]{1,4}:)*[0-9a-fA-F]{1,4})?)|(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4})|localhost)(:(\\d+))?");
    private final ExecutorService executor;
    private final AppRTCClient.SignalingEvents events;
    private TCPChannelClient tcpClient;
    private AppRTCClient.RoomConnectionParameters connectionParameters;
    private ConnectionState roomState;

    public DirectRTCClient(AppRTCClient.SignalingEvents events) {
        this.events = events;
        this.executor = Executors.newSingleThreadExecutor();
        this.roomState = ConnectionState.NEW;
    }

    @Override
    public void connectToRoom(AppRTCClient.RoomConnectionParameters connectionParameters) {
        this.connectionParameters = connectionParameters;
        if (connectionParameters.loopback) {
            this.reportError("Loopback connections aren't supported by DirectRTCClient.");
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                DirectRTCClient.this.connectToRoomInternal();
            }
        });
    }

    @Override
    public void disconnectFromRoom() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                DirectRTCClient.this.disconnectFromRoomInternal();
            }
        });
    }

    private void connectToRoomInternal() {
        int port;
        this.roomState = ConnectionState.NEW;
        String endpoint = this.connectionParameters.roomId;
        Matcher matcher = IP_PATTERN.matcher(endpoint);
        if (!matcher.matches()) {
            this.reportError("roomId must match IP_PATTERN for DirectRTCClient.");
            return;
        }
        String ip = matcher.group(1);
        String portStr = matcher.group(matcher.groupCount());
        if (portStr != null) {
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                this.reportError("Invalid port number: " + portStr);
                return;
            }
        } else {
            port = 8888;
        }
        this.tcpClient = new TCPChannelClient(this.executor, this, ip, port);
    }

    private void disconnectFromRoomInternal() {
        this.roomState = ConnectionState.CLOSED;
        if (this.tcpClient != null) {
            this.tcpClient.disconnect();
            this.tcpClient = null;
        }
        this.executor.shutdown();
    }

    @Override
    public void sendOfferSdp(final SessionDescription sdp) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (DirectRTCClient.this.roomState != ConnectionState.CONNECTED) {
                    DirectRTCClient.this.reportError("Sending offer SDP in non connected state.");
                    return;
                }
                JSONObject json = new JSONObject();
                DirectRTCClient.jsonPut(json, "sdp", sdp.description);
                DirectRTCClient.jsonPut(json, "type", "offer");
                DirectRTCClient.this.sendMessage(json.toString());
            }
        });
    }

    @Override
    public void sendAnswerSdp(final SessionDescription sdp) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                JSONObject json = new JSONObject();
                DirectRTCClient.jsonPut(json, "sdp", sdp.description);
                DirectRTCClient.jsonPut(json, "type", "answer");
                DirectRTCClient.this.sendMessage(json.toString());
            }
        });
    }

    @Override
    public void sendLocalIceCandidate(final IceCandidate candidate) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                JSONObject json = new JSONObject();
                DirectRTCClient.jsonPut(json, "type", "candidate");
                DirectRTCClient.jsonPut(json, "label", candidate.sdpMLineIndex);
                DirectRTCClient.jsonPut(json, "id", candidate.sdpMid);
                DirectRTCClient.jsonPut(json, "candidate", candidate.sdp);
                if (DirectRTCClient.this.roomState != ConnectionState.CONNECTED) {
                    DirectRTCClient.this.reportError("Sending ICE candidate in non connected state.");
                    return;
                }
                DirectRTCClient.this.sendMessage(json.toString());
            }
        });
    }

    @Override
    public void sendLocalIceCandidateRemovals(final IceCandidate[] candidates) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                JSONObject json = new JSONObject();
                DirectRTCClient.jsonPut(json, "type", "remove-candidates");
                JSONArray jsonArray = new JSONArray();
                for (IceCandidate candidate : candidates) {
                    jsonArray.put((Object)DirectRTCClient.toJsonCandidate(candidate));
                }
                DirectRTCClient.jsonPut(json, "candidates", jsonArray);
                if (DirectRTCClient.this.roomState != ConnectionState.CONNECTED) {
                    DirectRTCClient.this.reportError("Sending ICE candidate removals in non connected state.");
                    return;
                }
                DirectRTCClient.this.sendMessage(json.toString());
            }
        });
    }

    @Override
    public void onTCPConnected(boolean isServer) {
        if (isServer) {
            this.roomState = ConnectionState.CONNECTED;
            AppRTCClient.SignalingParameters parameters = new AppRTCClient.SignalingParameters(new ArrayList<PeerConnection.IceServer>(), isServer, null, null, null, null, null);
            this.events.onConnectedToRoom(parameters);
        }
    }

    @Override
    public void onTCPMessage(String msg) {
        try {
            JSONObject json = new JSONObject(msg);
            String type = json.optString("type");
            if (type.equals("candidate")) {
                this.events.onRemoteIceCandidate(DirectRTCClient.toJavaCandidate(json));
            } else if (type.equals("remove-candidates")) {
                JSONArray candidateArray = json.getJSONArray("candidates");
                IceCandidate[] candidates = new IceCandidate[candidateArray.length()];
                for (int i = 0; i < candidateArray.length(); ++i) {
                    candidates[i] = DirectRTCClient.toJavaCandidate(candidateArray.getJSONObject(i));
                }
                this.events.onRemoteIceCandidatesRemoved(candidates);
            } else if (type.equals("answer")) {
                SessionDescription sdp = new SessionDescription(SessionDescription.Type.fromCanonicalForm((String)type), json.getString("sdp"));
                this.events.onRemoteDescription(sdp);
            } else if (type.equals("offer")) {
                SessionDescription sdp = new SessionDescription(SessionDescription.Type.fromCanonicalForm((String)type), json.getString("sdp"));
                AppRTCClient.SignalingParameters parameters = new AppRTCClient.SignalingParameters(new ArrayList<PeerConnection.IceServer>(), false, null, null, null, sdp, null);
                this.roomState = ConnectionState.CONNECTED;
                this.events.onConnectedToRoom(parameters);
            } else {
                this.reportError("Unexpected TCP message: " + msg);
            }
        }
        catch (JSONException e) {
            this.reportError("TCP message JSON parsing error: " + e.toString());
        }
    }

    @Override
    public void onTCPError(String description) {
        this.reportError("TCP connection error: " + description);
    }

    @Override
    public void onTCPClose() {
        this.events.onChannelClose();
    }

    private void reportError(final String errorMessage) {
        LogUtils.ELog((String)TAG, (String)errorMessage);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (DirectRTCClient.this.roomState != ConnectionState.ERROR) {
                    DirectRTCClient.this.roomState = ConnectionState.ERROR;
                    DirectRTCClient.this.events.onChannelError(errorMessage);
                }
            }
        });
    }

    private void sendMessage(final String message) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                DirectRTCClient.this.tcpClient.send(message);
            }
        });
    }

    private static void jsonPut(JSONObject json, String key, Object value) {
        try {
            json.put(key, value);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private static JSONObject toJsonCandidate(IceCandidate candidate) {
        JSONObject json = new JSONObject();
        DirectRTCClient.jsonPut(json, "label", candidate.sdpMLineIndex);
        DirectRTCClient.jsonPut(json, "id", candidate.sdpMid);
        DirectRTCClient.jsonPut(json, "candidate", candidate.sdp);
        return json;
    }

    private static IceCandidate toJavaCandidate(JSONObject json) throws JSONException {
        return new IceCandidate(json.getString("id"), json.getInt("label"), json.getString("candidate"));
    }

    private static enum ConnectionState {
        NEW,
        CONNECTED,
        CLOSED,
        ERROR;

    }
}

