/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business.webrtc.apprtc;

import android.os.Environment;
import android.util.Log;
import com.czt.mp3recorder.DataEncodeThread;
import com.czt.mp3recorder.util.LameUtil;
import com.czt.mp3recorder.util.RecordFileUtils;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.config.Constants;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.concurrent.ExecutorService;
import org.webrtc.audio.JavaAudioDeviceModule;
import org.webrtc.voiceengine.WebRtcAudioRecord;

public class RecordedAudioToFileController
implements JavaAudioDeviceModule.SamplesReadyCallback,
WebRtcAudioRecord.WebRtcAudioRecordSamplesReadyCallback {
    private static final String TAG = "RecordedAudioToFile";
    private final Object lock = new Object();
    private final ExecutorService executor;
    private DataEncodeThread mEncodeThread;
    private static final int DEFAULT_SAMPLING_RATE = 16000;
    private static final int DEFAULT_LAME_MP3_QUALITY = 7;
    private static final int DEFAULT_LAME_IN_CHANNEL = 1;
    private static final int DEFAULT_LAME_MP3_BIT_RATE = 16;
    private static final int DEFAULT_BUFFER_ZISE = 2560;
    private OnSaveRecordCallBack saveRecordCallBack;
    private static double audioVolumn;

    public RecordedAudioToFileController(ExecutorService executor) {
        LogUtils.DLog((String)TAG, (String)"ctor");
        this.executor = executor;
    }

    public RecordedAudioToFileController(ExecutorService executor, OnSaveRecordCallBack saveRecordCallBack) {
        LogUtils.DLog((String)TAG, (String)"ctor");
        this.executor = executor;
        this.saveRecordCallBack = saveRecordCallBack;
    }

    public boolean start() {
        LogUtils.DLog((String)TAG, (String)"start");
        return true;
    }

    public void stop() {
        LogUtils.DLog((String)TAG, (String)"stop");
    }

    private boolean isExternalStorageWritable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state);
    }

    public void onWebRtcAudioRecordSamplesReady(WebRtcAudioRecord.AudioSamples samples) {
        if (!this.isExternalStorageWritable()) {
            LogUtils.ELog((String)TAG, (String)"Writing to external media is not possible");
            return;
        }
        this.onWebRtcAudioRecordSamplesReady(new JavaAudioDeviceModule.AudioSamples(samples.getAudioFormat(), samples.getChannelCount(), samples.getSampleRate(), samples.getData()));
    }

    public void onWebRtcAudioRecordSamplesReady(JavaAudioDeviceModule.AudioSamples samples) {
        if (samples.getAudioFormat() != 2) {
            LogUtils.ELog((String)TAG, (String)"Invalid audio format");
            return;
        }
        if (samples.getData() == null) {
            return;
        }
        final byte[] data = new byte[samples.getData().length];
        System.arraycopy(samples.getData(), 0, data, 0, samples.getData().length);
        short[] audioData = this.bytesToShort_(data);
        if (audioData != null && audioData.length > 0) {
            try {
                double volume;
                long r = audioData.length;
                long v = 0L;
                for (short anAudioData : audioData) {
                    v += (long)(anAudioData * anAudioData);
                }
                double mean = (double)v / (double)r;
                audioVolumn = volume = 10.0 * Math.log10(mean);
                Log.d((String)TAG, (String)("\u5206\u8d1d\u503c:" + audioVolumn + "  mean: " + mean + " r: " + r + "  v: " + v + " length= " + audioData.length));
            }
            catch (Exception e) {
                LogUtils.ELog((String)TAG, (String)("e: " + e.getLocalizedMessage()));
            }
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RecordedAudioToFileController.this.mEncodeThread != null) {
                    RecordedAudioToFileController.this.mEncodeThread.addTask(RecordedAudioToFileController.this.bytesToShort(data), data.length / 2);
                    RecordedAudioToFileController.this.mEncodeThread.processData();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebRtcAudioRecordSamplesStart() {
        Log.e((String)TAG, (String)"onWebRtcAudioRecordSamplesStart: ");
        if (!this.isExternalStorageWritable()) {
            LogUtils.ELog((String)TAG, (String)"Writing to external media is not possible");
            return;
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                LameUtil.init((int)16000, (int)1, (int)16000, (int)16, (int)7);
                File path = new File(Constants.HISTORY_RECORD_FILE_PATH);
                if (!path.exists()) {
                    path.mkdirs();
                }
                String mp3FileName = new RecordFileUtils().getRecordFileName();
                final File mp3File = new File(path, mp3FileName);
                this.mEncodeThread = new DataEncodeThread(mp3File, 2560, new DataEncodeThread.DataEncodeCallBack(){

                    public void onEncodeStart() {
                        if (RecordedAudioToFileController.this.saveRecordCallBack != null) {
                            RecordedAudioToFileController.this.saveRecordCallBack.onStartSave(mp3File.getAbsolutePath());
                            Log.d((String)RecordedAudioToFileController.TAG, (String)("onEncodeStart: " + mp3File.getAbsolutePath()));
                        }
                    }

                    public void onEncodeFinish() {
                        if (RecordedAudioToFileController.this.saveRecordCallBack != null) {
                            RecordedAudioToFileController.this.saveRecordCallBack.onEndSave();
                        }
                    }
                });
                this.mEncodeThread.start();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebRtcAudioRecordSamplesStop() {
        Log.e((String)TAG, (String)"onWebRtcAudioRecordSamplesStop: ");
        if (!this.isExternalStorageWritable()) {
            LogUtils.ELog((String)TAG, (String)"Writing to external media is not possible");
            return;
        }
        if (this.mEncodeThread != null) {
            Object object = this.lock;
            synchronized (object) {
                this.mEncodeThread.sendStopMessage();
            }
        }
    }

    private short[] bytesToShort(byte[] data) {
        int dataLength = data.length;
        int shortLength = dataLength / 2;
        ByteBuffer byteBuffer = ByteBuffer.wrap(data, 0, dataLength);
        ShortBuffer shortBuffer = byteBuffer.order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        short[] shortSamples = new short[shortLength];
        shortBuffer.get(shortSamples, 0, shortLength);
        return shortSamples;
    }

    public static double getAudioVolumn() {
        return audioVolumn;
    }

    public short[] bytesToShort_(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        short[] shorts = new short[bytes.length / 2];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(shorts);
        return shorts;
    }

    public static interface OnSaveRecordCallBack {
        public void onStartSave(String var1);

        public void onEndSave();
    }
}

