/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business.webrtc.janusclientapi;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.PersistableBundle;
import android.util.Log;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.business.JobSchedulerService;
import com.xdja.poc.sdk.business.webrtc.apprtc.PeerConnectionClient;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusAttachPluginCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusGatewayCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusMessageObserver;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusMessenger;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusPluginCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusSessionCreationCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IPluginHandleSendMessageCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IPluginHandleWebRTCCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.ITransactionCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusMessageType;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusMessagerFactory;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusMessengerType;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusPluginHandleWithWebrtc;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusSupportedPluginPackages;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusTransactionCallbackFactory;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.TransactionType;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.EglBase;
import org.webrtc.VideoSink;

public class JanusServer
implements Runnable,
IJanusMessageObserver,
IJanusSessionCreationCallbacks,
IJanusAttachPluginCallbacks {
    public static final String API_KEY = "xdja_api_abc";
    public String serverUri;
    private static volatile ConcurrentHashMap<Integer, JanusServer> serverMap;
    private static volatile ConcurrentHashMap<Integer, BigInteger> serverSessionIdMap;
    private int lastCode = 0;
    private String lastString;
    private List<IJanusGatewayCallbacks> gatewayCallbacksList = new ArrayList<IJanusGatewayCallbacks>();
    private final RandomString stringGenerator = new RandomString();
    private ConcurrentHashMap<BigInteger, JanusPluginHandleWithWebrtc> attachedPlugins = new ConcurrentHashMap();
    private HashMap<String, ITransactionCallbacks> transactions = new HashMap();
    private final Object transactionsLock = new Object();
    private volatile boolean connected;
    private volatile boolean connecting;
    private volatile boolean opened = false;
    private IJanusMessenger serverConnection;
    private volatile Thread keep_alive;
    private volatile boolean peerConnectionFactoryInitialized = false;
    private boolean isCreatePeerConnection;
    private HandlerThread monitorThread = new HandlerThread("monitor_thread");
    private volatile Handler monitorHandler = null;
    private final int CONNECT_TIMEOUT_MSG = 1;
    private final int CONNECT_TIMEOUT_SECOND_VALUE = 10000;
    private volatile int reconnectTimes = 0;
    private final int MAX_RETRY_TIMES = 3;
    JobScheduler mJobScheduler;
    public static final int MY_BACKGROUND_JOB = 0;
    Context mContext;
    PeerConnectionClient.PeerConnectionParameters peerConnectionParameters;
    VideoSink localVideoSink;
    VideoSink remoteVideoSink;
    EglBase eglBase;

    private static ConcurrentHashMap<Integer, JanusServer> getJanusServerMap() {
        if (serverMap == null) {
            serverMap = new ConcurrentHashMap();
        }
        return serverMap;
    }

    private static void putSessionID(String serverUri, BigInteger sessionId) {
        if (serverSessionIdMap == null) {
            serverSessionIdMap = new ConcurrentHashMap();
        }
        serverSessionIdMap.remove(serverUri.hashCode());
        serverSessionIdMap.put(serverUri.hashCode(), sessionId);
    }

    private static BigInteger getSessionId(String serverUri) {
        if (serverSessionIdMap == null) {
            return null;
        }
        return serverSessionIdMap.get(serverUri.hashCode());
    }

    private static void removeSessionId(String serverUri) {
        if (serverSessionIdMap == null) {
            return;
        }
        serverSessionIdMap.remove(serverUri.hashCode());
    }

    public static JanusServer getJanusServer(String serverUri) {
        if (JanusServer.getJanusServerMap().get(serverUri.hashCode()) != null) {
            return JanusServer.getJanusServerMap().get(serverUri.hashCode());
        }
        JanusServer janusServer = new JanusServer(serverUri);
        JanusServer.getJanusServerMap().put(serverUri.hashCode(), janusServer);
        return janusServer;
    }

    public synchronized void removeCallback(IJanusGatewayCallbacks callback) {
        if (this.gatewayCallbacksList != null && this.gatewayCallbacksList.contains(callback)) {
            Log.d((String)JanusServer.class.getName(), (String)("poc room is removed==" + this.serverUri.hashCode() + ", serverUri:" + this.serverUri));
            this.gatewayCallbacksList.remove(callback);
        }
    }

    public synchronized void addCallback(IJanusGatewayCallbacks callback) {
        if (this.gatewayCallbacksList == null) {
            this.gatewayCallbacksList = new ArrayList<IJanusGatewayCallbacks>();
        }
        this.gatewayCallbacksList.add(callback);
        Log.d((String)JanusServer.class.getName(), (String)("poc room add==" + this.serverUri + ", serverUri.hashCode():" + this.serverUri.hashCode()));
    }

    private JanusServer(String serverUri) {
        System.setProperty("java.net.preferIPv6Addresses", "false");
        System.setProperty("java.net.preferIPv4Stack", "true");
        this.connected = false;
        this.opened = false;
        this.serverUri = serverUri;
        this.serverConnection = JanusMessagerFactory.createMessager(serverUri, this);
        this.initMonitorThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String putNewTransaction(ITransactionCallbacks transactionCallbacks) {
        String transaction = this.stringGenerator.randomString(12);
        Object object = this.transactionsLock;
        synchronized (object) {
            while (this.transactions.containsKey(transaction)) {
                transaction = this.stringGenerator.randomString(12);
            }
            this.transactions.put(transaction, transactionCallbacks);
        }
        return transaction;
    }

    private void createSession() {
        this.monitorHandler.removeMessages(1);
        this.monitorHandler.removeCallbacksAndMessages(null);
        try {
            JSONObject obj = new JSONObject();
            obj.put("janus", (Object)JanusMessageType.create);
            ITransactionCallbacks cb = JanusTransactionCallbackFactory.createNewTransactionCallback(this, TransactionType.create);
            String transaction = this.putNewTransaction(cb);
            BigInteger sessionId = JanusServer.getSessionId(this.serverUri);
            if (sessionId != null && sessionId.intValue() != -1) {
                obj.put("id", (Object)sessionId);
            }
            obj.put("apisecret", (Object)API_KEY);
            obj.put("transaction", (Object)transaction);
            this.serverConnection.sendMessage(obj.toString());
        }
        catch (JSONException ex) {
            this.onCallbackError(ex.getMessage());
        }
    }

    public boolean initializeMediaContext(Context context, boolean audio, boolean video, boolean videoHwAcceleration, PeerConnectionClient.PeerConnectionParameters peerConnectionParameters) {
        this.mContext = context;
        this.peerConnectionParameters = peerConnectionParameters;
        this.peerConnectionFactoryInitialized = true;
        return true;
    }

    public boolean initializeMediaContext(Context context, VideoSink localVideoSink, VideoSink remoteVideoSink, EglBase eglBase, PeerConnectionClient.PeerConnectionParameters peerConnectionParameters) {
        this.mContext = context;
        this.eglBase = eglBase;
        this.peerConnectionParameters = peerConnectionParameters;
        this.localVideoSink = localVideoSink;
        this.remoteVideoSink = remoteVideoSink;
        this.peerConnectionFactoryInitialized = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long waitTime = 60000L;
        int retryTimes = 0;
        int maxRetryTimes = 5;
        Thread thisThread = Thread.currentThread();
        LogUtils.DLog((String)JanusServer.class.getName(), (String)("Run start check:" + this.serverUri + ",this:" + this));
        while (this.keep_alive == thisThread) {
            if (!this.connected || this.serverConnection.getMessengerType() != JanusMessengerType.websocket) {
                LogUtils.ELog((String)JanusServer.class.toString(), (String)"[1]heartbeat check not connected ");
                break;
            }
            try {
                JanusServer janusServer = this;
                synchronized (janusServer) {
                    this.wait(waitTime);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            LogUtils.ELog((String)JanusServer.class.toString(), (String)("connected: " + this.connected + "  serverConnection.getMessengerType(): " + (Object)((Object)this.serverConnection.getMessengerType()) + ",this:" + this));
            if (!this.connected || this.serverConnection.getMessengerType() != JanusMessengerType.websocket) {
                LogUtils.ELog((String)JanusServer.class.toString(), (String)"[2]heartbeat check not connected ");
                break;
            }
            JSONObject obj = new JSONObject();
            try {
                BigInteger sessionId = JanusServer.getSessionId(this.serverUri);
                obj.put("janus", (Object)JanusMessageType.keepalive.toString());
                if (this.serverConnection.getMessengerType() == JanusMessengerType.websocket && sessionId != null && sessionId.intValue() != -1) {
                    obj.put("session_id", (Object)sessionId);
                }
                obj.put("apisecret", (Object)API_KEY);
                obj.put("transaction", (Object)this.stringGenerator.randomString(12));
                this.serverConnection.sendMessage(obj.toString(), sessionId);
                retryTimes = 0;
                waitTime = 60000L;
            }
            catch (Exception ex) {
                LogUtils.ELog((String)JanusServer.class.toString(), (String)("ex:" + ex.getMessage()));
                waitTime = 2000L;
                if (++retryTimes < maxRetryTimes) continue;
                this.onCallbackError(-1, ex.getMessage());
                this.connected = false;
                break;
            }
        }
        this.connected = false;
        this.connecting = false;
        LogUtils.ELog((String)JanusServer.class.getName(), (String)("Run end, remove serverUri from map:" + this.serverUri + ", hashcode:" + this.serverUri.hashCode()));
        JanusServer.removeSessionId(this.serverUri);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean peerConnectionFactoryInitialized() {
        return this.peerConnectionFactoryInitialized;
    }

    public BigInteger getSessionId() {
        return JanusServer.getSessionId(this.serverUri);
    }

    public void Attach(IJanusPluginCallbacks callbacks, boolean flag) {
        this.isCreatePeerConnection = flag;
        if (!this.peerConnectionFactoryInitialized) {
            callbacks.onCallbackError("Peerconnection factory is not initialized, please initialize via initializeMediaContext connected:" + this.connected + ",connecting:" + this.connecting);
            return;
        }
        new AsyncAttach(this).execute(new IJanusPluginCallbacks[]{callbacks});
    }

    public static void disconnectServer() {
        for (Map.Entry<Integer, JanusServer> server : JanusServer.getJanusServerMap().entrySet()) {
            server.getValue().destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.monitorHandler.removeMessages(1);
            this.monitorHandler.removeCallbacksAndMessages(null);
            if (this.monitorThread != null && this.monitorThread.isAlive()) {
                this.monitorThread.getLooper().quit();
            }
            JanusServer.getJanusServerMap().remove(this.serverUri.hashCode());
            JanusServer.removeSessionId(this.serverUri);
        }
        catch (Exception ex) {
            LogUtils.ELog((String)JanusServer.class.toString(), (String)("destroy():" + ex.getMessage()));
        }
        if (this.connected) {
            for (Map.Entry entry : this.attachedPlugins.entrySet()) {
                ((JanusPluginHandleWithWebrtc)entry.getValue()).detach();
            }
            this.serverConnection.disconnect();
        }
        Object object = this;
        synchronized (object) {
            this.notifyAll();
        }
        this.keep_alive = null;
        this.connected = false;
        object = this.transactionsLock;
        synchronized (object) {
            for (Map.Entry<String, ITransactionCallbacks> trans : this.transactions.entrySet()) {
                this.transactions.remove(trans);
            }
        }
        this.gatewayCallbacksList.clear();
        this.onDestroy();
    }

    public synchronized boolean connect() {
        if (this.connected) {
            LogUtils.ELog((String)JanusServer.class.toString(), (String)"connect() connected");
            return true;
        }
        if (this.connecting) {
            LogUtils.ELog((String)JanusServer.class.toString(), (String)"connect() connecting");
            return true;
        }
        Log.v((String)JanusServer.class.toString(), (String)"start connect()");
        this.reconnectTimes = 0;
        this.connecting = true;
        this.reconnectTimes = 0;
        this.lastCode = 0;
        try {
            this.serverConnection.connect();
            this.monitorHandler.sendEmptyMessageDelayed(1, 10000L);
        }
        catch (Exception ex) {
            this.onCallbackError("connect failed:" + ex.getMessage());
            return false;
        }
        return true;
    }

    private void initMonitorThread() {
        try {
            this.monitorThread.start();
            this.monitorHandler = new Handler(this.monitorThread.getLooper()){

                public void handleMessage(Message msg) {
                    super.handleMessage(msg);
                    switch (msg.what) {
                        case 1: {
                            LogUtils.ELog((String)JanusServer.class.toString(), (String)("CONNECT_TIMEOUT_MSG, reconnect:" + JanusServer.this.reconnectTimes));
                            if (JanusServer.this.reconnectTimes > 3) {
                                JanusServer.this.connecting = false;
                                JanusServer.this.onCallbackError("can not connect server.");
                                return;
                            }
                            JanusServer.this.connecting = true;
                            JanusServer.this.reconnectTimes++;
                            JanusServer.this.serverConnection.disconnect();
                            JanusServer.this.serverConnection = JanusMessagerFactory.createMessager(JanusServer.this.serverUri, JanusServer.this);
                            JanusServer.this.serverConnection.connect();
                            JanusServer.this.monitorHandler.sendEmptyMessageDelayed(1, 10000L);
                            break;
                        }
                    }
                }
            };
        }
        catch (Exception ex) {
            LogUtils.ELog((String)JanusServer.class.toString(), (String)("monitorHandler.sendEmptyMessageDelayed ex:" + ex.getMessage()));
        }
    }

    public void newMessageForPlugin(String message, BigInteger plugin_id) {
        JanusPluginHandleWithWebrtc handle = this.attachedPlugins.get(plugin_id);
        if (handle != null) {
            handle.onMessage(message);
        }
    }

    public void sendMessage(JSONObject msg, JanusMessageType type, BigInteger handle) {
        try {
            if (!this.connected) {
                LogUtils.ELog((String)JanusServer.class.toString(), (String)"sendMessage not connected");
                return;
            }
            msg.put("janus", (Object)type.toString());
            BigInteger sessionId = JanusServer.getSessionId(this.serverUri);
            if (this.serverConnection.getMessengerType() == JanusMessengerType.websocket && sessionId != null && sessionId.intValue() != -1) {
                msg.put("session_id", (Object)sessionId);
            }
            msg.put("apisecret", (Object)API_KEY);
            msg.put("handle_id", (Object)handle);
            msg.put("transaction", (Object)this.stringGenerator.randomString(12));
            if (this.connected) {
                this.serverConnection.sendMessage(msg.toString(), sessionId, handle);
            }
            if (type == JanusMessageType.detach && this.attachedPlugins.containsKey(handle)) {
                this.attachedPlugins.remove(handle);
            }
        }
        catch (JSONException ex) {
            LogUtils.ELog((String)JanusServer.class.toString(), (String)("ex:" + ex.getMessage()));
        }
    }

    public void sendMessage(TransactionType type, BigInteger handle, IPluginHandleSendMessageCallbacks callbacks, JanusSupportedPluginPackages plugin) {
        if (!this.connected) {
            callbacks.onCallbackError("websocket not connected.");
            return;
        }
        JSONObject msg = callbacks.getMessage();
        if (msg != null) {
            try {
                JSONObject newMessage = new JSONObject();
                newMessage.put("janus", (Object)JanusMessageType.message.toString());
                newMessage.put("apisecret", (Object)API_KEY);
                BigInteger sessionId = JanusServer.getSessionId(this.serverUri);
                if (this.serverConnection.getMessengerType() == JanusMessengerType.websocket && sessionId != null && sessionId.intValue() != -1) {
                    newMessage.put("session_id", (Object)sessionId);
                }
                newMessage.put("handle_id", (Object)handle);
                ITransactionCallbacks cb = JanusTransactionCallbackFactory.createNewTransactionCallback(this, TransactionType.plugin_handle_message, plugin, callbacks);
                String transaction = this.putNewTransaction(cb);
                newMessage.put("transaction", (Object)transaction);
                if (msg.has("message")) {
                    newMessage.put("body", (Object)msg.getJSONObject("message"));
                }
                if (msg.has("jsep")) {
                    newMessage.put("jsep", (Object)msg.getJSONObject("jsep"));
                }
                this.serverConnection.sendMessage(newMessage.toString(), sessionId, handle);
            }
            catch (JSONException ex) {
                callbacks.onCallbackError(ex.getMessage());
            }
            catch (Exception ex) {
                callbacks.onCallbackError(ex.getMessage());
            }
        }
    }

    public void sendMessage(TransactionType type, BigInteger handle, IPluginHandleWebRTCCallbacks callbacks, JanusSupportedPluginPackages plugin) {
        if (!this.connected) {
            callbacks.onCallbackError("websocket not connected.");
            return;
        }
        try {
            JSONObject msg = new JSONObject();
            msg.put("janus", (Object)JanusMessageType.message.toString());
            msg.put("apisecret", (Object)API_KEY);
            BigInteger sessionId = JanusServer.getSessionId(this.serverUri);
            if (this.serverConnection.getMessengerType() == JanusMessengerType.websocket && sessionId != null && sessionId.intValue() != -1) {
                msg.put("session_id", (Object)sessionId);
                msg.put("handle_id", (Object)handle);
            }
            ITransactionCallbacks cb = JanusTransactionCallbackFactory.createNewTransactionCallback(this, TransactionType.plugin_handle_webrtc_message, plugin, callbacks);
            String transaction = this.putNewTransaction(cb);
            msg.put("transaction", (Object)transaction);
            if (callbacks.getJsep() != null) {
                msg.put("jsep", (Object)callbacks.getJsep());
            }
            this.serverConnection.sendMessage(msg.toString(), sessionId, handle);
        }
        catch (JSONException ex) {
            callbacks.onCallbackError(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCallbackError(int code, String error) {
        LogUtils.ELog((String)JanusServer.class.toString(), (String)("code:" + code + " , lastCode: " + this.lastCode + " , err:" + error + ", reconnectTimes:" + this.reconnectTimes));
        if (this.reconnectTimes > 0 && this.reconnectTimes < 3) {
            return;
        }
        this.connected = false;
        this.connecting = false;
        JanusServer janusServer = this;
        synchronized (janusServer) {
            this.notifyAll();
        }
        this.lastCode = code;
        try {
            if (this.gatewayCallbacksList == null) {
                return;
            }
            for (IJanusGatewayCallbacks callback : this.gatewayCallbacksList) {
                callback.onCallbackError(error);
            }
            this.gatewayCallbacksList.clear();
        }
        catch (Exception ex) {
            LogUtils.ELog((String)JanusServer.class.toString(), (String)("e:" + ex.getMessage()));
        }
        try {
            if (this.monitorThread != null && this.monitorThread.isAlive()) {
                this.monitorThread.getLooper().quit();
            }
            JanusServer.getJanusServerMap().remove(this.serverUri.hashCode());
        }
        catch (Exception ex) {
            LogUtils.ELog((String)JanusServer.class.toString(), (String)("destroy():" + ex.getMessage()));
        }
    }

    synchronized void onCallbackSuccess() {
        this.lastCode = 0;
        if (this.gatewayCallbacksList == null) {
            return;
        }
        for (IJanusGatewayCallbacks callback : this.gatewayCallbacksList) {
            callback.onSuccess();
        }
    }

    synchronized void onDestroy() {
        if (this.gatewayCallbacksList == null) {
            return;
        }
        for (IJanusGatewayCallbacks callback : this.gatewayCallbacksList) {
            callback.onDestroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedNewMessage(JSONObject obj) {
        try {
            JanusMessageType type = JanusMessageType.fromString(obj.getString("janus"));
            String transaction = null;
            BigInteger sender = null;
            if (obj.has("transaction")) {
                transaction = obj.getString("transaction");
            }
            if (obj.has("sender")) {
                sender = new BigInteger(obj.getString("sender"));
            }
            JanusPluginHandleWithWebrtc handle = null;
            if (sender != null) {
                handle = this.attachedPlugins.get(sender);
            }
            switch (type) {
                case keepalive: {
                    break;
                }
                case ack: 
                case success: 
                case error: {
                    ITransactionCallbacks cb;
                    if (transaction == null) break;
                    Object object = this.transactionsLock;
                    synchronized (object) {
                        cb = this.transactions.get(transaction);
                        if (cb != null) {
                            this.transactions.remove(transaction);
                        }
                    }
                    if (cb == null) break;
                    if (obj.has("error")) {
                        JSONObject error = obj.getJSONObject("error");
                        LogUtils.ELog((String)JanusServer.class.toString(), (String)("error : " + error.toString()));
                        if (error.has("code")) {
                            int errorCode = error.getInt("code");
                            if (errorCode == 468) {
                                BigInteger sessionId = new BigInteger("-1");
                                JanusServer.putSessionID(this.serverUri, sessionId);
                                try {
                                    if (this.monitorHandler != null) {
                                        this.monitorHandler.postDelayed(new Runnable(){

                                            @Override
                                            public void run() {
                                                JanusServer.this.createSession();
                                            }
                                        }, 1000L);
                                    }
                                }
                                catch (IllegalStateException illegalStateException) {
                                    // empty catch block
                                }
                                return;
                            }
                            if (errorCode == 403 || errorCode == 405) {
                                LogUtils.ELog((String)JanusServer.class.getName(), (String)(error.get("reason") + ""));
                                this.onCallbackError(-4, "token error");
                                return;
                            }
                            if (errorCode == 458) {
                                if (!this.connected || this.connecting) {
                                    this.createSession();
                                } else {
                                    this.onCallbackError(-4, "session error");
                                }
                                return;
                            }
                        }
                    }
                    cb.reportSuccess(obj);
                    break;
                }
                case hangup: 
                case detached: {
                    if (handle == null) break;
                    handle.onDetached();
                    handle.detach();
                    break;
                }
                case event: {
                    if (handle == null) break;
                    LogUtils.DLog((String)JanusServer.class.getName(), (String)"handle input event.");
                    JSONObject plugin_data = null;
                    if (obj.has("plugindata")) {
                        plugin_data = obj.getJSONObject("plugindata");
                    }
                    if (plugin_data == null) break;
                    JSONObject data = null;
                    JSONObject jsep = null;
                    if (plugin_data.has("data")) {
                        data = plugin_data.getJSONObject("data");
                    }
                    if (obj.has("jsep")) {
                        jsep = obj.getJSONObject("jsep");
                    }
                    LogUtils.DLog((String)JanusServer.class.getName(), (String)("handle input event:" + jsep));
                    handle.onMessage(data, jsep);
                }
            }
        }
        catch (JSONException ex) {
            LogUtils.ELog((String)JanusServer.class.toString(), (String)("ex:" + ex.getMessage()));
        }
    }

    @Override
    public void onOpen() {
        LogUtils.ILog((String)JanusServer.class.toString(), (String)("onOpen: connect ok:" + this.opened));
        if (this.opened) {
            return;
        }
        this.opened = true;
        this.createSession();
    }

    @Override
    public void onClose() {
        this.opened = false;
        this.connected = false;
        this.onCallbackError(0, "Connection to janus server is closed");
    }

    @Override
    public void onError(int errorCode, String message) {
        this.connected = false;
        this.opened = false;
        this.onCallbackError(errorCode, message);
    }

    @Override
    public void onCallbackError(String msg) {
        LogUtils.ELog((String)JanusServer.class.toString(), (String)("Create session faild,onCallbackError:" + msg));
        this.connecting = false;
        this.connected = false;
        this.reconnectTimes = 0;
        if (this.monitorHandler != null) {
            this.monitorHandler.removeMessages(1);
        }
        this.onCallbackError(-1, msg);
    }

    @Override
    public void onSessionCreationSuccess(JSONObject obj) {
        Log.v((String)JanusServer.class.toString(), (String)"onSessionCreationSuccess: connect ok");
        if (this.monitorHandler != null) {
            this.monitorHandler.removeMessages(1);
        }
        this.reconnectTimes = 0;
        try {
            BigInteger sessionId = new BigInteger(obj.getJSONObject("data").getString("id"));
            JanusServer.putSessionID(this.serverUri, sessionId);
            this.keep_alive = new Thread((Runnable)this, "KeepAlive");
            this.connected = true;
            this.connecting = false;
            this.keep_alive.start();
            this.onCallbackSuccess();
        }
        catch (Exception ex) {
            this.onCallbackError(-3, ex.getMessage());
        }
    }

    @Override
    public void attachPluginSuccess(JSONObject obj, JanusSupportedPluginPackages plugin, IJanusPluginCallbacks pluginCallbacks) {
        try {
            BigInteger handle = new BigInteger(obj.getJSONObject("data").getString("id"));
            JanusPluginHandleWithWebrtc pluginHandle = new JanusPluginHandleWithWebrtc(this, plugin, handle, pluginCallbacks, this.mContext, this.peerConnectionParameters, this.localVideoSink, this.remoteVideoSink, this.eglBase, this.isCreatePeerConnection);
            this.attachedPlugins.put(handle, pluginHandle);
            pluginCallbacks.success(pluginHandle);
        }
        catch (JSONException ex) {
            pluginCallbacks.onCallbackError(ex.getMessage());
        }
    }

    public static void doAllSchedule() {
        LogUtils.ILog((String)JanusServer.class.toString(), (String)"doAllSchedule");
        for (Map.Entry<Integer, JanusServer> handle : serverMap.entrySet()) {
            handle.getValue().doSchedule(handle.getValue().serverUri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doSchedule(String serveruri) {
        LogUtils.ILog((String)JanusServer.class.toString(), (String)("doSchedule: connect:" + this.connected + ",serveruri:" + serveruri + ",this:" + this));
        if (!this.connected) {
            LogUtils.ILog((String)JanusServer.class.toString(), (String)"doSchedule:reconnect server");
            this.connect();
            return false;
        }
        JanusServer janusServer = this;
        synchronized (janusServer) {
            this.notifyAll();
        }
        return true;
    }

    private void scheduleJob() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.mJobScheduler = (JobScheduler)this.mContext.getSystemService("jobscheduler");
            JobInfo.Builder builder = new JobInfo.Builder(0, new ComponentName(this.mContext.getPackageName(), JobSchedulerService.class.getName()));
            builder.setRequiredNetworkType(1);
            builder.setBackoffCriteria(TimeUnit.MILLISECONDS.toMillis(10L), 0);
            if (Build.VERSION.SDK_INT >= 24) {
                builder.setMinimumLatency(120000L);
            } else {
                builder.setPeriodic(60000L);
            }
            PersistableBundle persiBundle = new PersistableBundle();
            persiBundle.putString("SERVER_URI", this.serverUri);
            builder.setExtras(persiBundle);
            this.mJobScheduler.schedule(builder.build());
        }
    }

    private void stopJob() {
        this.mJobScheduler.cancelAll();
    }

    private static class AsyncAttach
    extends AsyncTask<IJanusPluginCallbacks, Void, Void> {
        private final WeakReference<JanusServer> janusServerWeakReference;

        public AsyncAttach(JanusServer janusServer) {
            this.janusServerWeakReference = new WeakReference<JanusServer>(janusServer);
        }

        protected Void doInBackground(IJanusPluginCallbacks ... cbs) {
            IJanusPluginCallbacks cb = cbs[0];
            if (this.janusServerWeakReference.get() != null) {
                JanusServer janusServer = (JanusServer)this.janusServerWeakReference.get();
                if (!janusServer.connected || janusServer.connecting) {
                    cb.onCallbackError("AsyncAttach failed, for connected:" + janusServer.connected + ",connecting:" + janusServer.connecting);
                    return null;
                }
                try {
                    JSONObject obj = new JSONObject();
                    obj.put("janus", (Object)JanusMessageType.attach);
                    obj.put("plugin", (Object)cb.getPlugin());
                    obj.put("apisecret", (Object)JanusServer.API_KEY);
                    BigInteger sessionId = JanusServer.getSessionId(janusServer.serverUri);
                    if (janusServer.serverConnection.getMessengerType() == JanusMessengerType.websocket && sessionId != null && sessionId.intValue() != -1) {
                        obj.put("session_id", (Object)sessionId);
                    }
                    ITransactionCallbacks tcb = JanusTransactionCallbackFactory.createNewTransactionCallback(janusServer, TransactionType.attach, cb.getPlugin(), cb);
                    String transaction = janusServer.putNewTransaction(tcb);
                    obj.put("transaction", (Object)transaction);
                    janusServer.serverConnection.sendMessage(obj.toString(), sessionId);
                }
                catch (JSONException ex) {
                    cb.onCallbackError(ex.getMessage());
                }
                catch (Exception ex) {
                    cb.onCallbackError(ex.getMessage());
                }
            }
            return null;
        }

        protected void onPostExecute(Void aVoid) {
            super.onPostExecute((Object)aVoid);
            LogUtils.ELog((String)"AsyncAttach", (String)"cancel");
            try {
                this.cancel(true);
            }
            catch (Exception e) {
                LogUtils.ELog((Throwable)e);
            }
        }
    }

    public static class RandomString {
        final String str = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        final Random rnd = new Random();

        public String randomString(Integer length) {
            StringBuilder sb = new StringBuilder(length);
            for (int i = 0; i < length; ++i) {
                sb.append("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(this.rnd.nextInt("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".length())));
            }
            return sb.toString();
        }
    }
}

