/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.greendao;

import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.greendao.dao.RecordMessageDao;
import com.xdja.poc.sdk.greendao.manager.GreenDaoManager;
import com.xdja.poc.sdk.record.RecordMessage;
import java.util.List;
import org.greenrobot.greendao.Property;

public class LocalRecordDBHelper {
    private static final String TAG = LocalRecordDBHelper.class.getSimpleName();
    private final GreenDaoManager daoManager = GreenDaoManager.getInstance();
    private static LocalRecordDBHelper dbHelper;

    private LocalRecordDBHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalRecordDBHelper getInstance() {
        if (dbHelper != null) return dbHelper;
        Class<LocalRecordDBHelper> clazz = LocalRecordDBHelper.class;
        synchronized (LocalRecordDBHelper.class) {
            if (dbHelper != null) return dbHelper;
            dbHelper = new LocalRecordDBHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return dbHelper;
        }
    }

    public synchronized void insert(RecordMessage recordMessage) {
        this.getRecordMessageDao().insert(recordMessage);
        LogUtils.DLog((String)TAG, (String)"insert success");
    }

    public synchronized List<RecordMessage> query(int offset, int pageCount) {
        List temp = this.getRecordMessageDao().queryBuilder().orderDesc(new Property[]{RecordMessageDao.Properties.RecordUri}).offset(offset).limit(pageCount).build().list();
        return temp;
    }

    public synchronized RecordMessage queryNoUploadRecord() {
        List temp = this.getRecordMessageDao().queryBuilder().orderDesc(new Property[]{RecordMessageDao.Properties.RecordUri}).limit(1).build().list();
        if (temp != null && temp.size() > 0) {
            return (RecordMessage)temp.get(0);
        }
        return null;
    }

    public synchronized RecordMessage update(String key, String remoteUrl) {
        RecordMessage temp = (RecordMessage)this.getRecordMessageDao().load(key);
        if (temp != null) {
            temp.setRecordRemoteUrl(remoteUrl);
            this.getRecordMessageDao().update(temp);
            LogUtils.DLog((String)TAG, (String)"update success");
        }
        return temp;
    }

    public synchronized void delete(String key) {
        this.getRecordMessageDao().deleteByKey(key);
        LogUtils.DLog((String)TAG, (String)"delete success");
    }

    private RecordMessageDao getRecordMessageDao() {
        return this.daoManager.getDaoSession().getRecordMessageDao();
    }
}

