/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.ui.conversion.audioview;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.ui.conversion.audioview.VolumeDrawable;
import java.lang.ref.WeakReference;

public class AudioEffectPresenter
implements Drawable.Callback {
    private VolumeDrawable volumeDrawable;
    private String TAG = "AudioEffect";
    private String mRoomId;
    private Context mContext;
    private WeakReference weakReference;
    private THandler handler;

    public AudioEffectPresenter(Context context, ImageView imageView, String roomId) {
        this.mContext = context;
        this.mRoomId = roomId;
        this.volumeDrawable = new VolumeDrawable();
        this.volumeDrawable.setCallback(this);
        this.volumeDrawable.setLineWidth(GlobalContext.getContext().getResources().getInteger(R.integer.poc_audio_effect_line_width));
        this.volumeDrawable.setMinHeight(3);
        this.volumeDrawable.setStepWidth(GlobalContext.getContext().getResources().getInteger(R.integer.poc_audio_effect_step_width));
        imageView.setImageDrawable((Drawable)this.volumeDrawable);
        this.handler = new THandler(this);
    }

    public void start() {
        this.handler.removeCallbacks(null);
        this.handler.removeMessages(0);
        this.volumeDrawable.start();
        this.handler.sendEmptyMessageDelayed(0, 200L);
    }

    public void stop() {
        this.handler.removeMessages(0);
        this.handler.removeCallbacks(null);
        this.volumeDrawable.setVolume(0);
        this.volumeDrawable.stop();
    }

    public void scheduleDrawable(@NonNull Drawable drawable2, @NonNull Runnable runnable, long when) {
        this.handler.postAtTime(runnable, when);
    }

    public void invalidateDrawable(@NonNull Drawable drawable2) {
        drawable2.invalidateSelf();
    }

    public void unscheduleDrawable(@NonNull Drawable drawable2, @NonNull Runnable runnable) {
        this.handler.removeCallbacks(runnable);
    }

    public void init() {
    }

    public void release() {
        this.volumeDrawable.release();
        this.volumeDrawable = null;
    }

    public static class THandler
    extends Handler {
        private final WeakReference<AudioEffectPresenter> mAudioPreseter;

        public THandler(AudioEffectPresenter audioEffectPresenter) {
            this.mAudioPreseter = new WeakReference<AudioEffectPresenter>(audioEffectPresenter);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (this.mAudioPreseter.get() != null) {
                AudioEffectPresenter audioEffectPresenter = (AudioEffectPresenter)this.mAudioPreseter.get();
                if (audioEffectPresenter.volumeDrawable == null) {
                    return;
                }
                int value = (int)(POCClient.getAudioVolumn(audioEffectPresenter.mRoomId) / 10.0);
                int minValue = audioEffectPresenter.mContext.getResources().getInteger(R.integer.poc_audio_volumn_min_value);
                LogUtils.ILog((String)audioEffectPresenter.TAG, (String)("value: " + value + " minValue:" + minValue));
                value = value < minValue ? 0 : value;
                audioEffectPresenter.volumeDrawable.setVolume(value);
                audioEffectPresenter.handler.sendEmptyMessageDelayed(0, 50L);
            }
        }
    }
}

