/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.ui.history;

import android.media.MediaPlayer;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ToastUtils;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.greendao.HistoryMessageDBHelper;
import com.xdja.poc.sdk.record.http.HttpClientFactory;
import com.xdja.poc.sdk.record.http.IHttpClient;
import com.xdja.poc.sdk.ui.history.POCHistoryMessage;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.Response;

public class HistoryVoicePlayer {
    private static final String TAG = HistoryVoicePlayer.class.getSimpleName();
    private MediaPlayer mediaPlayer;
    private PlayVoiceCallBack playVoiceCallBack;
    private String upVoiceUrl = "";
    private IHttpClient client;
    private boolean downloading = false;
    private static HistoryVoicePlayer instance = null;

    private HistoryVoicePlayer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HistoryVoicePlayer getInstance() {
        if (instance != null) return instance;
        Class<HistoryVoicePlayer> clazz = HistoryVoicePlayer.class;
        synchronized (HistoryVoicePlayer.class) {
            if (instance != null) return instance;
            instance = new HistoryVoicePlayer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void startPlay(POCHistoryMessage message, PlayVoiceCallBack voiceCallBack) {
        String destPath;
        if (this.upVoiceUrl.equals(message.getFileUrl())) {
            if (this.downloading) {
                ToastUtils.showToast((String)"\u8bed\u97f3\u6b63\u5728\u52a0\u8f7d\uff0c\u8bf7\u7a0d\u540e");
                return;
            }
            if (this.mediaPlayer != null && this.mediaPlayer.isPlaying()) {
                this.releasePlay();
                if (this.playVoiceCallBack != null) {
                    this.playVoiceCallBack.onPlayStop();
                }
                return;
            }
        }
        this.upVoiceUrl = message.getFileUrl();
        this.playVoiceCallBack = voiceCallBack;
        if (this.playVoiceCallBack != null) {
            this.playVoiceCallBack.onPlayStart();
        }
        if (!StringUtils.isEmpty((String)(destPath = message.getLocalCacheUri())) && new File(destPath).exists()) {
            this.realPlay(destPath);
            return;
        }
        this.downloadFile(message);
    }

    public void releasePlay() {
        if (this.mediaPlayer != null && this.mediaPlayer.isPlaying()) {
            this.mediaPlayer.stop();
            this.mediaPlayer.release();
        }
        this.mediaPlayer = null;
    }

    public boolean isDownloading() {
        return this.downloading;
    }

    private void realPlay(String fileUri) {
        block2: {
            this.releasePlay();
            this.mediaPlayer = new MediaPlayer();
            try {
                this.mediaPlayer.setDataSource(fileUri);
                this.mediaPlayer.setLooping(false);
                this.mediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                    public boolean onError(MediaPlayer mp, int what, int extra) {
                        HistoryVoicePlayer.this.releasePlay();
                        if (HistoryVoicePlayer.this.playVoiceCallBack != null) {
                            HistoryVoicePlayer.this.playVoiceCallBack.onPlayStop();
                        }
                        return false;
                    }
                });
                this.mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                    public void onCompletion(MediaPlayer mp) {
                        HistoryVoicePlayer.this.releasePlay();
                        if (HistoryVoicePlayer.this.playVoiceCallBack != null) {
                            HistoryVoicePlayer.this.playVoiceCallBack.onPlayStop();
                        }
                    }
                });
                this.mediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                    public void onPrepared(MediaPlayer mp) {
                        if (mp != null) {
                            mp.start();
                        }
                    }
                });
                this.mediaPlayer.prepare();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.releasePlay();
                if (this.playVoiceCallBack == null) break block2;
                this.playVoiceCallBack.onPlayFailed();
            }
        }
    }

    private void downloadFile(POCHistoryMessage message) {
        this.downloading = true;
        final POCHistoryMessage currMessage = message;
        Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

            public void subscribe(final ObservableEmitter<String> emitter) throws Exception {
                if (HistoryVoicePlayer.this.client == null) {
                    HistoryVoicePlayer.this.client = HttpClientFactory.createHttpClient();
                }
                Request request = new Request.Builder().url(currMessage.fileUrl).build();
                HistoryVoicePlayer.this.client.downloadFile(request, new Callback(){

                    public void onFailure(Call call, IOException e) {
                        HistoryVoicePlayer.this.downloading = false;
                        emitter.onError((Throwable)e);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onResponse(Call call, Response response) throws IOException {
                        boolean hasError = false;
                        InputStream is = null;
                        byte[] buff = new byte[1024];
                        FilterOutputStream fos = null;
                        File dir = new File(HistoryVoicePlayer.this.createRecordPath());
                        if (!dir.exists()) {
                            dir.mkdirs();
                        }
                        File file = new File(dir, currMessage.id + "." + currMessage.fileType);
                        try {
                            is = response.body().byteStream();
                            fos = new BufferedOutputStream(new FileOutputStream(file));
                            while (is.read(buff) != -1) {
                                fos.write(buff);
                            }
                            ((BufferedOutputStream)fos).flush();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            emitter.onError((Throwable)e);
                            hasError = true;
                        }
                        finally {
                            try {
                                if (is != null) {
                                    is.close();
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            try {
                                if (fos != null) {
                                    fos.close();
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        HistoryVoicePlayer.this.downloading = false;
                        if (!hasError) {
                            emitter.onNext((Object)file.getAbsolutePath());
                        }
                    }
                });
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(voiceUri -> {
            if (!this.upVoiceUrl.equals(currMessage.getFileUrl())) {
                return;
            }
            currMessage.setLocalCacheUri((String)voiceUri);
            HistoryMessageDBHelper.getInstance().insertOrUpdate(currMessage);
            this.realPlay((String)voiceUri);
        }, e -> {
            if (!this.upVoiceUrl.equals(currMessage.getFileUrl())) {
                return;
            }
            if (this.playVoiceCallBack != null) {
                this.playVoiceCallBack.onPlayFailed();
            }
        });
    }

    private String createRecordPath() {
        return Constants.HISTORY_RECORD_DOWNLOAD_PATH + this.getTime() + File.separator;
    }

    private long getTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd", Locale.CHINA);
        long time = 0L;
        try {
            Date destDate = dateFormat.parse(dateFormat.format(new Date()));
            time = destDate.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return time;
    }

    public static interface PlayVoiceCallBack {
        public void onPlayStart();

        public void onPlayStop();

        public void onPlayFailed();
    }
}

