package com.xdja.poc.sdk.business;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.os.Build;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;

import com.czt.mp3recorder.util.RecordFileUtils;
import com.xdja.net.RetrofitUtil;
import com.xdja.net.observer.CommonObserver;
import com.xdja.net.throwable.HttpThrowable;
import com.xdja.poc.common.utils.ToastUtils;
import com.xdja.poc.sdk.BuildConfig;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.POCMediaAidlInterface;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.WorkHandler;
import com.xdja.poc.sdk.business.bean.POCCallMessage;
import com.xdja.poc.sdk.business.ringplay.RingPlayer;
import com.xdja.poc.sdk.business.webrtc.apprtc.AppRTCAudioManager;
import com.xdja.poc.sdk.business.webrtc.apprtc.PeerConnectionClient;
import com.xdja.poc.sdk.business.webrtc.apprtc.RecordedAudioToFileController;
import com.xdja.poc.sdk.business.webrtc.apprtc.util.AsyncHttpURLConnection;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusAttachSuccessCallBack;
import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusServer;
import com.xdja.poc.sdk.config.GroupConfig;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.NetUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.db.manager.PocDaoGroupManager;
import com.xdja.poc.sdk.greendao.LocalRecordDBHelper;
import com.xdja.poc.sdk.record.RecordMessage;
import com.xdja.poc.sdk.record.UploadRecordHelper;
import com.xdja.poc.sdk.dameon.CancelNoticeService;
import com.xdja.poc.sdk.manager.AMnager;
import com.xdja.poc.sdk.record.api.RecordBusiness;
import com.xdja.poc.sdk.record.api.bean.BaseRecordResponse;
import com.xdja.poc.sdk.record.api.bean.CreateMessageRequest;
import com.xdja.poc.sdk.utils.GroupUtils;
import com.xdja.poc.sdk.utils.IPHost;
import com.xdja.poc.sdk.utils.Utils;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import static com.xdja.poc.sdk.POCClient.TRYCALL_POC_BANK;

/**
 * Created by Administrator on 2018/8/23.
 */

public class POCService extends Service {
    private static String TAG = "POCService";
    public static final String ACTIOON_STOP_SELF = "action_stop_self";
    public static final String ACTION_POC_ALL_ROOM = "action_poc_all_room";
    public static final String ACTION_POC_SWITCH_MUTE_STATUS = "action_poc_switch_mute_status";
    public static final String ACTION_POC_START_WAITING_ACTIVITY = "action_poc_start_waiting_activity";
    private final JanusServer.RandomString stringGenerator = new JanusServer.RandomString();
    private final IBinder mBinder = new ServiceStub(this);
    private int mServiceStartId = -1;
    //ConcurrentHashMap支持并发,内部保证了线程安全
    private Map<String, POCRoom> pocRoomCache = new ConcurrentHashMap<>();
    private Map<Long, String> roomIdAndUrLCache = new ConcurrentHashMap<>();
    private List<String> mCacheReConnectRoomId = new ArrayList<>();
    public Map<String, Boolean> lastMuteStatus = new HashMap<>();
    private WorkHandler workHandler;
    private PeerConnectionClient.PeerConnectionParameters peerConnectionParameters;
    private String mUserId;
    private SubProgressReceiver subProgressReceiver;
    private HandlerThread workThread;
    private boolean isRinging = false;
    private ConcurrentHashMap<String, RoomStatus> roomStatusMap = new ConcurrentHashMap<>();
    private int reconnectTimes = 0;//lyz@xdja.com add for auto reconnect.
    private boolean isReConnect = false;

    @Nullable
    @Override
    public IBinder onBind(Intent intent) {
        return mBinder;
    }

    @Override
    public boolean onUnbind(Intent intent) {
        LogUtils.DLog("POCService", "onUnBind");
        stopSelf(mServiceStartId);
        return true;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        pocRoomCache = new ConcurrentHashMap<>();
        roomIdAndUrLCache = new ConcurrentHashMap<>();
        mCacheReConnectRoomId = new ArrayList<>();
        lastMuteStatus = new HashMap<>();
    }

    private void initReceiver() {
        subProgressReceiver = new SubProgressReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction(ACTION_POC_ALL_ROOM);
        filter.addAction(ACTIOON_STOP_SELF);
        filter.addAction(ACTION_POC_START_WAITING_ACTIVITY);
        filter.addAction(ACTION_POC_SWITCH_MUTE_STATUS);
        filter.addAction(JobSchedulerService.ACTION_CHECK_JANUS_SCHEDULE);
        filter.addAction("update_poc_group_list");
        filter.addAction(Intent.ACTION_SCREEN_ON);
        filter.addAction(Intent.ACTION_HEADSET_PLUG);
        filter.addAction("android.intent.action.PHONE_STATE");
        filter.addAction(BluetoothHeadset.ACTION_CONNECTION_STATE_CHANGED);
        filter.addAction(BluetoothAdapter.ACTION_STATE_CHANGED);
        GlobalContext.getContext().registerReceiver(subProgressReceiver, filter);
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        mServiceStartId = startId;

        LogUtils.ILog("POCService", "onStartCommand");
        return START_STICKY;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        mServiceStartId = -1;
        LogUtils.ELog("POCService", "onDestroy");
        if (subProgressReceiver != null) {
            GlobalContext.getContext().unregisterReceiver(subProgressReceiver);
        }
        if (pocRoomCache != null) {
            pocRoomCache.clear();
            pocRoomCache = null;
        }
        if (peerConnectionParameters != null) {
            peerConnectionParameters = null;
        }
        if (lastMuteStatus != null) {
            lastMuteStatus.clear();
            lastMuteStatus = null;
        }
        if (!StringUtils.isEmpty(PreferenceHelper.getString(UserConfig.LOGIN_ACCOUNT, "")) &&
                PreferenceHelper.getBoolean(UserConfig.IS_SHOW_NOTIFICATION, true)) {
            startService(new Intent(GlobalContext.getContext(), PocNotificationService.class));
        }
        if (workThread != null && workThread.isAlive()) {
            workThread.getLooper().quit();
        }
        UploadRecordHelper.getInstance().stopUploadRecord();
    }

    /**
     * 获取声音的分贝
     *
     * @param roomId
     * @return
     */
    public double getAudioVolumn(String roomId) {
        try {
            if (isRoomCacheContains(String.valueOf(roomId))) {
                return RecordedAudioToFileController.getAudioVolumn();
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(TAG, "getMemberList: " + throwable.getLocalizedMessage());
        }
        return 0;
    }

    private static class ServiceStub extends POCMediaAidlInterface.Stub {
        private WeakReference<POCService> mService;

        private ServiceStub(final POCService service) {
            mService = new WeakReference<>(service);
        }

        @Override
        public void initParams() throws RemoteException {
            if (mService.get() != null)
                mService.get().initParams();
            else
                LogUtils.ELog(TAG, "initParams: mService.get() is null");
        }

        @Override
        public void leaveRoom(String userId, String roomId) throws RemoteException {
            if (mService.get() != null)
                mService.get().leaveRoom(userId, roomId);
            else
                LogUtils.ELog(TAG, "leaveRoom: mService.get() is null");
        }

        @Override
        public void hangUpRoom(String roomId) throws RemoteException {
            if (mService.get() != null)
                mService.get().hangUpRoom(roomId);
            else
                LogUtils.ELog(TAG, "hangUpRoom: mService.get() is null");
        }

        @Override
        public void destroyRoom(String userId, String roomId) throws RemoteException {
            if (mService.get() != null)
                mService.get().destroyRoom(userId, roomId);
            else
                LogUtils.ELog(TAG, "destroyRoom: mService.get() is null");
        }

        @Override
        public void forceQuitRoom(String userId, String targetId, String roomId) throws RemoteException {
            if (mService.get() != null)
                mService.get().forceQuitRoom(userId, targetId, roomId);
            else
                LogUtils.ELog(TAG, "forceQuitRoom: mService.get() is null");
        }

        @Override
        public void deletePocRoomFromServer(String userId, String roomId) throws RemoteException {
            if (mService.get() != null)
                mService.get().deletePocRoomFromServer(userId, roomId);
            else
                LogUtils.ELog(TAG, "deletePocRoomFromServer: mService.get() is null");
        }

        @Override
        public void controlRoomStatus(String roomId, boolean isSilence) throws RemoteException {
            if (mService.get() != null)
                mService.get().controlRoomStatus(roomId, isSilence);
            else
                LogUtils.ELog(TAG, "controlRoomStatus: mService.get() is null");
        }

        @Override
        public void removeRoomFromCache(String userId, String roomId) throws RemoteException {
            if (mService.get() != null)
                mService.get().removeRoomFromCache(true, roomId);
            else
                LogUtils.ELog(TAG, "removeRoomFromCache: mService.get() is null");
        }

        @Override
        public void removeRoomListFromCache() throws RemoteException {
            if (mService.get() != null)
                mService.get().removeRommListFromCache();
            else
                LogUtils.ELog(TAG, "removeRoomListFromCache: mService.get() is null");
        }

        @Override
        public void removeFromReconnectCache(String roomId) throws RemoteException {
            if (mService.get() != null)
                mService.get().removeFromReconnectCache(roomId);
            else
                LogUtils.ELog(TAG, "removeFromReconnectCache: mService.get() is null");

        }

        @Override
        public void getPocRoom(String roomId) throws RemoteException {
            if (mService.get() != null)
                mService.get().getPocRoom(roomId);
            else
                LogUtils.ELog(TAG, "getPocRoom: mService.get() is null");
        }

        @Override
        public void takenTBCP(String roomId, int isForce) throws RemoteException {
            if (mService.get() != null)
                mService.get().takenTBCP(roomId, isForce);
            else
                LogUtils.ELog(TAG, "takenTBCP: mService.get() is null");
        }

        @Override
        public void releaseTBCP(String roomId) throws RemoteException {
            if (mService.get() != null)
                mService.get().releaseTBCP(roomId);
            else
                LogUtils.ELog(TAG, "releaseTBCP: mService.get() is null");
        }

        @Override
        public void destroyAllRoom() throws RemoteException {
            if (mService.get() != null)
                mService.get().destroyAllRoom();
            else
                LogUtils.ELog(TAG, "destroyAllRoom: mService.get() is null");
        }

        @Override
        public void updateForceInsert(String roomId, boolean isForceInsert) throws RemoteException {
            if (mService.get() != null)
                mService.get().updateForceInsert(roomId, isForceInsert);
            else
                LogUtils.ELog(TAG, "updateForceInsert: mService.get() is null");
        }

        @Override
        public boolean getRoomForceInsertStatus(String roomId) throws RemoteException {
            if (mService.get() != null)
                return mService.get().getRoomForceInsertStatus(roomId);
            else
                return false;
        }


        @Override
        public Map getAllSpeakers() throws RemoteException {
            return mService.get() != null ? mService.get().getAllSpeakers() : null;
        }

        @Override
        public void switchAudioTrack() throws RemoteException {
//            if (mService.get() != null)
//                mService.get().checkPlayerStatus();
//            else
//                LogUtils.ELog(TAG, "switchAudioTrack: mService.get() is null");
        }


        @Override
        public void createRoom(long roomId, String secret, String pin, String userId, String userName, String description, boolean permanent, boolean isPrivate) throws RemoteException {
            if (mService.get() != null) {
                mService.get().createRoom(roomId, secret, pin, userId, userName, description, permanent, isPrivate);
            } else {
                LogUtils.ELog(TAG, "createRoom: mService.get() is null");
            }
        }

        @Override
        public void editRoom(long roomid, String secret, String newDescription, String newSecret, String newPin, boolean newIsPrivated, boolean newRequirePrivated, int newBitrate, int newFirFreq, int newPublishers, boolean permanent) throws RemoteException {
            if (mService.get() != null)
                mService.get().editRoom(roomid, secret, newDescription, newSecret, newPin, newIsPrivated, newRequirePrivated, newBitrate, newFirFreq, newPublishers, permanent);
            else
                LogUtils.ELog(TAG, "editRoom: mService.get() is null");
        }

        @Override
        public void existRoom(long roomid) throws RemoteException {
            if (mService.get() != null)
                mService.get().existsRoom(roomid);
            else
                LogUtils.ELog(TAG, "existRoom: mService.get() is null");
        }

        @Override
        public void kickPerson(long roomId, int peopleId, String secret) throws RemoteException {
            if (mService.get() != null)
                mService.get().kickPerson(roomId, peopleId, secret);
            else
                LogUtils.ELog(TAG, "kickPerson: mService.get() is null");
        }

        @Override
        public void listRooms(long roomId) throws RemoteException {
            if (mService.get() != null)
                mService.get().listRoom(roomId);
            else
                LogUtils.ELog(TAG, "listRooms: mService.get() is null");
        }

        @Override
        public void listPeoples(long roomId) throws RemoteException {
            if (mService.get() != null)
                mService.get().listParticipants(roomId);
        }

        @Override
        public void joinRoom(long roomId, int userId, String userName, String pin, String token) throws RemoteException {
            if (mService.get() != null)
                mService.get().joinRoom(roomId, 0, userName, pin, token);
        }

        @Override
        public void createSessionAndAttach(String roomId, String userId, String pin, String userName, String token, int flag) throws RemoteException {
//            if (mService.get() != null) {
//                try {
//                    mService.get().createSessionAndAttach(Long.valueOf(roomId), userId, "", pin, userName, token, flag);
//                } catch (Exception ex) {
//                    LogUtils.ELog("POCService", "err:" + ex.getMessage());
//                }
//            } else {
//                LogUtils.ELog(TAG, "createSessionAndAttach: mService.get() is null");
//            }
        }

        @Override
        public void publish(long roomId, boolean audio, boolean video, boolean data, String audioCode, String videoCode, int bitrate, boolean record, String fileName, String display) throws RemoteException {
            if (mService.get() != null)
                mService.get().publish(roomId, audio, video, data, audioCode, videoCode, bitrate, record, fileName, display);
            else
                LogUtils.ELog(TAG, "publish: mService.get() is null");
        }

        @Override
        public void unpublish(long roomId) throws RemoteException {
            if (mService.get() != null)
                mService.get().unpublish(roomId);
        }

        @Override
        public void configure(long roomId, boolean audio, boolean video, boolean data, int bitrate, boolean record, String fileName, String display) throws RemoteException {
            if (mService.get() != null)
                mService.get().configure(roomId, audio, video, data, bitrate, record, fileName, display);
        }

        @Override
        public void listforwarders(long roomID, String secret) throws RemoteException {
            if (mService.get() != null)
                mService.get().listforwarders(roomID, secret);
        }

        @Override
        public void subscriberJoin(long roomId, int feedId, String pin, int privateId, boolean closePc, boolean audio, boolean video, boolean data, boolean offerAudio, boolean offerVideo, boolean offerData) throws RemoteException {
            if (mService.get() != null)
                mService.get().subscriberJoin(roomId, new BigInteger(Integer.toString(feedId)), pin, new BigInteger(Integer.toString(privateId)), closePc, audio, video, data, offerAudio, offerVideo, offerData);
        }

        @Override
        public void startMedia(long roomId) throws RemoteException {
            if (mService.get() != null)
                mService.get().startMedia(roomId);
        }

        @Override
        public void pauseMedia(long roomId) throws RemoteException {
            if (mService.get() != null)
                mService.get().pauseMedia(roomId);
        }

        @Override
        public void switchSubscriber(long roomId, int feed, boolean audio, boolean video, boolean data) throws RemoteException {
            if (mService.get() != null)
                mService.get().switchSubscriber(roomId, feed, audio, video, data);
        }

        @Override
        public void mute(long roomId, boolean enable) throws RemoteException {
            if (mService.get() != null)
                mService.get().mute(roomId, enable);
        }

        @Override
        public void muteAndNotifyUI(long roomId, boolean enable) throws RemoteException {
            if (mService.get() != null)
                mService.get().muteAndNotifyUI(roomId, enable);
            else
                LogUtils.ELog(TAG, "muteAndNotifyUI: mService.get() is null");
        }

        @Override
        public void muteAllRoomStatus(boolean enable, String channelId) throws RemoteException {
            if (mService.get() != null)
                mService.get().muteAllRoomStatus(enable, channelId);
            else
                LogUtils.ELog(TAG, "muteAllRoomStatus: mService.get() is null");
        }

        @Override
        public void reMuteLastStatus() throws RemoteException {
            if (mService.get() != null)
                mService.get().reMuteLastStatus();
            else
                LogUtils.ELog(TAG, "reMuteLastStatus: mService.get() is null");
        }

        @Override
        public List<String> getMemberList(long roomId) throws RemoteException {
            return mService.get() != null ? mService.get().getMemberList(roomId) : null;
        }

        @Override
        public double getAudioVolumn(String roomId) throws RemoteException {
            return mService.get() != null ? mService.get().getAudioVolumn(roomId) : 0;
        }

        @Override
        public void sendPocCallMember(String json, String imeiArray, String roomId) throws RemoteException {
            if (mService.get() != null)
                mService.get().sendPocCallMember(json, imeiArray, roomId);
        }

        @Override
        public void sendPocUserBusy(String json, String senderUserId, String roomId) throws RemoteException {
            if (mService.get() != null)
                mService.get().sendPocUserBusy(json, senderUserId, roomId);
        }

        @Override
        public void sendPocRejectCall(String json, String senderUserId, String roomId) throws RemoteException {
            if (mService.get() != null)
                mService.get().sendPocRejectCall(json, senderUserId, roomId);
        }

        @Override
        public void sendPocAcceptCall(String json, String senderUserId, String roomId) throws RemoteException {
            if (mService.get() != null)
                mService.get().sendPocAcceptCall(json, senderUserId, roomId);
        }

        @Override
        public void sendPocDelayCall(String json, String senderUserId, String roomId) throws RemoteException {
            if (mService.get() != null)
                mService.get().sendPocDelayCall(json, senderUserId, roomId);
        }

        @Override
        public void insertTempGroupData(String roomId, String roomName, String userIds, String ownerId) throws RemoteException {
            if (mService.get() != null)
                mService.get().insertTempGroupData(roomId, roomName, userIds, ownerId);
        }

        @Override
        public void deleteRoomByRoomId(String userId, String roomId) throws RemoteException {
            if (mService.get() != null)
                mService.get().deleteRoomByRoomId(userId, roomId);
        }

        @Override
        public void deleteRoomByIdWithNotifyUI(String userId, String roomId, int position) throws RemoteException {
            if (mService.get() != null)
                mService.get().deleteRoomByIdWithNotifyUI(userId, roomId, position);
        }

        @Override
        public void updateGroupMuteStatus(String userId, String roomId, boolean status) throws RemoteException {
            if (mService.get() != null)
                mService.get().updateGroupMuteStatus(userId, roomId, status);
        }


        @Override
        public void handleNetConnectFailed() throws RemoteException {
//            mService.get().handleNetConnectFailed();
        }

        @Override
        public void handleNetConnectSuccess() throws RemoteException {
            if (mService.get() != null)
                mService.get().handleNetConnectSuccess();
            else
                LogUtils.ELog(TAG, "handleNetConnectSuccess: mService.get() is null");
        }

        @Override
        public List<String> getOnLineRoom() throws RemoteException {
            return mService.get() != null ? mService.get().getOnLineRoom() : null;
        }

        @Override
        public List<String> getReconnectRoom() throws RemoteException {
            return mService.get() != null ? mService.get().getReconnectRoom() : null;
        }

        @Override
        public boolean insertStickGroupData(String json) throws RemoteException {
            return mService.get() != null && mService.get().insertStickGroupData(json);
        }

        @Override
        public void uploadRecord(String recordUri) throws RemoteException {
            if (mService.get() != null) {
                mService.get().realUploadRecord(recordUri);
            }
        }
    }

    private boolean getRoomForceInsertStatus(String roomId) {
        if (isRoomCacheContains(roomId)) {
            POCRoom pocRoom = pocRoomCache.get(roomId);
            if (pocRoom != null) {
                return pocRoom.getForceInsertStatus();
            }
        }
        return false;
    }

    private void updateForceInsert(String roomId, boolean isForceInsert) {
        if (isRoomCacheContains(roomId)) {
            POCRoom pocRoom = pocRoomCache.get(roomId);
            if (pocRoom != null) {
                pocRoom.updateForceInsert(isForceInsert);
            }
        }
    }

    private void hangUpRoom(String roomId) {
        if (isRoomCacheContains(roomId)) {
            POCRoom pocRoom = pocRoomCache.get(roomId);
            if (pocRoom != null) {
                pocRoom.hangupPeerConnection();
            }
        }
    }

    private void removeFromReconnectCache(String roomId) {
        if (mCacheReConnectRoomId != null && mCacheReConnectRoomId.size() > 0) {
            LogUtils.ILog("removeFromReconnectCache: remove  from reconnectList: " + roomId);
            mCacheReConnectRoomId.remove(roomId);
        } else {
            LogUtils.ELog(TAG, "removeFromReconnectCache:mCacheReConnectRoomId.size()= " + (mCacheReConnectRoomId != null ? mCacheReConnectRoomId.size() : 0));
        }
    }

    /**
     * 获取断网重连的缓存频道数
     *
     * @return
     */
    private List<String> getReconnectRoom() {
        return mCacheReConnectRoomId;
    }

    private boolean insertStickGroupData(String json) {
        if (StringUtils.isEmpty(json)) {
            return false;
        }
        POCHandlerService.insertOrReplaceGroupData(POCService.this, json);
        return true;
    }


    /**
     * @return
     */
    private Map<String, String> getAllSpeakers() {
        Map<String, String> mSpeakers = null;
        try {
            if (pocRoomCache != null && pocRoomCache.size() > 0) {
                mSpeakers = new HashMap<>();
                for (String roomId : pocRoomCache.keySet()) {
                    if (pocRoomCache.containsKey(roomId) && pocRoomCache.get(roomId) == null) {
                        pocRoomCache.remove(roomId);
                        removeRoomStatusCache(roomId);
                        continue;
                    }
                    String currTBCPUser = pocRoomCache.get(roomId).getCurrTBCPUser();
                    if (!StringUtils.isEmpty(currTBCPUser)) {
                        mSpeakers.put(roomId, currTBCPUser);
                    }
                }
            }
        } catch (Exception e) {
            LogUtils.ELog(TAG, "getAllSpeakers: " + e.getMessage());
        }

        LogUtils.ILog("mSpeakers: " + (mSpeakers == null ? 0 : mSpeakers.size()));
        return mSpeakers;
    }

    /**
     * 获取在线的频道集合
     *
     * @return
     */
    private List<String> getOnLineRoom() {
        List<String> mList = new ArrayList<>();
        if (pocRoomCache == null || pocRoomCache.size() <= 0) {
            LogUtils.ILog("OnLineRoomCount: " + 0);
            return mList;
        }
        int count = 0;
        for (String roomId : pocRoomCache.keySet()) {
            List<String> memberList = getMemberList(Long.valueOf(roomId));
            if (memberList == null || memberList.size() <= 0) {
                break;
            }
            mList.add(roomId);
        }
        LogUtils.ILog("OnLineRoomCount: " + count);
        return mList;
    }


    private void sendPocDelayCall(String json, String senderUserId, String roomId) {
    }

    private void updateGroupMuteStatus(String userId, String roomId, boolean status) {
        POCHandlerService.updateGroupIsSilence(POCService.this, userId, roomId, status);
    }

    private void deleteRoomByIdWithNotifyUI(String userId, String roomId, int position) {
        POCHandlerService.deleteRoomByIdWithNotifyUI(POCService.this, userId, roomId, position);
    }

    /**
     * 插入临时频道数据
     *
     * @param roomId
     * @param memberInfoList
     */
    private void insertTempGroupData(String roomId, String roomName, String memberInfoList, String ownerId) {
//        POCHandlerService.insertTempGroupData(POCService.this, mUserId, roomId, roomName, memberInfoList, ownerId);
    }

    /**
     * 发起成员呼叫
     *
     * @param json
     * @param imeiArray
     */
    private void sendPocCallMember(String json, String imeiArray, String roomId) {
    }

    /**
     * 用户在忙
     *
     * @param json
     * @param senderUserId
     * @param roomId
     */
    private void sendPocUserBusy(String json, String senderUserId, String roomId) {
    }

    /**
     * 发送拒绝信令
     *
     * @param json
     * @param roomId
     */
    private void sendPocRejectCall(String json, String senderUserId, String roomId) {
//        mPushPresenter.sendRejectPocCall(json, senderUserId, roomId);
    }

    /**
     * 发送接收信令
     *
     * @param json
     * @param roomId
     */
    private void sendPocAcceptCall(String json, String senderUserId, String roomId) {
    }

    /**
     * 从缓存中移出:未创建成功的/未加入成功的room
     */
    private void removeRommListFromCache() {
        try {
            if (pocRoomCache != null && pocRoomCache.size() > 0) {
                Set<String> strings = pocRoomCache.keySet();
                for (String id : strings) {
                    if (isRoomCacheContains(id)) {
                        POCRoom pocRoom = pocRoomCache.get(id);
                        if (pocRoom != null) {
                            if ((!pocRoom.isCreated() || !pocRoom.isJoined())) {
                                pocRoomCache.remove(id);
                                removeRoomStatusCache(id);
                            }
                        } else {
                            pocRoomCache.remove(id);
                        }
                    }
                }
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(TAG, "removeRommListFromCache:" + throwable.getLocalizedMessage());
        }
    }

    /**
     * 销毁所有频道
     */
    private void destroyAllRoom() {
        workHandler.post(new Runnable() {
            @Override
            public void run() {
                try {
                    LogUtils.DLog(TAG, "start destroyAllRoom");
                    mCacheReConnectRoomId.clear();
                    if (pocRoomCache == null) {
                        LogUtils.DLog(TAG, "destroyAllRoom, pocRoomCache is null");
                        return;
                    }
                    if (pocRoomCache.size() > 0) {
                        for (String roomId : pocRoomCache.keySet()) {
                            if (pocRoomCache.containsKey(roomId)) {
                                pocRoomCache.get(roomId).leaveRoom();
//                        pocRoomCache.get(roomId).destroyRoom(Integer.parseInt(roomId), null, false);
                            }
                        }
                    }
                    POCRoom.disconnectServer();
                    pocRoomCache.clear();
                } catch (Throwable e) {
                    LogUtils.ELog(TAG, "destroyAllRoom: " + e.getLocalizedMessage());
                }
            }
        });


    }

    /**
     * 释放TBCP 讲话
     *
     * @param roomId
     */
    private void releaseTBCP(String roomId) {
        try {
            LogUtils.DLog(TAG, "POCService releaseTBCP ....");
            if (isRoomCacheContains(roomId)) {
                POCRoom pocRoom = pocRoomCache.get(roomId);
                if (pocRoom != null) pocRoom.releaseTBCP();
                else
                    LogUtils.ELog(TAG, "releaseTBCP: " + "pocRoomCache contains " + roomId + " but pocRoom is null");
            } else {
                LogUtils.ELog(TAG, "releaseTBCP: " + "pocRoomCache not contains " + roomId);
                MessageProxy.sendUserChanged(POCService.this, String.valueOf(roomId), null, Constants.ROOM_SEVER_DISCONNECT);
            }
        } catch (Throwable e) {
            LogUtils.ELog(TAG, "releaseTBCP: " + e.getLocalizedMessage());
        }

    }

    /**
     * 开始讲话
     *
     * @param roomId
     */
    private void takenTBCP(String roomId, int isForce) {
        try {
            if (isRoomCacheContains(roomId)) {
                POCRoom pocRoom = pocRoomCache.get(roomId);
                if (pocRoom != null) pocRoom.takenTBCP(isForce);
                else
                    LogUtils.ELog(TAG, "takenTBCP: " + "pocRoomCache contains " + roomId + " but pocRoom is null");
            } else {
                LogUtils.ELog(TAG, "takenTBCP: " + "pocRoomCache not contains " + roomId);
                MessageProxy.sendUserChanged(POCService.this, String.valueOf(roomId), null, Constants.ROOM_SEVER_DISCONNECT);
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(throwable);
        }

    }

    /**
     * 离开
     *
     * @param roomId
     */
    private void leaveRoom(String userId, String roomId) {
        LogUtils.ILog(TAG, "leavedRoom: " + roomId);
        try {
//            if (netTips()) return;
            if (isRoomCacheContains(roomId)) {
                POCRoom pocRoom = pocRoomCache.get(roomId);
                if (pocRoom != null) {
                    pocRoom.leaveRoom();
                    pocRoom.hangupPeerConnection();
                    pocRoomCache.remove(roomId);
                    removeRoomStatusCache(roomId);
                    LogUtils.ILog("pocRoomCache leaveRoom");
                } else {
                    LogUtils.ELog(TAG, "leaveRoom: " + "pocRoomCache contains " + roomId + " but pocRoom is null");
                }
            } else {
                LogUtils.ELog(TAG, "leaveRoom: " + "pocRoomCache not contains " + roomId + " but pocRoom is null");
                ArrayList<String> strings = new ArrayList<>();
                strings.add("缓存中没有当前频道");
                removeRoomStatusCache(roomId);
                MessageProxy.sendUserChanged(POCService.this, String.valueOf(roomId), strings, Constants.ROOM_LEAVE_SUCCESS);
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(TAG, "leaveRoom: " + throwable.getLocalizedMessage());
            removeRoomStatusCache(roomId);
        }
    }

    /**
     * 销毁频道
     *
     * @param roomId
     */
    private void destroyRoom(String roomId, String secret) {
        LogUtils.ILog(TAG, "destroyRoom: " + roomId);
        try {
            if (netTips()) return;
            if (isRoomCacheContains(roomId)) {
                POCRoom pocRoom = pocRoomCache.get(roomId);
                if (pocRoom != null) {
//                    pocRoom.destroyRoom(Integer.parseInt(roomId), secret, false);
                    removeRoomStatusCache(String.valueOf(roomId));
                    pocRoom.leaveRoom();
                    pocRoom.hangupPeerConnection();
                    pocRoomCache.remove(roomId);
                    LogUtils.ILog("pocRoomCache destroyRoom");
                } else {
                    LogUtils.ELog(TAG, "destroyRoom: " + "pocRoomCache contains " + roomId + " but pocRoom is null");
                }
            } else {
                LogUtils.ELog(TAG, "destroyRoom: " + "pocRoomCache not contains " + roomId);
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(TAG, "destroyRoom: " + throwable.getLocalizedMessage());
        }
    }

    /**
     * 将某人强制退出频道
     *
     * @param roomId
     */
    private void forceQuitRoom(String userId, String targetId, String roomId) {
        LogUtils.ILog(TAG, "forceQuitRoom: " + roomId);
        try {
            if (netTips()) return;
            if (isRoomCacheContains(roomId)) {
                POCRoom pocRoom = pocRoomCache.get(roomId);
                if (pocRoom != null) {
                    pocRoom.leaveRoom();
                    pocRoomCache.remove(roomId);
                    removeRoomStatusCache(String.valueOf(roomId));
                    LogUtils.ILog("pocRoomCache forceQuitRoom");
                }
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(TAG, "forceQuitRoom: " + throwable.getLocalizedMessage());
        }
    }

    /**
     * （群主）删除/解散频道
     *
     * @param roomId
     */
    private void deletePocRoomFromServer(String userId, String roomId) {
        LogUtils.ILog(TAG, "deletePocRoomFromServer: " + roomId);
        try {
            if (netTips()) return;
            if (isRoomCacheContains(roomId)) {
                POCRoom pocRoom = pocRoomCache.get(roomId);
                if (pocRoom != null) pocRoom.leaveRoom();
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(TAG, "deletePocRoomFromServer: " + throwable.getLocalizedMessage());
        }
    }

    /**
     * 设置频道当前状态
     *
     * @param roomId
     * @param isSilence true: 不接收  false 接收
     */
    private void controlRoomStatus(String roomId, boolean isSilence) {
        try {

        } catch (Throwable throwable) {
            LogUtils.ELog(TAG, throwable.getLocalizedMessage());
        }
    }

    /**
     * 删除频道数据
     *
     * @param userId
     * @param roomId
     */
    private void deleteRoomByRoomId(String userId, String roomId) {
        LogUtils.ILog(TAG, "deleteRoomByRoomId: " + roomId);
        try {
            POCHandlerService.deleteRoomByRoomId(POCService.this, GroupUtils.generatePOCGroupDbKey(userId, roomId));
        } catch (Throwable throwable) {
            LogUtils.ELog(TAG, throwable.getLocalizedMessage());
        }
    }


    /**
     * 某人加入某个频道
     */
    /*private synchronized void joinRoom(String userId, String roomId) {
        try {
            if(netTips()) return;
            POCRoom pocRoom;
            if (pocRoomCache.containsKey(roomId)) {
                pocRoom = pocRoomCache.get(roomId);
            } else {
                pocRoom = getPocRoom(roomId, userId, false);
                pocRoomCache.put(roomId, pocRoom);
            }
            if (pocRoom != null) {
                if (pocRoom.mProperty.isJoining) {
                    showToast("正在加入频道");
                    return;
                }
                if (pocRoom.mProperty.isJoin) {
                    showToast("您已在频道内");
                    return;
                }
                pocRoom.mProperty.isJoining = true;
                pocRoom.initializeMediaContext(POCService.this, true, true, true, peerConnectionParameters, null);
                pocRoom.startConnectServer();
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(throwable);
        }
    }
*/
    private void showToast(final String msg) {
        workHandler.post(new Runnable() {
            @Override
            public void run() {
                LogUtils.ILog(msg);
            }
        });
    }

    /**
     * 某人创建频道
     *
     * @param userId
     */
   /* private synchronized void createRoom(String userId, String roomId) {
        try {
            if (netTips()) return;
            POCRoom pocRoom;
            if (isRoomCacheContains(roomId)) {
                pocRoom = pocRoomCache.get(roomId);
            } else {
                pocRoom = getPocRoom(roomId, userId, true);
                pocRoomCache.put(roomId, pocRoom);
            }
            if (pocRoom != null) {
                if (pocRoom.mProperty.isCreating) {
                    showToast("正在创建频道");
                    return;
                }
                if (pocRoom.mProperty.isCreate) {
                    showToast("对应的频道已创建,直接加入该频道");
                    joinRoom(userId, roomId);
                    return;
                }
                pocRoom.mProperty.isCreating = true;
                pocRoom.initializeMediaContext(POCService.this, true, true, true, peerConnectionParameters, null);
                pocRoom.startConnectServer();
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(throwable);
        }


    }*/

    /**
     * 加入频道
     *
     * @param token 加入频道校验令牌
     */
    private synchronized void joinRoom(final long roomId, final Integer userId, final String userName, final String pin, final String token) {
//        LogUtils.ILog(TAG, "joinRoom: " + roomId);
//        try {
//            if (isRoomCacheContains(String.valueOf(roomId))) {
//                POCRoom pocRoom = pocRoomCache.get(String.valueOf(roomId));
//                if (pocRoom != null) {
//                    pocRoom.newJoinRoom(roomId, userId, userName, pin, token);
//                } else {
//                    LogUtils.ELog(TAG, "joinRoom: pocRoomCache contains roomId, but  pocRoom is null ");
//                }
//            } else {
//                createSessionAndAttach(roomId, Integer.toString(userId), "", pin, userName, token, Constants.ROOM_STATUS_JOIN);
//                final POCRoom pocRoom = pocRoomCache.get(String.valueOf(roomId));
//                if (pocRoom != null) {
//                    pocRoom.registAttachSuccessCallBack(new IJanusAttachSuccessCallBack() {
//                        @Override
//                        public void createSessionAndAttachSuccess() {
//                            pocRoom.newJoinRoom(roomId, userId, userName, pin, token);
//                        }
//                    });
//                } else {
//                    LogUtils.ELog(TAG, "joinRoom: pocRoomCache not contains roomId and  pocRoom is null ");
//                }
//
//            }
//        } catch (Throwable throwable) {
//            LogUtils.ELog(TAG, "joinRoom: " + throwable.getLocalizedMessage());
//        }
    }

    private void realUploadRecord(String recordUri) {
        UploadRecordHelper.getInstance().startUploadRecord(recordUri);
        UploadRecordHelper.getInstance().setUploadRecordCallBack(new UploadRecordHelper.UploadRecordCallBack() {
            @Override
            public void onUploadRecordSuccess(String fileId, String fileUri) {
                //录音数据上传完成，广播出去
                MessageProxy.sendUploadRecordResultBroadcast(POCService.this, fileId, fileUri, 0);

                RecordMessage recordMessage = LocalRecordDBHelper.getInstance().update(fileUri,
                        IPHost.getFastDfsUrl() + File.separator + fileId);
                if (recordMessage == null) {
                    return;
                }
                commitMessageRecord(recordMessage);
            }

            @Override
            public void onUploadRecordFailed(int errorCode, String fileUri) {
                MessageProxy.sendUploadRecordResultBroadcast(POCService.this, null, fileUri, errorCode);
            }
        });
    }

    private void commitMessageRecord(RecordMessage recordMessage) {
        CreateMessageRequest request = new CreateMessageRequest();
        request.setType(CreateMessageRequest.TYPE_VOICE);
        request.setGroupUri(recordMessage.getRecordRoom());
        request.setFileUrl(recordMessage.getRecordRemoteUrl());
        request.setFileSize(Integer.valueOf(recordMessage.getRecordTimeLen()));
        RetrofitUtil.request(RecordBusiness.createTalkGroupMessage(request), new CommonObserver<BaseRecordResponse<String>>() {
            @Override
            public void onResult(BaseRecordResponse<String> result) {
                if (Constants.RESPONSE_SUCCESS.equals(result.getResult())) {
                    LogUtils.DLog(TAG, "录音记录提交成功，删除本地录音");
                    LocalRecordDBHelper.getInstance().delete(recordMessage.getRecordUri());
                    File desFile = new File(recordMessage.getRecordUri());
                    if (desFile.exists()) {
                        desFile.delete();
                    }
                    //录音记录上传完成，广播出去
                    MessageProxy.sendCommitRecordResultBroadcast(POCService.this, recordMessage.getRecordUri(), 0);
                    uploadNextRecord();
                }
                LogUtils.DLog(TAG, "commitMessageRecord_onResult: " + result);
            }

            @Override
            public void onError(HttpThrowable httpThrowable) {
                LogUtils.DLog(TAG, "commitMessageRecord_onError: " + httpThrowable.message);
                MessageProxy.sendCommitRecordResultBroadcast(POCService.this, recordMessage.getRecordUri(), -1);
            }
        });
    }

    private void uploadNextRecord() {
        LogUtils.DLog(TAG, "查找下一未上传录音");
        //查询未上传录音
        RecordMessage waitUploadMessage = LocalRecordDBHelper.getInstance().queryNoUploadRecord();
        if (waitUploadMessage == null) {
            File cacheDir = new File(Constants.HISTORY_RECORD_FILE_PATH);
            if (!cacheDir.exists()) {
                return;
            }
            String[] cacheFiles = cacheDir.list();
            if (cacheFiles == null || cacheFiles.length == 0) {
                return;
            }
            for (String dest : cacheFiles) {
                File file = new File(cacheDir, dest);
                if (file.exists()) {
                    file.delete();
                }
            }
            LogUtils.DLog(TAG, "无未上传录音，删除所有本地录音");
            return;
        }
        //已上传fastdfs，直接提交记录
        if (!StringUtils.isEmpty(waitUploadMessage.getRecordRemoteUrl())) {
            commitMessageRecord(waitUploadMessage);
            LogUtils.DLog(TAG, "录音已上传fastdfs，直接提交记录");
            return;
        }
        //上传fastdfs
        LogUtils.DLog(TAG, "录音上传fastdfs");
        realUploadRecord(waitUploadMessage.getRecordUri());
    }

    private synchronized void createSessionAndAttach(long roomId, String userId, final String secret, final String pin, String userName, String token, int flag) {
        try {
            if (isRoomCacheContains(String.valueOf(roomId))) {
                POCRoom pocRoom = pocRoomCache.get(String.valueOf(roomId));
                if (pocRoom != null && flag == Constants.ROOM_STATUS_CREATE) {
                    if (pocRoom.isJoined() && pocRoom.isCreated()) {
                        MessageProxy.sendUserChanged(POCService.this, String.valueOf(roomId), pocRoom.getMemberList(), Constants.ROOM_JOIN_SUCCESS);
                        return;
                    }
                    //other status, just reconnect.
                }
                if (pocRoom != null) {
                    pocRoom.hangupPeerConnection();
                } else {
                    LogUtils.ELog(TAG, "createSessionAndAttach: pocRoomCache contains roomId but  pocRoom is null ");
                }
                pocRoomCache.remove(String.valueOf(roomId));
                removeRoomStatusCache(String.valueOf(roomId));
            }

            //检查房间状态，一次只容许一个POCRoom房间创建
            RoomStatus roomStatus = getRoomStatus(String.valueOf(roomId));
            if (roomStatus != null && roomStatus.isCreating()) {
                LogUtils.ELog(TAG, "the room " + roomId + " is creating");
                return;
            }
            setRoomStatusCreating(String.valueOf(roomId));
            //end
            getPocRoom(roomId, userId, flag, new PocRoomGetCallback() {
                @Override
                public void onSuccess(POCRoom pocRoom, boolean isCache) {
                    if (handleExceptionChannel(roomId) || pocRoomCache == null) return;
                    if (pocRoomCache.containsKey(String.valueOf(roomId)) && (pocRoomCache.get(String.valueOf(roomId)) != null)) {
                        LogUtils.ELog(TAG, "pocRoomCache has :" + roomId);
                        removeRoomStatusCache(String.valueOf(roomId));
                        return;
                    }
                    if (pocRoom != null) {
                        pocRoomCache.put(String.valueOf(roomId), pocRoom);
                        pocRoom.initializeMediaContext(POCService.this, true, true, true, peerConnectionParameters, null);

                        pocRoom.registAttachSuccessCallBack(new IJanusAttachSuccessCallBack() {
                            @Override
                            public void createSessionAndAttachSuccess() {
                                if (!pocRoom.newCreateRoom(roomId, secret, pin, userId, userName, "", Boolean.FALSE, Boolean.FALSE)) {
                                    LogUtils.ILog("newCreateRoom failed.");
                                    MessageProxy.sendUserChanged(POCService.this, String.valueOf(roomId), pocRoom.getMemberList(), Constants.ROOM_CREATE_FAILED);
                                }
                            }
                        });
                        if (!pocRoom.startConnectServer()) {
                            //failed
                            LogUtils.ILog("getPocRoom onSuccess: connect room server failed.");
                            MessageProxy.sendUserChanged(POCService.this, String.valueOf(roomId), pocRoom.getMemberList(), Constants.ROOM_CREATE_FAILED);
                        } else {
                            LogUtils.ELog(TAG, "createSessionAndAttach: getPocRoom onSuccess, pocRoom.startConnectServer() is true");

                            MessageProxy.sendUserChanged(POCService.this, String.valueOf(roomId), pocRoom.getMemberList(), Constants.ROOM_CREATE_FAILED);
                            removeRoomStatusCache(String.valueOf(roomId));
                        }
                    } else {
                        LogUtils.ELog(TAG, "createSessionAndAttach: getPocRoom onSuccess, but pocRoom is null ");

                        assert pocRoom != null;
                        MessageProxy.sendUserChanged(POCService.this, String.valueOf(roomId), pocRoom.getMemberList(), Constants.ROOM_CREATE_FAILED);
                        removeRoomStatusCache(String.valueOf(roomId));
                    }
                }

                @Override
                public void onFail(String msg) {
                    if (handleExceptionChannel(roomId)) return;
                    LogUtils.ELog(TAG, "createSessionAndAttach: getPocRoom onFail:  " + msg);
                    removeRoomStatusCache(String.valueOf(roomId));
                    MessageProxy.sendUserChanged(POCService.this, String.valueOf(roomId), null, Constants.ROOM_SERVER_LOAD_FAILED);
                    if (!mCacheReConnectRoomId.contains(String.valueOf(roomId))) {
                        mCacheReConnectRoomId.add(String.valueOf(roomId));
                    }
                }
            });
//            pocRoomCache.put(roomId, pocRoom);
        } catch (Throwable throwable) {
            if (handleExceptionChannel(roomId)) return;
            LogUtils.ELog(TAG, "createSessionAndAttach: " + throwable.getLocalizedMessage());
            removeRoomStatusCache(String.valueOf(roomId));
            MessageProxy.sendUserChanged(POCService.this, String.valueOf(roomId), null, Constants.ROOM_CREATE_FAILED);
            if (!mCacheReConnectRoomId.contains(String.valueOf(roomId))) {
                mCacheReConnectRoomId.add(String.valueOf(roomId));
            }
        }
    }

    /**
     * add by wwq
     * 判断断网重连获取ip端口后的缓存里是否包含该房间，如果不包含说明不用真正start
     *
     * @param roomId
     * @return
     */
    private boolean handleExceptionChannel(long roomId) {
        if (mCacheReConnectRoomId != null && mCacheReConnectRoomId.size() > 0) {
            if (!mCacheReConnectRoomId.contains(String.valueOf(roomId))) {
                removeRoomStatusCache(String.valueOf(roomId));
                return true;
            }
        }
        return false;
    }

    /**
     * 创建频道
     *
     * @param roomId      频道id
     * @param secret      操作频道密码
     * @param pin         加入频道密码
     * @param userName    用户名称
     * @param description 频道描述或名称
     * @param permanent   是否将频道保存到配置文件中
     * @param isPrivate   频道是否私有
     */
    private synchronized void createRoom(final long roomId, final String secret, final String pin, final String userId, final String userName,
                                         final String description, final @Nullable Boolean permanent, final @Nullable Boolean isPrivate) {
        LogUtils.ELog(TAG, "createRoom: " + roomId);

        try {
            createSessionAndAttach(roomId, userId, secret, pin, userName, "", Constants.ROOM_STATUS_CREATE);
        } catch (Throwable throwable) {
            LogUtils.ELog(TAG, "createRoom: " + throwable.getLocalizedMessage());
            removeRoomStatusCache(String.valueOf(roomId));
        }
    }

    private void setRoomStatusCreating(String roomId) {
        RoomStatus roomStatus = new RoomStatus();
        roomStatus.setCreating(true);
        roomStatusMap.put(roomId, roomStatus);
    }

    private void setRoomStatusCreated(String roomId) {
        RoomStatus roomStatus = new RoomStatus();
        roomStatus.setCreated(true);
        roomStatusMap.put(roomId, roomStatus);
    }

    private void setRoomStatusDestroyed(String roomId) {
        RoomStatus roomStatus = new RoomStatus();
        roomStatus.setDestroy(true);
        roomStatusMap.put(roomId, roomStatus);
    }

    private void removeRoomStatusCache(String roomId) {
        roomStatusMap.remove(roomId);
    }

    private RoomStatus getRoomStatus(String roomId) {
        RoomStatus status = roomStatusMap.get(roomId);
        if (status != null) {
            LogUtils.ILog(TAG, "status:" + status.toString());
        }
        return status;
    }

    private void getPocRoomServer(long roomId, GetJanusUrlCallback getJanusUrlCallback) {
        LogUtils.ELog(TAG, "getPocRoomServer: " + roomId);
        try {
           /* String cacheUrl = roomIdAndUrLCache.get(roomId);
            if (cacheUrl != null) {
                return getJanusUrlCallback.onSuccess(cacheUrl);
            }*/
            JSONObject object = new JSONObject();
            object.put("janus", "query_valid_server");
            object.put("transaction", stringGenerator.randomString(12));
            object.put("admin_secret", "xdja_api_abc_admin");
            object.put("room_id", roomId);
            AsyncHttpURLConnection httpConnection =
                    new AsyncHttpURLConnection("POST", IPHost.getLoadBalanceServer(), object.toString(), new AsyncHttpURLConnection.AsyncHttpEvents() {
                        @Override
                        public void onHttpError(String errorMessage) {
                            LogUtils.ELog(TAG, "getPocRoomServer: onHttpError," + errorMessage);
                            getJanusUrlCallback.onFail(errorMessage);
                        }

                        @Override
                        public void onHttpComplete(String response) {
                            LogUtils.ELog(TAG, "getPocRoomServer: onHttpComplete," + response);
                            try {
                                JSONObject jsonObject = new JSONObject(response);
                                String success = jsonObject.getString("janus");
                                if ((jsonObject.has("ip") && jsonObject.has("balance_ip")) || "success".equals(success)) {
                                    jsonObject.getString("transaction");
                                    String ip = jsonObject.getString("ip");
                                    String port = jsonObject.getString("port");

                                    String balance_ip = jsonObject.getString("balance_ip");
                                    String balance_port = jsonObject.getString("balance_port");
                                    String balance_ts = jsonObject.getString("balance_ts");
                                    Utils.offset_localTime_serverTime = System.currentTimeMillis() / 1000 - Long.parseLong(balance_ts) / 1000;

                                    LogUtils.DLog("zlq", "balance_ip==" + balance_ip + "balance_port==" + balance_port + "balance_ts==" + balance_ts + "offset==" + Utils.offset_localTime_serverTime);
                                    String janusUrl = "ws://" + ip + ":" + port;
                                    roomIdAndUrLCache.put(roomId, janusUrl);
                                    getJanusUrlCallback.onSuccess(janusUrl);
                                } else {
                                    getJanusUrlCallback.onFail("error onHttpComplete fail");
                                }

                            } catch (JSONException e) {
                                e.printStackTrace();
                                getJanusUrlCallback.onFail(e.getMessage());
                            }
                        }
                    });
            httpConnection.send();
        } catch (JSONException e) {
            LogUtils.ELog(TAG, "getPocRoomServer: " + e.getLocalizedMessage());
            getJanusUrlCallback.onFail(e.getMessage());
        }

    }

    private synchronized void editRoom(long roomid, String secret, String newDescription,
                                       String newSecret, String newPin, @Nullable Boolean newIsPrivated, @Nullable Boolean newRequirePrivated,
                                       @Nullable Integer newBitrate, @Nullable Integer newFirFreq, @Nullable Integer newPublishers, @Nullable Boolean permanent) {
        LogUtils.ELog(TAG, "editRoom: " + roomid);
        try {
            if (isRoomCacheContains(String.valueOf(roomid))) {
                POCRoom pocRoom = pocRoomCache.get(String.valueOf(roomid));
                if (pocRoom != null) {
                    pocRoom.editRoom(roomid, secret, newDescription, newSecret, newPin, newIsPrivated, newRequirePrivated, newBitrate, newFirFreq, newPublishers, permanent);
                }
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(TAG, "editRoom: " + throwable.getLocalizedMessage());
        }
    }

    //与是否创建频道无关
    private void existsRoom(final long roomId) {
        LogUtils.ELog(TAG, "existsRoom: " + roomId);
//        try {
//            if (isRoomCacheContains(String.valueOf(roomId))) {
//                POCRoom pocRoom = pocRoomCache.get(String.valueOf(roomId));
//                if (pocRoom != null) {
//                    pocRoom.existsRoom(roomId);
//                } else {
//                    LogUtils.ELog(TAG, "existsRoom: pocRoomCache contains " + roomId + " but pocRoom is null");
//                }
//            } else {
//                createSessionAndAttach(roomId, "", "", "", "", "", Constants.ROOM_STATUS_NO_CREATE_JOIN);
//                final POCRoom pocRoom = pocRoomCache.get(String.valueOf(roomId));
//                pocRoom.registAttachSuccessCallBack(new IJanusAttachSuccessCallBack() {
//                    @Override
//                    public void createSessionAndAttachSuccess() {
//                        pocRoom.existsRoom(roomId);
//
//                    }
//                });
//            }
//        } catch (Throwable throwable) {
//            LogUtils.ELog(TAG, "existsRoom" + throwable.getLocalizedMessage());
//        }

    }

    private void listRoom(long roomId) {
//        LogUtils.ELog(TAG, "listRoom: " + roomId);
//        try {
//            if (isRoomCacheContains(String.valueOf(roomId))) {
//                POCRoom pocRoom = pocRoomCache.get(String.valueOf(roomId));
//                if (pocRoom != null) {
//                    pocRoom.listRooms();
//                } else {
//                    LogUtils.ELog(TAG, "existsRoom: pocRoomCache contains " + roomId + " but pocRoom is null");
//                }
//            } else {
//                createSessionAndAttach(roomId, "", "", "", "", "", Constants.ROOM_STATUS_NO_CREATE_JOIN);
//                final POCRoom pocRoom = pocRoomCache.get(String.valueOf(roomId));
//                pocRoom.registAttachSuccessCallBack(new IJanusAttachSuccessCallBack() {
//                    @Override
//                    public void createSessionAndAttachSuccess() {
//                        pocRoom.listRooms();
//
//                    }
//                });
//            }
//        } catch (Throwable throwable) {
//            LogUtils.ELog(TAG, "listRoom:  " + throwable.getLocalizedMessage());
//        }
    }

    private void listParticipants(final long roomId) {
//        LogUtils.ELog(TAG, "listParticipants:  " + roomId);
//        try {
//            if (isRoomCacheContains(String.valueOf(roomId))) {
//                POCRoom pocRoom = pocRoomCache.get(String.valueOf(roomId));
//                if (pocRoom != null) {
//                    pocRoom.listParticipants(roomId);
//                }
//            } else {
//                createSessionAndAttach(roomId, "", "", "", "", "", Constants.ROOM_STATUS_NO_CREATE_JOIN);
//                final POCRoom pocRoom = pocRoomCache.get(String.valueOf(roomId));
//                pocRoom.registAttachSuccessCallBack(new IJanusAttachSuccessCallBack() {
//                    @Override
//                    public void createSessionAndAttachSuccess() {
//                        pocRoom.listParticipants(roomId);
//
//                    }
//                });
//            }
//        } catch (Throwable throwable) {
//            LogUtils.ELog(throwable);
//        }
    }

    private void listforwarders(final long roomID, final String secret) {
//        try {
//            if (isRoomCacheContains(String.valueOf(roomID))) {
//                POCRoom pocRoom = pocRoomCache.get(String.valueOf(roomID));
//                if (pocRoom != null) {
//                    pocRoom.listforwarders(roomID, secret);
//                }
//            } else {
//                createSessionAndAttach(roomID, "", "", "", "", "", Constants.ROOM_STATUS_NO_CREATE_JOIN);
//                final POCRoom pocRoom = pocRoomCache.get(String.valueOf(roomID));
//                pocRoom.registAttachSuccessCallBack(new IJanusAttachSuccessCallBack() {
//                    @Override
//                    public void createSessionAndAttachSuccess() {
//                        pocRoom.listforwarders(roomID, secret);
//
//                    }
//                });
//            }
//        } catch (Throwable throwable) {
//            LogUtils.ELog(throwable);
//        }
    }


    private void kickPerson(long roomId, int userId, String secret) {
        try {
            if (isRoomCacheContains(String.valueOf(roomId))) {
                POCRoom pocRoom = pocRoomCache.get(String.valueOf(roomId));
                if (pocRoom != null) {
                    pocRoom.kickPerson(roomId, userId, secret);
                }
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(throwable);
        }
    }

    private void publish(long roomId, boolean audio, boolean video, boolean data, String audioCode, String videoCode,
                         int bitrate, boolean record, String fileName, String display) {
        try {
            if (isRoomCacheContains(String.valueOf(roomId))) {
                POCRoom pocRoom = pocRoomCache.get(String.valueOf(roomId));
                if (pocRoom != null) {
                    pocRoom.publish(roomId, audio, video, data, audioCode, videoCode, bitrate, record, fileName, display);
                }
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(throwable);
        }
    }

    private void unpublish(long roomId) {
        try {
            if (isRoomCacheContains(String.valueOf(roomId))) {
                POCRoom pocRoom = pocRoomCache.get(String.valueOf(roomId));
                if (pocRoom != null) {
                    pocRoom.unpublish(roomId);
                }
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(throwable);
        }
    }

    private void configure(long roomId, boolean audio, boolean video, boolean data, int bitrate, boolean record, String fileName, String display) {
        try {
            if (isRoomCacheContains(String.valueOf(roomId))) {
                POCRoom pocRoom = pocRoomCache.get(String.valueOf(roomId));
                if (pocRoom != null) {
                    pocRoom.configure(roomId, audio, video, data, bitrate, record, fileName, display);
                }
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(throwable);
        }
    }

    private void subscriberJoin(long roomId, BigInteger feedId, String pin, BigInteger privateId, boolean closePc,
                                boolean audio, boolean video, boolean data, boolean offerAudio, boolean offerVideo, boolean offerData) {
        try {
            if (isRoomCacheContains(String.valueOf(roomId))) {
                POCRoom pocRoom = pocRoomCache.get(String.valueOf(roomId));
                if (pocRoom != null) {
                    pocRoom.subscriberJoin(roomId, feedId, pin, privateId, closePc, audio, video, data, offerAudio, offerVideo, offerData);
                }
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(throwable);
        }
    }

    private void startMedia(long roomId) {
        try {
            if (isRoomCacheContains(String.valueOf(roomId))) {
                POCRoom pocRoom = pocRoomCache.get(String.valueOf(roomId));
                if (pocRoom != null) {
                    pocRoom.startMedia(roomId);
                }
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(throwable);
        }
    }

    private synchronized void pauseMedia(long roomId) {
        try {
            if (isRoomCacheContains(String.valueOf(roomId))) {
                POCRoom pocRoom = pocRoomCache.get(String.valueOf(roomId));
                if (pocRoom != null) {
//                    pocRoom.pauseMedia(roomId);
                }
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(throwable);
        }
    }

    private synchronized void switchSubscriber(long roomId, int feed, boolean audio, boolean video, boolean data) {
        try {
            if (isRoomCacheContains(String.valueOf(roomId))) {
                POCRoom pocRoom = pocRoomCache.get(String.valueOf(roomId));
                if (pocRoom != null) {
//                    pocRoom.switchSubscriber(roomId, feed, audio, video, data);
                }
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(throwable);
        }
    }

    /**
     * 只用于设置静音模式,不刷新UI
     *
     * @param roomId
     * @param enable
     */
    private synchronized void mute(long roomId, boolean enable) {
        try {
            if (isRoomCacheContains(String.valueOf(roomId))) {
                POCRoom pocRoom = pocRoomCache.get(String.valueOf(roomId));
                if (pocRoom != null) {
                    Map<String, String> allSpeakers = getAllSpeakers();
                    pocRoom.mute(enable);
                    if (allSpeakers != null && allSpeakers.size() > 0) {
                        if (allSpeakers.containsKey(String.valueOf(roomId))) {
//                            pocRoom.setPlayerStatus(!enable);
                        }
                    }
                }
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(throwable);
        }
    }

    /**
     * 除了设置静音模式外还带刷新界面
     *
     * @param roomId
     * @param enable
     */
    public synchronized void muteAndNotifyUI(long roomId, boolean enable) {
        LogUtils.ELog(TAG, "muteAndNotifyUI: " + roomId + " enable: " + enable);
        try {
            if (isRoomCacheContains(String.valueOf(roomId))) {
                POCRoom pocRoom = pocRoomCache.get(String.valueOf(roomId));
                if (pocRoom != null) {
                    lastMuteStatus.put(String.valueOf(roomId), enable);
                    pocRoom.mute(enable);
                    releaseSetPlayStatus(String.valueOf(roomId));
//                    pocRoom.setPlayerStatus(true);
                } else {
                    LogUtils.ELog(TAG, "muteAndNotifyUI:  pocRoomCache contains " + roomId + " but pocRoom is null");
                }
            }
            updateGroupMuteStatus(mUserId, String.valueOf(roomId), enable);
        } catch (Throwable throwable) {
            LogUtils.ELog(TAG, "muteAndNotifyUI:  " + throwable.getLocalizedMessage());
        }
    }

    public synchronized void muteAllRoomStatus(boolean enable, String channelId) {
        LogUtils.ELog(TAG, "muteAllRoomStatus: enable:" + enable);
        // TODO: 2019/1/21 wwq 注释了对lastMuteStatus重新put值
        //lastMuteStatus的值应该也只是每次从view传过来的值，view层传递什么，则缓存里保存什么
//        lastMuteStatus.clear();
        for (String id : pocRoomCache.keySet()) {
//            lastMuteStatus.put(id, pocRoomCache.get(id).getMuteState());
            POCRoom pocRoom = pocRoomCache.get(String.valueOf(id));
            if (pocRoom != null) {
                pocRoom.setPlayerStatus(false);
                pocRoom.mute(enable);
                if (pocRoom.getCurrTBCPStatus() == Constants.ROOM_TBCP_REQUEST_SUCCESS) {
                    pocRoom.releaseTBCP();
                }
            }
        }
    }


    public synchronized void reMuteLastStatus() {
        LogUtils.ELog(TAG, "reMuteLastStatus: lastMuteStatus:" + (lastMuteStatus != null ? lastMuteStatus.size() : 0));
        try {
            for (String roomId : lastMuteStatus.keySet()) {
                if (isRoomCacheContains(String.valueOf(roomId))) {
                    boolean muteStatus = lastMuteStatus.get(roomId);
                    LogUtils.DLog(TAG, "reMuteLastStatus  lastMuteStatus: " + muteStatus);
                    POCRoom pocRoom = pocRoomCache.get(String.valueOf(roomId));
                    if (pocRoom != null) {
                        pocRoom.setPlayerStatus(true);
                        pocRoom.mute(muteStatus);
                    }
                }
            }
        } catch (Exception e) {
            LogUtils.ELog(e);
        }

    }


    /**
     * 网络连接失败时去全部从缓存移出,对之前已经加入的频道的做缓存后续处理
     */
    private synchronized void handleNetConnectFailed() {
        LogUtils.ILog("Join room success: pocRoomCache= " + (pocRoomCache != null ? pocRoomCache.size() : 0));
        for (String roomId : pocRoomCache.keySet()) {
            mCacheReConnectRoomId.add(roomId);
            if (pocRoomCache.get(roomId) != null) {
                pocRoomCache.get(roomId).hangupPeerConnection();
            }
            pocRoomCache.remove(roomId);
            LogUtils.ILog("pocRoomCache handleNetConnectFailed");
        }
        pocRoomCache.clear();

    }

    private synchronized void handleNetConnectSuccess() {
        isReConnect = true;
        workHandler.postDelayed(new Runnable() {
            @Override
            public void run() {
                LogUtils.ILog("handleNetConnectSuccess: mCacheReConnectRoomId= " + (mCacheReConnectRoomId != null ? mCacheReConnectRoomId.size() : 0));
                PeerConnectionClient.resetPlayerStatus();//
                reconnectTimes = 0;
                if (mCacheReConnectRoomId != null && mCacheReConnectRoomId.size() > 0) {
                    createRoom(Long.valueOf(mCacheReConnectRoomId.get(0)), Constants.SECRET, Constants.PIN, mUserId, mUserId, "", false, false);
                }
            }
        }, 1000);
    }

    private synchronized List<String> getMemberList(long roomId) {
        try {
            if (isRoomCacheContains(String.valueOf(roomId))) {
                POCRoom pocRoom = pocRoomCache.get(String.valueOf(roomId));
                if (pocRoom != null) {
                    return pocRoom.getMemberList();
                }
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(TAG, "getMemberList: " + throwable.getLocalizedMessage());
        }
        return null;
    }

    interface PocRoomGetCallback {
        void onSuccess(POCRoom pocRoom, boolean isCache);

        void onFail(String msg);
    }

    interface GetJanusUrlCallback {
        void onSuccess(String path);

        void onFail(String msg);
    }

    /**
     * 获取pocRoom实例化对象
     *
     * @param roomId     频道id
     * @param bCreateFlg true 创建频道  false 加入频道
     */
    private void getPocRoom(final long roomId, final String userId, int bCreateFlg, PocRoomGetCallback pocRoomGetCallback) {
        try {
            getPocRoomServer(roomId, new GetJanusUrlCallback() {
                @Override
                public void onSuccess(String path) {
                    LogUtils.DLog(TAG, "getPocRoomServer: onSuccess, id==" + roomId + "url==" + path);
                    POCRoom pocRoom = new POCRoom(path, roomId, userId, bCreateFlg, new JanusRoomEvent(String.valueOf(roomId)), POCService.this);
                    pocRoomGetCallback.onSuccess(pocRoom, false);
                }

                @Override
                public void onFail(String msg) {
                    LogUtils.DLog(TAG, "getPocRoomServer: onFail:" + msg);
                    pocRoomGetCallback.onFail(msg);
                }
            });

        } catch (Throwable throwable) {
            LogUtils.ELog(TAG, "getPocRoom: " + throwable.getLocalizedMessage());
            pocRoomGetCallback.onFail(throwable.getMessage());
        }

    }

    private void reconnectNextRoom(long roomId) {
        if (mCacheReConnectRoomId != null && mCacheReConnectRoomId.size() > 0) {
            LogUtils.ILog("reconnectNextRoom:  remove  from reconnectList");
            mCacheReConnectRoomId.remove(String.valueOf(roomId));
        }
        LogUtils.ILog("Room can talk: " + (mCacheReConnectRoomId != null ? mCacheReConnectRoomId.size() : 0));
        workHandler.postDelayed(new Runnable() {
            @Override
            public void run() {
                try {
                    if (mCacheReConnectRoomId.iterator().hasNext()) {
                        String next = mCacheReConnectRoomId.iterator().next();
                        LogUtils.ILog("Room can talk has next " + next);
                        createRoom(Long.valueOf(next), Constants.SECRET, Constants.PIN, mUserId, mUserId, "", false, false);
                    } else {
                        isReConnect = false;
                    }
                    /*else {
                        mCacheReConnectRoomId.clear();
                    }*/
                } catch (Exception E) {
                    LogUtils.ELog(E);
                }
            }
        }, 100);

    }

//    private void insertOrReplaceGroup(String activeUserId, long roomId, boolean isJoin) {
//        DBGroupEntity pocGroup = new DBGroupEntity();
//        pocGroup.setIsCreated(true);
//        pocGroup.setUserId(mUserId);
//        pocGroup.setRooomId(String.valueOf(roomId));
//        pocGroup.setActiveUserId(activeUserId);
//        pocGroup.setIsCreated(true);
//        pocGroup.setIsJoin(isJoin);
//        pocGroup.setKey(GroupUtils.generatePOCGroupDbKey(mUserId, String.valueOf(roomId)));
//        POCMemberInfo info = new POCMemberInfo();
//        info.setRoomId(String.valueOf(roomId));
//        info.setOnLine(true);
//        info.setId(activeUserId);
//        info.setDisplayName("");
//        POCHandlerService.insertOrReplaceGroupData(POCService.this, activeUserId, pocGroup, info);
//    }

    /**
     * 根据频道id获取pocRoom对象
     *
     * @param roomId
     */
    private POCRoom getPocRoom(String roomId) {
        LogUtils.ELog(TAG, "getPocRoom: " + roomId);
        try {
            if (isRoomCacheContains(roomId)) {
                return pocRoomCache.get(roomId);
            } else {
                LogUtils.ELog(TAG, "getPocRoom: pocRoomCache not contains  " + roomId);
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(TAG, "getPocRoom: " + throwable.getLocalizedMessage());
        }
        return null;
    }

    private void initParams() {
        LogUtils.ELog(TAG, " initParams ");
        try {
            mUserId = PreferenceHelper.getString(UserConfig.LOGIN_ACCOUNT, "");
            PocBroadReceiver.currentNetState = NetUtils.getNetworkState(POCService.this);
            workThread = new HandlerThread("workThread");
            workThread.start();
            workHandler = new WorkHandler(workThread.getLooper());

            PeerConnectionClient.DataChannelParameters dataChannelParameters = new PeerConnectionClient.DataChannelParameters(true,
                    -1,
                    -1, "json", true, -1);
            peerConnectionParameters =
                    new PeerConnectionClient.PeerConnectionParameters(false, false,
                            false, 640, 480, 15,
                            800, "VP8",
                            false,
                            false,
                            16, "opus",
                            false,
                            false,
                            true,
                            false,
                            true,
                            true,
                            true,
                            false,
                            false,
                            false, dataChannelParameters);
            initReceiver();
//            POCHandlerService.getAllPocRoom(POCService.this, mUserId);
        } catch (Throwable throwable) {
            LogUtils.ELog(TAG, "initParams: " + throwable.getLocalizedMessage());
        }

    }

    /**
     * 判断roomCache对象是否为空并且是否包含roomId对应的频道对象
     *
     * @param roomId
     * @return
     */
    private boolean isRoomCacheContains(String roomId) {
        try {
            if (pocRoomCache != null && pocRoomCache.size() > 0) {
                if (pocRoomCache.containsKey(roomId)) {
                    return true;
                }
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(TAG, "isRoomCacheContains" + throwable.getLocalizedMessage());
        }
        return false;
    }

    /**
     * 单个频道连接失败的时候做的处理/移出缓存
     *
     * @param roomId
     */
    private void removeRoomFromCache(boolean isLeave, String roomId) {
        LogUtils.ELog(TAG, "removeRoomFromCache: isLeave=" + isLeave + " roomId=" + roomId);
        if (isRoomCacheContains(roomId)) {
            if (pocRoomCache.get(roomId) != null && isLeave) {
                pocRoomCache.get(roomId).leaveRoom();
            }
            pocRoomCache.remove(roomId);
            removeRoomStatusCache(String.valueOf(roomId));
        } else {
            LogUtils.ELog(TAG, "removeRoomFromCache: pocRoomCache not contains " + roomId);
        }
    }

    private boolean netTips() {
        if (!NetUtils.isNetworkAvailable(this)) {
            showToast(getString(R.string.common_net_failed));
            return true;
        }
        return false;
    }

    private class SubProgressReceiver extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent == null || TextUtils.isEmpty(intent.getAction()))
                return;
            switch (intent.getAction()) {
                case ACTION_POC_ALL_ROOM:
                    break;
                case ACTIOON_STOP_SELF:
                    stopSelf(mServiceStartId);
                    break;
                //lyz@xdja.com add for schedule check.
                case JobSchedulerService.ACTION_CHECK_JANUS_SCHEDULE: {
                    String serverUri = intent.getStringExtra(JobSchedulerService.SERVER_URI);
                    if (serverUri != null) {
                        JanusServer.getJanusServer(serverUri).doSchedule(serverUri);
                    } else {
                        JanusServer.doAllSchedule();
                    }
                }
                break;
                case ACTION_POC_SWITCH_MUTE_STATUS:
                    boolean status = intent.getBooleanExtra(MessageProxy.SWITCH_MUTE_STATUS, true);
                    if (status) {
                        POCClient.muteAllRoomStatus(true, "");
                    } else {
                        POCClient.reMuteLastStatus();
                    }
                    break;
                case ACTION_POC_START_WAITING_ACTIVITY:
                    if (intent.getSerializableExtra(AMnager.INTENT_KEY_CALL_WAITING_DATE) != null) {
                        LogUtils.DLog(TAG, "start POCWaitingActivity ");
                        POCCallMessage callMessage = (POCCallMessage) intent.getSerializableExtra(AMnager.INTENT_KEY_CALL_WAITING_DATE);
                        AMnager.startPOCCallWaitingActivity(GlobalContext.getContext(), callMessage);
                        POCClient.getInstance().clearNotify(TRYCALL_POC_BANK);
                        return;
                    } else {
                        LogUtils.DLog(TAG, "start POCWaitingActivity,but extra is null ");
                    }
                    break;
                case Intent.ACTION_HEADSET_PLUG:
                    boolean isHeadsetIn = intent.getIntExtra("state", 0) == 1;
                    Constants.IS_HEADSET_PLUG = isHeadsetIn;
                    LogUtils.ILog("processHeadsetChanged: headsetIn: " + isHeadsetIn);
                    if (!isHeadsetIn) {
                        RingPlayer.getInstance(context).setAudioMode(true);
                    } else {
                        RingPlayer.getInstance(context).setAudioMode(false);
                    }
                    break;
                case Intent.ACTION_SCREEN_ON:
                    if (NetUtils.isNetworkAvailable(GlobalContext.getContext())) {
                        POCClient.handleNetConnectSuccess();
                    }
                    break;
                case "android.intent.action.PHONE_STATE":
                    String state = intent.getStringExtra(TelephonyManager.EXTRA_STATE);
                    if (StringUtils.isEmpty(state)) {
                        return;
                    }
                    switch (state) {
                        case "IDLE"://挂断
                            AppRTCAudioManager.create(GlobalContext.getContext()).start(new AppRTCAudioManager.AudioManagerEvents() {
                                // This method will be called each time the number of available audio
                                // devices has changed.
                                @Override
                                public void onAudioDeviceChanged(AppRTCAudioManager.AudioDevice audioDevice, Set<AppRTCAudioManager.AudioDevice> availableAudioDevices) {
                                }
                            });
                            POCClient.reMuteLastStatus();
                            isRinging = false;
                            break;
                        case "OFFHOOK"://主动呼叫
                            if (isRinging) {
                                break;
                            }
                            isRinging = true;
                            POCClient.muteAllRoomStatus(true, "");
                            break;
                        case "RINGING"://被叫来电
                            if (isRinging) {
                                break;
                            }
                            isRinging = true;
                            POCClient.muteAllRoomStatus(true, "");
                            break;
                    }
                    break;
                case BluetoothAdapter.ACTION_STATE_CHANGED:
                case BluetoothHeadset.ACTION_CONNECTION_STATE_CHANGED:
                    BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
                    int bluetoothState = adapter.getProfileConnectionState(BluetoothProfile.HEADSET);
                    if (bluetoothState == BluetoothProfile.STATE_DISCONNECTED) {
                        RingPlayer.getInstance(context).setAudioMode(true);
                    } else {
                        RingPlayer.getInstance(context).setAudioMode(false);
                    }
                    break;
                case "update_poc_group_list":
                    break;
            }
        }
    }

    private class JanusRoomEvent implements POCRoom.RoomEvent {
        private final String roomId;

        public JanusRoomEvent(String roomId) {
            this.roomId = roomId;
        }

        @Override
        public void onRoom(final long roomId, final int status, final String desc) {
/*            workHandler.post(new Runnable() {
                @Override
                public void run() {*/
            LogUtils.ILog(TAG, "onRoom status:" + status + "  roomId:" + roomId);
            switch (status) {
                case Constants.ROOM_SEVER_DISCONNECT:
                    LogUtils.ILog("Connect room server failed");

                    setRoomStatusDestroyed(String.valueOf(roomId));
//                                    handleNetConnectFailed();
                    if (!mCacheReConnectRoomId.contains(String.valueOf(roomId))) {
                        mCacheReConnectRoomId.add(String.valueOf(roomId));
                    }
                    MessageProxy.sendUserChanged(POCService.this, String.valueOf(roomId), getMemberList(roomId), Constants.ROOM_SEVER_DISCONNECT);
                    if (pocRoomCache == null) {
                        return;
                    }
                    POCRoom pocroom = pocRoomCache.remove(String.valueOf(roomId));
                    if (pocroom != null) {
                        pocroom.hangupPeerConnection();
                    }
                    removeRoomStatusCache(String.valueOf(roomId));
                    //disconnec server
                    if (pocRoomCache != null && pocRoomCache.size() == 0) {
                        LogUtils.ILog("No cacheRoom exist, disconnect server with janus.");
                        POCRoom.disconnectServer();
                    }

                    //auto reconnect.
                    if (reconnectTimes++ < 1 && NetUtils.isNetworkAvailable(getApplicationContext())) {
                        handleNetConnectSuccess();
                    }
                    //end.
                    break;
                case Constants.ROOM_CREATE_FAILED:
                case Constants.ROOM_CREATE_ERROR:
                case Constants.ROOM_SEVER_CONNECT_FAILED:
                    setRoomStatusDestroyed(String.valueOf(roomId));
                    LogUtils.ILog("ROOM_SEVER_CONNECT_FAILED connect room server failed");
                    // TODO: 2018/11/16 wwq remove
//                            removeRoomFromCache(true, String.valueOf(roomId));
                            /*if (mCacheReConnectRoomId != null) {
                                mCacheReConnectRoomId.clear();
                            }*/
                    MessageProxy.sendUserChanged(POCService.this, String.valueOf(roomId), getMemberList(roomId), Constants.ROOM_SEVER_CONNECT_FAILED);
                    break;

                case Constants.ROOM_SEVER_DISCONNECT_SUCCESS:
                case Constants.ROOM_LEAVE_SUCCESS:
                case Constants.ROOM_STATUS_DESTORYED:
                case Constants.ROOM_DESTROY_FAILED:
                case Constants.ROOM_DESTROY_SUCCESS:
                    setRoomStatusDestroyed(String.valueOf(roomId));
                    LogUtils.ILog("Room has been left:" + status);
                {
                    if (pocRoomCache != null && pocRoomCache.containsKey(String.valueOf(roomId))) {
                        POCRoom pocRoom = pocRoomCache.remove(String.valueOf(roomId));
                        if (pocRoom != null) {
                            pocRoom.removeCallbackFromJanusServer();
                        }
                        removeRoomStatusCache(String.valueOf(roomId));
                    }
                }
                reconnectTimes = 0;
                removeRoomFromCache(false, String.valueOf(roomId));
                MessageProxy.sendSelfLeaveEvent(POCService.this, String.valueOf(roomId), getMemberList(roomId));
                MessageProxy.sendUserChanged(POCService.this, String.valueOf(roomId), getMemberList(roomId), Constants.ROOM_DESTROY_SUCCESS);
                //disconnec server
                if (pocRoomCache != null && pocRoomCache.size() == 0) {
                    LogUtils.ILog("No Room exist, disconnect server with janus.");
                    POCRoom.disconnectServer();
                }
                break;
                case Constants.ROOM_OTHER_USER_LEFT:
                    ArrayList<String> strings = new ArrayList<>();
                    strings.add(desc);
                    MessageProxy.sendUserChanged(POCService.this, String.valueOf(roomId), strings, Constants.ROOM_LEAVE_SUCCESS);
                    MessageProxy.sendUserIncomeOrLeave(POCService.this, String.valueOf(roomId), desc, Constants.ROOM_LEAVE_SUCCESS);
                    LogUtils.ILog(" User :" + desc + " left");
                    break;
                case Constants.ROOM_OTHER_USER_INCOMING:
                    ArrayList<String> incomingUsers = new ArrayList<>();
                    incomingUsers.add(desc);
                    MessageProxy.sendUserChanged(POCService.this, String.valueOf(roomId), incomingUsers, Constants.ROOM_JOIN_SUCCESS);
                    MessageProxy.sendUserIncomeOrLeave(POCService.this, String.valueOf(roomId), desc, Constants.ROOM_JOIN_SUCCESS);
                    LogUtils.ILog(" User :" + desc + " inComing");
                    break;
                case Constants.ROOM_STATUS_JOIN_FAILED_FOR_NO_ROOM:
                    LogUtils.ILog(desc);
                    removeRoomFromCache(true, String.valueOf(roomId));
                    break;
                case Constants.ROOM_CREATE_SUCCESS:
                    LogUtils.ILog("Create room success");
//                                    MessageProxy.sendUserChanged(POCService.this, String.valueOf(roomId), getMemberList(roomId));
//                                    insertOrReplaceGroup(userId, roomId, false);
                    break;
                case Constants.ROOM_ALREADY_EXIST:
                    break;
                case Constants.ROOM_CAN_TALK: {
                    LogUtils.ILog("Room can talk");
                    reconnectTimes = 0;
                    LogUtils.ILog(TAG, "Room can talk");
                    setRoomStatusCreated(String.valueOf(roomId));
                    String room = String.valueOf(roomId);
                    POCRoom pocRoom = getPocRoom(room);
                    //MessageProxy.sendMeIncomingRoom(POCService.this, pocRoom.getMemberList(), String.valueOf(roomId));
                    if (pocRoom != null) {
                        if (lastMuteStatus != null && lastMuteStatus.containsKey(room)) {
                            LogUtils.DLog(TAG, "ROOM_CAN_TALK:　mute ");
                            pocRoom.mute(lastMuteStatus.get(room));
                        }
                        MessageProxy.sendUserChanged(POCService.this, room, pocRoom.getMemberList(), Constants.ROOM_JOIN_SUCCESS);
//                        checkPlayerStatus(String.valueOf(roomId));

                        releaseSetPlayStatus(String.valueOf(roomId));
                    } else {
                        LogUtils.ELog(TAG, "Room can talk,but pocRoom is null: " + roomId);
                    }
                    if (isReConnect) {
                        reconnectNextRoom(roomId);
                    }
                }
                break;
                case Constants.ROOM_JOIN_SUCCESS:
                    LogUtils.ILog("Join room success");
                    String room = String.valueOf(roomId);
                    POCRoom pocRoom = getPocRoom(room);
                    if (pocRoom != null) {
                        MessageProxy.sendMeIncomingRoom(POCService.this, pocRoom.getMemberList(), String.valueOf(roomId));
                    }
                    //must wait room_can_talk event, del by lyz@xdja.com.
//                                    MessageProxy.sendUserChanged(POCService.this, String.valueOf(roomId), GroupUtils.jsonToList(desc), Constants.ROOM_JOIN_SUCCESS);
//                                    MessageProxy.sendMeIncomingRoom(POCService.this, GroupUtils.jsonToList(desc), String.valueOf(roomId));
//                                    insertOrReplaceGroup(userId, roomId, true);
                    break;
                case Constants.ROOM_JOIN_FAILED:
                    setRoomStatusDestroyed(String.valueOf(roomId));
                    LogUtils.ILog("Join room failed");
                    removeRoomFromCache(true, String.valueOf(roomId));
//                                    insertOrReplaceGroup(userId, roomId, true);
                    break;

                case Constants.ROOM_KICK_PERSON_SUCCESS:
                    LogUtils.ILog("踢人成功");
                    MessageProxy.sendUserChanged(POCService.this, String.valueOf(roomId), getMemberList(roomId));
                    break;
                case Constants.ROOM_KICK_PERSON_FAILED:
                    LogUtils.ILog("踢人失败");
                    MessageProxy.sendUserChanged(POCService.this, String.valueOf(roomId), getMemberList(roomId));
                    break;
                case Constants.ROOM_PUBLISH_FAILED:
                    LogUtils.ILog("PUBLISH失败");
                    MessageProxy.sendUserChanged(POCService.this, String.valueOf(roomId), getMemberList(roomId));
                    break;
                case Constants.ROOM_PUBLISH_SUCCESS:
                    LogUtils.ILog("PUBLISH成功");
                    break;
                case Constants.ROOM_UNPUBLISH_SUCCESS:
                    LogUtils.ILog("UNPUBLISH成功");
                    break;
                case Constants.ROOM_UNPUBLISH_FAILED:
                    LogUtils.ILog("UNPUBLISH失败");
                    break;
                case Constants.ROOM_CONFIGURE_SUCCESS:
                    LogUtils.ILog("CONFIGURE成功");
                    break;
                case Constants.ROOM_CONFIGURE_FAILED:
                    LogUtils.ILog("CONFIGURE失败");
                    break;
                case Constants.ROOM_STARTMEDIA_FAILED:
                    LogUtils.ILog("STARTMEDIA失败");

                    break;
                case Constants.ROOM_STARTMEDIA_SUCCESS:
                    LogUtils.ILog("STARTMEDIA成功");
                    break;
                case Constants.ROOM_PAUSEMEDIA_SUCCESS:
                    LogUtils.ILog("PAUSEMEDIA成功");
                    break;
                case Constants.ROOM_PAUSEMEDIA_FAILED:
                    LogUtils.ILog("PAUSEMEDIA失败");
                    break;
                case Constants.ROOM_SWITCH_SUBSCRIBER_FAILED:
                    LogUtils.ILog("SWITCH_SUBSCRIBER失败");
                    break;
                case Constants.ROOM_SWITCH_SUBSCRIBER_SUCCESS:
                    LogUtils.ILog("SWITCH_SUBSCRIBER SUCCESS");
                    break;
                case Constants.ROOM_EXIST_FAILED:
                    LogUtils.ILog("room not  exist");
                    break;
                case Constants.ROOM_EXIST_SUCCESS:
                    LogUtils.ILog("room exist");
                    break;
                case Constants.ROOM_LIST_FAILED:
                    LogUtils.ILog("room list 失败");
                    break;
                case Constants.ROOM_LIST_SUCCESS:
                    LogUtils.ILog("room list 成功");
                    break;
                case Constants.ROOM_LIST_PARTICIPANTS_FAILED:
                    LogUtils.ILog("room list people 失败");
                    break;
                case Constants.ROOM_LIST_PARTICIPANTS_SUCCESS:
                    LogUtils.ILog("room list people 成功");
                    break;
                case Constants.ROOM_LIST_FORWARDERS_FAILED:
                    LogUtils.ILog("room list FORWARDERS 失败");
                    break;
                case Constants.ROOM_LIST_FORWARDERS_SUCCESS:
                    LogUtils.ILog("room list FORWARDERS 成功");
                    break;
                case Constants.ROOM_SUBSCRIBERJOIN_FAILED:
                    LogUtils.ILog("切换订阅者 失败");
                    removeRoomFromCache(true, String.valueOf(roomId));
                    break;
                case Constants.ROOM_SUBSCRIBERJOIN_SUCCESS:
                    LogUtils.ILog("切换订阅者 成功");
                    break;
                default:
                    break;
            }
    /*            }
            });*/

        }

        @Override
        public void onTBCP(final int status, final String ownerUser) {
/*            workHandler.post(new Runnable() {
                @Override
                public void run() {*/
            LogUtils.ELog(TAG, "onTBCP: status " + status + " ownerUser: " + ownerUser);
            switch (status) {
                case Constants.ROOM_TBCP_REQUEST_SUCCESS:
                    LogUtils.ILog(ownerUser + " request talk success");
                    Intent requestSuc = new Intent(PocBroadReceiver.ACTION);
                    requestSuc.setPackage(POCService.this.getPackageName());
                    requestSuc.putExtra(MessageProxy.USER_ID, ownerUser);
                    requestSuc.putExtra(MessageProxy.ROOM_ID, roomId);
                    requestSuc.putExtra(PocBroadReceiver.STATUS, GroupConfig.GROUP_BUSY);
                    requestSuc.putExtra(PocBroadReceiver.BEHAVIOR, PocBroadReceiver.ROOM_REQUEST_TBCP_SUCCESS);
                    requestSuc.putExtra(PocBroadReceiver.FLAG, PocBroadReceiver.FLAG_POC_CONVERATION_TBCP_STATUS);
                    sendBroadcast(requestSuc);
                    break;
                case Constants.ROOM_TBCP_REQUEST_FAILED:
                    LogUtils.ILog(ownerUser + " request talk failed ");
                    Intent requestFailed = new Intent(PocBroadReceiver.ACTION);
                    requestFailed.setPackage(POCService.this.getPackageName());
                    requestFailed.putExtra(MessageProxy.USER_ID, ownerUser);
                    requestFailed.putExtra(MessageProxy.ROOM_ID, roomId);
                    requestFailed.putExtra(PocBroadReceiver.STATUS, GroupConfig.GROUP_FREE);
                    requestFailed.putExtra(PocBroadReceiver.BEHAVIOR, PocBroadReceiver.ROOM_REQUEST_TBCP_FAILED);
                    requestFailed.putExtra(PocBroadReceiver.FLAG, PocBroadReceiver.FLAG_POC_CONVERATION_TBCP_STATUS);
                    sendBroadcast(requestFailed);
                    break;
                case Constants.ROOM_TBCP_RELEASE_SUCCESS:
                    LogUtils.ILog(ownerUser + " release talk success ");
                    Intent releaseSuc = new Intent(PocBroadReceiver.ACTION);
                    releaseSuc.setPackage(POCService.this.getPackageName());
                    releaseSuc.putExtra(MessageProxy.USER_ID, ownerUser);
                    releaseSuc.putExtra(MessageProxy.ROOM_ID, roomId);
                    releaseSuc.putExtra(PocBroadReceiver.STATUS, GroupConfig.GROUP_FREE);
                    releaseSuc.putExtra(PocBroadReceiver.BEHAVIOR, PocBroadReceiver.ROOM_RELEASE_TBCP_SUCCESS);
                    releaseSuc.putExtra(PocBroadReceiver.FLAG, PocBroadReceiver.FLAG_POC_CONVERATION_TBCP_STATUS);
                    sendBroadcast(releaseSuc);
                    releaseSetPlayStatus(roomId);
                    break;
                case Constants.ROOM_TBCP_RELEASE_FAILED:
                    LogUtils.ILog(ownerUser + " release talk failed");
                    Intent releaseFailed = new Intent(PocBroadReceiver.ACTION);
                    releaseFailed.setPackage(POCService.this.getPackageName());
                    releaseFailed.putExtra(MessageProxy.USER_ID, ownerUser);
                    releaseFailed.putExtra(MessageProxy.ROOM_ID, roomId);
                    releaseFailed.putExtra(PocBroadReceiver.STATUS, GroupConfig.GROUP_FREE);
                    releaseFailed.putExtra(PocBroadReceiver.BEHAVIOR, PocBroadReceiver.ROOM_RELEASE_TBCP_FAILED);
                    releaseFailed.putExtra(PocBroadReceiver.FLAG, PocBroadReceiver.FLAG_POC_CONVERATION_TBCP_STATUS);
                    sendBroadcast(releaseFailed);
                    break;
                case Constants.ROOM_OTHER_TBCP_REQUEST_SUCCESS:
                    LogUtils.ILog(roomId + ":" + ownerUser + " Talk ");
//                    boolean playStatus = false;
                    boolean muteStatus;
                    if (getPocRoom(String.valueOf(roomId)) != null) {
                        getPocRoom(String.valueOf(roomId)).setPlayerStatus(true);
                        if (lastMuteStatus != null && lastMuteStatus.size() > 0 && lastMuteStatus.containsKey(String.valueOf(roomId))) {
                            muteStatus = lastMuteStatus.get(String.valueOf(roomId));
                        } else {
                            DBGroupEntity channelInfoByChannelId = POCClient.getChannelInfoByChannelId(GlobalContext.getContext(), roomId);
                            muteStatus = false;
                            if (channelInfoByChannelId != null) {
                                muteStatus = channelInfoByChannelId.getIsSilence();
                                lastMuteStatus.put(String.valueOf(roomId), channelInfoByChannelId.getIsSilence());
                            }
                            LogUtils.ELog(TAG, "other_request_success, but lastMuteStatus not contains roomId: " + roomId);
                        }
                        getPocRoom(String.valueOf(roomId)).mute(muteStatus);
                    } else {
                        LogUtils.ELog(TAG, "other_request_success, but pocRoom is null roomId: " + roomId);
                    }
                    Intent intent = new Intent(PocBroadReceiver.ACTION);
                    intent.setPackage(POCService.this.getPackageName());
                    intent.putExtra(MessageProxy.USER_ID, ownerUser);
                    intent.putExtra(MessageProxy.ROOM_ID, roomId);
                    intent.putExtra(PocBroadReceiver.MEMBER_INFO, POCClient.getInstance().generateListString(getMemberList(Long.parseLong(roomId))));
                    intent.putExtra(PocBroadReceiver.STATUS, GroupConfig.GROUP_BUSY);
                    intent.putExtra(PocBroadReceiver.BEHAVIOR, PocBroadReceiver.ROOM_OTHER_REQUEST_TBCP_SUCCESS);
                    intent.putExtra(PocBroadReceiver.FLAG, PocBroadReceiver.UPDATE_POC_CONVERSION_STATUS);
                    sendBroadcast(intent);
                    if (isRinging) {
                        muteAllRoomStatus(true, "");
                    }
                    break;
                case Constants.ROOM_OTHER_TBCP_RELEASE_SUCCESS:
                    LogUtils.ILog(ownerUser + " Not Talk");
                    otherRelease(ownerUser);
                    break;
                default:
                    break;
            }
    /*            }
            });*/

        }

        private void otherRelease(String ownerUser) {
            releaseSetPlayStatus(roomId);
            Intent intent_ = new Intent(PocBroadReceiver.ACTION);
            intent_.setPackage(POCService.this.getPackageName());
            intent_.putExtra(MessageProxy.USER_ID, ownerUser);
            intent_.putExtra(MessageProxy.ROOM_ID, roomId);
            intent_.putExtra(PocBroadReceiver.MEMBER_INFO, POCClient.getInstance().generateListString(getMemberList(Long.parseLong(roomId))));
            intent_.putExtra(PocBroadReceiver.STATUS, GroupConfig.GROUP_FREE);
            intent_.putExtra(PocBroadReceiver.BEHAVIOR, PocBroadReceiver.ROOM_OTHER_RELEASE_TBCP_SUCCESS);
            intent_.putExtra(PocBroadReceiver.FLAG, PocBroadReceiver.UPDATE_POC_CONVERSION_STATUS);
            sendBroadcast(intent_);
        }

        @Override
        public void onRecord(String mp3RecordUri) {
            //录音数据保存完成，广播出去
            MessageProxy.sendRecordCompletedBroadcast(POCService.this, roomId, mp3RecordUri);

            if (StringUtils.isEmpty(mp3RecordUri)) {
                return;
            }
            File file = new File(mp3RecordUri);
            if (!file.exists()) {
                return;
            }
            long time = new RecordFileUtils().getRecordDuration(file.getAbsolutePath());
            if (time <= 1) {
                return;
            }

            RecordMessage recordMessage = new RecordMessage();
            recordMessage.setRecordUri(file.getAbsolutePath());
            recordMessage.setRecordRoom(roomId);
            recordMessage.setRecordName(file.getName());
            recordMessage.setRecordSize(String.valueOf(file.length()));
            recordMessage.setRecordTimeLen(String.valueOf(time));
            LocalRecordDBHelper.getInstance().insert(recordMessage);
            LogUtils.DLog(TAG, "onRecordCompleted: roomId = " + roomId);
            realUploadRecord(recordMessage.getRecordUri());
        }

    }

    private void releaseSetPlayStatus(String roomId) {
        Map<String, String> allSpeakers = getAllSpeakers();
        boolean playStatus_ = false;
        if (allSpeakers != null && allSpeakers.size() > 0) {
            for (String _roomId : allSpeakers.keySet()) {
                if (lastMuteStatus != null && lastMuteStatus.containsKey(_roomId) && !lastMuteStatus.get(_roomId)) {
                    playStatus_ = true;
                    break;
                }
            }
        }
        POCRoom pocRoom = getPocRoom(roomId);
        if (pocRoom != null) {
            pocRoom.setPlayerStatus(playStatus_);
        }
    }
}
