package com.xdja.poc.sdk.business;

import android.app.Activity;
import android.app.Application;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.RemoteViews;

import com.xdja.poc.sdk.R;
import com.xdja.poc.common.base.BaseActivity;
import com.xdja.poc.common.event.CancelNotification;
import com.xdja.poc.common.event.NetWorkConnectEvent;
import com.xdja.poc.sdk.event.UpdateNotification;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.NetUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.sdk.manager.AMnager;
import com.xdja.poc.sdk.utils.Utils;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;


/**
 * @author CGA
 * @time 2018/9/1311:31
 * @des 开启通知服务
 */ 
public class PocNotificationService extends Service {

    private static final String TAG = PocNotificationService.class.getSimpleName();


    private NotificationManager nm;
    private RemoteViews mRemoteViews;
    private PendingIntent pendingIntent;
    private Notification.Builder builder;
    //notification
    Notification notification = null;
    private String roomId;
    private String userId;
    private int notifyId = 10012;
    private String title = "安通对讲";
    private String content = "通知";
    private String channelId = "poc_channel";
    public static final int NOTIFY_ID = 12132;
    //    private IPOCRoomEventCallBack roomEventCallBack;
    private static final String DATE_FORMAT = "HH:mm";
    public static boolean isChange = true;

    @Override
    public void onCreate() {
        super.onCreate();
        EventBus.getDefault().register(this);
        createNotification();
        MessageProxy.reBindService(this);
        initEvent();
//        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR2) {
//            Notification.Builder builder = new Notification.Builder(this);
//            startForeground(NOTIFY_ID, builder.build());
//            Intent intent = new Intent(this, CancelNoticeService.class);
//            startService(intent);
//        } else {
//            startForeground(NOTIFY_ID, new Notification());
//        }
    }

    private void initEvent() {
//        roomEventCallBack = new IPOCAbstractRoomEventCallBack() {
//            @Override
//            public void onTBCPEventCallBack(POCConverationTbcpStatusEvent tbcpStatusEvent) {
//                super.onTBCPEventCallBack(tbcpStatusEvent);
//                userId = tbcpStatusEvent.getUserId();
//                roomId = tbcpStatusEvent.getRoomId();
//                if (nm == null || notification == null) {
//                    return;
//                }
//                mRemoteViews.setTextViewText(R.id.tv_talk_status, "在线");
//                mRemoteViews.setTextColor(R.id.tv_talk_status, getResources().getColor(R.color.poc_conversation_free_or_talking));
//                nm.notify(notifyId, notification);
//                if (BaseActivity.isSelfActivity) {
//                    nm.cancel(notifyId);
//                }
//            }
//        };
//        POCUiKitProxyImpl.getInstance().addRoomEventCallBack(roomEventCallBack);
    }

    @Nullable
    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }


    private void createNotification() {
        initRemoteView();
        int resId = PreferenceHelper.getInt(UserConfig.NOTIFICATION_ICON, -1);
        if(resId==-1){
            resId=R.drawable.poc_notifiy_icon;
        }
        initNotification(resId);
        getApplication().registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks() {
            @Override
            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {

            }

            @Override
            public void onActivityStarted(Activity activity) {
            }

            @Override
            public void onActivityResumed(Activity activity) {
                BaseActivity.isSelfActivity = true;
                MessageProxy.sendNotificationStaus(false);
            }

            @Override
            public void onActivityPaused(Activity activity) {
                BaseActivity.isSelfActivity = false;
            }

            @Override
            public void onActivityStopped(Activity activity) {

            }

            @Override
            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {

            }

            @Override
            public void onActivityDestroyed(Activity activity) {

            }
        });
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        // 如果Service被终止
        // 当资源允许情况下,重启service
        return START_STICKY;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        EventBus.getDefault().unregister(this);
        if (nm != null) {
            nm.cancel(notifyId);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                nm.cancel(notifyId);
                nm.deleteNotificationChannel(channelId);
                LogUtils.ILog(TAG, "onPocConversionStatusChanged notification cancel");
            }
            nm = null;
            notification = null;
        }
        try {
            if (!StringUtils.isEmpty(PreferenceHelper.getString(UserConfig.LOGIN_ACCOUNT, ""))&&
                    PreferenceHelper.getBoolean(UserConfig.IS_SHOW_NOTIFICATION, true)) {
                startService(new Intent(this, PocNotificationService.class));
            }
        } catch (Exception ex) {
            LogUtils.ELog(TAG, "ex:" + ex.getMessage());
        }
    }

    private void initRemoteView() {
        mRemoteViews = new RemoteViews(getPackageName(), R.layout.poc_notification);
        updateUserInfo();
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onNetWorkConnectEvent(NetWorkConnectEvent netWorkConnectEvent) {
        updateUserInfo();
        nm.notify(notifyId, notification);
    }

    private void updateUserInfo() {
        String userAccount = PreferenceHelper.getString(UserConfig.LOGIN_ACCOUNT, "");
        String userName = PreferenceHelper.getString(UserConfig.USER_INFO_NAME, "");
        String pwd = PreferenceHelper.getString(UserConfig.LOGIN_PWD, "");
        String appName = PreferenceHelper.getString(UserConfig.APP_NAME, "安通对讲");

        //根据通知栏主题色设置相反字体颜色
//        boolean darTheme = POCNotificationUtils.getInstance().isDarkNotificationTheme(getApplicationContext());
//        if (darTheme){
//            mRemoteViews.setTextColor(R.id.tv_login_tips,getResources().getColor(R.color.poc_btn_text_press));
//            mRemoteViews.setTextColor(R.id.tv_app_name,getResources().getColor(R.color.poc_btn_text_press));
//            mRemoteViews.setTextColor(R.id.tv_user_name,getResources().getColor(R.color.poc_conversation_small_text));
//            mRemoteViews.setTextColor(R.id.tv_time,getResources().getColor(R.color.poc_conversation_small_text));
//        }else {
//            mRemoteViews.setTextColor(R.id.tv_login_tips,getResources().getColor(R.color.poc_conversation_title_text));
//            mRemoteViews.setTextColor(R.id.tv_app_name,getResources().getColor(R.color.poc_conversation_title_text));
//            mRemoteViews.setTextColor(R.id.tv_user_name,getResources().getColor(R.color.poc_conversation_small_text));
//            mRemoteViews.setTextColor(R.id.tv_time,getResources().getColor(R.color.poc_conversation_small_text));
//        }

        int resId = PreferenceHelper.getInt(UserConfig.APP_ICON, -1);
        mRemoteViews.setTextViewText(R.id.tv_app_name, appName);
        mRemoteViews.setTextViewText(R.id.tv_login_tips, appName + "(请登录)");
        if (resId != -1) {
            mRemoteViews.setImageViewResource(R.id.iv_logo, resId);
        } else {
            mRemoteViews.setImageViewResource(R.id.iv_logo, R.mipmap.poc_logo);
        }
        title = userAccount;
        boolean networkAvailable = NetUtils.isNetworkAvailable(this);
        if (StringUtils.isEmpty(pwd)) {
            //UI修改 离线只显示提醒登录
            mRemoteViews.setViewVisibility(R.id.tv_login_tips, View.VISIBLE);
            mRemoteViews.setViewVisibility(R.id.ll_user_info, View.GONE);
            mRemoteViews.setViewVisibility(R.id.tv_time, View.GONE);
            String URI_STRING= PreferenceHelper.getString(UserConfig.ROUTER_SCHEME,"xdja")+AMnager.URI_END;
            Uri uri = Uri.parse(URI_STRING + getPackageName()).buildUpon().appendPath("login").build();
            Intent intent = new Intent(Intent.ACTION_VIEW, uri);
            pendingIntent = PendingIntent.getActivity(getApplicationContext(), 0,
                    intent, PendingIntent.FLAG_UPDATE_CURRENT);
            mRemoteViews.setOnClickPendingIntent(R.id.rel_talk_status_and_people_count, pendingIntent);
        } else if (!StringUtils.isEmpty(pwd)) {
            mRemoteViews.setTextViewText(R.id.tv_user_name, StringUtils.splitDisplayName(5, userName));
            if (!networkAvailable) {
                mRemoteViews.setTextColor(R.id.tv_talk_status, getResources().getColor(R.color.poc_color_red));
                mRemoteViews.setTextViewText(R.id.tv_talk_status, "离线");
            } else {
                // TODO: 2018/12/15 wwq modify  
                if(isChange){
                    mRemoteViews.setTextViewText(R.id.tv_talk_status, "在线");
                    mRemoteViews.setTextColor(R.id.tv_talk_status, getResources().getColor(R.color.poc_conversation_free_or_talking));
                }
            }
            mRemoteViews.setViewVisibility(R.id.tv_login_tips, View.GONE);
            mRemoteViews.setViewVisibility(R.id.ll_user_info, View.VISIBLE);
            mRemoteViews.setViewVisibility(R.id.tv_time, View.VISIBLE);
            mRemoteViews.setTextViewText(R.id.tv_time, Utils.fmatLongToString(System.currentTimeMillis(), DATE_FORMAT));
//            Uri uri = Uri.parse(AMnager.URI_STRING + getPackageName()).buildUpon().appendPath("pocMain").build();
            Intent intent = getPackageManager().getLaunchIntentForPackage(getPackageName());//获取启动Activity
//            Intent intent = new Intent(Intent.ACTION_VIEW, uri);
            pendingIntent = PendingIntent.getActivity(getApplicationContext(), 0,
                    intent, PendingIntent.FLAG_UPDATE_CURRENT);
            mRemoteViews.setOnClickPendingIntent(R.id.rel_talk_status_and_people_count, pendingIntent);
        }
    }

    private void initNotification( int drawableRes) {
        //获取NotificationManager实例
        nm = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);

        //版本兼容
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN) {
            notification = new Notification();
            notification.tickerText = title;
            notification.when = System.currentTimeMillis();
            notification.icon = drawableRes;
            notification.flags = Notification.FLAG_AUTO_CANCEL;
        } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN &&
                Build.VERSION.SDK_INT < Build.VERSION_CODES.O) {
            notification = new Notification.Builder(getApplicationContext())
                    .setContentIntent(pendingIntent)
                    .setContent(mRemoteViews)
                    .setPriority(Notification.PRIORITY_DEFAULT)
                    .setCategory(Notification.CATEGORY_MESSAGE)
                    .setShowWhen(true)
                    .setOngoing(true)
                    .setSmallIcon(drawableRes)
                    .setWhen(System.currentTimeMillis())
                    .setVisibility(Notification.VISIBILITY_PUBLIC)
                    .build();
        } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            CharSequence name = "安通对讲";
            //降低通知重要程度,只显示,不入侵
            int importance = NotificationManager.IMPORTANCE_LOW;
            channelId = getPackageName();
            NotificationChannel mChannel = new NotificationChannel(channelId, name, importance);
            mChannel.enableLights(false);//是否在展示小红点
            // 设置通知出现时的震动（如果 android 设备支持的话）
//            mChannel.enableVibration(true);
            mChannel.setSound(null, null);
            //是否在久按桌面图标时显示此渠道的通知
            mChannel.setShowBadge(false);
            mChannel.setLockscreenVisibility(Notification.VISIBILITY_PRIVATE);
            nm.createNotificationChannel(mChannel);

            notification = new Notification.Builder(this, channelId)
                    .setContentTitle("安通对讲")
                    .setContentIntent(pendingIntent)
                    .setContent(mRemoteViews)
                    .setCategory(Notification.CATEGORY_MESSAGE)
                    .setShowWhen(true)
                    .setOngoing(true)
                    .setSmallIcon(drawableRes)//drawableRes
                    .setWhen(System.currentTimeMillis())
                    // 铃声、闪光、震动均系统默认
                    .setDefaults(Notification.DEFAULT_ALL)
                    // 设置为public后,通知栏将在锁屏界面显示
                    .setVisibility(Notification.VISIBILITY_PUBLIC)
                    //设置优先级别
                    .setPriority(Notification.PRIORITY_DEFAULT)
                    .setChannelId(channelId)
                    .setAutoCancel(false)
                    .setOnlyAlertOnce(true)//声音或者灯光只提醒一次
                    .build();
        }

//        nm.notify(notifyId, notification);
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onCancelNotification(CancelNotification cancelNotification) {
        boolean isShow = (boolean) cancelNotification.getT();
        if (!isChange) {
            return;
        }
        if (nm == null || notification == null) {
            stopSelf();
            LogUtils.ILog(TAG, "stop self ");
            return;
        }
        updateUserInfo();
        if (isShow) {
            nm.notify(notifyId, notification);
        } else {
            nm.cancel(notifyId);
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onUpdateNotificationEvent(UpdateNotification event) {
        if (nm == null || notification == null) {
            stopSelf();
            return;
        }
        isChange = true;
        updateUserInfo();
        boolean isRing = event.getT();
        if (isRing) {
            isChange = false;
            String userName = event.getCallMessage().getUserName();
            mRemoteViews.setViewVisibility(R.id.ll_user_info, View.VISIBLE);
            mRemoteViews.setViewVisibility(R.id.tv_login_tips, View.GONE);
            mRemoteViews.setTextViewText(R.id.tv_user_name, StringUtils.splitDisplayName(5, userName));
            mRemoteViews.setTextViewText(R.id.tv_talk_status, " 邀请您加入频道");
            mRemoteViews.setTextColor(R.id.tv_talk_status, getResources().getColor(R.color.poc_conversation_free_or_talking));
            mRemoteViews.setViewVisibility(R.id.tv_time, View.VISIBLE);
            mRemoteViews.setTextViewText(R.id.tv_time, Utils.fmatLongToString(System.currentTimeMillis(), DATE_FORMAT));
//            String URI_STRING= PreferenceHelper.getString(UserConfig.ROUTER_SCHEME,"xdja")+AMnager.URI_END;
////            Uri uri = Uri.parse(URI_STRING + getPackageName()).buildUpon().appendPath("pocCallWaiting").build();
            Intent intent = new Intent(POCService.ACTION_POC_START_WAITING_ACTIVITY);
            intent.setPackage(getPackageName());
            intent.putExtra(AMnager.INTENT_KEY_CALL_WAITING_DATE, event.getCallMessage());
            pendingIntent = PendingIntent.getBroadcast(getApplicationContext(), 0,
                    intent, PendingIntent.FLAG_UPDATE_CURRENT);
            mRemoteViews.setOnClickPendingIntent(R.id.rel_talk_status_and_people_count, pendingIntent);
            nm.notify(notifyId, notification);
        } else {
            boolean networkAvailable = NetUtils.isNetworkAvailable(this);

            String pwd = PreferenceHelper.getString(UserConfig.LOGIN_PWD, "");
            if (StringUtils.isEmpty(pwd)) {
                nm.notify(notifyId, notification);
                return;
            }
            mRemoteViews.setViewVisibility(R.id.ll_user_info, View.VISIBLE);
            if (event.getCallType() == 0) {
                String userName = PreferenceHelper.getString(UserConfig.USER_INFO_NAME, "");
                mRemoteViews.setTextViewText(R.id.tv_user_name, StringUtils.splitDisplayName(5, userName));
                if (networkAvailable) {
                    mRemoteViews.setTextViewText(R.id.tv_talk_status, "在线");
                    mRemoteViews.setTextColor(R.id.tv_talk_status, getResources().getColor(R.color.poc_conversation_free_or_talking));
                } else {
                    mRemoteViews.setTextViewText(R.id.tv_talk_status, "离线");
                    mRemoteViews.setTextColor(R.id.tv_talk_status, getResources().getColor(R.color.poc_color_red));
                }
            } else if (event.getCallType() == 1) {
                isChange = false;
                mRemoteViews.setTextViewText(R.id.tv_user_name, "您");
                mRemoteViews.setTextColor(R.id.tv_talk_status, getResources().getColor(R.color.poc_conversation_free_or_talking));
                mRemoteViews.setTextViewText(R.id.tv_talk_status, " 正在呼叫对方");
            }
            mRemoteViews.setViewVisibility(R.id.tv_login_tips, View.GONE);
            mRemoteViews.setTextColor(R.id.tv_talk_status, getResources().getColor(R.color.poc_conversation_free_or_talking));
            mRemoteViews.setViewVisibility(R.id.tv_time, View.VISIBLE);
            mRemoteViews.setTextViewText(R.id.tv_time, Utils.fmatLongToString(System.currentTimeMillis(), DATE_FORMAT));
//            Uri uri = Uri.parse(AMnager.URI_STRING + getPackageName()).buildUpon().appendPath("pocMain").build();
//            Intent intent = new Intent(Intent.ACTION_VIEW, uri);
            Intent intent = getPackageManager().getLaunchIntentForPackage(getPackageName());//获取启动Activity
            pendingIntent = PendingIntent.getActivity(getApplicationContext(), 0,
                    intent, PendingIntent.FLAG_UPDATE_CURRENT);
            mRemoteViews.setOnClickPendingIntent(R.id.rel_talk_status_and_people_count, pendingIntent);
            nm.notify(notifyId, notification);
        }
    }
}
