package com.xdja.poc.sdk.business.plugincallback;

import android.support.annotation.Nullable;
import android.util.Log;

import com.xdja.poc.sdk.business.POCRoom;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusPluginCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IPluginHandleSendMessageCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IPluginHandleWebRTCCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusMediaConstraints;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusPluginHandleWithWebrtc;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusServer;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusSupportedPluginPackages;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.PluginHandleSendMessageCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.PluginHandleWebRTCCallbacks;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.config.JaunsApi;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.MediaStream;
import org.webrtc.VideoSink;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

import static com.xdja.poc.sdk.config.Constants.CUSTOM_TBCP_SAVE_MP3_RECORD;
import static com.xdja.poc.sdk.config.Constants.TBCP_RELEASE_FAILED;
import static com.xdja.poc.sdk.config.Constants.TBCP_RELEASE_SUCCESS;
import static com.xdja.poc.sdk.config.Constants.TBCP_REQUEST_FAILED;
import static com.xdja.poc.sdk.config.Constants.TBCP_REQUEST_SUCCESS;
import static com.xdja.poc.sdk.config.Constants.TBCP_REQUEST_TAKEN;

/**
 * Created by john on 2018/9/6.
 */


public class JanusCreateRoomPluginCallbacks implements IJanusPluginCallbacks {
    private static final String TAG = "JanusCreateRoom";

    private JanusPluginHandleWithWebrtc handle = null;
    private volatile boolean bWaitTakenTBCPResult = false;
    private volatile boolean bWaitRealeaseTBCPResult = false;
    private volatile String takeTbcpcurrTransaction = null;
    private volatile String releaseTbcpcurrTransaction = null;
    private volatile String copyTakenTransaction = null;
    private volatile String copyReleaseTransaction = null;

    private JanusListenerAttachCallbacks listenerAttachCallbacks;
    private BigInteger newPunishId;
    private BigInteger privateId;
    private long roomId = -1;
    private String userName;
    private POCRoom pocRoom;
    ArrayList<String> memberList = new ArrayList<>();
    private boolean needPlayer = false;
    private boolean muteState = false;

    public JanusCreateRoomPluginCallbacks(long roomId, String userName, POCRoom pocRoom) {
        this.roomId = roomId;
        this.userName = userName;
        this.pocRoom = pocRoom;
    }

    public void editroom(long roomId, String secret, String newDescription,
                         String newSecret, String newPin, @Nullable Boolean newIsPrivated, @Nullable Boolean newRequirePrivated,
                         @Nullable Integer newBitrate, @Nullable Integer newFirFreq, @Nullable Integer newPublishers, @Nullable Boolean permanent) {
        if (handle != null) {
            JSONObject jsonObject = JaunsApi.editRoom(roomId, secret, newDescription, newSecret, newPin, newIsPrivated, newRequirePrivated, newBitrate, newFirFreq, newPublishers, permanent);
            handle.sendMessage(new PluginHandleSendMessageCallbacks(jsonObject));
        }
    }

    public void kickPerson(final long roomID, int personId, String secret) {
        if (handle != null) {
            final JSONObject jsonObject = JaunsApi.kickPerson(roomID, personId, secret);
            handle.sendMessage(new IPluginHandleSendMessageCallbacks() {
                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog("Zhangs", "kickPerson 837 : " + obj.toString());
                    if (obj.has("error_code")) {
                        pocRoom.onRoomStatus(roomID, Constants.ROOM_KICK_PERSON_FAILED, obj.optString("error"));
                    } else {
                        pocRoom.onRoomStatus(roomID, Constants.ROOM_KICK_PERSON_SUCCESS, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {

                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {

                }
            });
        }
    }

    public void publish(final long roomID, boolean audio, boolean video, boolean data, String audioCode, String videoCode,
                        int bitrate, boolean record, String fileName, String display) {
        if (handle != null) {
            final JSONObject jsonObject = JaunsApi.publish(audio, video, data, audioCode, videoCode, bitrate, record, fileName, display);
            handle.sendMessage(new IPluginHandleSendMessageCallbacks() {
                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog("Zhangs", "publish 911 : " + obj);
                    if (obj.has("error_code")) {
                        pocRoom.onRoomStatus(roomID, Constants.ROOM_PUBLISH_FAILED, obj.optString("error"));
                    } else {
                        pocRoom.onRoomStatus(roomID, Constants.ROOM_PUBLISH_SUCCESS, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {

                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {

                }
            });
        }
    }

    public JanusListenerAttachCallbacks getHandler() {
        return listenerAttachCallbacks;
    }

    public void startPlayer(boolean value) {
        if (handle != null) {
            handle.startPlayer(value);
        }
    }

    public void unpublish(final long roomID) {
        if (handle != null) {
            final JSONObject jsonObject = JaunsApi.unpublish();
            handle.sendMessage(new IPluginHandleSendMessageCallbacks() {
                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog("Zhangs", "unpublish 937 : " + obj);
                    if (obj.has("error_code")) {
                        pocRoom.onRoomStatus(roomID, Constants.ROOM_UNPUBLISH_FAILED, obj.optString("error"));
                    } else {
                        pocRoom.onRoomStatus(roomID, Constants.ROOM_UNPUBLISH_SUCCESS, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {

                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {

                }
            });
        }
    }

    public void configure(final long roomId, boolean audio, boolean video, boolean data, int bitrate, boolean record, String fileName, String display) {
        if (handle != null) {
            final JSONObject jsonObject = JaunsApi.configure(audio, video, data, bitrate, record, fileName, display);
            handle.sendMessage(new IPluginHandleSendMessageCallbacks() {
                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog("Zhangs", "configure 963 : " + obj);
                    if (obj.has("error_code")) {
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_CONFIGURE_FAILED, obj.optString("error"));
                    } else {
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_CONFIGURE_SUCCESS, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {

                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {

                }
            });
        }
    }

    public void subscriberJoin(final long roomId, BigInteger feedId, String pin, BigInteger privateId, boolean closePc,
                               boolean audio, boolean video, boolean data, boolean offerAudio, boolean offerVideo, boolean offerData) {
        if (handle != null) {
            final JSONObject jsonObject = JaunsApi.subscriberJoin(roomId, feedId, pin, privateId, closePc, audio, video, data, offerAudio, offerVideo, offerData);
            handle.sendMessage(new IPluginHandleSendMessageCallbacks() {
                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog("Zhangs", "subscriberJoin 990 : " + obj);
                    if (obj.has("error_code")) {
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_SUBSCRIBERJOIN_FAILED, obj.optString("error"));
                    } else {
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_SUBSCRIBERJOIN_SUCCESS, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {
                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {
                    pocRoom.onRoomStatus(roomId, Constants.ROOM_JOIN_FAILED, error);
                }
            });
        }
    }

    public void mute(boolean enable) {
        muteState = enable;
        if (handle != null) {
            handle.mute(enable);
        }
//        if (listenerAttachCallbacks != null) {
//            listenerAttachCallbacks.mute(enable);
//        }
    }

    public boolean getMuteState() {
        if (listenerAttachCallbacks != null)
            return listenerAttachCallbacks.getMuteState();
        return true;
    }

    public void startMedia(final long roomId) {
        if (handle != null) {
            final JSONObject jsonObject = JaunsApi.startMedia(roomId);
            handle.sendMessage(new IPluginHandleSendMessageCallbacks() {
                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog("Zhangs", "startMedia 244 : " + obj);
                    if (obj.has("error_code")) {
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_STARTMEDIA_FAILED, obj.optString("error"));
                    } else {
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_STARTMEDIA_SUCCESS, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {
                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {
                }
            });
        }
    }

    public void pauseMedia(final long roomId) {
        if (handle != null) {
            final JSONObject jsonObject = JaunsApi.pauseMedia(roomId);
            handle.sendMessage(new IPluginHandleSendMessageCallbacks() {
                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog("Zhangs", "pauseMedia 1042 : " + obj);
                    if (obj.has("error_code")) {
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_PAUSEMEDIA_FAILED, obj.optString("error"));
                    } else {
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_PAUSEMEDIA_SUCCESS, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {
                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {

                }
            });
        }
    }

    public void switchSubscriber(final long roomId, int feed, boolean audio, boolean video, boolean data) {
        if (handle != null) {
            final JSONObject jsonObject = JaunsApi.switchSubscriber(feed, audio, video, data);
            handle.sendMessage(new IPluginHandleSendMessageCallbacks() {
                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog("Zhangs", "switchSubscriber 1068 : " + obj);
                    if (obj.has("error_code")) {
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_SWITCH_SUBSCRIBER_FAILED, obj.optString("error"));
                    } else {
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_SWITCH_SUBSCRIBER_SUCCESS, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {
                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {
                    pocRoom.onRoomStatus(roomId, Constants.ROOM_CREATE_FAILED, error);
                }
            });
        }
    }

    public void joinRoom(long roomId, @Nullable Integer userId, String userName, String pin, String token) {
        if (handle != null) {
            final JSONObject join = JaunsApi.join(roomId, userId, userName, pin, token);
            handle.sendMessage(new PluginHandleSendMessageCallbacks(join));
        } else {
            LogUtils.DLog("zlq", "joinRoom handle is null");
        }
    }

    public void publishOwnFeed(String audioCodec) {
        if (handle != null) {
            handle.createOffer(new IPluginHandleWebRTCCallbacks() {
                @Override
                public void onSuccess(JSONObject obj) {
                    try {
                        final JSONObject msg = new JSONObject();
                        JSONObject body = new JSONObject();
                        body.put(Constants.REQUEST, "configure");
                        body.put("audio", true);
                        body.put("audiocodec", audioCodec);//lyz@xdja.com add
                        body.put("video", false);//data
                        body.put("data", true);//data
                        msg.put(Constants.MESSAGE, body);
                        msg.put("jsep", obj);
                        handle.sendMessage(new IPluginHandleSendMessageCallbacks() {
                            @Override
                            public void onSuccessSynchronous(JSONObject obj) {
                            }

                            @Override
                            public void onSuccesAsynchronous() {
//                                if (newPunishId != null) {
//                                    newRemoteFeed(newPunishId, audioCodec);
//                                }
                            }

                            @Override
                            public JSONObject getMessage() {
                                return msg;
                            }

                            @Override
                            public void onCallbackError(String error) {
                                pocRoom.onRoomStatus(roomId, Constants.ROOM_CREATE_FAILED, error);
                            }
                        });
                    } catch (Exception ex) {

                    }
                }

                @Override
                public JSONObject getJsep() {
                    return null;
                }

                @Override
                public JanusMediaConstraints getMedia() {
                    JanusMediaConstraints cons = new JanusMediaConstraints();
                    cons.setRecvAudio(true);//lyz@xdja.com modify
                    cons.setRecvVideo(false);
                    cons.setSendAudio(true);
                    cons.setAudioCodec(audioCodec);
                    return cons;
                }


                @Override
                public Boolean getTrickle() {
                    return true;
                }

                @Override
                public VideoSink getRemoteSink() {
                    return null;
                }

                @Override
                public void onCallbackError(String error) {
                    LogUtils.ELog(TAG, "error: " + error);
                    if (handle != null) {
                        handle.hangUp();//?
                    }
                }
            });
        }
    }

    public List<String> getMemberList() {
        if (memberList != null) {
            LogUtils.ILog(TAG, "onLineMemberList size: " + memberList.size() +
                    "  onLineMemberList: " + memberList.toString());
        }
        return memberList;
    }

    public synchronized void takenTBCP(int isForce) {
        if (!pocRoom.isJoined() && !pocRoom.isCreated()) {
            pocRoom.onRoomStatus(roomId, Constants.ROOM_LEAVE_SUCCESS, "");
            return;
        }
        LogUtils.DLog(TAG, "takenTBCP bWaitTakenTBCPResult: " + bWaitTakenTBCPResult);
        bWaitTakenTBCPResult = true;
        JanusServer.RandomString stringGenerator = new JanusServer.RandomString();
        takeTbcpcurrTransaction = stringGenerator.randomString(12);
        copyTakenTransaction = takeTbcpcurrTransaction;
        JSONObject jsonObject = JaunsApi.takenTBCP(roomId, takeTbcpcurrTransaction, isForce);
        if (handle != null) {
            assert jsonObject != null;
            handle.sendMsgOverDataChannel(jsonObject.toString());
        }
    }

    public synchronized void releaseTBCP() {
        LogUtils.DLog(TAG, "JanusCreateRoomPluginCallbacks releaseTBCP ....");
        if (!pocRoom.isJoined() && !pocRoom.isCreated()) {
            pocRoom.onRoomStatus(roomId, Constants.ROOM_LEAVE_SUCCESS, "");
            LogUtils.DLog(TAG, "JanusCreateRoomPluginCallbacks releaseTBCP return ....");
            return;
        }
        LogUtils.DLog(TAG, "releaseTBCP bWaitRealeaseTBCPResult: " + bWaitRealeaseTBCPResult);
        bWaitRealeaseTBCPResult = true;
        JanusServer.RandomString stringGenerator = new JanusServer.RandomString();
        releaseTbcpcurrTransaction = stringGenerator.randomString(12);
        copyReleaseTransaction = releaseTbcpcurrTransaction;
        JSONObject jsonObject = JaunsApi.releaseTBCP(roomId, releaseTbcpcurrTransaction);
        if (handle != null) {
            assert jsonObject != null;
            handle.sendMsgOverDataChannel(jsonObject.toString());
        }
        if (handle != null) {
            handle.releaseTBCP();
        }
    }

    public void sendMsgToRoom(String msg) {
        if (handle != null) {
            handle.sendMsgOverDataChannel(msg);
        }
    }

    private void unPublishRoom() {
        if (handle != null) {
            JSONObject unpublish = JaunsApi.unpublish();
            handle.sendMessage(new PluginHandleSendMessageCallbacks(unpublish));
        }
    }

    public void hangup() {
        if (handle != null) {
            handle.hangUp();
        }
        if (listenerAttachCallbacks != null && listenerAttachCallbacks.getHandler() != null) {
            listenerAttachCallbacks.getHandler().hangUp();
        }
    }

    public void destoryRoom(String secret, @Nullable Boolean permanent) {
        unPublishRoom();

        if (listenerAttachCallbacks != null) {
            listenerAttachCallbacks.leaveRoom();
        }
        if (handle != null) {
            //JSONObject msg = JaunsApi.leaveRoom();
            //handle.sendMessage(new PluginHandleSendMessageCallbacks(msg));

            final JSONObject jsonObject = JaunsApi.destroyRoom(roomId, secret, permanent);
            handle.sendMessage(new IPluginHandleSendMessageCallbacks() {
                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    if (obj != null) {
                        if (obj.has("error_code")) {
                            try {
                                pocRoom.onRoomStatus(roomId, Constants.ROOM_DESTROY_FAILED, obj.getString("error"));
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }

                @Override
                public void onSuccesAsynchronous() {
                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {
                    LogUtils.ELog(TAG, "error: " + error);
                    pocRoom.onRoomStatus(roomId, Constants.ROOM_DESTROY_FAILED, error);
                }
            });

            //end detach
            handle.hangUp();
        }
    }

    public synchronized void leaveRoom() {
        if (!pocRoom.isJoined() && !pocRoom.isCreated()) {
            pocRoom.onRoomStatus(roomId, Constants.ROOM_LEAVE_SUCCESS, "");
            return;
        }
        unPublishRoom();

        if (listenerAttachCallbacks != null) {
            listenerAttachCallbacks.leaveRoom();
        }
        if (handle != null) {
            handle.sendMessage(new IPluginHandleSendMessageCallbacks() {
                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    pocRoom.onRoomStatus(roomId, Constants.ROOM_LEAVE_SUCCESS, "");
                    if (memberList != null) {
                        memberList.clear();
                    }
                    pocRoom.removeCallbackFromJanusServer();
                }

                @Override
                public void onSuccesAsynchronous() {
                    pocRoom.onRoomStatus(roomId, Constants.ROOM_LEAVE_SUCCESS, "");
                    if (memberList != null) {
                        memberList.clear();
                    }
                    pocRoom.removeCallbackFromJanusServer();
                }

                @Override
                public JSONObject getMessage() {
                    JSONObject msg = JaunsApi.leaveRoom();
                    return msg;
                }

                @Override
                public void onCallbackError(String error) {
                    LogUtils.ELog(TAG, "error: " + error);
                    //pocRoom.onRoomStatus(roomId, Constants.ROOM_LEAVE_FAILED, error);
                    //pocRoom.removeCallbackFromJanusServer();
                }
            });
            if (handle != null)
                handle.hangUp();

            //after later need detach the server.
            //handle.detatch();
        }

    }

    public void createRoom(final long roomId, String secret, final String pin, final String userId, final String userName,
                           String description, @Nullable Boolean permanent, @Nullable Boolean isPrivate) {
        if (handle != null) {
            final JSONObject room = JaunsApi.createRoom(roomId, secret, pin, userName, description, permanent, isPrivate);
            handle.sendMessage(new IPluginHandleSendMessageCallbacks() {
                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    //
                    pocRoom.setCreating(false);
                    if (obj != null) {
                        LogUtils.DLog(TAG, obj.toString());

                        try {
                            if (obj.has("room") && obj.getLong("room") == roomId) {
                                pocRoom.onRoomStatus(roomId, Constants.ROOM_CREATE_SUCCESS, null);
                                pocRoom.setCreated(true);
//                                joinRoom(roomId, Integer.parseInt(userId), userName, pin, null);
                                joinRoom(roomId, 0, userName, pin, null);
                            } else {
                                //{"videoroom":"event","error_code":427,"error":"Room 3636 already exists"}
                                LogUtils.DLog(TAG, "err:" + obj.get("error"));
                                int error_code = obj.getInt("error_code");
                                if (error_code == 427) {
                                    //
                                    String error = obj.getString("error");
                                    pocRoom.onRoomStatus(roomId, Constants.ROOM_ALREADY_EXIST, error);
                                    pocRoom.setCreated(true);
//                                    joinRoom(roomId, Integer.parseInt(userId), userName, pin, null);
                                    joinRoom(roomId, 0, userName, pin, null);
                                } else {
                                    String error = obj.getString("error");
                                    pocRoom.onRoomStatus(roomId, Constants.ROOM_CREATE_ERROR, error);
                                }
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }

                @Override
                public void onSuccesAsynchronous() {
                }

                @Override
                public JSONObject getMessage() {
                    return room;
                }

                @Override
                public void onCallbackError(String error) {
                    LogUtils.ELog(TAG, "error: " + error);
                    pocRoom.setCreated(false);
                    pocRoom.setCreating(false);
                    pocRoom.setJoined(false);
                    pocRoom.onRoomStatus(roomId, Constants.ROOM_CREATE_FAILED, error);
                }
            });
        }
    }

    public void newRemoteFeed(BigInteger id, String audioCodec) { //todo attach the plugin as a listener
        /*POCRoom.ProxyVideoSink myrenderer;
        if (!remoteRenderers.containsKey(id)) {
            if (!availableRemoteRenderers.isEmpty()) {
                remoteRenderers.put(id, availableRemoteRenderers.pop());
            }
        }
        myrenderer = remoteRenderers.get(id);*/
        LogUtils.DLog(TAG, "newRemoteFeed needPlayer: " + needPlayer);
        listenerAttachCallbacks = new JanusListenerAttachCallbacks(roomId, privateId, id, null, pocRoom, needPlayer);
        listenerAttachCallbacks.setAudioCode(audioCodec);
        listenerAttachCallbacks.mute(muteState);
        pocRoom.attach(listenerAttachCallbacks);
    }

    @Deprecated
    @Override
    public void success(JanusPluginHandleWithWebrtc handle1) {
        handle = handle1;

        pocRoom.attachSuccess();
        //createRoom();
    }

    @Override
    public void onMessage(JSONObject msg, JSONObject jsepLocal) {
        try {
            String event = msg.getString("videoroom");
            LogUtils.DLog(TAG, "onMessage:" + event);
            if (event.equals("joined")) {
                if (msg.has("private_id")) {
                    privateId = new BigInteger(msg.getString("private_id"));
                } else {
                    privateId = new BigInteger(msg.getString("id"));
                }
                String audioCodec = "opus";
                if (msg.has(Constants.PUBLISHERS)) {
                    JSONArray pubs = msg.getJSONArray(Constants.PUBLISHERS);
                    for (int i = 0; i < pubs.length(); i++) {
                        JSONObject pub = pubs.getJSONObject(i);
                        newPunishId = new BigInteger(pub.getString("id"));
                        if (pub.has("audio_codec")) {
                            audioCodec = pub.getString("audio_codec");
                        }
                    }
                }
                publishOwnFeed(audioCodec); //lyz del
                JSONArray pubs = null;
                if (msg.has(Constants.MEMBERS)) {
                    pubs = msg.getJSONArray(Constants.MEMBERS);
                    for (int i = 0; i < pubs.length(); i++) {
                        JSONObject pub = pubs.getJSONObject(i);
                        String userid = pub.getString("display");
                        if (!memberList.contains(userid)) {
                            memberList.add(userid);
                        }
                    }
                }

                LogUtils.DLog(TAG, "send Constants.ROOM_JOIN_SUCCESS:" + roomId);
                assert pubs != null;
                pocRoom.onRoomStatus(roomId, Constants.ROOM_JOIN_SUCCESS, pubs.toString());
                if (msg.has("current_publisher")) {
                    needPlayer = true;
                    pocRoom.onTBCP(Constants.ROOM_OTHER_TBCP_REQUEST_SUCCESS, msg.optString("current_publisher"));
                }
            } else if (event.equals("destroyed")) {
                //destory
                //if (janusServer != null) {
                //    janusServer.destroy();
                //}

                handle.detach();
                //after later need detach the server.
                pocRoom.onRoomStatus(roomId, Constants.ROOM_DESTROY_SUCCESS, event);
                pocRoom.setDestroy(true);
            } else if (event.equals("event")) {
                if (msg.has("leaving")) {
                    //some body leaver
                    String user = msg.getString("leaving");
                    if (user != null && !user.equals(userName)) {
                        if (user.equals(pocRoom.getCurrTBCPUser())) {
                            pocRoom.resetCurrTBCPUser();
                        }
                        memberList.remove(user);//
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_OTHER_USER_LEFT, msg.getString("leaving"));
                    }
                } else if (msg.has("publishers")) {
                    JSONArray pubs = msg.getJSONArray("publishers");
                    JSONObject pub = pubs.getJSONObject(0);
                    if (pub.has("display")) {
                        String userid = pub.getString("display");
                        if (!memberList.contains(userid)) {
                            memberList.add(userid);
                        }
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_OTHER_USER_INCOMING, userid);
                    }
                } else if (msg.has("unpublished")) {
                    String user = msg.getString("unpublished");
                    if (user != null && user.equals(userName)) {
                        memberList.remove(user);//
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_LEAVE_SUCCESS, user);
                    }
                } else if (msg.has("started")) {

                }
                //todo error
                if (jsepLocal != null) {
                    handle.handleRemoteJsep(new PluginHandleWebRTCCallbacks(null, jsepLocal, false));
                }
            } else {
                LogUtils.DLog(TAG, "event:" + event);
            }
        } catch (Exception ex) {
            LogUtils.ELog(ex);
        }
    }

    @Override
    public void onLocalStream(MediaStream stream) {
    }

    @Override
    public void onRemoteStream(MediaStream stream) {

    }

    @Override
    public void onDataOpen(Object data) {
        pocRoom.onRoomStatus(roomId, Constants.ROOM_CAN_TALK, "");
    }

    @Override
    public void onData(Object data) {
        boolean ret = true;
        if (data instanceof JSONObject) {
            ret = false;
        }
        if (ret) {
            return;
        }
        JSONObject object = (JSONObject) data;
        String currTransaction = null;
        boolean bWaitTbcp = false;
        int result_code = 0;
        try {
            result_code = object.getInt("result_code");
            if (result_code != CUSTOM_TBCP_SAVE_MP3_RECORD) {
                ack();//for reliable udp.
            }
            if (result_code == TBCP_REQUEST_SUCCESS || result_code == TBCP_REQUEST_FAILED || result_code == TBCP_REQUEST_TAKEN) {
                if (takeTbcpcurrTransaction == null) {
                    takeTbcpcurrTransaction = copyTakenTransaction;
                }
                currTransaction = takeTbcpcurrTransaction;
                bWaitTbcp = bWaitTakenTBCPResult;
            } else if (result_code == TBCP_RELEASE_FAILED || result_code == TBCP_RELEASE_SUCCESS) {
                if (releaseTbcpcurrTransaction == null) {
                    releaseTbcpcurrTransaction = copyReleaseTransaction;
                }
                currTransaction = releaseTbcpcurrTransaction;
                bWaitTbcp = bWaitRealeaseTBCPResult;
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        pocRoom.handleTBCP(bWaitTbcp, (JSONObject) data, currTransaction, handle, /*listenerAttachCallbacks.getHandler()*/null);
        LogUtils.DLog(TAG, "onData bWaitTakenTBCPResult: " + bWaitTakenTBCPResult + ",bWaitRealeaseTBCPResult:" + bWaitRealeaseTBCPResult);
        if ((result_code == TBCP_REQUEST_SUCCESS || result_code == TBCP_REQUEST_FAILED || result_code == TBCP_REQUEST_TAKEN) && bWaitTakenTBCPResult) {
            bWaitTakenTBCPResult = false;
            takeTbcpcurrTransaction = null;
        } else if ((result_code == TBCP_RELEASE_FAILED || result_code == TBCP_RELEASE_SUCCESS) && bWaitRealeaseTBCPResult) {
            bWaitRealeaseTBCPResult = false;
            releaseTbcpcurrTransaction = null;
        }
    }

    private void ack() {
        try {
              /*  JanusServer.RandomString stringGenerator = new JanusServer.RandomString();
                currTransaction = stringGenerator.randomString(12);*/
            JSONObject obj = new JSONObject();
            obj.put("request", "tbcp");
            obj.put("type", "ack");
            obj.put("room", roomId);
            // obj.put("transaction",currTransaction);
            if (handle != null) {
                handle.sendMsgOverDataChannel(obj.toString());
            }

        } catch (Exception ex) {

        }
    }

    @Override
    public void onCleanup() {
//        pocRoom.setCreated(false);
//        pocRoom.setCreating(false);
//        pocRoom.setJoined(false);

        if (handle != null) {
            handle.hangUp();
        }
//        pocRoom.onRoomStatus(roomId, Constants.ROOM_SEVER_DISCONNECT_SUCCESS, "");
    }

    @Override
    public JanusSupportedPluginPackages getPlugin() {
        return JanusSupportedPluginPackages.JANUS_POC_ROOM;
    }

    @Override
    public void onCallbackError(String error) {
        LogUtils.ELog(TAG, "err:" + error);
        pocRoom.setCreated(false);
        pocRoom.setCreating(false);
        pocRoom.setJoined(false);

        if (handle != null) {
            handle.hangUp();
        }

        if (memberList != null) {
            memberList.clear();
        }

        if (error != null && error.contains("connection failed")) {
            //leaveRoom();
            //pocRoom.onRoomStatus(roomId, Constants.ROOM_SEVER_CONNECT_FAILED, error);
            pocRoom.onRoomStatus(roomId, Constants.ROOM_SEVER_DISCONNECT, error);
        } else {
            pocRoom.onRoomStatus(roomId, Constants.ROOM_CREATE_FAILED, error);
        }
    }

    @Override
    public void onDetached() {
        if (handle != null) {
            handle.hangUp();
        }
        if (memberList != null) {
            memberList.clear();
        }
        handle = null;
        pocRoom.onRoomStatus(roomId, Constants.ROOM_SEVER_DISCONNECT_SUCCESS, "");
    }
}