package com.xdja.poc.sdk.business.plugincallback;

import com.xdja.poc.sdk.business.POCRoom;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusPluginCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IPluginHandleWebRTCCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusMediaConstraints;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusPluginHandleWithWebrtc;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusSupportedPluginPackages;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.PluginHandleSendMessageCallbacks;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.config.JaunsApi;

import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.MediaStream;
import org.webrtc.VideoSink;

import java.math.BigInteger;

/**
 * Created by john on 2018/9/6.
 */


public class JanusListenerAttachCallbacks implements IJanusPluginCallbacks {
    private final String TAG = "ListenerAttach";
    private POCRoom.ProxyVideoSink renderer = null;
    private BigInteger feedid = null;
    private BigInteger privateId;
    private long roomid;
    private JanusPluginHandleWithWebrtc listenerHandle = null;
    private POCRoom pocRoom;
    private boolean needPlayer = false;
    private boolean muteState = false;
    String audioCodec = "opus";

    public JanusListenerAttachCallbacks(long roomid, BigInteger privateId, BigInteger id, POCRoom.ProxyVideoSink renderer, POCRoom pocRoom, boolean needPlayer) {
        this.renderer = renderer;
        this.feedid = id;
        this.roomid = roomid;
        this.privateId = privateId;
        this.pocRoom = pocRoom;
        this.needPlayer = needPlayer;
    }

    public void setAudioCode(String codec){
        audioCodec =  codec;
    }

    @Override
    public void success(JanusPluginHandleWithWebrtc handle) {
        listenerHandle = handle;
        try {
            JSONObject jsonObject = JaunsApi.subscriberJoin(roomid, feedid, Constants.PIN, privateId, true, true, false, true, true, false, true);
            handle.sendMessage(new PluginHandleSendMessageCallbacks(jsonObject));
        } catch (Exception ex) {

        }
    }

    public void sendMsgToRoom(String msg) {
        if (listenerHandle != null) {
            listenerHandle.sendMsgOverDataChannel(msg);
        }
    }

    public void mute(boolean enable){
        muteState = enable;
        if(listenerHandle != null){
            listenerHandle.mute(enable);
        }
    }

    public JanusPluginHandleWithWebrtc getHandler(){
        return listenerHandle;
    }

    public boolean getMuteState() {
        if (listenerHandle != null)
            return listenerHandle.getMuteState();
        return true;
    }
    public void leaveRoom() {
        if (listenerHandle != null) {
            JSONObject jsonObject = JaunsApi.leaveRoom();
            listenerHandle.sendMessage(new PluginHandleSendMessageCallbacks(jsonObject));

            listenerHandle.hangUp();
            //after later need detach the server.
            //handle.detatch();
        }
    }

    @Override
    public void onMessage(JSONObject msg, JSONObject jsep) {
        pocRoom.setJoining(false);
        try {
            String event = msg.getString("videoroom");
            if (event.equals("attached") && jsep != null) {
                final JSONObject remoteJsep = jsep;
                listenerHandle.createAnswer(new IPluginHandleWebRTCCallbacks() {
                    @Override
                    public void onSuccess(JSONObject obj) {
                        try {
                            JSONObject mymsg = new JSONObject();
                            JSONObject body = new JSONObject();
                            body.put(Constants.REQUEST, "start");
                            body.put("room", roomid);
                            mymsg.put(Constants.MESSAGE, body);
                            mymsg.put("jsep", obj);
                            listenerHandle.sendMessage(new PluginHandleSendMessageCallbacks(mymsg));
                            //del by zhangs
                            //pocRoom.onRoomStatus(roomid, Constants.ROOM_JOIN_SUCCESS, null);
                            pocRoom.setJoined(true);

                            LogUtils.ELog(TAG, "onSuccess: " + needPlayer + ", needPlayer:"+needPlayer+", muteState:"+muteState);
                            if (!muteState && needPlayer && listenerHandle != null){
                                listenerHandle.startPlayer(true);
                            }/*else{
                                listenerHandle.startPlayer(false);
                            }*/
                        } catch (Exception ex) {
                            pocRoom.onRoomStatus(roomid, Constants.ROOM_JOIN_FAILED, ex.getMessage());
                            LogUtils.ELog(ex);
                        }
                    }

                    @Override
                    public JSONObject getJsep() {
                        return remoteJsep;
                    }

                    @Override
                    public VideoSink getRemoteSink() {
                        return renderer;
                    }

                    @Override
                    public JanusMediaConstraints getMedia() {
                        JanusMediaConstraints cons = new JanusMediaConstraints();
                        cons.setVideo(null);
                        cons.setRecvAudio(true);
                        cons.setRecvVideo(false);
                        cons.setSendAudio(false);
                        cons.setAudioCodec(audioCodec);
                        return cons;
                    }

                    @Override
                    public Boolean getTrickle() {
                        return true;
                    }

                    @Override
                    public void onCallbackError(String error) {
                        LogUtils.ELog(TAG, "error: " + error);
                        if (listenerHandle != null) {
                            listenerHandle.hangUp();
                        }
//                        pocRoom.onRoomStatus(roomid, Constants.ROOM_JOIN_FAILED, error);
                    }
                });
            } else if (event.equals("event")) {
                if (msg.has("left")) {
                    if (listenerHandle != null) {
                        listenerHandle.detach();//detach
                    }
                }
            }
        } catch (Exception ex) {
            LogUtils.ELog(ex);
        }
    }

    @Override
    public void onLocalStream(MediaStream stream) {

    }

    @Override
    public void onRemoteStream(MediaStream stream) {
    }

    @Override
    public void onDataOpen(Object data) {

    }

    @Override
    public void onData(Object data) {
        boolean ret = true;
        if (data instanceof JSONObject) {
            ret = false;
        }
        if (ret) {
            return;
        }

        JSONObject obj = (JSONObject) data;
        if (obj.has("result")) {
            try {
                String result = obj.getString("result");
                if (result.equals("tbcp")) {
                    int result_code = obj.getInt("result_code");
                    switch (result_code) {
                        case Constants.TBCP_REQUEST_SUCCESS: {
                            String tbcp_owner = obj.getString("tbcp_owner_name");
                            pocRoom.onTBCP(Constants.ROOM_OTHER_TBCP_REQUEST_SUCCESS, tbcp_owner);
                        }
                        break;
                        case Constants.TBCP_RELEASE_SUCCESS:
                            String tbcp_owner = obj.getString("tbcp_old_owner");
                            pocRoom.onTBCP(Constants.ROOM_OTHER_TBCP_RELEASE_SUCCESS, tbcp_owner);
                            break;
                    }
                }

            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onCleanup() {

        pocRoom.setCreated(false);
        pocRoom.setCreating(false);
        pocRoom.setJoined(false);
    }

    @Override
    public void onDetached() {
        listenerHandle = null;

        pocRoom.setCreated(false);
        pocRoom.setCreating(false);
        pocRoom.setJoined(false);
    }

    @Override
    public JanusSupportedPluginPackages getPlugin() {
        return JanusSupportedPluginPackages.JANUS_POC_ROOM;
    }

    @Override
    public void onCallbackError(String error) {

        LogUtils.ELog(TAG, "listen err:" + error);
        pocRoom.setCreated(false);
        pocRoom.setCreating(false);
        pocRoom.setJoined(false);

        if (listenerHandle != null) {
            listenerHandle.hangUp();
        }
        if (error != null && error.contains("connection failed")) {
            //leaveRoom();
            //pocRoom.onRoomStatus(roomId, Constants.ROOM_SEVER_CONNECT_FAILED, error);
            pocRoom.onRoomStatus(roomid, Constants.ROOM_SEVER_DISCONNECT, error);
        } else {
            pocRoom.onRoomStatus(roomid, Constants.ROOM_CREATE_FAILED, error);
        }
    }
}
