package com.xdja.poc.sdk.config;

import android.support.annotation.Nullable;
import android.text.TextUtils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.math.BigInteger;

/**
 * Created by zhangsen on 2018/8/29.
 */

public class JaunsApi {
    public static final String REQUEST = "request";
    public static final String MESSAGE = "message";

    /**
     * 创建频道
     * @param roomId 频道id
     * @param secret 操作频道密码
     * @param pin    加入频道密码
     * @param userName  用户名称
     * @param description  频道描述或名称
     * @param permanent    是否从配置文件删除该频道
     * @param isPrivate    是否将频道配置为私有
     * @return
     */
    public static JSONObject createRoom(long roomId, String secret, String pin, String userName,
                                        String description, @Nullable Boolean permanent, @Nullable Boolean isPrivate) {
        JSONObject obj = new JSONObject();
        final JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, "create");
            obj.put("room", roomId);
            if (!isEmpty(description)) {
                obj.put("description", description);
            }
            if (!isEmpty(secret)) {
                obj.put("secret", secret);
            }
            if (!isEmpty(pin)) {
                obj.put("pin", pin);
            }
            if (!isEmpty(userName)) {
                obj.put("display", userName);
            }
            if(!isNull(permanent)){
                obj.put("permanent", permanent);
            }
            if(!isNull(isPrivate)){
                obj.put("is_private", isPrivate);
            }

            msg.put(MESSAGE, obj);
            return msg;
        } catch (JSONException ex) {
            ex.printStackTrace();

        }
        return null;
    }

    /**
     * 编辑频道属性
     *
     * @param roomid             频道id
     * @param secret             操作频道密码
     * @param newDescription     频道新描述或名称
     * @param newSecret          频道新的操作密码
     * @param newPin             加入频道需要的密码
     * @param newIsPrivated      频道是否出现在请求列表中
     * @param newRequirePrivated 频道是否能被订阅
     * @param newBitrate         码率上限
     * @param newFirFreq         对发布者来说按周期请求PLI关键帧
     * @param newPublishers      发布者并发数量
     * @param permanent          是否从配置文件删除该频道
     * @return
     */
    public static JSONObject editRoom(long roomid, String secret, String newDescription,
                                      String newSecret, String newPin, @Nullable Boolean newIsPrivated, @Nullable Boolean newRequirePrivated,
                                      @Nullable Integer newBitrate, @Nullable Integer newFirFreq, @Nullable Integer newPublishers, @Nullable Boolean permanent) {

        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, "edit");
            obj.put("room", roomid);
            obj.put("secret", secret);

            if (!isEmpty(newDescription)) {
                obj.put("new_description", newDescription);
            }
            if (!isEmpty(newSecret)) {
                obj.put("new_secret", newSecret);
            }
            if (!isEmpty(newPin)) {
                obj.put("new_pin", newPin);
            }
            if (!isNull(newIsPrivated)) {
                obj.put("new_is_private", newIsPrivated);
            }
            if (!isNull(newRequirePrivated)) {
                obj.put("new_require_pvtid", newRequirePrivated);
            }
            if (!isNull(newBitrate)) {
                obj.put("new_bitrate", newBitrate);
            }
            if (!isNull(newFirFreq)) {
                obj.put("new_fir_freq", newFirFreq);
            }
            if (!isNull(newPublishers)) {
                obj.put("new_publishers", newPublishers);
            }
            if (!isNull(permanent)) {
                obj.put("permanent", permanent);
            }
            msg.put(MESSAGE, obj);
            return msg;
        } catch (JSONException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /**
     * 销毁频道
     * @param roomId  频道id
     * @param secret   操作频道密码
     * @param permanent  是否从配置文件删除该频道
     * @return
     */
    public static JSONObject destroyRoom(long roomId,String secret,@Nullable Boolean permanent){
        JSONObject obj2 = new JSONObject();
        JSONObject msg2 = new JSONObject();
        try {
            obj2.put(REQUEST, "destroy");
            obj2.put("room", roomId);
            obj2.put("secret", secret);
            if(!isNull(permanent)){
                obj2.put("permanent",permanent);
            }
            msg2.put(MESSAGE, obj2);
            return msg2;
        } catch (JSONException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /**
     * 频道是否存在
     * @param roomid 频道id
     * @return
     */
    public static JSONObject existsRoom(long roomid){
        JSONObject obj2 = new JSONObject();
        JSONObject msg2 = new JSONObject();
        try {
            obj2.put(REQUEST, "exists");
            obj2.put("room", roomid);
            msg2.put(MESSAGE, obj2);
            return msg2;
        } catch (JSONException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /**
     * 检查token权限   或者添加或删除人员
     * @param roomid  频道id
     * @param secret  操作频道密码
     * @param action  动作 包括四个值 enable(开启检查token) / disable(关闭检查token) / add(添加用户) / remove(删除用户)
     * @param alloweds
     * @return
     */
    public static JSONObject allowedRoom(long roomid,int secret,String action,String[] alloweds){
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        try {
            obj.put(REQUEST, "allowed");
            obj.put("secret", secret);
            obj.put("action", action);
            obj.put("room", roomid);
            for (String allow:alloweds) {
                jsonArray.put(allow);
            }
            obj.put("allowed",jsonArray);
            msg.put(MESSAGE, obj);
            return msg;
        } catch (JSONException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /**
     *  踢人  当前方法只是把用户移除频道,但是并不禁止用户再次加入,如果要彻底移除,配合 allowedRoom() 方法
     * @param roomId   频道ID
     * @param peopleId 要踢的用户的ID
     * @param secret   操作频道的密码
     * @return
     */
    public static JSONObject kickPerson(long roomId,int peopleId,String secret){
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, "kick");
            obj.put("secret", secret);
            obj.put("id", peopleId);
            obj.put("room", roomId);
            msg.put(MESSAGE, obj);
            return msg;
        } catch (JSONException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /**
     * 列出当前所有频道
     * @return
     */
    public static JSONObject listRooms(){
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, "list");
            msg.put(MESSAGE, obj);
            return msg;
        } catch (JSONException ex) {
            ex.printStackTrace();
        }
        return null;
    }
    /**
     * 列出当前频道所有用户
     * @return
     */
    public static JSONObject listParticipants(long roomId){
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, "listparticipants");
            obj.put("room", roomId);
            msg.put(MESSAGE, obj);
            return msg;
        } catch (JSONException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /**
     * 发布者加入频道
     * @param roomId     频道id
     * @param userId     用户id
     * @param userName   用户名
     * @param token      加入频道令牌,防止频道有ACL(访问控制列表)
     * @return
     */
    public static JSONObject join(long roomId,@Nullable  Integer userId, @Nullable  String userName,String pin,@Nullable String token){
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, "join");
            obj.put("ptype", Constants.PTYPE_PUBLISH);
            obj.put("room", roomId);
            if(!isEmpty(pin)){
                obj.put("pin",pin);
            }
            if(!isNull(userId)){
//                obj.put("id",userId);
                obj.put("display",String.valueOf(userId));
            }
            if(!isNull(userName)){
                obj.put("display",userName);
            }
            if(!isNull(token)){
                obj.put("token",token);
            }
            msg.put(MESSAGE, obj);
            return msg;
        } catch (JSONException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /**
     *  发布媒体
     * @param audio   是否应该转发音频; 默认为true
     * @param video   是否应传播视频; 默认为true,
     * @param data    是否应该中继数据; 默认为true,
     * @param audioCode   音频编码类型  (opus|g722|pcmu|pcma|isac32|isac16 default value=opus)
     * @param videoCode   视频编码器类型 (vp8|vp9|h264  default value = vp8)
     * @param bitrate    比特率上限
     * @param record     是否记录发布者
     * @param fileName   如果录制,录制文件的保存路径
     * @param display    在频道中使用的名字
     * @return
     */
    public static JSONObject publish(@Nullable Boolean audio,@Nullable Boolean video,@Nullable Boolean data,
        String audioCode,String videoCode,@Nullable Integer bitrate,@Nullable Boolean record,String fileName,String display){
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, "publish");
            obj.put("audio", audio);
            obj.put("video", video);
            obj.put("data", data);
            if(!isEmpty(audioCode)){
                obj.put("audiocodec",audioCode);
            }
            if(!isEmpty(videoCode)){
                obj.put("videocodec",videoCode);
            }
            if(!isNull(bitrate)){
                obj.put("bitrate",bitrate);
            }
            if(!isNull(record)){
                obj.put("record",record);
            }
            if(!isEmpty(fileName)){
                obj.put("filename",fileName);
            }
            if(!isEmpty(display)){
                obj.put("display",display);
            }
            msg.put(MESSAGE, obj);
            return msg;
        } catch (JSONException ex) {
            ex.printStackTrace();
        }
        return null;
    }
    /**
     * 停止发送消息并拆解相关的PeerConnection
     * @return
     */
    public static JSONObject unpublish(){
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, "unpublish");
            msg.put(MESSAGE, obj);
            return msg;
        } catch (JSONException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /**
     * 调整配置属性
     * @param audio   是否应该转发音频; 默认为true
     * @param video   是否应传播视频; 默认为true,
     * @param data    是否应该中继数据; 默认为true
     * @param bitrate    比特率上限
     * @param record     是否记录发布者
     * @param fileName   如果录制,录制文件的保存路径
     * @param display    在频道中使用的名字
     * @return
     */
    public static JSONObject configure(@Nullable Boolean audio,@Nullable Boolean video,@Nullable Boolean data,
                                     @Nullable Integer bitrate,@Nullable Boolean record,String fileName,String display){
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, "configure");
            obj.put("audio", audio);
            obj.put("video", video);
            obj.put("data", data);
            if(!isNull(bitrate)){
                obj.put("bitrate",bitrate);
            }
            if(!isNull(record)){
                obj.put("record",record);
            }
            if(!isEmpty(fileName)){
                obj.put("filename",fileName);
            }
            if(!isEmpty(display)){
                obj.put("display",display);
            }
            msg.put(MESSAGE, obj);
            return msg;
        } catch (JSONException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /**
     * 列出当前频道所有RTP转发列表
     * @param roomID
     * @param secret
     * @return
     */
    public static JSONObject listforwarders(long roomID,String secret){
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, "listforwarders");
            obj.put("room", roomID);
            obj.put("secret", secret);
            msg.put(MESSAGE, obj);
            return msg;
        } catch (JSONException ex) {
            ex.printStackTrace();
        }
        return null;

    }
    /**
     * 离开频道
     * @return
     */
    public static JSONObject leaveRoom(){
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, "leave");
            msg.put(MESSAGE, obj);
            return msg;
        } catch (JSONException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /**
     * 订阅者加入频道
     * @param roomId            频道id
     * @param feedId            要订阅的发布者的唯一ID
     * @param privateId         发起此请求的发布者的唯一ID
     * @param closePc           具体取决于发布者离开时是否应自动关闭PeerConnectio
     * @param audio             是否转发音频
     * @param video             是否传播视频
     * @param data              是否中继数据
     * @param offerAudio
     * @param offerVideo
     * @param offerData
     * @return
     */
    public static JSONObject subscriberJoin(long roomId, BigInteger feedId, String pin, @Nullable BigInteger privateId, @Nullable Boolean closePc ,
                                            @Nullable Boolean audio, @Nullable Boolean video, @Nullable Boolean data,
                                            @Nullable Boolean offerAudio, @Nullable Boolean offerVideo, @Nullable Boolean offerData){
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, "join");
            obj.put("ptype", Constants.PTYPE_LISTEN);
            obj.put("room", roomId);
            obj.put("feed", feedId);
            if(!isEmpty(pin)){
                obj.put("pin",pin);
            }
            if(!isNull(privateId)){
                obj.put("private_id",privateId);
            }
            if(!isNull(closePc)){
                obj.put("close_pc",closePc);
            }
            if(!isNull(audio)){
                obj.put("audio",audio);
            }
            if(!isNull(video)){
                obj.put("video",video);
            }
            if(!isNull(data)){
                obj.put("data",data);
            }
            if(!isNull(offerAudio)){
                obj.put("offer_audio",offerAudio);
            }
            if(!isNull(offerVideo)){
                obj.put("offer_video",offerVideo);
            }
            if(!isNull(offerData)){
                obj.put("offer_data",offerData);
            }
            msg.put(MESSAGE, obj);
            return msg;
        } catch (JSONException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /**
     *  启用媒体数据流
     * @param roomId
     * @return
     */
    public static JSONObject startMedia(long roomId){
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, "start");
            obj.put("room", "roomId");
            msg.put(MESSAGE, obj);
            return msg;
        } catch (JSONException ex) {
            ex.printStackTrace();
        }
        return null;
    }
    /**
     *  暂停媒体数据流
     * @param roomId
     * @return
     */
    public static JSONObject pauseMedia(long roomId){
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, "pause");
            obj.put("room", "roomId");
            msg.put(MESSAGE, obj);
            return msg;
        } catch (JSONException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /**
     * 切换订阅的发布者
     * @param feed              要切换到的新发布者的唯一ID
     * @param audio             是否转发音频
     * @param video             是否传播视频
     * @param data              是否中继数据
     * @return
     */
    public static JSONObject switchSubscriber(long feed,@Nullable Boolean audio,@Nullable Boolean video,@Nullable Boolean data){
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, "pause");
            obj.put("feed", feed);
            if(!isNull(audio)){
                obj.put("audio",audio);
            }
            if(!isNull(video)){
                obj.put("video",video);
            }
            if(!isNull(data)){
                obj.put("data",data);
            }
            msg.put(MESSAGE, obj);
            return msg;
        } catch (JSONException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /**
     * 抢占话语权
     * @param roomId
     * @param transaction
     * @return
     */
    public static JSONObject takenTBCP(long roomId,String transaction,int isForce){
        JSONObject obj = new JSONObject();
        try {
            obj.put(REQUEST, "tbcp");
            obj.put("type", "requst");
            obj.put("room", roomId);
            if(isForce==1){
                obj.put("forceinsert",isForce);
            }
            if(!isEmpty(transaction)){
                obj.put("transaction",transaction);
            }
            return obj;
        } catch (JSONException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /**
     * 释放话语权
     * @param roomId
     * @param transaction
     * @return
     */
    public static JSONObject releaseTBCP(long roomId,String transaction){
        JSONObject obj = new JSONObject();
        try {
            obj.put(REQUEST, "tbcp");
            obj.put("type", "release");
            obj.put("room", roomId);
            if(!isEmpty(transaction)){
                obj.put("transaction",transaction);
            }
            return obj;
        } catch (JSONException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private static boolean isEmpty(String str) {
        return TextUtils.isEmpty(str);
    }

    private static boolean isNull(Object obj) {
        return obj == null;
    }

}
