package com.xdja.poc.sdk.proxy;

import android.app.Activity;
import android.support.v4.app.FragmentActivity;

import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.event.GroupEvent;
import com.xdja.poc.sdk.event.POCConverationTbcpStatusEvent;
import com.xdja.poc.sdk.event.POCConversationMeIncomeRoom;
import com.xdja.poc.sdk.event.POCConversationUserChangeEvent;
import com.xdja.poc.sdk.event.POCMemberEvent;
import com.xdja.poc.sdk.event.POCSelfLeaveEvent;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.db.entity.User;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * janus-gateway-android-master
 * 功能
 * 描述
 * created by Wwq : 2018/9/28
 */

public interface IPOCUiKitProxy {
    /**
     * 用户缓存信息相关回调接口
     *
     * @param callBack
     */
    void setUserCacheCallBack(IPOCUserCacheCallBack callBack);

    void removeUserCacheCallBack(IPOCUserCacheCallBack cacheCallBack);

    Map<String, POCMemberInfo> getUserInfosCache();

    User getUserInfo();
    boolean isCanTalk();
    /**
     * 用户数据获取信息相关回调接口
     *
     * @param callBack
     */
    void setMemberInfoCallBack(IPOCMemberInfoCallBack callBack);

    void removeMemberInfoCallBack(IPOCMemberInfoCallBack callBack);

    List<POCMemberInfo> getPOCGroupUserInfos(String[] userIdsArray);

    /**
     * 频道回调
     */
    void addRoomEventCallBack(IPOCRoomEventCallBack callBack);

    void removeRoomEventCallBack(IPOCRoomEventCallBack callBack);

    void notifyServerRoomCreated(GroupEvent event, boolean stataus);

    void notifyTempRoomCreated(DBGroupEntity entity,String channelName, boolean stataus);

    void notifyServerRoomDeleted(GroupEvent event, boolean status);

    void notifyAddMembers(GroupEvent event, boolean status);

    void notifyRemoveMembers(GroupEvent event, boolean status);

    void notifyUpdateMembers(GroupEvent groupEvent, boolean status);

    void notifySelfLeave(POCSelfLeaveEvent selfLeaveEvent);

    void notifyTBCPEvent(POCConverationTbcpStatusEvent tbcpStatusEvent);

    void notifyMeIncomeRoom(POCConversationMeIncomeRoom meIncomeRoom);

    void notifyMemberEvent(POCMemberEvent memberEvent);

    void notifyUserChanged(POCConversationUserChangeEvent userChangeEvent);

    /**
     * 刷新频道列表
     */
    void setPOCGroupRefreshCallBack(IPOCGroupRefreshCallBack callBack);

    void removePOCGroupRefreshCallBack(IPOCGroupRefreshCallBack callBack);

    void notifyRefreshGroupList(int currentPage,int pageSize,int groupType);
    void notifyRefreshChannelMembersInfo(DBGroupEntity entity);
    void notifyUpdateChannelName(String channelId,String channelName);

    /**
     * 用户点击行为回调
     */
    void addUserClickCallBack(IPOCUserClickCallBack clickCallBack);

    void removeUserClickCallBack(IPOCUserClickCallBack callBack);

    void notigyUserDetailsClick(FragmentActivity activity,POCMemberInfo account);

    void notifyConversionViewMenuClick(DBGroupEntity entity, String channelName);

    void notifyConversionAddMembers(DBGroupEntity entity);

    void notifyChannelInfoResult(boolean result);

    /**
     * 频道列表长按事件
     */
    void setPOCGroupItemLongClickCallBack(IPOCGroupLongClickCallBack callBack);

    void removePOCGroupItemLongClickCallBack(IPOCGroupLongClickCallBack callBack);
    void notifyChannelListItemLongClick(DBGroupEntity entity, int position, String channleName);
    void notifyChannelDetailsItemLongClick(Activity activity,POCMemberInfo pocMemberInfo, String ownerId);
    /**
     * 需要app做的通知事件
     */
    void setRequestCallBack(IPOCRequestCallBack callBack);

    void removeRequestCallBack(IPOCRequestCallBack callBack);

    void doDeleteServerRoom(String roomId);

    void doRemoveMembersFromRoom(String roomId, String members);

    /**
     * 呼叫相关的接口
     */
    void setPushMessageCallBack(IPOCPushMessageCallBack callBack);

    void removePushMessageCallBack(IPOCPushMessageCallBack callBack);

    void notifyUserAccepet(String userId, String roomId,String channelName);

    void notifyUserReject(String userId, String roomId);

    void notifyUserNoResponse(String userId, String roomId);


    /**
     * ptt 回调
     */
    void addPttKeyEventCallBack(IPOCChannelInfoCallBack pttKeyEventCallBack);

    void removePttKeyEventCallBack(IPOCChannelInfoCallBack pttEventCallBack);

    void notifyPttKeyEvent(String channelId, boolean pttStatus);

    void notifyChannelNameEvent(String channelId, String channelName);

    void notifyChannelPwqEvent(String channelId, String channelPwd);

    void notifyChannelPwdModeEvent(String channelId, boolean channelPwdMode);

    void notifySubscribeTopic(ArrayList<DBGroupEntity> mDbEntity);

    /*录音*/

    void setRecordCallBack(IPOCRecordCallBack callBack);

    void removeRecordCallBack(IPOCRecordCallBack callBack);

    void notifyRecordComplete(String roomId, String mp3RecordUri);

    void notifyRecordUploadResult(String mp3RecordUri, String fileId, int errorCode);

    void notifyRecordCommitResult(String mp3RecordUri, int errorCode);

    void notifyChannelInfoInsertToDBFinished();
}

