package com.xdja.poc.sdk.proxy;

import android.app.Activity;
import android.support.v4.app.FragmentActivity;

import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.event.GroupEvent;
import com.xdja.poc.sdk.event.POCConverationTbcpStatusEvent;
import com.xdja.poc.sdk.event.POCConversationMeIncomeRoom;
import com.xdja.poc.sdk.event.POCConversationUserChangeEvent;
import com.xdja.poc.sdk.event.POCMemberEvent;
import com.xdja.poc.sdk.event.POCSelfLeaveEvent;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.db.entity.User;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * janus-gateway-android-master
 * 功能  对外提供注册回调类
 * 描述
 * created by Wwq : 2018/9/28
 */

public class POCUiKitProxyImpl implements IPOCUiKitProxy {
    private IPOCUserCacheCallBack mUserCacheCallBack;
    private IPOCMemberInfoCallBack mMemberInfoCallBack;
    private IPOCGroupRefreshCallBack mGroupRefreshCallBack;
    private String TAG = "POC_CALLBACK";
    private List<IPOCRoomEventCallBack> mRoomEventCallBackList;
    private IPOCUserClickCallBack mUserClickCallBack;
    private IPOCGroupLongClickCallBack mGroupLongClickCallBack;
    private IPOCRequestCallBack mRequestCallBack;
    private IPOCPushMessageCallBack mPushMessageCallBack;
    private IPOCRecordCallBack mRecordCallBack;
    private IChannelInfoIntoDBCallBack mChannelInfoDBCallBack;
    private List<IPOCChannelInfoCallBack> mChannelInfoCallBackList;

    public POCUiKitProxyImpl() {
        mRoomEventCallBackList = new ArrayList<>();
        mChannelInfoCallBackList = new ArrayList<>();
    }

    public static POCUiKitProxyImpl getInstance() {
        return POCUiKitProxyImpl.SingletonInstance.mInstance;
    }

    @Override
    public void setUserCacheCallBack(IPOCUserCacheCallBack callBack) {
        mUserCacheCallBack = callBack;
    }

    @Override
    public void removeUserCacheCallBack(IPOCUserCacheCallBack cacheCallBack) {
        mUserCacheCallBack = null;
    }


    @Override
    public Map<String, POCMemberInfo> getUserInfosCache() {
        if (mUserCacheCallBack != null)
            return mUserCacheCallBack.getUserInfosCache();
        else {
            LogUtils.ELog(TAG, "must register IPOCUserCacheCallBack event");
        }
        return null;
    }

    @Override
    public List<POCMemberInfo> getPOCGroupUserInfos(String[] userIdsArray) {
        if (mMemberInfoCallBack != null)
            return mMemberInfoCallBack.getPOCGroupUserInfos(userIdsArray);
        else {
            LogUtils.ELog(TAG, "must register IPOCUserInfoCallBack event");
        }
        return null;
    }

    @Override
    public User getUserInfo() {
        if (mUserCacheCallBack != null)
            return mUserCacheCallBack.getUserInfo();
        else {
            LogUtils.ELog(TAG, "initUserInfo: must register IPOCUserCacheCallBack event");
        }
        return null;
    }

    @Override
    public boolean isCanTalk() {
        if (mUserCacheCallBack != null)
            return mUserCacheCallBack.isCanTalk();
        else {
            LogUtils.ELog(TAG, "initUserInfo: must register IPOCUserCacheCallBack event");
            return true;
        }
    }

    @Override
    public void setMemberInfoCallBack(IPOCMemberInfoCallBack callBack) {
        mMemberInfoCallBack = callBack;
    }

    @Override
    public void removeMemberInfoCallBack(IPOCMemberInfoCallBack callBack) {
        mMemberInfoCallBack = null;
    }

    @Override
    public void addRoomEventCallBack(IPOCRoomEventCallBack callBack) {
        if (!mRoomEventCallBackList.contains(callBack)) {
            mRoomEventCallBackList.add(callBack);
        }
    }

    @Override
    public void removeRoomEventCallBack(IPOCRoomEventCallBack callBack) {
        if (mRoomEventCallBackList != null && mRoomEventCallBackList.contains(callBack))
            mRoomEventCallBackList.remove(callBack);

    }

    @Override
    public void notifyServerRoomCreated(GroupEvent event, boolean stataus) {
        if (mRoomEventCallBackList != null)
            for (IPOCRoomEventCallBack callBack : mRoomEventCallBackList) {
                callBack.onCreateServerRooomCallBack(event, stataus);
            }
        else {
            LogUtils.ELog(TAG, "notifyServerRoomCreated: mRoomEventCallBackList is null");
        }
    }

    @Override
    public void notifyTempRoomCreated(DBGroupEntity entity, String channelName, boolean stataus) {
        if (mRoomEventCallBackList != null)
            for (IPOCRoomEventCallBack callBack : mRoomEventCallBackList) {
                callBack.onCreateTempRooomCallBack(entity, channelName, stataus);
            }
        else {
            LogUtils.ELog(TAG, "notifyTempRoomCreated: mRoomEventCallBackList is null");
        }
    }

    @Override
    public void notifyServerRoomDeleted(GroupEvent event, boolean status) {
        if (mRoomEventCallBackList != null) {
            for (IPOCRoomEventCallBack callBack : mRoomEventCallBackList) {
                callBack.onDeleteServerRoomCallBack(event, status);
            }
        } else {
            LogUtils.ELog(TAG, "notifyServerRoomDeleted: mRoomEventCallBackList is null");
        }
    }

    @Override
    public void notifyAddMembers(GroupEvent event, boolean status) {
        if (mRoomEventCallBackList != null) {
            for (IPOCRoomEventCallBack callBack : mRoomEventCallBackList) {
                callBack.onAddMembersCallBack(event, status);
            }
        } else {
            LogUtils.ELog(TAG, "notifyAddMembers: mRoomEventCallBackList is null");
        }
    }

    @Override
    public void notifyRemoveMembers(GroupEvent event, boolean status) {
        if (mRoomEventCallBackList != null)
            for (IPOCRoomEventCallBack callBack : mRoomEventCallBackList) {
                callBack.onRemoveMembersCallBack(event, status);
            }
        else {
            LogUtils.ELog(TAG, "notifyRemoveMembers: mRoomEventCallBackList is null");
        }
    }

    @Override
    public void notifyUpdateMembers(GroupEvent groupEvent, boolean status) {
        if (mRoomEventCallBackList != null)
            for (IPOCRoomEventCallBack callBack : mRoomEventCallBackList) {
                callBack.onUpdateMembersCallBack(groupEvent, status);
            }
        else {
            LogUtils.ELog(TAG, "notifyUpdateMembers: mRoomEventCallBackList is null");
        }
    }

    @Override
    public void notifySelfLeave(POCSelfLeaveEvent selfLeaveEvent) {
        if (mRoomEventCallBackList != null)
            for (IPOCRoomEventCallBack callBack : mRoomEventCallBackList) {
                callBack.onSelfLeaveRoomCallBack(selfLeaveEvent);
            }
        else {
            LogUtils.ELog(TAG, "notifySelfLeave: mRoomEventCallBackList is null");
        }
    }

    @Override
    public void notifyTBCPEvent(POCConverationTbcpStatusEvent tbcpStatusEvent) {
        if (mRoomEventCallBackList != null)
            for (IPOCRoomEventCallBack callBack : mRoomEventCallBackList) {
                callBack.onTBCPEventCallBack(tbcpStatusEvent);
            }
        else {
            LogUtils.ELog(TAG, "notifyTBCPEvent: mRoomEventCallBackList is null");
        }
    }

    @Override
    public void notifyMeIncomeRoom(POCConversationMeIncomeRoom meIncomeRoom) {
        if (mRoomEventCallBackList != null)
            for (IPOCRoomEventCallBack callBack : mRoomEventCallBackList) {
                callBack.onMeIncomeRoomCallBack(meIncomeRoom);
            }
        else {
            LogUtils.ELog(TAG, "notifyMeIncomeRoom: mRoomEventCallBackList is null");
        }
    }

    @Override
    public void notifyMemberEvent(POCMemberEvent memberEvent) {
        if (mRoomEventCallBackList != null)
            for (IPOCRoomEventCallBack callBack : mRoomEventCallBackList) {
                callBack.onMemberEventCallBack(memberEvent);
            }
        else {
            LogUtils.ELog(TAG, "notifyMemberEvent: mRoomEventCallBackList is null");
        }
    }

    @Override
    public void notifyUserChanged(POCConversationUserChangeEvent userChangeEvent) {
        if (mRoomEventCallBackList != null)
            for (IPOCRoomEventCallBack callBack : mRoomEventCallBackList) {
                callBack.onUserChangedCallBack(userChangeEvent);
            }
        else {
            LogUtils.ELog(TAG, "notifyUserChanged: mRoomEventCallBackList is null");
        }
    }

    @Override
    public void setPOCGroupRefreshCallBack(IPOCGroupRefreshCallBack callBack) {
        this.mGroupRefreshCallBack = callBack;
    }

    @Override
    public void removePOCGroupRefreshCallBack(IPOCGroupRefreshCallBack callBack) {
        mGroupRefreshCallBack = null;
    }

    @Override
    public void notifyRefreshGroupList(int currentPage,int pageSize,int groupType) {
        if (mGroupRefreshCallBack != null) {
            mGroupRefreshCallBack.onRefreshGroupList(currentPage,pageSize,groupType);
        } else {
            LogUtils.ELog(TAG, "mGroupRefreshCallBack is null");
        }
    }

    @Override
    public void notifyRefreshChannelMembersInfo(DBGroupEntity entity) {
        if (mGroupRefreshCallBack != null) {
            mGroupRefreshCallBack.onRefreshChannelMembersInfo(entity);
        } else {
            LogUtils.ELog(TAG, "mGroupRefreshCallBack is null");
        }
    }

    @Override
    public void notifyUpdateChannelName(String channelId, String channelName) {
        if (mGroupRefreshCallBack != null) {
            mGroupRefreshCallBack.onUpdateChannelName(channelId, channelName);
        } else {
            LogUtils.ELog(TAG, "mGroupRefreshCallBack is null");
        }
    }

    @Override
    public void addUserClickCallBack(IPOCUserClickCallBack clickCallBack) {
        mUserClickCallBack = clickCallBack;
    }

    @Override
    public void removeUserClickCallBack(IPOCUserClickCallBack callBack) {
        mUserClickCallBack = null;
    }

    @Override
    public void notigyUserDetailsClick(FragmentActivity activity, POCMemberInfo account) {
        if (mUserClickCallBack != null) {
            mUserClickCallBack.onClickUserDetails(activity, account);
        } else {
            LogUtils.ELog(TAG, "must register IPOCUserCacheCallBack event");
        }
    }

    @Override
    public void notifyConversionViewMenuClick(DBGroupEntity entity, String channelName) {
        if (mUserClickCallBack != null) {
            mUserClickCallBack.onClickConversionViewMenuClick(entity, channelName);
        } else {
            LogUtils.ELog(TAG, "notifyConversionViewMenuClick: must register mUserClickCallBackList event");
        }
    }

    @Override
    public void notifyConversionAddMembers(DBGroupEntity entity) {
        if (mUserClickCallBack != null) {
            mUserClickCallBack.onClickConversionAddMembers(entity);
        } else {
            LogUtils.ELog(TAG, "notifyConversionViewMenuClick: must register mUserClickCallBackList event");
        }
    }

    @Override
    public void notifyChannelInfoResult(boolean result) {
        if (mUserClickCallBack != null) {
            mUserClickCallBack.onClickChannelInfoResult(result);
        } else {
            LogUtils.ELog(TAG, "notifyChannelInfoResult: must register mUserClickCallBackList event");
        }
    }


    @Override
    public void notifyChannelDetailsItemLongClick(Activity activity, POCMemberInfo pocMemberInfo, String ownerId) {
        if (mGroupLongClickCallBack != null) {
            mGroupLongClickCallBack.onChannelDetailsItemLongClick(activity, pocMemberInfo, ownerId);
        } else {
            LogUtils.ELog(TAG, "notifyChannelInfoResult: must register mUserClickCallBackList event");
        }
    }

    @Override
    public void setPOCGroupItemLongClickCallBack(IPOCGroupLongClickCallBack callBack) {
        mGroupLongClickCallBack = callBack;
    }

    @Override
    public void removePOCGroupItemLongClickCallBack(IPOCGroupLongClickCallBack callBack) {
        mGroupLongClickCallBack = null;
    }

    @Override
    public void notifyChannelListItemLongClick(DBGroupEntity entity, int position, String channleName) {
        if (mGroupLongClickCallBack != null)
            mGroupLongClickCallBack.onChannelListItemLongClick(entity, position, channleName);
        else
            LogUtils.ELog(TAG, "notifyItemLongClick: need register mGroupLongClickCallBack");
    }

    @Override
    public void setRequestCallBack(IPOCRequestCallBack callBack) {
        mRequestCallBack = callBack;
    }

    @Override
    public void removeRequestCallBack(IPOCRequestCallBack callBack) {
        mRequestCallBack = null;
    }

    @Override
    public void doDeleteServerRoom(String roomId) {
        if (mRequestCallBack != null)
            mRequestCallBack.onDoDeleteServerRoom(roomId);
        else {
            LogUtils.ELog(TAG, "doDeleteServerRoom: need register mRequestCallBack ");
        }
    }

    @Override
    public void doRemoveMembersFromRoom(String roomId, String members) {
        if (mRequestCallBack != null)
            mRequestCallBack.onDoRemoveMembersFromRoom(roomId, members);
        else {
            LogUtils.ELog(TAG, "doDeleteServerRoom: need register mRequestCallBack ");
        }
    }

    @Override
    public void setPushMessageCallBack(IPOCPushMessageCallBack callBack) {
        mPushMessageCallBack = callBack;
    }

    @Override
    public void removePushMessageCallBack(IPOCPushMessageCallBack callBack) {
        mPushMessageCallBack = null;
    }

    @Override
    public void notifyUserAccepet(String senderUserId, String roomId,String channelName) {
        if (mPushMessageCallBack != null) {
            mPushMessageCallBack.onUserAccept(senderUserId, roomId,channelName);
        } else {
            LogUtils.ELog(TAG, "notifyUserAccepet: need register IPOCPushMessageCallBack");
        }
    }

    @Override
    public void notifyUserReject(String senderUserId, String roomId) {
        if (mPushMessageCallBack != null) {
            mPushMessageCallBack.onUserReject(senderUserId, roomId);
        } else {
            LogUtils.ELog(TAG, "notifyUserReject: need register IPOCPushMessageCallBack");
        }
    }

    @Override
    public void notifyUserNoResponse(String senderUserId, String roomId) {
        if (mPushMessageCallBack != null) {
            mPushMessageCallBack.onUserNoResponse(senderUserId, roomId);
        } else {
            LogUtils.ELog(TAG, "notifyUserNoResponse: need register IPOCPushMessageCallBack");
        }
    }

    @Override
    public void addPttKeyEventCallBack(IPOCChannelInfoCallBack channelInfoCallBack) {
        if (!mChannelInfoCallBackList.contains(channelInfoCallBack)) {
            mChannelInfoCallBackList.add(channelInfoCallBack);
        }
    }

    @Override
    public void removePttKeyEventCallBack(IPOCChannelInfoCallBack channelInfoCallBack) {
        mChannelInfoCallBackList.remove(channelInfoCallBack);
    }

    @Override
    public void notifyPttKeyEvent(String channelId, boolean pttStatus) {
        for (IPOCChannelInfoCallBack callBack : mChannelInfoCallBackList) {
            if (callBack != null)
                callBack.onPttKeyEvent(channelId, pttStatus);
            else
                LogUtils.ELog(TAG, "notifyPttKeyEvent:　need register mPttEventCallBack");

        }
    }

    @Override
    public void notifyChannelNameEvent(String channelId, String channelName) {
        for (IPOCChannelInfoCallBack callBack : mChannelInfoCallBackList) {
            if (callBack != null)
                callBack.onChannelNameEvent(channelId, channelName);
            else
                LogUtils.ELog(TAG, "notifyPttKeyEvent:　need register mPttEventCallBack");
        }
    }

    @Override
    public void notifyChannelPwqEvent(String channelId, String channelPwd) {
        for (IPOCChannelInfoCallBack callBack : mChannelInfoCallBackList) {
            if (callBack != null)
                callBack.onChannelPwdEvent(channelId, channelPwd);
            else
                LogUtils.ELog(TAG, "notifyPttKeyEvent:　need register mPttEventCallBack");
        }
    }

    @Override
    public void notifyChannelPwdModeEvent(String channelId, boolean channelPwdMode) {
        for (IPOCChannelInfoCallBack callBack : mChannelInfoCallBackList) {
            if (callBack != null)
                callBack.onChannelPwdModeEvent(channelId, channelPwdMode);
            else
                LogUtils.ELog(TAG, "notifyPttKeyEvent:　need register mPttEventCallBack");

        }
    }

    @Override
    public void notifySubscribeTopic(ArrayList<DBGroupEntity> mDbEntity) {
        if(mPushMessageCallBack!=null)
            mPushMessageCallBack.onSubscribeTopic(mDbEntity);
        else
            LogUtils.ELog(TAG, "notifySubscribeTopic:　need register IPOCPushMessageCallBack");
    }

    @Override
    public void setRecordCallBack(IPOCRecordCallBack callBack) {
        mRecordCallBack = callBack;
    }

    @Override
    public void removeRecordCallBack(IPOCRecordCallBack callBack) {
        mRecordCallBack = null;
    }

    @Override
    public void notifyRecordComplete(String roomId, String mp3RecordUri) {
        LogUtils.ELog(TAG,"notifyRecordComplete "+mRecordCallBack);
        if (mRecordCallBack != null) {
            mRecordCallBack.onRecordCompleted(roomId, mp3RecordUri);
        }
    }

    @Override
    public void notifyRecordUploadResult(String mp3RecordUri, String fileId, int errorCode) {
        if (mRecordCallBack != null) {
            mRecordCallBack.onRecordUploadResult(mp3RecordUri, fileId, errorCode);
        }
    }

    @Override
    public void notifyRecordCommitResult(String mp3RecordUri, int errorCode) {
        if (mRecordCallBack != null) {
            mRecordCallBack.onRecordCommitResult(mp3RecordUri,errorCode);
        }
    }
    public void setmChannelInfoDBCallBack(IChannelInfoIntoDBCallBack mChannelInfoDBCallBack) {
        this.mChannelInfoDBCallBack = mChannelInfoDBCallBack;
    }

    @Override
    public void notifyChannelInfoInsertToDBFinished() {
        if(mChannelInfoDBCallBack!=null){
            mChannelInfoDBCallBack.onChnnelInfoIntoDB();
        }
    }

    private static class SingletonInstance {
        private static final POCUiKitProxyImpl mInstance = new POCUiKitProxyImpl();

        private SingletonInstance() {

        }
    }

}
