package com.xdja.poc.sdk.record.play;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.media.AudioManager;
import android.os.Bundle;
import android.telephony.TelephonyManager;
import android.view.ViewTreeObserver;

import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.sdk.business.ringplay.RingPlayer;
import com.xdja.poc.sdk.ui.history.HistoryVoicePlayer;


/**
 * @Package: com.xdja.im.uikit.action.media
 * @Author: xdjaxa
 * @Creation: 2017-09-15 13:56
 * @Version V1.0
 * @Description:
 */
public class ReceiverModeManger implements SensorEventListener, Application.ActivityLifecycleCallbacks {
    private String TAG = "ReceiverModeManger";
    private Activity mActivity;
    private float voiceMode = DEFAULT_MODE_CODE;
    /**
     * 语音播放模式初始默认值
     */
    private static final int DEFAULT_MODE_CODE = -1;
    /*
     * 传感器管理类
     */
    private SensorManager mSensorManager;
    private Sensor mSensor;
    private IPlayState iPlayState;

    public void init(Activity activity, IPlayState playState) {
        mActivity = activity;
        this.iPlayState = playState;
        //听筒模式初始化
        mSensorManager = (SensorManager) activity.getSystemService(Context.SENSOR_SERVICE);
        mSensor = mSensorManager.getDefaultSensor(Sensor.TYPE_PROXIMITY);

        //添加Activity生命周期监听处理
        mActivity.getApplication().registerActivityLifecycleCallbacks(this);

        initAudioMode(mActivity);
    }

    @SuppressLint("NewApi")
    public void initAudioMode(Activity activity) {
        mActivity = activity;
    }

    /**
     * 注册sensor监听器
     */
    private void registerSensor() {
        mSensorManager.registerListener(this, mSensor, SensorManager.SENSOR_DELAY_NORMAL);
    }

    /**
     * 反注册sensor监听器
     */
    private void unRegisterSensor() {
        mSensorManager.unregisterListener(this);
    }

    /**
     * 注册线控耳机插拔广播
     */
    private void registerHeadset() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(Intent.ACTION_HEADSET_PLUG);
        intentFilter.addAction(AudioManager.ACTION_AUDIO_BECOMING_NOISY);
        intentFilter.addAction("android.intent.action.PHONE_STATE");
        intentFilter.addAction(BluetoothHeadset.ACTION_CONNECTION_STATE_CHANGED);
        intentFilter.addAction(BluetoothAdapter.ACTION_STATE_CHANGED);
        mActivity.registerReceiver(headsetPlugReceiver, intentFilter);
    }

    /**
     * 反注册线控耳机插拔广播
     */
    private void unRegisterHeadset() {
        try {
            mActivity.unregisterReceiver(headsetPlugReceiver);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean assetActivity(Activity activity) {
        return mActivity.getClass().getName().equals(activity.getClass().getName());
    }

    @Override
    public void onSensorChanged(SensorEvent event) {

        //耳机模式下，直接返回
//        if (MediaManger.getInstance().getCurrentMode() == MediaManger.MODE_HEADSET) {
//            return;
//        }
//
//        if (!AudioPlayerManager.getInstance().isPlaying()) {
//            return;
//        }
//
//        if (event.values[0] >= mSensor.getMaximumRange()) { //正常模式
//            showReceiverTipsView();
//            MediaManger.getInstance().changeToSpeakerMode();
//            MediaManger.getInstance().wakeLockBrightRelease();
//            AudioPlayerManager.getInstance().startToRePlay();
//        } else {                                            //听筒模式
//            MediaManger.getInstance().setAudioMode();
//            MediaManger.getInstance().changeToEarpieceMode();
//            MediaManger.getInstance().wakeLockBrightAcquire();
//            AudioPlayerManager.getInstance().startToRePlay();
//        }
        if (voiceMode == event.values[0] && HistoryVoicePlayer.getInstance().isPlaying()) {
            return;
        }
        //情景二：如果在听筒模式时，插上耳机，然后放开听筒，应该切换正常模式，耳机起作用
        if (MediaManger.getInstance().isHeadsetOn()) {

            if (event.values[0] >= mSensor.getMaximumRange()) {//正常模式
                MediaManger.getInstance().setReceiverMode(false);
                MediaManger.getInstance().onSensorChanged(false);
            }
            MediaManger.getInstance().wakeLockBrightRelease();
            return;
        }

        //情景：正在播放过程中
        if (HistoryVoicePlayer.getInstance().isPlaying()) {
            if (event.values[0] >= mSensor.getMaximumRange()) {//正常模式
                MediaManger.getInstance().wakeLockBrightRelease();
            } else {                                           //听筒模式
                MediaManger.getInstance().wakeLockBrightAcquire();
            }
        } else {
            MediaManger.getInstance().wakeLockBrightRelease();
        }

        voiceMode = event.values[0];
        //情景四：听筒和正常模式之间切换
        if (event.values[0] >= mSensor.getMaximumRange()) { //正常模式
            MediaManger.getInstance().setReceiverMode(false);
            MediaManger.getInstance().onSensorChanged(false);
            LogUtils.DLog(TAG, "onSensorChanged 111111");
//            HistoryVoicePlayer.getInstance().startToRePlay();
        } else {                                            //听筒模式
            MediaManger.getInstance().setReceiverMode(true);
            MediaManger.getInstance().onSensorChanged(true);
            LogUtils.DLog(TAG, "onSensorChanged 22222");
//            HistoryVoicePlayer.getInstance().startToRePlay();
        }
    }

    @Override
    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    @Override
    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    @Override
    public void onActivityStarted(Activity activity) {
    }

    @Override
    public void onActivityResumed(Activity activity) {
        if (assetActivity(activity)) {
            registerSensor();
            registerHeadset();
        }
    }

    @Override
    public void onActivityPaused(Activity activity) {
        if (assetActivity(activity)) {
            unRegisterSensor();
            unRegisterHeadset();
            if (iPlayState != null) {
                iPlayState.stop();
            }
        }
    }

    @Override
    public void onActivityStopped(Activity activity) {
    }

    @Override
    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    @Override
    public void onActivityDestroyed(Activity activity) {
        if (assetActivity(activity)) {

            MediaManger.getInstance().releaseWakeLock();
            mActivity.getApplication().unregisterActivityLifecycleCallbacks(this);
        }
    }

    private BroadcastReceiver headsetPlugReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();

            if (Intent.ACTION_HEADSET_PLUG.equals(action)) {
                int state = intent.getIntExtra("state", 0);
                if (state == 1) {
                    LogUtils.DLog(TAG, "WZ Current HeadSet State : On");
                    MediaManger.getInstance().setHeadsetOn(true);
                    MediaManger.getInstance().setReceiverModeOn();
                } else if (state == 0) {
                    LogUtils.DLog(TAG, "WZ Current HeadSet State : Off");

                    MediaManger.getInstance().setHeadsetOn(false);
                    MediaManger.getInstance().setReceiverModeOff();
                }
            } else if (action.equals("android.intent.action.PHONE_STATE")) {
                String state = intent.getStringExtra(TelephonyManager.EXTRA_STATE);
                if (StringUtils.isEmpty(state)) {
                    return;
                }
                //来电时停止播放
                if (state.equals("RINGING")) {
                    if (iPlayState != null) {
                        iPlayState.stop();
                    }
                }
            } else if (BluetoothAdapter.ACTION_STATE_CHANGED.equals(action) ||
                    BluetoothHeadset.ACTION_CONNECTION_STATE_CHANGED.equals(action)) {
                BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
                int bluetoothState = adapter.getProfileConnectionState(BluetoothProfile.HEADSET);
                if (bluetoothState == BluetoothProfile.STATE_DISCONNECTED) {
                    LogUtils.DLog(TAG, " Current blueteeth State : Off");
                    MediaManger.getInstance().setReceiverModeOff();
                    MediaManger.getInstance().setHeadsetOn(false);
                } else {
                    LogUtils.DLog(TAG, " Current blueteeth State : On");
                    MediaManger.getInstance().setReceiverModeOn();
                    MediaManger.getInstance().setHeadsetOn(true);
                }

            }
        }
    };
}
