package com.xdja.poc.sdk.ui.history;

/**
 * Created by xdjaxa on 2019/1/10.
 */

import android.content.Context;
import android.content.Intent;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.text.TextUtils;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.jude.easyrecyclerview.EasyRecyclerView;
import com.jude.easyrecyclerview.adapter.RecyclerArrayAdapter;
import com.xdja.poc.common.annotation.TitleViewAnnotation;
import com.xdja.poc.common.base.BaseActivity;
import com.xdja.poc.common.utils.NetUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ToastUtils;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.sdk.greendao.HistoryMessageDBHelper;
import com.xdja.poc.sdk.record.play.IPlayState;
import com.xdja.poc.sdk.record.play.ReceiverModeManger;
import com.xdja.poc.sdk.ui.main.mvp.POCHistoryMessageContract;
import com.xdja.poc.sdk.ui.main.mvp.POCHistoryMessagePresenter;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/**
 * poc-历史消息
 * Created by xdjaxa on 2019/1/4.
 */

@TitleViewAnnotation
public class POCHistoryMessageActivity extends BaseActivity implements POCHistoryMessageContract.IView {

    private EasyRecyclerView mRecyclerView;
    private POCHistoryMessageAdapter mAdapter;
    private POCHistoryMessagePresenter pocHistoryMessagePresenter;

    private static final String ROOM_ID = "roomId";
    private String roomId;

    private int pageSize = 15;
    private int currentPage = 1;
    private long syncTime = 0;
    private LinearLayoutManager lm;
    private View moreView;
    private View errorView;

    private TextView tvError;
    private ProgressBar errorProgress;
    private boolean isLoading = false;
    private String currentLoadOrder;

    public static void startPOCHistoryMessageActivity(Context context, String roomId) {
        if (!PreferenceHelper.getBoolean(UserConfig.POC_IS_SAVE_RECORD, true)) {
            ToastUtils.showToast("暂不支持历史语音查看");
            return;
        }
        Intent target = new Intent(context, POCHistoryMessageActivity.class);
        target.putExtra(ROOM_ID, roomId);
        context.startActivity(target);
    }

    @Override
    protected int generateLayout() {
        return R.layout.poc_activity_history_message;
    }

    protected int getTranslucentStatusBarColor() {
        return getResources().getColor(R.color.common_main_color);
    }

    @Override
    protected void initView() {
        roomId = getIntent().getStringExtra(ROOM_ID);
        if (StringUtils.isEmpty(roomId)) {
            finish();
            return;
        }

        initTitleBar();

        mRecyclerView = findViewById(R.id.rv_history_message);
        lm = new LinearLayoutManager(this);
        mRecyclerView.setLayoutManager(lm);
        mRecyclerView.getSwipeToRefresh().setColorSchemeResources(R.color.common_main_color);
        mAdapter = new POCHistoryMessageAdapter(this, this);
        moreView = View.inflate(this, R.layout.poc_history_message_view_more, null);
        errorView = View.inflate(this, R.layout.poc_view_history_message_loadmore_error, null);
        tvError = errorView.findViewById(R.id.tv_error);
        errorProgress = errorView.findViewById(R.id.erro_progress);
        pocHistoryMessagePresenter = new POCHistoryMessagePresenter(this);
        new ReceiverModeManger().init(this, new IPlayState() {
            @Override
            public void start() {

            }

            @Override
            public void stop() {
                HistoryVoicePlayer.getInstance().releasePlay();
                HistoryVoicePlayer.getInstance().resetMessage();
                mAdapter.notifyDataSetChanged();
            }
        });
    }

    private void initTitleBar() {
        getTitleBarView().setTile("历史消息");
        getTitleBarView().setBackgroundRecource(R.color.common_main_color);
        getTitleBarView().setLeftViewRecource(R.mipmap.common_back_n);
        getTitleBarView().setTitleColor(getResources().getColor(R.color.common_white_color));
        getTitleBarView().setTextSize(18);
        getTitleBarView().setLeftViewClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
    }

    @Override
    protected void initEvent() {
        mRecyclerView.setRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
            @Override
            public void onRefresh() {
                syncTime = 0;
                if (mAdapter.getCount() > 0) {
                    POCHistoryMessage firstMessage = mAdapter.getAllData().get(0);
                    if (firstMessage != null) {
                        syncTime = Long.valueOf(firstMessage.syncTime);
                    }
                }
                loadData("up", syncTime);
            }
        });
//        mAdapter.setNoMore();
        mAdapter.setMore(moreView, new RecyclerArrayAdapter.OnLoadMoreListener() {
            @Override
            public void onLoadMore() {
                loadMore();
            }

//            @Override
//            public void onMoreClick() {
//                loadMore();
//            }
        });
        mAdapter.setError(errorView, new RecyclerArrayAdapter.OnErrorListener() {
            @Override
            public void onErrorShow() {
            }

            @Override
            public void onErrorClick() {
                if (!NetUtils.isNetworkAvailable(POCHistoryMessageActivity.this)) {
                    ToastUtils.showToast(getResources().getString(R.string.common_net_failed));
                    return;
                }
                mAdapter.resumeMore();
            }
        });

        mRecyclerView.getErrorView().findViewById(R.id.reload_btn).setOnClickListener(v -> {
            mRecyclerView.showProgress();
            syncTime = 0;
//            pocHistoryMessagePresenter.loadFirstMessage(roomId, pageSize, syncTime);
            loadData("down", 0);
        });

        mRecyclerView.setAdapter(mAdapter);
        mRecyclerView.getSwipeToRefresh().setEnabled(true);

        mRecyclerView.showProgress();
//        if (HistoryMessageDBHelper.getInstance().count(roomId) > 0) {
//            pocHistoryMessagePresenter.loadLocalMessage(roomId, pageSize, syncTime);
//        } else {
//            loadData("down", 0);
//        }
        // TODO: 2019/4/11 修改为每次从 服务器获取数据，这样保证每次进来看到的是最新的数据
        loadData("down", 0);
    }

    /**
     * 加载数据
     *
     * @param order
     * @param syncTime
     */
    private void loadData(String order, long syncTime) {
        if (isLoading && !TextUtils.isEmpty(currentLoadOrder) && currentLoadOrder.equals(order)) {
            return;
        }
        isLoading = true;
        currentLoadOrder = order;
        pocHistoryMessagePresenter.syncHistoryMessage(order, pageSize, roomId, syncTime);
    }

    private void loadMore() {
        if (mAdapter == null) return;
        List<POCHistoryMessage> temp = mAdapter.getAllData();
        if (temp != null && temp.size() > 0) {
            POCHistoryMessage lastMessage = temp.get(temp.size() - 1);
            if (lastMessage != null) {
                syncTime = Long.valueOf(lastMessage.getSyncTime());
                loadData("down", syncTime);
            }
        }
    }

    /**
     * @param historyMessages
     * @param totalRecord     -1：代表数据为缓存数据 other：数据总数
     */
    @Override
    public void loadMessageSuccess(List<POCHistoryMessage> historyMessages, int totalRecord, boolean isHasServerData, boolean isToBottom) {
        mRecyclerView.setRefreshing(false);
        isLoading = false;
        if (!isHasServerData) {
            if (currentPage != -1) {
                currentPage++;
            }
            if (mAdapter.getCount() == 0 && mAdapter.getCount() == 0) {
                mRecyclerView.showEmpty();
            }
            if (totalRecord != -1) {
                mAdapter.pauseMore();
            }
            errorProgress.setVisibility(View.GONE);
            tvError.setText("已加载全部");
            return;
        }
        //加载本地
        if (totalRecord == -1) {
            if (mAdapter.getCount() == 0 && historyMessages.size() > 0) {
                mAdapter.insertAll(historyMessages, 0);
                mAdapter.pauseMore();
                mRecyclerView.scrollToPosition(mAdapter.getCount());
                syncTime = Long.valueOf(historyMessages.get(historyMessages.size() - 1).getSyncTime());
//                pocHistoryMessagePresenter.loadMoreHistoryMessage(roomId, pageSize, syncTime);
                loadData("down", syncTime);
                return;
            }
            mAdapter.insertAll(historyMessages, 0);
            mRecyclerView.scrollToPosition(mAdapter.getCount());
            return;
        }
        //加载网络数据
//        mAdapter.clear();
        List<POCHistoryMessage> allData = mAdapter.getAllData();
        allData.addAll(historyMessages);
        Collections.sort(allData, new Comparator<POCHistoryMessage>() {
            @Override
            public int compare(POCHistoryMessage o1, POCHistoryMessage o2) {
                return o1.getSyncTime().compareTo(o2.getSyncTime());
            }
        });
        mAdapter.clear();
        mAdapter.addAll(allData);
//        mAdapter.pauseMore();
        if (isToBottom)
            mRecyclerView.scrollToPosition(mAdapter.getCount());
//        syncTime = Long.valueOf(historyMessages.get(historyMessages.size() - 1).getSyncTime());
//        pocHistoryMessagePresenter.syncHistoryMessage("down", pageSize, roomId, syncTime);
    }

    @Override
    public void loadMessageFailed() {
        isLoading = false;
        mRecyclerView.setRefreshing(false);
        if (mAdapter.getCount() == 0) {
            mRecyclerView.showError();
            mAdapter.pauseMore();
            return;
        }
        ToastUtils.showToast(getResources().getString(R.string.common_net_failed));
        mAdapter.pauseMore();
        errorProgress.setVisibility(View.GONE);
        tvError.setText("加载失败，点击重试");
    }

    @Override
    public boolean isExist() {
        return !isFinishing();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (mAdapter != null) {
            mAdapter.stopAnim();
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
    }
}
