package com.xdja.poc.sdk.ui.history;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.jude.easyrecyclerview.adapter.BaseViewHolder;
import com.jude.easyrecyclerview.adapter.RecyclerArrayAdapter;
import com.xdja.poc.common.utils.DisplayUtil;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ToastUtils;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.sdk.db.entity.User;
import com.xdja.poc.sdk.proxy.POCUiKitProxyImpl;
import com.xdja.poc.sdk.utils.GlideUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

/**
 * 历史消息适配器
 * Created by xdjaxa on 2019/1/4.
 */

public class POCHistoryMessageAdapter extends RecyclerArrayAdapter<POCHistoryMessage> {

    private AnimationDrawable drawAnim; //语音播放动画处理
    private Map<String, POCMemberInfo> mCacheUserinfoMap = null; //群组成员信息
    private User mCacheUserinfo = null; //我的信息
    private String upMessageTime; //上一条消息时间，用于判断是否显示消息时间
    private static final int MAX_MESSAGE_TIME_INTERVAL = 2 * 60 * 1000; //消息时间间隔
    private int upSelectIndex = -1; //上一播放音频index
    private AppCompatActivity appCompatActivity;
    private int currentPlayPosition = -1;

    public POCHistoryMessageAdapter(AppCompatActivity activity, Context context) {
        super(context);
        this.appCompatActivity = activity;
        mCacheUserinfoMap = POCUiKitProxyImpl.getInstance().getUserInfosCache();
        mCacheUserinfo = POCUiKitProxyImpl.getInstance().getUserInfo();
    }

    @Override
    public BaseViewHolder OnCreateViewHolder(ViewGroup parent, int viewType) {
        return new MessageViewHolder(parent);
    }

    @Override
    public void OnBindViewHolder(BaseViewHolder holder, int position) {
        //super，调用ViewHolder的setData方法绑定数据
        super.OnBindViewHolder(holder, position);
        if (holder instanceof MessageViewHolder) {
            //我的消息语音播放
            ((MessageViewHolder) holder).mMineVoiceLayout.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    POCHistoryMessageAdapter.this.restoreVoice(position);
                    POCHistoryMessage pocHistoryMessage = HistoryVoicePlayer.getInstance().getMessage();
                    if (pocHistoryMessage != null) {
                        if (pocHistoryMessage.getFileUrl().equals(POCHistoryMessageAdapter.this.getAllData().get(position).getFileUrl())) {
                            POCHistoryMessageAdapter.this.stopMineAnim((MessageViewHolder) holder, position);
                            return;
                        }
                    }
                    POCHistoryMessageAdapter.this.stopAllAnim();
                    HistoryVoicePlayer.getInstance().startPlay(POCHistoryMessageAdapter.this.getAllData().get(position), new HistoryVoicePlayer.PlayVoiceCallBack() {
                        @Override
                        public void onPlayFailed() {
                            ToastUtils.showToast("播放失败");
                            stopAnim();
                        }

                        @Override
                        public void onPlayStart() {
                            currentPlayPosition = position;
                            ((MessageViewHolder) holder).mMineVoice.setBackground(getContext().getDrawable(R.drawable.poc_anim_history_record_voice_white));
                            drawAnim = (AnimationDrawable) ((MessageViewHolder) holder).mMineVoice.getBackground();
                            drawAnim.start();
                        }

                        @Override
                        public void onPlayStop() {
                            stopMineAnim((MessageViewHolder) holder, position);
                        }
                    });
                }
            });
            //其他人消息语音播放
            ((MessageViewHolder) holder).mOtherVoiceLayout.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    POCHistoryMessageAdapter.this.restoreVoice(position);
                    POCHistoryMessage pocHistoryMessage = HistoryVoicePlayer.getInstance().getMessage();
                    if (pocHistoryMessage != null) {
                        if (pocHistoryMessage.getFileUrl().equals(POCHistoryMessageAdapter.this.getAllData().get(position).getFileUrl())) {
                            POCHistoryMessageAdapter.this.stopOtherAnim((MessageViewHolder) holder, position);
                            return;
                        }
                    }
                    POCHistoryMessageAdapter.this.stopAllAnim();
                    HistoryVoicePlayer.getInstance().startPlay(POCHistoryMessageAdapter.this.getAllData().get(position), new HistoryVoicePlayer.PlayVoiceCallBack() {
                        @Override
                        public void onPlayFailed() {
                            stopOtherAnim((MessageViewHolder) holder, position);
                            ToastUtils.showToast("播放失败");
                            ((MessageViewHolder) holder).mOtherVoice.setBackground(getContext().getDrawable(R.drawable.poc_history_record_voice_blue_3));
                        }

                        @Override
                        public void onPlayStart() {
                            currentPlayPosition = position;
                            ((MessageViewHolder) holder).mOtherVoice.setBackground(getContext().getDrawable(R.drawable.poc_anim_history_record_voice_blue));
                            drawAnim = (AnimationDrawable) ((MessageViewHolder) holder).mOtherVoice.getBackground();
                            drawAnim.start();
                        }

                        @Override
                        public void onPlayStop() {
                            stopOtherAnim((MessageViewHolder) holder, position);
                        }
                    });
                }
            });
        }
    }

    private void stopAllAnim() {
        HistoryVoicePlayer.getInstance().releasePlay();
        HistoryVoicePlayer.getInstance().resetMessage();
        notifyDataSetChanged();
    }

    private void stopMineAnim(MessageViewHolder holder, int position) {
        stopAnim();
        holder.mMineVoice.setBackground(getContext().getDrawable(R.drawable.poc_history_record_voice_white_3));
        HistoryVoicePlayer.getInstance().releasePlay();
        HistoryVoicePlayer.getInstance().resetMessage();
        notifyItemChanged(position);
    }

    private void stopOtherAnim(MessageViewHolder holder, int position) {
        stopAnim();
        holder.mOtherVoice.setBackground(getContext().getDrawable(R.drawable.poc_history_record_voice_blue_3));
        HistoryVoicePlayer.getInstance().releasePlay();
        HistoryVoicePlayer.getInstance().resetMessage();
        notifyItemChanged(position);
    }


    /**
     * 前一音频正在播，再次点击音频重置上一音频状态
     *
     * @param position
     */
    private void restoreVoice(int position) {
        if (!HistoryVoicePlayer.getInstance().isDownloading()) {
            stopAnim();
            if (position != upSelectIndex) {
                notifyItemChanged(upSelectIndex - 1);
            }
            upSelectIndex = position;
        }
    }

    /**
     * 用于停止正在播放的音频并返回文件数据
     *
     * @return
     */
    private POCHistoryMessage stopOtherPlay() {
        if (HistoryVoicePlayer.getInstance().isPlaying()) {
            stopAnim();
            return HistoryVoicePlayer.getInstance().getMessage();
        }
        return null;
    }

    public class MessageViewHolder extends BaseViewHolder<POCHistoryMessage> {

        ImageView mMineIcon, mOtherIcon;
        TextView mMineTime, mOtherTime;
        TextView mMineName, mOtherName;
        RelativeLayout mMineLayout, mOtherLayout;
        TextView mNotSupportLayout, mTime;
        RelativeLayout mMineVoiceLayout, mOtherVoiceLayout;
        ImageView mMineVoice, mOtherVoice;

        public MessageViewHolder(ViewGroup group) {
            super(group, R.layout.poc_item_history_message);
            mMineIcon = $(R.id.iv_mine_message_icon);
            mMineLayout = $(R.id.rl_mine);
            mMineTime = $(R.id.tv_mine_message_time);
            mMineName = $(R.id.tv_mine_name);
            mMineVoiceLayout = $(R.id.rl_mine_voice_bg);
            mMineVoice = $(R.id.iv_mine_voice);

            mOtherIcon = $(R.id.iv_other_message_icon);
            mOtherLayout = $(R.id.rl_other);
            mOtherTime = $(R.id.tv_other_message_time);
            mOtherName = $(R.id.tv_other_name);
            mOtherVoiceLayout = $(R.id.rl_other_voice_bg);
            mOtherVoice = $(R.id.iv_other_voice);

            mNotSupportLayout = $(R.id.tv_not_support);
            mTime = $(R.id.iv_interval_time);

        }

        @Override
        public void setData(POCHistoryMessage message) {

            upMessageTime = getItem(getDataPosition() > 0 ? getDataPosition() - 1 : getDataPosition()).getCreateTime();
            //获取登录帐号、消息帐号
            String userAccount = mCacheUserinfo != null ? mCacheUserinfo.getAccount() : "";
            String messageAccount = message.owner;
            //帐号为空，非法消息
            if (StringUtils.isEmpty(messageAccount) || StringUtils.isEmpty(userAccount)) {
                mNotSupportLayout.setVisibility(View.VISIBLE);
                mOtherLayout.setVisibility(View.GONE);
                mMineLayout.setVisibility(View.GONE);
                return;
            }
            //消息时间
            mTime.setText(formatTime(message.createTime));
            mTime.setVisibility(computeMessageTimeInterval(message.createTime) || getDataPosition() == 0 ? View.VISIBLE : View.GONE);
            //我的消息
            if (userAccount.equals(messageAccount)) {
                mOtherLayout.setVisibility(View.GONE);
                mNotSupportLayout.setVisibility(View.GONE);
                mMineLayout.setVisibility(View.VISIBLE);
                POCMemberInfo transation = transation(messageAccount);
                mMineName.setText(transation == null ? messageAccount : transation.getName());
                POCHistoryMessage message1 = HistoryVoicePlayer.getInstance().getMessage();
                if (message1 == null || !message1.getFileUrl().equals(message.getFileUrl())) {
                    mMineVoice.setBackground(getContext().getDrawable(R.drawable.poc_history_record_voice_white_3));
                } else {
                    if(drawAnim!=null&&drawAnim.isRunning())drawAnim.stop();
                    mMineVoice.setBackground(getContext().getDrawable(R.drawable.poc_anim_history_record_voice_white));
                    drawAnim = (AnimationDrawable) mMineVoice.getBackground();
                    drawAnim.start();
                }
                int voiceTime = computeVoiceTime(message);
                mMineTime.setText(String.format(getContext().getString(R.string.poc_history_record_format_time), (voiceTime > 60 ? 60 : voiceTime) + ""));

                RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) mMineVoiceLayout.getLayoutParams();
                params.width = computeLayoutWidth(voiceTime);
                mMineVoiceLayout.setLayoutParams(params);

                GlideUtils.setImageUseNetWithCircle(getContext(), transation == null ? "" : transation.getIcon(), mMineIcon);
                mMineIcon.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        POCMemberInfo memberInfo = new POCMemberInfo();
                        memberInfo.setAccount(PreferenceHelper.getString(UserConfig.LOGIN_ACCOUNT, ""));
                        memberInfo.setIcon(transation == null ? "" : transation.getIcon());
                        memberInfo.setName(PreferenceHelper.getString(UserConfig.USER_INFO_NAME, ""));
                        POCUiKitProxyImpl.getInstance().notigyUserDetailsClick(appCompatActivity, memberInfo);

                    }
                });
                return;
            }
            //其他人消息
            mMineLayout.setVisibility(View.GONE);
            mNotSupportLayout.setVisibility(View.GONE);
            mOtherLayout.setVisibility(View.VISIBLE);
            POCMemberInfo transation = transation(messageAccount);
            mOtherName.setText(transation == null ? messageAccount : transation.getName());

            int voiceTime = computeVoiceTime(message);
            mOtherTime.setText(String.format(getContext().getString(R.string.poc_history_record_format_time), (voiceTime > 60 ? 60 : voiceTime) + ""));
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) mOtherVoiceLayout.getLayoutParams();
            params.width = computeLayoutWidth(voiceTime);
            mOtherVoiceLayout.setLayoutParams(params);

            GlideUtils.setImageUseNetWithCircle(getContext(), transation == null ? "" : transation.getIcon(), mOtherIcon);
            mOtherIcon.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    POCMemberInfo memberInfo = new POCMemberInfo();
                    memberInfo.setAccount(messageAccount);
                    memberInfo.setIcon(transation == null ? "" : transation.getIcon());
                    memberInfo.setName(transation == null ? messageAccount : transation.getName());
                    POCUiKitProxyImpl.getInstance().notigyUserDetailsClick(appCompatActivity, memberInfo);
                }
            });
            POCHistoryMessage message1 = HistoryVoicePlayer.getInstance().getMessage();
            if (message1 == null || !message1.getFileUrl().equals(message.getFileUrl())) {
                mOtherVoice.setBackground(getContext().getDrawable(R.drawable.poc_history_record_voice_blue_3));
            } else {
                if(drawAnim!=null&&drawAnim.isRunning())drawAnim.stop();
                mOtherVoice.setBackground(getContext().getDrawable(R.drawable.poc_anim_history_record_voice_blue));
                drawAnim = (AnimationDrawable) mOtherVoice.getBackground();
                drawAnim.start();
                LogUtils.DLog("wwq"," start anim ");
            }
        }

    }

    /**
     * 计算voice时长
     *
     * @param message
     * @return
     */
    private int computeVoiceTime(POCHistoryMessage message) {
        return Integer.valueOf(message.getFileSize()) / 1000 + 1;
    }

    /**
     * 计算录音布局长度
     *
     * @param voiceTime
     * @return
     */
    private int computeLayoutWidth(int voiceTime) {
        if (voiceTime > 60)
            voiceTime = 60;
        if (voiceTime == 0)
            voiceTime = 1;
        int maxItemWidth = (int) (DisplayUtil.getScreenWidth(getContext()) * 0.4f);
        return (int) (DisplayUtil.dip2px(getContext(), 64) + (maxItemWidth / 60f * voiceTime));
    }

    /**
     * 计算与上一条消息时间间隔
     *
     * @param currMsgTime
     * @return
     */
    private boolean computeMessageTimeInterval(String currMsgTime) {
        SimpleDateFormat sourceFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
        try {
            Date currMsgDate = sourceFormat.parse(currMsgTime);
            Date upMsgDate = sourceFormat.parse(upMessageTime);
            if (currMsgDate.getTime() - upMsgDate.getTime() > MAX_MESSAGE_TIME_INTERVAL) {
                return true;
            }
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return false;
    }

    /**
     * 获取消息人员信息
     *
     * @param messageAccount
     * @return
     */
    private POCMemberInfo transation(String messageAccount) {
        if (mCacheUserinfoMap == null) {
            return null;
        }
        return mCacheUserinfoMap.get(messageAccount);
    }

    /**
     * 格式化消息时间
     *
     * @param sourceTime
     * @return
     */
    private String formatTime(String sourceTime) {
        SimpleDateFormat sourceFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
        SimpleDateFormat destFormat = new SimpleDateFormat("HH:mm", Locale.CHINA);
        try {
            Date date = sourceFormat.parse(sourceTime);
            return getAppendTime(date) + destFormat.format(date);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return sourceTime;
    }


    /**
     * 获取消息附加时间信息
     *
     * @param messageDate
     * @return
     * @throws ParseException
     */
    private String getAppendTime(Date messageDate) throws ParseException {

        SimpleDateFormat msgDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.CHINA);
        String msgDateStr = msgDateFormat.format(messageDate);
        Date msgResultDate = msgDateFormat.parse(msgDateStr);

        Date phoneDate = new Date();
        String phoneDateStr = msgDateFormat.format(phoneDate);
        Date phoneResultDate = msgDateFormat.parse(phoneDateStr);

        String append;
        if (phoneResultDate.getTime() - msgResultDate.getTime() == 0) {
            append = "";
        } else if (phoneResultDate.getTime() - msgResultDate.getTime() <= 24 * 60 * 60 * 1000) {
            append = "昨天" + " ";
        } else {
            SimpleDateFormat resultFormat = new SimpleDateFormat("yyyy年MM月dd日", Locale.CHINA);
            append = resultFormat.format(msgResultDate) + " ";
        }
        return append;
    }

    /**
     * 结束动画
     */
    public void stopAnim() {
        if (drawAnim != null && drawAnim.isRunning()) {
            drawAnim.stop();
        }
        drawAnim = null;
    }
}
