package com.xdja.poc.sdk.ui.main.mvp;

import android.view.View;

import com.jude.easyrecyclerview.EasyRecyclerView;
import com.jude.easyrecyclerview.adapter.RecyclerArrayAdapter;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.event.POCGroupUpdateEvent;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.utils.POCGroupOrderComparator;

import java.util.ArrayList;
import java.util.Map;

/**
 * janus-gateway-android-master
 * 功能 POC主业务 contract层
 * 描述
 * created by Wwq : 2018/8/27
 */

public interface POCGroupListContract {
    interface IView {
        void onGroupList(ArrayList<DBGroupEntity> mGroupList, int flag);
        void showLoading(String content);
        void dismissLoading();
        View getEmptyView();
        POCGroupOrderComparator getComparator();
        View getErrorView();
        void switchViewStatus(int flag);
        void onRefreshList();

        void onSelfInComing(String roomId);

        void resetFragment();
    }

    interface IPresenter {
        void showMenuDialog(int position);
        void deleteRoom(DBGroupEntity roomId);
        void attatchAdapter(EasyRecyclerView recyclerView, RecyclerArrayAdapter<DBGroupEntity> mSearchAdapter, RecyclerArrayAdapter<DBGroupEntity> adapter);
        void refreshGroupList(POCGroupUpdateEvent updateEvent);
        void refreshAdapter(String roomId);
        void destroy();

        void setUserCacheInfo(Map<String, POCMemberInfo> mAccountToName);

    }
}
