package com.xdja.poc.sdk.utils;

import android.app.Fragment;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.widget.ImageView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.xdja.poc.sdk.R;

import java.io.File;


public class GlideUtils {
    public static void setImageUseFile(Context context, String fileUri, ImageView view) {
        Glide.with(context)
                .load(new File(fileUri))
                .error(R.drawable.poc_icon_default_avatar)
                .placeholder(R.drawable.poc_icon_default_avatar)
                //.diskCacheStrategy( DiskCacheStrategy.NONE )
                .into(view);
    }
    public static void setImageUseNetWithCircle(Context context, String NetUri, ImageView view) {
        Glide.with(context)
                .load(NetUri)
                .bitmapTransform(new GlideCircleTransform(context))
                .error(R.drawable.poc_icon_default_avatar)
                .placeholder(R.drawable.poc_icon_default_avatar)
                .into(view);
    }

    public static void setImageUseNet(Fragment context, String NetUri, ImageView view) {
        Glide.with(context)
                .load(NetUri)
                .error(R.drawable.poc_icon_default_avatar)
                .placeholder(R.drawable.poc_icon_default_avatar)
                .diskCacheStrategy(DiskCacheStrategy.NONE)
                .into(view);
    }

    private static class GlideCircleTransform extends BitmapTransformation {
        GlideCircleTransform(Context context) {
            super(context);
        }

        @Override
        protected Bitmap transform(BitmapPool pool, Bitmap toTransform, int outWidth, int outHeight) {
            return circleCrop(pool, toTransform);
        }

        private Bitmap circleCrop(BitmapPool pool, Bitmap source) {
            if (source == null) return null;

            int size = Math.min(source.getWidth(), source.getHeight());
            int x = (source.getWidth() - size) / 2;
            int y = (source.getHeight() - size) / 2;

            // TODO this could be acquired from the pool too
            Bitmap squared = Bitmap.createBitmap(source, x, y, size, size);

            Bitmap result = pool.get(size, size, Bitmap.Config.ARGB_8888);
            if (result == null) {
                result = Bitmap.createBitmap(size, size, Bitmap.Config.ARGB_8888);
            }

            Canvas canvas = new Canvas(result);
            Paint paint = new Paint();
            paint.setShader(new BitmapShader(squared, BitmapShader.TileMode.CLAMP, BitmapShader.TileMode.CLAMP));
            paint.setAntiAlias(true);
            float r = size / 2f;
            canvas.drawCircle(r, r, r, paint);
            return result;
        }

        @Override
        public String getId() {
            return getClass().getName();
        }
    }
}
