package de.tavendo.autobahn;

import android.content.Context;
import android.util.Log;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLFactorys {

    private final Context mContext;

    public SSLFactorys(Context context) {
        this.mContext = context;
    }

    public SocketFactory getSSLSocketFactory() {
        try {
            //读取证书流
            InputStream stream = getCertificates("janus.jks");
            CertificateFactory instance = CertificateFactory.getInstance("X.509","BC");
            Certificate certificate = instance.generateCertificate(stream);

            // 创建 Keystore 包含我们的证书
            String defaultType = KeyStore.getDefaultType();
            KeyStore keyStore = KeyStore.getInstance(defaultType);
            keyStore.load(null);
            keyStore.setCertificateEntry("janus",certificate);

            //创建一个TrustManager 仅把 Keystore 中的证书 作为信任的锚点
            String algorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(algorithm);
            trustFactory.init(keyStore);
            TrustManager[] trustManagers = trustFactory.getTrustManagers();

            // 用 TrustManager 初始化一个 SSLContext
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null,trustManagers,null);

            return sc.getSocketFactory();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (KeyManagementException e) {
            e.printStackTrace();
        } catch (KeyStoreException e) {
            e.printStackTrace();
        } catch (CertificateException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        return null;
    }

    public SocketFactory getSocketFactory() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager() {
                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};

            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());

            return sc.getSocketFactory();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (KeyManagementException e) {
            e.printStackTrace();
        }
        return null;
    }




    /**
     * 获取资源assert中的证书流
     *
     * @return
     */
    private InputStream getCertificates(String certName) {
        try {
            InputStream stream = mContext.getResources().getAssets().open(certName);

            return stream;
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

}
