package de.tavendo.autobahn;


import android.content.Context;
import android.net.SSLCertificateSocketFactory;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;

import com.xdja.poc.common.utils.LogUtils;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;

import javax.net.SocketFactory;

public class SocketThread extends Thread {

    private static final String WS_CONNECTOR = "WebSocketConnector";
    private static final String WS_URI_SCHEME = "ws";
    private static final String WSS_URI_SCHEME = "wss";
    private static final String WS_WRITER = "WebSocketWriter";
    private static final String WS_READER = "WebSocketReader";
    private final URI mWebSocketURI;
    private Socket mSocket = null;
    private String mFailureMessage = null;
    private Handler mHandler;
    private Context mContext;

    public SocketThread(URI uri, WebSocketOptions options) {
        this.setName(WS_CONNECTOR);
        this.mWebSocketURI = uri;
    }
    public void setContext(Context context){
        this.mContext = context;
    }

    @Override
    public void run() {
        Looper.prepare();
        LogUtils.DLog("SocketThread", "SocketThread run...");
        this.mHandler = new Handler();
        synchronized (this) {
            this.notifyAll();
        }

        Looper.loop();
        this.mHandler = null;
        LogUtils.DLog("SocketThread", "SocketThread exited.");
    }

    public void startConnection() {
        try {
            String host = this.mWebSocketURI.getHost();
            int port = this.mWebSocketURI.getPort();
            if (port == -1) {
                if (this.mWebSocketURI.getScheme().equals(WSS_URI_SCHEME)) {
                    port = 443;
                } else {
                    port = 80;
                }
            }

            SocketFactory factory;
            if (this.mWebSocketURI.getScheme().equalsIgnoreCase(WSS_URI_SCHEME)) {
                //replace to ssl factory
                SSLFactorys sslFactorys = new SSLFactorys(mContext);
                //读取证书
                //factory = sslFactorys.getSSLSocketFactory();
                //不校验证书
                factory = sslFactorys.getSocketFactory();
                //防止未读取带证书的factory
                if (factory ==null){
                    factory = SSLCertificateSocketFactory.getDefault();
                    LogUtils.ELog("socketThread","get factory failed,get default factory");
                }else {
                    LogUtils.DLog("socketThread","get factory success");
                }
            } else {
                factory = SocketFactory.getDefault();
            }

            this.mSocket = factory.createSocket(host, port);
        } catch (IOException var5) {
            this.mFailureMessage = var5.getLocalizedMessage();
        }

        synchronized (this) {
            this.notifyAll();
        }
    }

    public void stopConnection() {
        try {
            this.mSocket.close();
            this.mSocket = null;
        } catch (IOException var2) {
            this.mFailureMessage = var2.getLocalizedMessage();
        }

    }

    public Handler getHandler() {
        return this.mHandler;
    }

    public Socket getSocket() {
        return this.mSocket;
    }

    public String getFailureMessage() {
        return this.mFailureMessage;
    }

}
