/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import javax.annotation.Nullable;
import org.webrtc.JNINamespace;
import org.webrtc.MediaSource;
import org.webrtc.NV21Buffer;
import org.webrtc.RendererCommon;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoFrame;

@JNINamespace(value="webrtc::jni")
public class VideoSource
extends MediaSource {
    private final VideoCapturer.CapturerObserver capturerObserver;

    public VideoSource(long nativeSource) {
        super(nativeSource);
        this.capturerObserver = new NativeCapturerObserver(nativeSource);
    }

    VideoSource(long nativeSource, SurfaceTextureHelper surfaceTextureHelper) {
        super(nativeSource);
        this.capturerObserver = new NativeCapturerObserver(nativeSource, surfaceTextureHelper);
    }

    public void adaptOutputFormat(int width, int height, int fps) {
        VideoSource.nativeAdaptOutputFormat(this.nativeSource, width, height, fps);
    }

    public VideoCapturer.CapturerObserver getCapturerObserver() {
        return this.capturerObserver;
    }

    private static native void nativeAdaptOutputFormat(long var0, int var2, int var3, int var4);

    private static native void nativeCapturerStarted(long var0, boolean var2);

    private static native void nativeCapturerStopped(long var0);

    private static native void nativeOnFrameCaptured(long var0, int var2, int var3, int var4, long var5, VideoFrame.Buffer var7);

    private static class NativeCapturerObserver
    implements VideoCapturer.CapturerObserver {
        private final long nativeSource;
        @Nullable
        private final SurfaceTextureHelper surfaceTextureHelper;

        public NativeCapturerObserver(long nativeSource) {
            this.nativeSource = nativeSource;
            this.surfaceTextureHelper = null;
        }

        public NativeCapturerObserver(long nativeSource, SurfaceTextureHelper surfaceTextureHelper) {
            this.nativeSource = nativeSource;
            this.surfaceTextureHelper = surfaceTextureHelper;
        }

        @Override
        public void onCapturerStarted(boolean success) {
            VideoSource.nativeCapturerStarted(this.nativeSource, success);
        }

        @Override
        public void onCapturerStopped() {
            VideoSource.nativeCapturerStopped(this.nativeSource);
        }

        @Override
        public void onByteBufferFrameCaptured(byte[] data, int width, int height, int rotation, long timestampNs) {
            NV21Buffer nv21Buffer = new NV21Buffer(data, width, height, null);
            VideoFrame frame = new VideoFrame(nv21Buffer, rotation, timestampNs);
            this.onFrameCaptured(frame);
            frame.release();
        }

        @Override
        public void onTextureFrameCaptured(int width, int height, int oesTextureId, float[] transformMatrix, int rotation, long timestampNs) {
            VideoFrame.TextureBuffer buffer = this.surfaceTextureHelper.createTextureBuffer(width, height, RendererCommon.convertMatrixToAndroidGraphicsMatrix(transformMatrix));
            VideoFrame frame = new VideoFrame(buffer, rotation, timestampNs);
            this.onFrameCaptured(frame);
            frame.release();
        }

        @Override
        public void onFrameCaptured(VideoFrame frame) {
            VideoSource.nativeOnFrameCaptured(this.nativeSource, frame.getBuffer().getWidth(), frame.getBuffer().getHeight(), frame.getRotation(), frame.getTimestampNs(), frame.getBuffer());
        }
    }
}

