/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business.plugincallback;

import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.business.POCRoom;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusPluginCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IPluginHandleWebRTCCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusMediaConstraints;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusPluginHandleWithWebrtc;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusSupportedPluginPackages;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.PluginHandleSendMessageCallbacks;
import com.xdja.poc.sdk.config.JaunsApi;
import java.math.BigInteger;
import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.MediaStream;
import org.webrtc.VideoSink;

public class JanusListenerAttachCallbacks
implements IJanusPluginCallbacks {
    private final String TAG = "ListenerAttach";
    private POCRoom.ProxyVideoSink renderer = null;
    private BigInteger feedid = null;
    private BigInteger privateId;
    private long roomid;
    private JanusPluginHandleWithWebrtc listenerHandle = null;
    private POCRoom pocRoom;
    private boolean needPlayer = false;
    private boolean muteState = false;
    String audioCodec = "opus";

    public JanusListenerAttachCallbacks(long roomid, BigInteger privateId, BigInteger id2, POCRoom.ProxyVideoSink renderer, POCRoom pocRoom, boolean needPlayer) {
        this.renderer = renderer;
        this.feedid = id2;
        this.roomid = roomid;
        this.privateId = privateId;
        this.pocRoom = pocRoom;
        this.needPlayer = needPlayer;
    }

    public void setAudioCode(String codec) {
        this.audioCodec = codec;
    }

    @Override
    public void success(JanusPluginHandleWithWebrtc handle) {
        this.listenerHandle = handle;
        try {
            JSONObject jsonObject = JaunsApi.subscriberJoin(this.roomid, this.feedid, "xdja_4321", this.privateId, true, true, false, true, true, false, true);
            handle.sendMessage(new PluginHandleSendMessageCallbacks(jsonObject));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendMsgToRoom(String msg) {
        if (this.listenerHandle != null) {
            this.listenerHandle.sendMsgOverDataChannel(msg);
        }
    }

    public void mute(boolean enable) {
        this.muteState = enable;
        if (this.listenerHandle != null) {
            this.listenerHandle.mute(enable);
        }
    }

    public JanusPluginHandleWithWebrtc getHandler() {
        return this.listenerHandle;
    }

    public boolean getMuteState() {
        if (this.listenerHandle != null) {
            return this.listenerHandle.getMuteState();
        }
        return true;
    }

    public void leaveRoom() {
        if (this.listenerHandle != null) {
            JSONObject jsonObject = JaunsApi.leaveRoom();
            this.listenerHandle.sendMessage(new PluginHandleSendMessageCallbacks(jsonObject));
            this.listenerHandle.hangUp();
        }
    }

    @Override
    public void onMessage(JSONObject msg, JSONObject jsep) {
        this.pocRoom.setJoining(false);
        try {
            String event = msg.getString("videoroom");
            if (event.equals("attached") && jsep != null) {
                final JSONObject remoteJsep = jsep;
                this.listenerHandle.createAnswer(new IPluginHandleWebRTCCallbacks(){

                    @Override
                    public void onSuccess(JSONObject obj) {
                        try {
                            JSONObject mymsg = new JSONObject();
                            JSONObject body = new JSONObject();
                            body.put("request", (Object)"start");
                            body.put("room", JanusListenerAttachCallbacks.this.roomid);
                            mymsg.put("message", (Object)body);
                            mymsg.put("jsep", (Object)obj);
                            JanusListenerAttachCallbacks.this.listenerHandle.sendMessage(new PluginHandleSendMessageCallbacks(mymsg));
                            JanusListenerAttachCallbacks.this.pocRoom.setJoined(true);
                            LogUtils.ELog((String)"ListenerAttach", (String)("onSuccess: " + JanusListenerAttachCallbacks.this.needPlayer + ", needPlayer:" + JanusListenerAttachCallbacks.this.needPlayer + ", muteState:" + JanusListenerAttachCallbacks.this.muteState));
                            if (!JanusListenerAttachCallbacks.this.muteState && JanusListenerAttachCallbacks.this.needPlayer && JanusListenerAttachCallbacks.this.listenerHandle != null) {
                                JanusListenerAttachCallbacks.this.listenerHandle.startPlayer(true);
                            }
                        }
                        catch (Exception ex) {
                            JanusListenerAttachCallbacks.this.pocRoom.onRoomStatus(JanusListenerAttachCallbacks.this.roomid, 9004, ex.getMessage());
                            LogUtils.ELog((Throwable)ex);
                        }
                    }

                    @Override
                    public JSONObject getJsep() {
                        return remoteJsep;
                    }

                    @Override
                    public VideoSink getRemoteSink() {
                        return JanusListenerAttachCallbacks.this.renderer;
                    }

                    @Override
                    public JanusMediaConstraints getMedia() {
                        JanusMediaConstraints cons = new JanusMediaConstraints();
                        cons.setVideo(null);
                        cons.setRecvAudio(true);
                        cons.setRecvVideo(false);
                        cons.setSendAudio(false);
                        cons.setAudioCodec(JanusListenerAttachCallbacks.this.audioCodec);
                        return cons;
                    }

                    @Override
                    public Boolean getTrickle() {
                        return true;
                    }

                    @Override
                    public void onCallbackError(String error) {
                        LogUtils.ELog((String)"ListenerAttach", (String)("error: " + error));
                        if (JanusListenerAttachCallbacks.this.listenerHandle != null) {
                            JanusListenerAttachCallbacks.this.listenerHandle.hangUp();
                        }
                    }
                });
            } else if (event.equals("event") && msg.has("left") && this.listenerHandle != null) {
                this.listenerHandle.detach();
            }
        }
        catch (Exception ex) {
            LogUtils.ELog((Throwable)ex);
        }
    }

    @Override
    public void onLocalStream(MediaStream stream) {
    }

    @Override
    public void onRemoteStream(MediaStream stream) {
    }

    @Override
    public void onDataOpen(Object data) {
    }

    @Override
    public void onData(Object data) {
        boolean ret = true;
        if (data instanceof JSONObject) {
            ret = false;
        }
        if (ret) {
            return;
        }
        JSONObject obj = (JSONObject)data;
        if (obj.has("result")) {
            try {
                String result = obj.getString("result");
                if (result.equals("tbcp")) {
                    int result_code = obj.getInt("result_code");
                    switch (result_code) {
                        case 101: {
                            String tbcp_owner = obj.getString("tbcp_owner_name");
                            this.pocRoom.onTBCP(9014, tbcp_owner);
                            break;
                        }
                        case 103: {
                            String tbcp_owner = obj.getString("tbcp_old_owner");
                            this.pocRoom.onTBCP(9015, tbcp_owner);
                        }
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onCleanup() {
        this.pocRoom.setCreated(false);
        this.pocRoom.setCreating(false);
        this.pocRoom.setJoined(false);
    }

    @Override
    public void onDetached() {
        this.listenerHandle = null;
        this.pocRoom.setCreated(false);
        this.pocRoom.setCreating(false);
        this.pocRoom.setJoined(false);
    }

    @Override
    public JanusSupportedPluginPackages getPlugin() {
        return JanusSupportedPluginPackages.JANUS_POC_ROOM;
    }

    @Override
    public void onCallbackError(String error) {
        LogUtils.ELog((String)"ListenerAttach", (String)("listen err:" + error));
        this.pocRoom.setCreated(false);
        this.pocRoom.setCreating(false);
        this.pocRoom.setJoined(false);
        if (this.listenerHandle != null) {
            this.listenerHandle.hangUp();
        }
        if (error != null && error.contains("connection failed")) {
            this.pocRoom.onRoomStatus(this.roomid, 9100, error);
        } else {
            this.pocRoom.onRoomStatus(this.roomid, 9002, error);
        }
    }
}

