/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business.plugincallback;

import android.support.annotation.Nullable;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.business.POCRoom;
import com.xdja.poc.sdk.business.plugincallback.JanusListenerAttachCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusPluginCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IPluginHandleSendMessageCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IPluginHandleWebRTCCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusMediaConstraints;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusPluginHandleWithWebrtc;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusServer;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusSupportedPluginPackages;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.PluginHandleSendMessageCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.PluginHandleWebRTCCallbacks;
import com.xdja.poc.sdk.config.JaunsApi;
import java.math.BigInteger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.webrtc.MediaStream;
import org.webrtc.VideoSink;

public class JanusPublisherPluginCallbacks
implements IJanusPluginCallbacks {
    private final String TAG = "JanusPublisher";
    private JanusListenerAttachCallbacks listenerAttachCallbacks = null;
    private JanusPluginHandleWithWebrtc handle = null;
    private BigInteger privateId;
    private long roomId;
    private String userName;
    private POCRoom pocRoom;
    boolean bWaitTakenTBCPResult = false;
    String currTransaction;

    public JanusPublisherPluginCallbacks(long roomId, String userName, POCRoom pocRoom) {
        this.roomId = roomId;
        this.userName = userName;
        this.pocRoom = pocRoom;
    }

    public void subscriberJoin(final long roomId, BigInteger feedId, String pin, BigInteger privateId, boolean closePc, boolean audio, boolean video, boolean data, boolean offerAudio, boolean offerVideo, boolean offerData) {
        if (this.handle != null) {
            final JSONObject jsonObject = JaunsApi.subscriberJoin(roomId, feedId, pin, privateId, closePc, audio, video, data, offerAudio, offerVideo, offerData);
            this.handle.sendMessage(new IPluginHandleSendMessageCallbacks(){

                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog((String)"Zhangs", (String)("subscriberJoin 990 : " + obj));
                    if (obj.has("error_code")) {
                        JanusPublisherPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9004, obj.optString("error"));
                    } else {
                        JanusPublisherPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9003, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {
                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {
                    JanusPublisherPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9004, error);
                }
            });
        }
    }

    public void startMedia(final long roomId) {
        if (this.handle != null) {
            final JSONObject jsonObject = JaunsApi.startMedia(roomId);
            this.handle.sendMessage(new IPluginHandleSendMessageCallbacks(){

                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog((String)"Zhangs", (String)("startMedia 1016 : " + obj));
                    if (obj.has("error_code")) {
                        JanusPublisherPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9033, obj.optString("error"));
                    } else {
                        JanusPublisherPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9034, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {
                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {
                }
            });
        }
    }

    public void pauseMedia(final long roomId) {
        if (this.handle != null) {
            final JSONObject jsonObject = JaunsApi.pauseMedia(roomId);
            this.handle.sendMessage(new IPluginHandleSendMessageCallbacks(){

                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog((String)"Zhangs", (String)("pauseMedia 1042 : " + obj));
                    if (obj.has("error_code")) {
                        JanusPublisherPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9036, obj.optString("error"));
                    } else {
                        JanusPublisherPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9035, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {
                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {
                }
            });
        }
    }

    public void switchSubscriber(final long roomId, int feed, boolean audio, boolean video, boolean data) {
        if (this.handle != null) {
            final JSONObject jsonObject = JaunsApi.switchSubscriber(feed, audio, video, data);
            this.handle.sendMessage(new IPluginHandleSendMessageCallbacks(){

                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog((String)"Zhangs", (String)("switchSubscriber 1068 : " + obj));
                    if (obj.has("error_code")) {
                        JanusPublisherPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9037, obj.optString("error"));
                    } else {
                        JanusPublisherPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9038, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {
                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {
                }
            });
        }
    }

    public void publish(final long roomId, boolean audio, boolean video, boolean data, String audioCode, String videoCode, int bitrate, boolean record, String fileName, String display) {
        if (this.handle != null) {
            final JSONObject jsonObject = JaunsApi.publish(audio, video, data, audioCode, videoCode, bitrate, record, fileName, display);
            this.handle.sendMessage(new IPluginHandleSendMessageCallbacks(){

                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog((String)"Zhangs", (String)("publish 911 : " + obj));
                    if (obj.has("error_code")) {
                        JanusPublisherPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9027, obj.optString("error"));
                    } else {
                        JanusPublisherPluginCallbacks.this.pocRoom.onRoomStatus(roomId, 9028, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {
                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {
                }
            });
        }
    }

    public void unpublish(final long roomID) {
        if (this.handle != null) {
            final JSONObject jsonObject = JaunsApi.unpublish();
            this.handle.sendMessage(new IPluginHandleSendMessageCallbacks(){

                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog((String)"Zhangs", (String)("unpublish 937 : " + obj));
                    if (obj.has("error_code")) {
                        JanusPublisherPluginCallbacks.this.pocRoom.onRoomStatus(roomID, 9030, obj.optString("error"));
                    } else {
                        JanusPublisherPluginCallbacks.this.pocRoom.onRoomStatus(roomID, 9029, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {
                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {
                }
            });
        }
    }

    public void publishOwnFeed() {
        if (this.handle != null) {
            this.handle.createOffer(new IPluginHandleWebRTCCallbacks(){

                @Override
                public void onSuccess(JSONObject obj) {
                    try {
                        JSONObject msg = new JSONObject();
                        JSONObject body = new JSONObject();
                        body.put("request", (Object)"configure");
                        body.put("audio", true);
                        body.put("video", false);
                        body.put("data", true);
                        msg.put("message", (Object)body);
                        msg.put("jsep", (Object)obj);
                        JanusPublisherPluginCallbacks.this.handle.sendMessage(new PluginHandleSendMessageCallbacks(msg));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                @Override
                public JSONObject getJsep() {
                    return null;
                }

                @Override
                public JanusMediaConstraints getMedia() {
                    JanusMediaConstraints cons = new JanusMediaConstraints();
                    cons.setRecvAudio(false);
                    cons.setRecvVideo(false);
                    cons.setSendAudio(true);
                    return cons;
                }

                @Override
                public Boolean getTrickle() {
                    return true;
                }

                @Override
                public VideoSink getRemoteSink() {
                    return null;
                }

                @Override
                public void onCallbackError(String error) {
                }
            });
        }
    }

    public void registerUsername(long roomId, @Nullable Integer userId, String userName, String pin, String token) {
        if (this.handle != null) {
            JSONObject join = JaunsApi.join(roomId, userId, userName, pin, token);
            this.handle.sendMessage(new PluginHandleSendMessageCallbacks(join));
        }
    }

    public void newRemoteFeed(BigInteger id2) {
        this.listenerAttachCallbacks = new JanusListenerAttachCallbacks(this.roomId, this.privateId, id2, null, this.pocRoom, false);
        this.pocRoom.attach(this.listenerAttachCallbacks);
    }

    @Override
    public void success(JanusPluginHandleWithWebrtc handle1) {
        this.handle = handle1;
        this.pocRoom.attachSuccess();
    }

    public void hangup() {
        if (this.handle != null) {
            this.handle.hangUp();
        }
    }

    public void leaveRoom() {
        if (this.listenerAttachCallbacks != null) {
            this.listenerAttachCallbacks.leaveRoom();
        }
        this.unPublishRoom();
        if (this.handle != null) {
            JSONObject obj = new JSONObject();
            JSONObject msg = new JSONObject();
            try {
                obj.put("request", (Object)"leave");
                msg.put("message", (Object)obj);
            }
            catch (Exception ex) {
                LogUtils.DLog((String)"JanusPublisher", (String)ex.getMessage());
            }
            this.handle.sendMessage(new PluginHandleSendMessageCallbacks(msg));
            this.handle.hangUp();
        }
    }

    public void mute(boolean enable) {
        if (this.listenerAttachCallbacks != null) {
            this.listenerAttachCallbacks.mute(enable);
        }
    }

    public boolean getMuteState() {
        if (this.listenerAttachCallbacks != null) {
            return this.listenerAttachCallbacks.getMuteState();
        }
        return true;
    }

    public void takenTBCP() {
        LogUtils.DLog((String)"JanusPublisher", (String)("takenTBCP JanusPublisherPluginCallbacks  bWaitTakenTBCPResult: " + this.bWaitTakenTBCPResult));
        this.bWaitTakenTBCPResult = true;
        JanusServer.RandomString stringGenerator = new JanusServer.RandomString();
        this.currTransaction = stringGenerator.randomString(12);
        JSONObject obj = new JSONObject();
        try {
            obj.put("request", (Object)"tbcp");
            obj.put("type", (Object)"requst");
            obj.put("room", this.roomId);
            obj.put("transaction", (Object)this.currTransaction);
            if (this.handle != null) {
                this.handle.sendMsgOverDataChannel(obj.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void releaseTBCP() {
        LogUtils.DLog((String)"JanusPublisher", (String)"JanusPublisherPluginCallbacks releaseTBCP return ....");
        JanusServer.RandomString stringGenerator = new JanusServer.RandomString();
        this.currTransaction = stringGenerator.randomString(12);
        JSONObject obj = new JSONObject();
        try {
            obj.put("request", (Object)"tbcp");
            obj.put("type", (Object)"release");
            obj.put("room", this.roomId);
            obj.put("transaction", (Object)this.currTransaction);
            if (this.handle != null) {
                this.handle.sendMsgOverDataChannel(obj.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.handle != null) {
            this.handle.releaseTBCP();
        }
    }

    public void sendMsgToRoom(String msg) {
        if (this.handle != null) {
            this.handle.sendMsgOverDataChannel(msg);
        }
        if (this.listenerAttachCallbacks != null) {
            this.listenerAttachCallbacks.sendMsgToRoom(msg);
        }
    }

    private void unPublishRoom() {
        if (this.handle != null) {
            JSONObject obj = new JSONObject();
            JSONObject msg = new JSONObject();
            try {
                obj.put("request", (Object)"unpublish");
                msg.put("message", (Object)obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.handle.sendMessage(new PluginHandleSendMessageCallbacks(msg));
        }
    }

    @Override
    public void onMessage(JSONObject msg, JSONObject jsepLocal) {
        try {
            String event = msg.getString("videoroom");
            if (event.equals("joined")) {
                this.privateId = msg.has("privateId") ? new BigInteger(msg.getString("private_id")) : new BigInteger(msg.getString("id"));
                this.publishOwnFeed();
                if (msg.has("publishers")) {
                    JSONArray pubs = msg.getJSONArray("publishers");
                    for (int i = 0; i < pubs.length(); ++i) {
                        JSONObject pub = pubs.getJSONObject(i);
                        BigInteger tehId = new BigInteger(pub.getString("id"));
                        this.newRemoteFeed(tehId);
                    }
                }
            } else if (event.equals("destroyed")) {
                this.pocRoom.onRoomStatus(this.roomId, 9018, event);
                this.handle.detach();
            } else if (event.equals("event")) {
                int error_code;
                if (msg.has("publishers")) {
                    JSONArray pubs = msg.getJSONArray("publishers");
                    for (int i = 0; i < pubs.length(); ++i) {
                        JSONObject pub = pubs.getJSONObject(i);
                        if (this.listenerAttachCallbacks == null) {
                            this.newRemoteFeed(new BigInteger(pub.getString("id")));
                            continue;
                        }
                        if (!pub.has("display")) continue;
                        String user = pub.getString("display");
                        this.pocRoom.onRoomStatus(this.roomId, 9017, user);
                    }
                } else if (msg.has("leaving")) {
                    String leaving_user = msg.getString("leaving");
                    if (leaving_user != null && !leaving_user.equals(this.userName)) {
                        this.pocRoom.onRoomStatus(this.roomId, 9016, msg.getString("leaving"));
                    }
                } else if (msg.has("unpublished")) {
                    String user = msg.getString("unpublished");
                    if (user != null && user.equals(this.userName)) {
                        this.handle.detach();
                        this.pocRoom.onRoomStatus(this.roomId, 9005, user);
                    } else {
                        this.pocRoom.onRoomStatus(this.roomId, 9016, user);
                    }
                } else if (msg.has("error_code") && (error_code = msg.getInt("error_code")) == 426) {
                    String error = msg.getString("error");
                    this.pocRoom.setJoined(false);
                    this.pocRoom.setJoining(false);
                    this.pocRoom.onRoomStatus(this.roomId, 9019, error);
                }
                if (jsepLocal != null) {
                    this.handle.handleRemoteJsep(new PluginHandleWebRTCCallbacks(null, jsepLocal, false));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onLocalStream(MediaStream stream) {
    }

    @Override
    public void onRemoteStream(MediaStream stream) {
    }

    @Override
    public void onDataOpen(Object data) {
    }

    @Override
    public void onData(Object data) {
        boolean ret = true;
        if (data instanceof JSONObject) {
            ret = false;
        }
        if (ret) {
            return;
        }
        if (!this.bWaitTakenTBCPResult) {
            this.ack(data);
        }
        LogUtils.DLog((String)"JanusPublisher", (String)("onData JanusPublisherPluginCallbacks  bWaitTakenTBCPResult: " + this.bWaitTakenTBCPResult));
        if (this.bWaitTakenTBCPResult) {
            this.bWaitTakenTBCPResult = false;
            this.currTransaction = "";
        }
    }

    private void ack(Object data) {
        try {
            JSONObject obj = new JSONObject();
            obj.put("request", (Object)"tbcp");
            obj.put("type", (Object)"ack");
            obj.put("room", this.roomId);
            if (this.handle != null) {
                this.handle.sendMsgOverDataChannel(obj.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onCleanup() {
    }

    @Override
    public JanusSupportedPluginPackages getPlugin() {
        return JanusSupportedPluginPackages.JANUS_POC_ROOM;
    }

    @Override
    public void onCallbackError(String error) {
    }

    @Override
    public void onDetached() {
        this.handle = null;
    }
}

