/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business.webrtc.apprtc;

import android.os.ParcelFileDescriptor;
import com.xdja.poc.common.utils.LogUtils;
import java.io.File;
import java.io.IOException;
import org.webrtc.PeerConnection;

public class RtcEventLog {
    private static final String TAG = "RtcEventLog";
    private static final int OUTPUT_FILE_MAX_BYTES = 10000000;
    private final PeerConnection peerConnection;
    private RtcEventLogState state = RtcEventLogState.INACTIVE;

    public RtcEventLog(PeerConnection peerConnection) {
        if (peerConnection == null) {
            throw new NullPointerException("The peer connection is null.");
        }
        this.peerConnection = peerConnection;
    }

    public void start(File outputFile) {
        ParcelFileDescriptor fileDescriptor;
        if (this.state == RtcEventLogState.STARTED) {
            LogUtils.ELog((String)TAG, (String)"RtcEventLog has already started.");
            return;
        }
        try {
            fileDescriptor = ParcelFileDescriptor.open((File)outputFile, (int)0x3C000000);
        }
        catch (IOException e) {
            LogUtils.ELog((String)TAG, (String)("Failed to create a new file: " + e.getLocalizedMessage()));
            return;
        }
        boolean success = this.peerConnection.startRtcEventLog(fileDescriptor.detachFd(), 10000000);
        if (!success) {
            LogUtils.ELog((String)TAG, (String)"Failed to start RTC event log.");
            return;
        }
        this.state = RtcEventLogState.STARTED;
        LogUtils.DLog((String)TAG, (String)"RtcEventLog started.");
    }

    public void stop() {
        if (this.state != RtcEventLogState.STARTED) {
            LogUtils.ELog((String)TAG, (String)"RtcEventLog was not started.");
            return;
        }
        this.peerConnection.stopRtcEventLog();
        this.state = RtcEventLogState.STOPPED;
        LogUtils.DLog((String)TAG, (String)"RtcEventLog stopped.");
    }

    static enum RtcEventLogState {
        INACTIVE,
        STARTED,
        STOPPED;

    }
}

