/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business.webrtc.apprtc;

import android.os.Handler;
import android.os.HandlerThread;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.business.webrtc.apprtc.AppRTCClient;
import com.xdja.poc.sdk.business.webrtc.apprtc.RoomParametersFetcher;
import com.xdja.poc.sdk.business.webrtc.apprtc.WebSocketChannelClient;
import com.xdja.poc.sdk.business.webrtc.apprtc.util.AsyncHttpURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.IceCandidate;
import org.webrtc.SessionDescription;

public class WebSocketRTCClient
implements AppRTCClient,
WebSocketChannelClient.WebSocketChannelEvents {
    private static final String TAG = "WebSocketRTCClient";
    private static final String ROOM_JOIN = "join";
    private static final String ROOM_MESSAGE = "message";
    private static final String ROOM_LEAVE = "leave";
    private final Handler handler;
    private boolean initiator;
    private AppRTCClient.SignalingEvents events;
    private WebSocketChannelClient wsClient;
    private ConnectionState roomState;
    private AppRTCClient.RoomConnectionParameters connectionParameters;
    private String messageUrl;
    private String leaveUrl;

    public WebSocketRTCClient(AppRTCClient.SignalingEvents events) {
        this.events = events;
        this.roomState = ConnectionState.NEW;
        HandlerThread handlerThread = new HandlerThread(TAG);
        handlerThread.start();
        this.handler = new Handler(handlerThread.getLooper());
    }

    @Override
    public void connectToRoom(AppRTCClient.RoomConnectionParameters connectionParameters) {
        this.connectionParameters = connectionParameters;
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                WebSocketRTCClient.this.connectToRoomInternal();
            }
        });
    }

    @Override
    public void disconnectFromRoom() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                WebSocketRTCClient.this.disconnectFromRoomInternal();
                WebSocketRTCClient.this.handler.getLooper().quit();
            }
        });
    }

    private void connectToRoomInternal() {
        String connectionUrl = this.getConnectionUrl(this.connectionParameters);
        LogUtils.DLog((String)TAG, (String)("Connect to room: " + connectionUrl));
        this.roomState = ConnectionState.NEW;
        this.wsClient = new WebSocketChannelClient(this.handler, this);
        RoomParametersFetcher.RoomParametersFetcherEvents callbacks = new RoomParametersFetcher.RoomParametersFetcherEvents(){

            @Override
            public void onSignalingParametersReady(final AppRTCClient.SignalingParameters params) {
                WebSocketRTCClient.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        WebSocketRTCClient.this.signalingParametersReady(params);
                    }
                });
            }

            @Override
            public void onSignalingParametersError(String description) {
                WebSocketRTCClient.this.reportError(description);
            }
        };
        new RoomParametersFetcher(connectionUrl, null, callbacks).makeRequest();
    }

    private void disconnectFromRoomInternal() {
        LogUtils.DLog((String)TAG, (String)("Disconnect. Room state: " + (Object)((Object)this.roomState)));
        if (this.roomState == ConnectionState.CONNECTED) {
            LogUtils.DLog((String)TAG, (String)"Closing room.");
            this.sendPostMessage(MessageType.LEAVE, this.leaveUrl, null);
        }
        this.roomState = ConnectionState.CLOSED;
        if (this.wsClient != null) {
            this.wsClient.disconnect(true);
        }
    }

    private String getConnectionUrl(AppRTCClient.RoomConnectionParameters connectionParameters) {
        return connectionParameters.roomUrl + "/" + ROOM_JOIN + "/" + connectionParameters.roomId + this.getQueryString(connectionParameters);
    }

    private String getMessageUrl(AppRTCClient.RoomConnectionParameters connectionParameters, AppRTCClient.SignalingParameters signalingParameters) {
        return connectionParameters.roomUrl + "/" + ROOM_MESSAGE + "/" + connectionParameters.roomId + "/" + signalingParameters.clientId + this.getQueryString(connectionParameters);
    }

    private String getLeaveUrl(AppRTCClient.RoomConnectionParameters connectionParameters, AppRTCClient.SignalingParameters signalingParameters) {
        return connectionParameters.roomUrl + "/" + ROOM_LEAVE + "/" + connectionParameters.roomId + "/" + signalingParameters.clientId + this.getQueryString(connectionParameters);
    }

    private String getQueryString(AppRTCClient.RoomConnectionParameters connectionParameters) {
        if (connectionParameters.urlParameters != null) {
            return "?" + connectionParameters.urlParameters;
        }
        return "";
    }

    private void signalingParametersReady(AppRTCClient.SignalingParameters signalingParameters) {
        LogUtils.DLog((String)TAG, (String)"Room connection completed.");
        if (this.connectionParameters.loopback && (!signalingParameters.initiator || signalingParameters.offerSdp != null)) {
            this.reportError("Loopback room is busy.");
            return;
        }
        if (!this.connectionParameters.loopback && !signalingParameters.initiator && signalingParameters.offerSdp == null) {
            LogUtils.WLog((String)TAG, (String)"No offer SDP in room response.");
        }
        this.initiator = signalingParameters.initiator;
        this.messageUrl = this.getMessageUrl(this.connectionParameters, signalingParameters);
        this.leaveUrl = this.getLeaveUrl(this.connectionParameters, signalingParameters);
        LogUtils.DLog((String)TAG, (String)("Message URL: " + this.messageUrl));
        LogUtils.DLog((String)TAG, (String)("Leave URL: " + this.leaveUrl));
        this.roomState = ConnectionState.CONNECTED;
        this.events.onConnectedToRoom(signalingParameters);
        this.wsClient.connect(signalingParameters.wssUrl, signalingParameters.wssPostUrl);
        this.wsClient.register(this.connectionParameters.roomId, signalingParameters.clientId);
    }

    @Override
    public void sendOfferSdp(final SessionDescription sdp) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (WebSocketRTCClient.this.roomState != ConnectionState.CONNECTED) {
                    WebSocketRTCClient.this.reportError("Sending offer SDP in non connected state.");
                    return;
                }
                JSONObject json = new JSONObject();
                WebSocketRTCClient.jsonPut(json, "sdp", sdp.description);
                WebSocketRTCClient.jsonPut(json, "type", "offer");
                WebSocketRTCClient.this.sendPostMessage(MessageType.MESSAGE, WebSocketRTCClient.this.messageUrl, json.toString());
                if (((WebSocketRTCClient)WebSocketRTCClient.this).connectionParameters.loopback) {
                    SessionDescription sdpAnswer = new SessionDescription(SessionDescription.Type.fromCanonicalForm((String)"answer"), sdp.description);
                    WebSocketRTCClient.this.events.onRemoteDescription(sdpAnswer);
                }
            }
        });
    }

    @Override
    public void sendAnswerSdp(final SessionDescription sdp) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (((WebSocketRTCClient)WebSocketRTCClient.this).connectionParameters.loopback) {
                    LogUtils.ELog((String)WebSocketRTCClient.TAG, (String)"Sending answer in loopback mode.");
                    return;
                }
                JSONObject json = new JSONObject();
                WebSocketRTCClient.jsonPut(json, "sdp", sdp.description);
                WebSocketRTCClient.jsonPut(json, "type", "answer");
                LogUtils.ILog((String)WebSocketRTCClient.TAG, (String)("sendAnswerSdp json:" + json.toString()));
                WebSocketRTCClient.this.wsClient.send(json.toString());
            }
        });
    }

    @Override
    public void sendLocalIceCandidate(final IceCandidate candidate) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                JSONObject json = new JSONObject();
                WebSocketRTCClient.jsonPut(json, "type", "candidate");
                WebSocketRTCClient.jsonPut(json, "label", candidate.sdpMLineIndex);
                WebSocketRTCClient.jsonPut(json, "id", candidate.sdpMid);
                WebSocketRTCClient.jsonPut(json, "candidate", candidate.sdp);
                LogUtils.ILog((String)WebSocketRTCClient.TAG, (String)("sendLocalIceCandidate json:" + json.toString()));
                if (WebSocketRTCClient.this.initiator) {
                    if (WebSocketRTCClient.this.roomState != ConnectionState.CONNECTED) {
                        WebSocketRTCClient.this.reportError("Sending ICE candidate in non connected state.");
                        return;
                    }
                    WebSocketRTCClient.this.sendPostMessage(MessageType.MESSAGE, WebSocketRTCClient.this.messageUrl, json.toString());
                    if (((WebSocketRTCClient)WebSocketRTCClient.this).connectionParameters.loopback) {
                        WebSocketRTCClient.this.events.onRemoteIceCandidate(candidate);
                    }
                } else {
                    WebSocketRTCClient.this.wsClient.send(json.toString());
                }
            }
        });
    }

    @Override
    public void sendLocalIceCandidateRemovals(final IceCandidate[] candidates) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                JSONObject json = new JSONObject();
                WebSocketRTCClient.jsonPut(json, "type", "remove-candidates");
                JSONArray jsonArray = new JSONArray();
                for (IceCandidate candidate : candidates) {
                    jsonArray.put((Object)WebSocketRTCClient.this.toJsonCandidate(candidate));
                }
                WebSocketRTCClient.jsonPut(json, "candidates", jsonArray);
                if (WebSocketRTCClient.this.initiator) {
                    if (WebSocketRTCClient.this.roomState != ConnectionState.CONNECTED) {
                        WebSocketRTCClient.this.reportError("Sending ICE candidate removals in non connected state.");
                        return;
                    }
                    WebSocketRTCClient.this.sendPostMessage(MessageType.MESSAGE, WebSocketRTCClient.this.messageUrl, json.toString());
                    if (((WebSocketRTCClient)WebSocketRTCClient.this).connectionParameters.loopback) {
                        WebSocketRTCClient.this.events.onRemoteIceCandidatesRemoved(candidates);
                    }
                } else {
                    WebSocketRTCClient.this.wsClient.send(json.toString());
                }
            }
        });
    }

    @Override
    public void onWebSocketMessage(String msg) {
        if (this.wsClient.getState() != WebSocketChannelClient.WebSocketConnectionState.REGISTERED) {
            LogUtils.ELog((String)TAG, (String)"Got WebSocket message in non registered state.");
            return;
        }
        try {
            JSONObject json = new JSONObject(msg);
            String msgText = json.getString("msg");
            String errorText = json.optString("error");
            if (msgText.length() > 0) {
                json = new JSONObject(msgText);
                String type = json.optString("type");
                if (type.equals("candidate")) {
                    this.events.onRemoteIceCandidate(this.toJavaCandidate(json));
                } else if (type.equals("remove-candidates")) {
                    JSONArray candidateArray = json.getJSONArray("candidates");
                    IceCandidate[] candidates = new IceCandidate[candidateArray.length()];
                    for (int i = 0; i < candidateArray.length(); ++i) {
                        candidates[i] = this.toJavaCandidate(candidateArray.getJSONObject(i));
                    }
                    this.events.onRemoteIceCandidatesRemoved(candidates);
                } else if (type.equals("answer")) {
                    if (this.initiator) {
                        SessionDescription sdp = new SessionDescription(SessionDescription.Type.fromCanonicalForm((String)type), json.getString("sdp"));
                        this.events.onRemoteDescription(sdp);
                    } else {
                        this.reportError("Received answer for call initiator: " + msg);
                    }
                } else if (type.equals("offer")) {
                    if (!this.initiator) {
                        SessionDescription sdp = new SessionDescription(SessionDescription.Type.fromCanonicalForm((String)type), json.getString("sdp"));
                        this.events.onRemoteDescription(sdp);
                    } else {
                        this.reportError("Received offer for call receiver: " + msg);
                    }
                } else if (type.equals("bye")) {
                    this.events.onChannelClose();
                } else {
                    this.reportError("Unexpected WebSocket message: " + msg);
                }
            } else if (errorText != null && errorText.length() > 0) {
                this.reportError("WebSocket error message: " + errorText);
            } else {
                this.reportError("Unexpected WebSocket message: " + msg);
            }
        }
        catch (JSONException e) {
            this.reportError("WebSocket message JSON parsing error: " + e.toString());
        }
    }

    @Override
    public void onWebSocketClose() {
        this.events.onChannelClose();
    }

    @Override
    public void onWebSocketError(String description) {
        this.reportError("WebSocket error: " + description);
    }

    private void reportError(final String errorMessage) {
        LogUtils.ELog((String)TAG, (String)errorMessage);
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (WebSocketRTCClient.this.roomState != ConnectionState.ERROR) {
                    WebSocketRTCClient.this.roomState = ConnectionState.ERROR;
                    WebSocketRTCClient.this.events.onChannelError(errorMessage);
                }
            }
        });
    }

    private static void jsonPut(JSONObject json, String key, Object value) {
        try {
            json.put(key, value);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private void sendPostMessage(final MessageType messageType, String url, String message) {
        String logInfo = url;
        if (message != null) {
            logInfo = logInfo + ". Message: " + message;
        }
        LogUtils.DLog((String)TAG, (String)("C->GAE: " + logInfo));
        AsyncHttpURLConnection httpConnection = new AsyncHttpURLConnection("POST", url, message, new AsyncHttpURLConnection.AsyncHttpEvents(){

            @Override
            public void onHttpError(String errorMessage) {
                WebSocketRTCClient.this.reportError("GAE POST error: " + errorMessage);
            }

            @Override
            public void onHttpComplete(String response) {
                if (messageType == MessageType.MESSAGE) {
                    try {
                        JSONObject roomJson = new JSONObject(response);
                        String result = roomJson.getString("result");
                        if (!result.equals("SUCCESS")) {
                            WebSocketRTCClient.this.reportError("GAE POST error: " + result);
                        }
                    }
                    catch (JSONException e) {
                        WebSocketRTCClient.this.reportError("GAE POST JSON error: " + e.toString());
                    }
                }
            }
        });
        httpConnection.send();
    }

    private JSONObject toJsonCandidate(IceCandidate candidate) {
        JSONObject json = new JSONObject();
        WebSocketRTCClient.jsonPut(json, "label", candidate.sdpMLineIndex);
        WebSocketRTCClient.jsonPut(json, "id", candidate.sdpMid);
        WebSocketRTCClient.jsonPut(json, "candidate", candidate.sdp);
        return json;
    }

    IceCandidate toJavaCandidate(JSONObject json) throws JSONException {
        return new IceCandidate(json.getString("id"), json.getInt("label"), json.getString("candidate"));
    }

    private static enum MessageType {
        MESSAGE,
        LEAVE;

    }

    private static enum ConnectionState {
        NEW,
        CONNECTED,
        CLOSED,
        ERROR;

    }
}

