/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business.webrtc.janusclientapi;

import android.net.Uri;
import com.koushikdutta.async.http.AsyncHttpClient;
import com.koushikdutta.async.http.AsyncHttpGet;
import com.koushikdutta.async.http.AsyncHttpPost;
import com.koushikdutta.async.http.AsyncHttpRequest;
import com.koushikdutta.async.http.AsyncHttpResponse;
import com.koushikdutta.async.http.body.AsyncHttpRequestBody;
import com.koushikdutta.async.http.body.JSONObjectBody;
import com.koushikdutta.async.http.callback.HttpConnectCallback;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusMessageObserver;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusMessenger;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusMessengerType;
import java.math.BigInteger;
import org.json.JSONObject;

public class JanusRestMessenger
implements IJanusMessenger {
    private final IJanusMessageObserver handler;
    private final String uri;
    private BigInteger session_id;
    private BigInteger handle_id;
    private String resturi;
    private final JanusMessengerType type = JanusMessengerType.restful;

    public void longPoll() {
        if (this.resturi.isEmpty()) {
            this.resturi = this.uri;
        }
        AsyncHttpGet get = new AsyncHttpGet(this.uri + "/" + this.session_id.toString() + "&maxev=1");
        AsyncHttpClient.getDefaultInstance().executeJSONObject((AsyncHttpRequest)get, new AsyncHttpClient.JSONObjectCallback(){

            public void onCompleted(Exception e, AsyncHttpResponse source, JSONObject result) {
                if (e == null) {
                    JanusRestMessenger.this.receivedMessage(result.toString());
                } else {
                    JanusRestMessenger.this.handler.onError(-1, e.getMessage());
                }
            }
        });
    }

    public JanusRestMessenger(String uri, IJanusMessageObserver handler) {
        this.handler = handler;
        this.uri = uri;
        this.resturi = "";
    }

    @Override
    public JanusMessengerType getMessengerType() {
        return this.type;
    }

    @Override
    public void connect() {
        AsyncHttpClient.getDefaultInstance().execute(this.uri, new HttpConnectCallback(){

            public void onConnectCompleted(Exception ex, AsyncHttpResponse response) {
                if (ex == null) {
                    JanusRestMessenger.this.handler.onOpen();
                } else {
                    JanusRestMessenger.this.handler.onError(-1, "Failed to connect");
                }
            }
        });
    }

    @Override
    public void disconnect() {
    }

    @Override
    public void sendMessage(String message) {
        LogUtils.DLog((String)"message", (String)("Sent: \n\t" + message));
        if (this.resturi.isEmpty()) {
            this.resturi = this.uri;
        }
        AsyncHttpRequest request = new AsyncHttpRequest(Uri.parse((String)this.resturi), "post");
        AsyncHttpPost post = new AsyncHttpPost(this.resturi);
        JSONObject obj = null;
        try {
            obj = new JSONObject(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
        post.setBody((AsyncHttpRequestBody)new JSONObjectBody(obj));
        AsyncHttpClient.getDefaultInstance().executeJSONObject((AsyncHttpRequest)post, new AsyncHttpClient.JSONObjectCallback(){

            public void onCompleted(Exception e, AsyncHttpResponse source, JSONObject result) {
                if (e == null) {
                    JanusRestMessenger.this.receivedMessage(result.toString());
                } else {
                    JanusRestMessenger.this.handler.onError(-1, result.toString());
                }
            }
        });
    }

    @Override
    public void sendMessage(String message, BigInteger session_id) {
        this.session_id = session_id;
        this.resturi = "";
        this.resturi = this.uri + "/" + session_id.toString();
        this.sendMessage(message);
    }

    @Override
    public void sendMessage(String message, BigInteger session_id, BigInteger handle_id) {
        this.session_id = session_id;
        this.handle_id = handle_id;
        this.resturi = "";
        this.resturi = this.uri + "/" + session_id.toString() + "/" + handle_id.toString();
        this.sendMessage(message);
    }

    private void handleNewMessage(String message) {
    }

    @Override
    public void receivedMessage(String msg) {
        try {
            LogUtils.DLog((String)"message", (String)("Recv: \n\t" + msg));
            JSONObject obj = new JSONObject(msg);
            this.handler.receivedNewMessage(obj);
        }
        catch (Exception ex) {
            this.handler.onError(-1, ex.getMessage());
        }
    }
}

