/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business.webrtc.janusclientapi;

import com.xdja.poc.sdk.business.webrtc.janusclientapi.IPluginHandleSendMessageCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.ITransactionCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusMessageType;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusSupportedPluginPackages;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.TransactionType;
import org.json.JSONException;
import org.json.JSONObject;

public class JanusSendPluginMessageTransaction
implements ITransactionCallbacks {
    private final IPluginHandleSendMessageCallbacks callbacks;

    public JanusSendPluginMessageTransaction(JanusSupportedPluginPackages plugin, IPluginHandleSendMessageCallbacks callbacks) {
        this.callbacks = callbacks;
    }

    @Override
    public TransactionType getTransactionType() {
        return TransactionType.plugin_handle_message;
    }

    @Override
    public void reportSuccess(JSONObject obj) {
        try {
            JanusMessageType type = JanusMessageType.fromString(obj.getString("janus"));
            switch (type) {
                case success: {
                    JSONObject plugindata = obj.getJSONObject("plugindata");
                    JanusSupportedPluginPackages plugin = JanusSupportedPluginPackages.fromString(plugindata.getString("plugin"));
                    JSONObject data = plugindata.getJSONObject("data");
                    if (plugin == JanusSupportedPluginPackages.JANUS_NONE) {
                        this.callbacks.onCallbackError("unexpected message: \n\t" + obj.toString());
                        break;
                    }
                    this.callbacks.onSuccessSynchronous(data);
                    break;
                }
                case ack: {
                    this.callbacks.onSuccesAsynchronous();
                    break;
                }
                default: {
                    this.callbacks.onCallbackError(obj.getJSONObject("error").getString("reason"));
                    break;
                }
            }
        }
        catch (JSONException ex) {
            this.callbacks.onCallbackError(ex.getMessage());
        }
    }
}

