/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.greendao.dao;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;
import com.xdja.poc.sdk.greendao.dao.DaoSession;
import com.xdja.poc.sdk.record.RecordMessage;
import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.AbstractDaoSession;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;
import org.greenrobot.greendao.internal.DaoConfig;

public class RecordMessageDao
extends AbstractDao<RecordMessage, String> {
    public static final String TABLENAME = "record_table";

    public RecordMessageDao(DaoConfig config) {
        super(config);
    }

    public RecordMessageDao(DaoConfig config, DaoSession daoSession) {
        super(config, (AbstractDaoSession)daoSession);
    }

    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists ? "IF NOT EXISTS " : "";
        db.execSQL("CREATE TABLE " + constraint + "\"record_table\" (\"RECORD_URI\" TEXT PRIMARY KEY NOT NULL ,\"RECORD_REMOTE_URL\" TEXT,\"RECORD_ROOM\" TEXT,\"RECORD_NAME\" TEXT,\"RECORD_SIZE\" TEXT,\"RECORD_TIME_LEN\" TEXT,\"RECORD_MESSAGE_ID\" TEXT);");
    }

    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"record_table\"";
        db.execSQL(sql);
    }

    protected final void bindValues(DatabaseStatement stmt, RecordMessage entity) {
        String recordMessageId;
        String recordTimeLen;
        String recordSize;
        String recordName;
        String recordRoom;
        String recordRemoteUrl;
        stmt.clearBindings();
        String recordUri = entity.getRecordUri();
        if (recordUri != null) {
            stmt.bindString(1, recordUri);
        }
        if ((recordRemoteUrl = entity.getRecordRemoteUrl()) != null) {
            stmt.bindString(2, recordRemoteUrl);
        }
        if ((recordRoom = entity.getRecordRoom()) != null) {
            stmt.bindString(3, recordRoom);
        }
        if ((recordName = entity.getRecordName()) != null) {
            stmt.bindString(4, recordName);
        }
        if ((recordSize = entity.getRecordSize()) != null) {
            stmt.bindString(5, recordSize);
        }
        if ((recordTimeLen = entity.getRecordTimeLen()) != null) {
            stmt.bindString(6, recordTimeLen);
        }
        if ((recordMessageId = entity.getRecordMessageId()) != null) {
            stmt.bindString(7, recordMessageId);
        }
    }

    protected final void bindValues(SQLiteStatement stmt, RecordMessage entity) {
        String recordMessageId;
        String recordTimeLen;
        String recordSize;
        String recordName;
        String recordRoom;
        String recordRemoteUrl;
        stmt.clearBindings();
        String recordUri = entity.getRecordUri();
        if (recordUri != null) {
            stmt.bindString(1, recordUri);
        }
        if ((recordRemoteUrl = entity.getRecordRemoteUrl()) != null) {
            stmt.bindString(2, recordRemoteUrl);
        }
        if ((recordRoom = entity.getRecordRoom()) != null) {
            stmt.bindString(3, recordRoom);
        }
        if ((recordName = entity.getRecordName()) != null) {
            stmt.bindString(4, recordName);
        }
        if ((recordSize = entity.getRecordSize()) != null) {
            stmt.bindString(5, recordSize);
        }
        if ((recordTimeLen = entity.getRecordTimeLen()) != null) {
            stmt.bindString(6, recordTimeLen);
        }
        if ((recordMessageId = entity.getRecordMessageId()) != null) {
            stmt.bindString(7, recordMessageId);
        }
    }

    public String readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getString(offset + 0);
    }

    public RecordMessage readEntity(Cursor cursor, int offset) {
        RecordMessage entity = new RecordMessage(cursor.isNull(offset + 0) ? null : cursor.getString(offset + 0), cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1), cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3), cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4), cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5), cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6));
        return entity;
    }

    public void readEntity(Cursor cursor, RecordMessage entity, int offset) {
        entity.setRecordUri(cursor.isNull(offset + 0) ? null : cursor.getString(offset + 0));
        entity.setRecordRemoteUrl(cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1));
        entity.setRecordRoom(cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2));
        entity.setRecordName(cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3));
        entity.setRecordSize(cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4));
        entity.setRecordTimeLen(cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5));
        entity.setRecordMessageId(cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6));
    }

    protected final String updateKeyAfterInsert(RecordMessage entity, long rowId) {
        return entity.getRecordUri();
    }

    public String getKey(RecordMessage entity) {
        if (entity != null) {
            return entity.getRecordUri();
        }
        return null;
    }

    public boolean hasKey(RecordMessage entity) {
        return entity.getRecordUri() != null;
    }

    protected final boolean isEntityUpdateable() {
        return true;
    }

    public static class Properties {
        public static final Property RecordUri = new Property(0, String.class, "recordUri", true, "RECORD_URI");
        public static final Property RecordRemoteUrl = new Property(1, String.class, "recordRemoteUrl", false, "RECORD_REMOTE_URL");
        public static final Property RecordRoom = new Property(2, String.class, "recordRoom", false, "RECORD_ROOM");
        public static final Property RecordName = new Property(3, String.class, "recordName", false, "RECORD_NAME");
        public static final Property RecordSize = new Property(4, String.class, "recordSize", false, "RECORD_SIZE");
        public static final Property RecordTimeLen = new Property(5, String.class, "recordTimeLen", false, "RECORD_TIME_LEN");
        public static final Property RecordMessageId = new Property(6, String.class, "recordMessageId", false, "RECORD_MESSAGE_ID");
    }
}

