/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.manager;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.PowerManager;

public class ScreenObserverManager {
    private OnScreenStateUpdateListener mOnScreenStateUpdateListener;
    private ScreenBroadcastReceiver mScreenBroadcastReceiver;
    private Context mContext;

    public ScreenObserverManager(Context context) {
        this.mContext = context;
        this.mScreenBroadcastReceiver = new ScreenBroadcastReceiver();
    }

    public void register(OnScreenStateUpdateListener listener) {
        this.registerListener();
        this.mOnScreenStateUpdateListener = listener;
        this.getScreenState();
    }

    public void unregister(OnScreenStateUpdateListener listener) {
        try {
            this.mContext.getApplicationContext().unregisterReceiver((BroadcastReceiver)this.mScreenBroadcastReceiver);
            this.mOnScreenStateUpdateListener = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void getScreenState() {
        PowerManager mPowerManager = (PowerManager)this.mContext.getSystemService("power");
        assert (mPowerManager != null);
        if (mPowerManager.isScreenOn()) {
            if (this.mOnScreenStateUpdateListener != null) {
                this.mOnScreenStateUpdateListener.onScreenOn();
            }
        } else if (this.mOnScreenStateUpdateListener != null) {
            this.mOnScreenStateUpdateListener.onScreenOff();
        }
    }

    private void registerListener() {
        try {
            if (this.mOnScreenStateUpdateListener != null) {
                this.unregister(null);
            }
            IntentFilter mIntentFilter = new IntentFilter();
            mIntentFilter.addAction("android.intent.action.SCREEN_ON");
            mIntentFilter.addAction("android.intent.action.SCREEN_OFF");
            mIntentFilter.addAction("android.intent.action.USER_PRESENT");
            this.mContext.getApplicationContext().registerReceiver((BroadcastReceiver)this.mScreenBroadcastReceiver, mIntentFilter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static interface OnScreenStateUpdateListener {
        public void onScreenOn();

        public void onScreenOff();

        public void onUserPresent();
    }

    private class ScreenBroadcastReceiver
    extends BroadcastReceiver {
        private ScreenBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.SCREEN_ON".equals(intent.getAction())) {
                ScreenObserverManager.this.mOnScreenStateUpdateListener.onScreenOn();
            } else if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                ScreenObserverManager.this.mOnScreenStateUpdateListener.onScreenOff();
            } else if ("android.intent.action.USER_PRESENT".equals(intent.getAction())) {
                ScreenObserverManager.this.mOnScreenStateUpdateListener.onUserPresent();
            }
        }
    }
}

