/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.record.fdfs;

import com.xdja.poc.common.utils.LogUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolManager {
    private static final String TAG = ThreadPoolManager.class.getSimpleName();
    private static final int KEEP_ALIVE_TIME = 1;
    private static final int MAX_EXECUTOR_THREADS = Runtime.getRuntime().availableProcessors() * 2 + 1;
    private static final int MAX_HTTP_THREADS = Runtime.getRuntime().availableProcessors() + 1;
    private static final int MAX_SCHEDULED_THREADS = Runtime.getRuntime().availableProcessors();
    private static final ThreadPoolManager INSTANCE = new ThreadPoolManager();
    private ExecutorService executorService;
    private ScheduledExecutorService scheduledExecutorService;
    private ExecutorService httpRequestExecutorService;
    private boolean init;

    public static ThreadPoolManager getInstance() {
        return INSTANCE;
    }

    public void init() {
        if (this.init) {
            LogUtils.DLog((String)TAG, (String)("init: already init. " + this));
            return;
        }
        this.init = true;
        LogUtils.DLog((String)TAG, (String)("init: " + this));
        this.executorService = new ThreadPoolExecutor(MAX_EXECUTOR_THREADS, MAX_EXECUTOR_THREADS, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new ThreadPoolExecutor.DiscardPolicy());
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(MAX_SCHEDULED_THREADS, new ThreadPoolExecutor.DiscardPolicy());
        this.httpRequestExecutorService = new ThreadPoolExecutor(MAX_HTTP_THREADS, MAX_HTTP_THREADS, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new ThreadPoolExecutor.DiscardPolicy());
    }

    public ExecutorService getHttpRequestExecutorService() {
        return this.httpRequestExecutorService;
    }

    public void execute(Runnable task) {
        this.submit(task);
    }

    public <T> Future<T> submit(Callable<T> task) {
        if (this.checkInvalidBeforeExec(task)) {
            return null;
        }
        return this.executorService.submit(task);
    }

    public Future<?> submit(Runnable task) {
        if (this.checkInvalidBeforeExec(task)) {
            return null;
        }
        return this.executorService.submit(task);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if (this.checkInvalidBeforeExec(command)) {
            return null;
        }
        return this.scheduledExecutorService.schedule(command, delay, unit);
    }

    private boolean checkInvalidBeforeExec(Object task) {
        if (task == null) {
            return true;
        }
        if (!this.init) {
            LogUtils.ELog((String)TAG, (String)"checkInvalidBeforeExec: not init");
            return true;
        }
        if (this.executorService.isShutdown()) {
            LogUtils.ELog((String)TAG, (String)"checkInvalidBeforeExec: executorService is shutdown");
            return true;
        }
        return false;
    }

    public void shutDown() {
        if (!this.init) {
            LogUtils.DLog((String)TAG, (String)("shutDown: already init. " + this));
            return;
        }
        this.init = false;
        LogUtils.DLog((String)TAG, (String)("shutDown: " + this));
        this.executorService.shutdownNow();
        this.scheduledExecutorService.shutdownNow();
        this.httpRequestExecutorService.shutdownNow();
    }
}

