/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.ui.conversion;

import android.app.ProgressDialog;
import android.content.Context;
import android.view.KeyEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xdja.poc.common.event.NetWorkConnectEvent;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ToastUtils;
import com.xdja.poc.common.utils.ViewUtils;
import com.xdja.poc.common.view.CircleImageView;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.business.MessageProxy;
import com.xdja.poc.sdk.business.bean.POCCallMessage;
import com.xdja.poc.sdk.business.ringplay.RingPlayer;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.event.DimissDialogEvent;
import com.xdja.poc.sdk.event.HomeOrRecentEvent;
import com.xdja.poc.sdk.event.POCChannelInfoResult;
import com.xdja.poc.sdk.proxy.POCUiKitProxyImpl;
import com.xdja.poc.sdk.ui.conversion.BaseScreenActivity;
import com.xdja.poc.sdk.utils.IPHost;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class ConversionCallWaitingActivity
extends BaseScreenActivity
implements View.OnClickListener {
    private LinearLayout llReject;
    private LinearLayout llAgree;
    private TextView tvUserName;
    private TextView tvCallDesc;
    private String mUserId;
    private POCCallMessage callMessage;
    private String senderUserId;
    private String roomId;
    private String ownerId;
    private String groupName;
    private String userName;
    private String memberIds;
    private Disposable mDisposable;
    public static int CALL_DELAY = 30;
    private ProgressDialog mProgressDialog;
    private CircleImageView circleImageView;

    protected int getTranslucentStatusBarColor() {
        return this.getResources().getColor(R.color.common_main_color);
    }

    @Override
    protected void initView() {
        super.initView();
        Constants.isReject = false;
        Constants.isScreenOn = true;
        CALL_DELAY = PreferenceHelper.getInt((String)"poc_call_waiting_time", (int)30);
        this.llReject = (LinearLayout)this.$(R.id.ll_reject);
        this.llAgree = (LinearLayout)this.$(R.id.ll_accept);
        this.tvUserName = (TextView)this.$(R.id.tv_user_name);
        this.tvCallDesc = (TextView)this.$(R.id.tv_call_desc);
        this.circleImageView = (CircleImageView)this.$(R.id.tv_user_avatar);
        this.userName = this.mUserId = PreferenceHelper.getString((String)"login_account", (String)"");
        this.callMessage = (POCCallMessage)this.getIntent().getSerializableExtra("intent_key_call_waiting_data");
        String icon = this.callMessage.getIcon();
        Map<String, POCMemberInfo> userInfo = POCUiKitProxyImpl.getInstance().getUserInfosCache();
        if (userInfo != null && userInfo.size() > 0 && userInfo.containsKey(this.callMessage.getUserId()) && !StringUtils.isEmpty((String)userInfo.get(this.callMessage.getUserId()).getName())) {
            this.callMessage.setUserName(userInfo.get(this.callMessage.getUserId()).getName());
            if (StringUtils.isEmpty((String)icon)) {
                icon = userInfo.get(this.callMessage.getUserId()).getIcon();
            }
            if (!StringUtils.isEmpty((String)icon)) {
                if (!icon.startsWith("http")) {
                    icon = IPHost.getMisServer() + icon;
                }
                ViewUtils.intoView((Context)this, (ImageView)this.circleImageView, (String)icon);
            }
        }
        this.senderUserId = this.callMessage.getUserId();
        this.ownerId = this.callMessage.getOwnerId();
        this.roomId = this.callMessage.getRoomId();
        this.memberIds = this.callMessage.getMemberIds();
        this.groupName = this.callMessage.getGroupName();
        this.tvUserName.setText((CharSequence)this.callMessage.getUserName());
        this.tvCallDesc.setText((CharSequence)this.getResources().getString(R.string.poc_start_call));
        RingPlayer.getInstance((Context)this).playIncomingRing(true, true);
        MessageProxy.sendSwitchMuteStatus(true);
        MessageProxy.updateNotificationCallMessage((Context)this, this.callMessage, true);
        EventBus.getDefault().post((Object)new DimissDialogEvent());
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    public void onScreenOn() {
        super.onScreenOn();
    }

    protected void initEvent() {
        this.llReject.setOnClickListener((View.OnClickListener)this);
        this.llAgree.setOnClickListener((View.OnClickListener)this);
        this.initPresenter();
        this.timerDelay(CALL_DELAY);
    }

    private void initPresenter() {
    }

    @Override
    protected void onPause() {
        super.onPause();
    }

    protected int generateLayout() {
        return R.layout.poc_activity_call_waiting;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.ll_reject) {
            Constants.isReject = true;
            POCUiKitProxyImpl.getInstance().notifyUserReject(this.senderUserId, this.roomId);
            this.finish();
        } else if (v.getId() == R.id.ll_accept) {
            this.showloading(this.getString(R.string.poc_get_channel_info));
            POCUiKitProxyImpl.getInstance().notifyUserAccepet(this.senderUserId, this.roomId, this.groupName);
            this.cancel();
            this.timerDelay(15);
        }
    }

    private void showloading(String message) {
        if (this.mProgressDialog == null) {
            this.mProgressDialog = new ProgressDialog((Context)this);
            this.mProgressDialog.setIndeterminateDrawable(this.getResources().getDrawable(R.drawable.poc_progressbar));
            this.mProgressDialog.setIndeterminate(true);
            this.mProgressDialog.setCancelable(false);
        }
        this.mProgressDialog.setMessage((CharSequence)message);
        if (this.mProgressDialog != null && !this.mProgressDialog.isShowing()) {
            this.mProgressDialog.show();
        }
    }

    public void hideLoading() {
        try {
            if (this.mProgressDialog != null && this.mProgressDialog.isShowing()) {
                this.mProgressDialog.dismiss();
            }
        }
        catch (Exception e) {
            LogUtils.ELog((Throwable)e);
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        MessageProxy.sendSwitchMuteStatus(false);
        this.cancel();
    }

    protected void onNetChanged(NetWorkConnectEvent netWorkConnectEvent) {
        super.onNetChanged(netWorkConnectEvent);
        if (!((Boolean)netWorkConnectEvent.getT()).booleanValue()) {
            ToastUtils.showToast((String)this.getResources().getString(R.string.common_net_failed));
            this.finish();
        }
    }

    private void timerDelay(int delay) {
        Observable.timer((long)delay, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new Observer<Long>(){

            public void onSubscribe(@NonNull Disposable d) {
                ConversionCallWaitingActivity.this.mDisposable = d;
            }

            public void onNext(@NonNull Long aLong) {
                POCUiKitProxyImpl.getInstance().notifyUserNoResponse(ConversionCallWaitingActivity.this.senderUserId, ConversionCallWaitingActivity.this.roomId);
            }

            public void onError(@NonNull Throwable e) {
                ConversionCallWaitingActivity.this.hideLoading();
                ConversionCallWaitingActivity.this.cancel();
                ConversionCallWaitingActivity.this.finish();
            }

            public void onComplete() {
                ConversionCallWaitingActivity.this.hideLoading();
                ConversionCallWaitingActivity.this.cancel();
                ConversionCallWaitingActivity.this.finish();
            }
        });
    }

    public void dealForceQuit() {
        POCUiKitProxyImpl.getInstance().notifyUserNoResponse(this.senderUserId, this.roomId);
        this.cancel();
    }

    private void cancel() {
        if (this.mDisposable != null && !this.mDisposable.isDisposed()) {
            this.mDisposable.dispose();
        }
        RingPlayer.getInstance((Context)this).release();
        MessageProxy.updateNotificationCallMessage((Context)this, this.callMessage, false);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onHomeKeyOrRecentKetEvent(HomeOrRecentEvent event) {
        MessageProxy.updateNotificationCallMessage((Context)this, this.callMessage, true);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onChnnelInfoEvent(POCChannelInfoResult channelInfoResult) {
        this.hideLoading();
        if (channelInfoResult != null && channelInfoResult.getT() != null && ((Boolean)channelInfoResult.getT()).booleanValue()) {
            this.finish();
        }
    }
}

