/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.ui.history;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.jude.easyrecyclerview.EasyRecyclerView;
import com.jude.easyrecyclerview.adapter.RecyclerArrayAdapter;
import com.xdja.poc.common.annotation.TitleViewAnnotation;
import com.xdja.poc.common.base.BaseActivity;
import com.xdja.poc.common.utils.NetUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ToastUtils;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.record.play.IPlayState;
import com.xdja.poc.sdk.record.play.ReceiverModeManger;
import com.xdja.poc.sdk.ui.history.HistoryVoicePlayer;
import com.xdja.poc.sdk.ui.history.POCHistoryMessage;
import com.xdja.poc.sdk.ui.history.POCHistoryMessageAdapter;
import com.xdja.poc.sdk.ui.main.mvp.POCHistoryMessageContract;
import com.xdja.poc.sdk.ui.main.mvp.POCHistoryMessagePresenter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@TitleViewAnnotation
public class POCHistoryMessageActivity
extends BaseActivity
implements POCHistoryMessageContract.IView {
    private EasyRecyclerView mRecyclerView;
    private POCHistoryMessageAdapter mAdapter;
    private POCHistoryMessagePresenter pocHistoryMessagePresenter;
    private static final String ROOM_ID = "roomId";
    private String roomId;
    private int pageSize = 15;
    private int currentPage = 1;
    private long syncTime = 0L;
    private LinearLayoutManager lm;
    private View moreView;
    private View errorView;
    private TextView tvError;
    private ProgressBar errorProgress;
    private boolean isLoading = false;
    private String currentLoadOrder;

    public static void startPOCHistoryMessageActivity(Context context, String roomId) {
        if (!PreferenceHelper.getBoolean((String)"poc_is_save_record", (boolean)true)) {
            ToastUtils.showToast((String)"\u6682\u4e0d\u652f\u6301\u5386\u53f2\u8bed\u97f3\u67e5\u770b");
            return;
        }
        Intent target = new Intent(context, POCHistoryMessageActivity.class);
        target.putExtra(ROOM_ID, roomId);
        context.startActivity(target);
    }

    protected int generateLayout() {
        return R.layout.poc_activity_history_message;
    }

    protected int getTranslucentStatusBarColor() {
        return this.getResources().getColor(R.color.common_main_color);
    }

    protected void initView() {
        this.roomId = this.getIntent().getStringExtra(ROOM_ID);
        if (StringUtils.isEmpty((String)this.roomId)) {
            this.finish();
            return;
        }
        this.initTitleBar();
        this.mRecyclerView = (EasyRecyclerView)this.findViewById(R.id.rv_history_message);
        this.lm = new LinearLayoutManager((Context)this);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.lm);
        this.mRecyclerView.getSwipeToRefresh().setColorSchemeResources(new int[]{R.color.common_main_color});
        this.mAdapter = new POCHistoryMessageAdapter((AppCompatActivity)this, (Context)this);
        this.moreView = View.inflate((Context)this, (int)R.layout.poc_history_message_view_more, null);
        this.errorView = View.inflate((Context)this, (int)R.layout.poc_view_history_message_loadmore_error, null);
        this.tvError = (TextView)this.errorView.findViewById(R.id.tv_error);
        this.errorProgress = (ProgressBar)this.errorView.findViewById(R.id.erro_progress);
        this.pocHistoryMessagePresenter = new POCHistoryMessagePresenter(this);
        new ReceiverModeManger().init((Activity)this, new IPlayState(){

            @Override
            public void start() {
            }

            @Override
            public void stop() {
                HistoryVoicePlayer.getInstance().releasePlay();
                HistoryVoicePlayer.getInstance().resetMessage();
                POCHistoryMessageActivity.this.mAdapter.notifyDataSetChanged();
            }
        });
    }

    private void initTitleBar() {
        this.getTitleBarView().setTile("\u5386\u53f2\u6d88\u606f");
        this.getTitleBarView().setBackgroundRecource(R.color.common_main_color);
        this.getTitleBarView().setLeftViewRecource(R.mipmap.common_back_n);
        this.getTitleBarView().setTitleColor(this.getResources().getColor(R.color.common_white_color));
        this.getTitleBarView().setTextSize(18);
        this.getTitleBarView().setLeftViewClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                POCHistoryMessageActivity.this.finish();
            }
        });
    }

    protected void initEvent() {
        this.mRecyclerView.setRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                POCHistoryMessage firstMessage;
                POCHistoryMessageActivity.this.syncTime = 0L;
                if (POCHistoryMessageActivity.this.mAdapter.getCount() > 0 && (firstMessage = (POCHistoryMessage)POCHistoryMessageActivity.this.mAdapter.getAllData().get(0)) != null) {
                    POCHistoryMessageActivity.this.syncTime = Long.valueOf(firstMessage.syncTime);
                }
                POCHistoryMessageActivity.this.loadData("up", POCHistoryMessageActivity.this.syncTime);
            }
        });
        this.mAdapter.setMore(this.moreView, new RecyclerArrayAdapter.OnLoadMoreListener(){

            public void onLoadMore() {
                POCHistoryMessageActivity.this.loadMore();
            }
        });
        this.mAdapter.setError(this.errorView, new RecyclerArrayAdapter.OnErrorListener(){

            public void onErrorShow() {
            }

            public void onErrorClick() {
                if (!NetUtils.isNetworkAvailable((Context)POCHistoryMessageActivity.this)) {
                    ToastUtils.showToast((String)POCHistoryMessageActivity.this.getResources().getString(R.string.common_net_failed));
                    return;
                }
                POCHistoryMessageActivity.this.mAdapter.resumeMore();
            }
        });
        this.mRecyclerView.getErrorView().findViewById(R.id.reload_btn).setOnClickListener(v -> {
            this.mRecyclerView.showProgress();
            this.syncTime = 0L;
            this.loadData("down", 0L);
        });
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mRecyclerView.getSwipeToRefresh().setEnabled(true);
        this.mRecyclerView.showProgress();
        this.loadData("down", 0L);
    }

    private void loadData(String order, long syncTime) {
        if (this.isLoading && !TextUtils.isEmpty((CharSequence)this.currentLoadOrder) && this.currentLoadOrder.equals(order)) {
            return;
        }
        this.isLoading = true;
        this.currentLoadOrder = order;
        this.pocHistoryMessagePresenter.syncHistoryMessage(order, this.pageSize, this.roomId, syncTime);
    }

    private void loadMore() {
        POCHistoryMessage lastMessage;
        if (this.mAdapter == null) {
            return;
        }
        List temp = this.mAdapter.getAllData();
        if (temp != null && temp.size() > 0 && (lastMessage = (POCHistoryMessage)temp.get(temp.size() - 1)) != null) {
            this.syncTime = Long.valueOf(lastMessage.getSyncTime());
            this.loadData("down", this.syncTime);
        }
    }

    @Override
    public void loadMessageSuccess(List<POCHistoryMessage> historyMessages, int totalRecord, boolean isHasServerData, boolean isToBottom) {
        this.mRecyclerView.setRefreshing(false);
        this.isLoading = false;
        if (!isHasServerData) {
            if (this.currentPage != -1) {
                ++this.currentPage;
            }
            if (this.mAdapter.getCount() == 0 && this.mAdapter.getCount() == 0) {
                this.mRecyclerView.showEmpty();
            }
            if (totalRecord != -1) {
                this.mAdapter.pauseMore();
            }
            this.errorProgress.setVisibility(8);
            this.tvError.setText((CharSequence)"\u5df2\u52a0\u8f7d\u5168\u90e8");
            return;
        }
        if (totalRecord == -1) {
            if (this.mAdapter.getCount() == 0 && historyMessages.size() > 0) {
                this.mAdapter.insertAll(historyMessages, 0);
                this.mAdapter.pauseMore();
                this.mRecyclerView.scrollToPosition(this.mAdapter.getCount());
                this.syncTime = Long.valueOf(historyMessages.get(historyMessages.size() - 1).getSyncTime());
                this.loadData("down", this.syncTime);
                return;
            }
            this.mAdapter.insertAll(historyMessages, 0);
            this.mRecyclerView.scrollToPosition(this.mAdapter.getCount());
            return;
        }
        List allData = this.mAdapter.getAllData();
        allData.addAll(historyMessages);
        Collections.sort(allData, new Comparator<POCHistoryMessage>(){

            @Override
            public int compare(POCHistoryMessage o1, POCHistoryMessage o2) {
                return o1.getSyncTime().compareTo(o2.getSyncTime());
            }
        });
        this.mAdapter.clear();
        this.mAdapter.addAll(allData);
        if (isToBottom) {
            this.mRecyclerView.scrollToPosition(this.mAdapter.getCount());
        }
    }

    @Override
    public void loadMessageFailed() {
        this.isLoading = false;
        this.mRecyclerView.setRefreshing(false);
        if (this.mAdapter.getCount() == 0) {
            this.mRecyclerView.showError();
            this.mAdapter.pauseMore();
            return;
        }
        ToastUtils.showToast((String)this.getResources().getString(R.string.common_net_failed));
        this.mAdapter.pauseMore();
        this.errorProgress.setVisibility(8);
        this.tvError.setText((CharSequence)"\u52a0\u8f7d\u5931\u8d25\uff0c\u70b9\u51fb\u91cd\u8bd5");
    }

    @Override
    public boolean isExist() {
        return !this.isFinishing();
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mAdapter != null) {
            this.mAdapter.stopAnim();
        }
    }

    protected void onPause() {
        super.onPause();
    }
}

