/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.ui.main.mvp;

import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import android.util.Log;
import android.util.Property;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.LinearInterpolator;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.jude.easyrecyclerview.adapter.RecyclerArrayAdapter;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ToastUtils;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.event.GroupEvent;
import com.xdja.poc.sdk.event.POCConverationTbcpStatusEvent;
import com.xdja.poc.sdk.event.POCConversationMeIncomeRoom;
import com.xdja.poc.sdk.event.POCConversationUserChangeEvent;
import com.xdja.poc.sdk.event.POCMemberEvent;
import com.xdja.poc.sdk.event.POCSelfLeaveEvent;
import com.xdja.poc.sdk.proxy.IPOCChannelInfoCallBack;
import com.xdja.poc.sdk.proxy.POCUiKitProxyImpl;
import com.xdja.poc.sdk.ui.main.mvp.POCConversationContract;
import com.xdja.poc.sdk.utils.GroupUtils;
import io.reactivex.disposables.Disposable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;

public class POCConversationPersenter
implements POCConversationContract.IPOCConversationPersenter {
    private static final String TAG = "POCConverationPersenter";
    private POCConversationContract.IPOCConversationView mView;
    private Context mContext;
    private DBGroupEntity group;
    private volatile boolean bWaitingTakenTBCP = false;
    private volatile boolean bWaitingReleaseTBCP = false;
    public volatile boolean bNeedReleaseTBCP = false;
    public boolean releaseStaus = false;
    private boolean releasedButAgainRequest = false;
    public volatile boolean bTakenTBCP = false;
    private final int TBCP_REQUEST_TIMEOUT = 1000;
    private AsyncTask<String, Void, List<POCMemberInfo>> searchTask = null;
    private int TotalCount = 0;
    private String roomId;
    private String mUserId;
    private String talkingUserID;
    private Handler handler = null;
    private static ValueAnimator animator;
    private ArrayList<POCMemberInfo> mSelectedMemberList;
    private volatile boolean bPressVolumeDown;
    private ProgressDialog mProgressDialog;
    private volatile boolean bPressTalk;
    public volatile boolean bPeopleTalking;
    private Disposable mDisposable;
    private Map<String, POCMemberInfo> mAccountToName = new HashMap<String, POCMemberInfo>();
    private int lastKeyCode = 0;
    private final int LAST_KEY_DOWN = 1;
    private final int LAST_KEY_UP = 2;
    HandlerThread tbcpTimeout;
    public IPOCChannelInfoCallBack pttEventCallBack = new IPOCChannelInfoCallBack(){

        @Override
        public void onPttKeyEvent(String channelId, boolean pttStatus) {
            if (POCConversationPersenter.this.group != null) {
                POCConversationPersenter.this.group.setIsPttKey(pttStatus ? 1 : 0);
            }
            if (POCConversationPersenter.this.mView != null) {
                POCConversationPersenter.this.mView.setPttKey(pttStatus);
            }
        }

        @Override
        public void onChannelNameEvent(String channelId, String channelName) {
            if (POCConversationPersenter.this.group != null) {
                POCConversationPersenter.this.group.setRoomName(channelName);
            }
            if (POCConversationPersenter.this.mView != null) {
                POCConversationPersenter.this.mView.setRoomName(channelName);
            }
        }

        @Override
        public void onChannelPwdEvent(String channelId, String channelPwd) {
            if (POCConversationPersenter.this.group != null) {
                POCConversationPersenter.this.group.setChannelPwd(channelPwd);
            }
            if (POCConversationPersenter.this.mView != null) {
                POCConversationPersenter.this.mView.setChannelPwd(channelPwd);
            }
        }

        @Override
        public void onChannelPwdModeEvent(String channelId, boolean channelPwdMode) {
            if (POCConversationPersenter.this.group != null) {
                POCConversationPersenter.this.group.setChannelPwdMode(channelPwdMode ? 1 : 0);
            }
            if (POCConversationPersenter.this.mView != null) {
                POCConversationPersenter.this.mView.setChannelPwdMode(channelPwdMode);
            }
        }
    };
    private Runnable connectRunnable = new Runnable(){

        @Override
        public void run() {
            LogUtils.ELog((String)POCConversationPersenter.TAG, (String)"try connect timeout ");
            POCConversationPersenter.this.mView.onConnectTimeOut();
        }
    };
    private Runnable requstTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            LogUtils.DLog((String)"[POC_LOG]", (String)"zlq timeoutRunnable.");
            POCConversationPersenter.this.resetButton(POCConversationPersenter.this.mContext.getString(R.string.poc_conversation_request_tbcp_timeout));
        }
    };
    private Runnable releaseTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            LogUtils.DLog((String)"[POC_LOG]", (String)"zlq timeoutRunnable.");
            POCConversationPersenter.this.resetButton(POCConversationPersenter.this.mContext.getString(R.string.poc_conversation_talk_status_free));
        }
    };

    public POCConversationPersenter(POCConversationContract.IPOCConversationView view, Context context, DBGroupEntity entity, Map<String, POCMemberInfo> userNameInfo) {
        this.mView = view;
        this.mContext = context;
        this.group = entity;
        this.roomId = entity.getRooomId();
        this.mUserId = PreferenceHelper.getString((String)"login_account", (String)"");
        this.mAccountToName = userNameInfo;
        if (this.mAccountToName == null) {
            this.mAccountToName = new HashMap<String, POCMemberInfo>();
        }
        if (this.handler != null) {
            this.handler = null;
        }
        this.tbcpTimeout = new HandlerThread("TbcpTimeout");
        this.tbcpTimeout.start();
        this.handler = new Handler(this.tbcpTimeout.getLooper());
        this.mSelectedMemberList = new ArrayList();
        this.delayCancel(false);
        this.initEvent();
    }

    private void initEvent() {
        POCUiKitProxyImpl.getInstance().addPttKeyEventCallBack(this.pttEventCallBack);
    }

    @Override
    public void resetAdapter(RecyclerArrayAdapter<POCMemberInfo> madapter) {
        this.mSelectedMemberList.clear();
        List allData = madapter.getAllData();
        for (POCMemberInfo info : allData) {
            info.setChecked(false);
        }
        madapter.notifyDataSetChanged();
    }

    @Override
    public void setSelectMemeber(RecyclerArrayAdapter<POCMemberInfo> mAdapter, int position) {
        if (position == -1) {
            LogUtils.ELog((String)TAG, (String)"setSelectMemeber: position=-1");
            return;
        }
        POCMemberInfo pocMemberInfo = (POCMemberInfo)mAdapter.getAllData().get(position);
        if (pocMemberInfo.isChecked()) {
            pocMemberInfo.setChecked(false);
            this.mView.searchNotifyMemberAdapterToUpdate(mAdapter, pocMemberInfo, false);
            if (this.mSelectedMemberList.size() >= 0) {
                this.mSelectedMemberList.remove(pocMemberInfo);
            }
        } else {
            pocMemberInfo.setChecked(true);
            this.mView.searchNotifyMemberAdapterToUpdate(mAdapter, pocMemberInfo, true);
            this.mSelectedMemberList.add(pocMemberInfo);
        }
        mAdapter.notifyItemChanged(position);
        this.mView.setSelectMember(this.mSelectedMemberList);
    }

    @Override
    public boolean requestTbcp(boolean isForce) {
        this.requestTbcp(false, isForce);
        this.bPressTalk = true;
        return true;
    }

    @Override
    public boolean releaseTbcp() {
        LogUtils.DLog((String)TAG, (String)("releaseTbcp  bPressVolumeDown= " + this.bPressVolumeDown));
        this.bPressTalk = false;
        return this.requestReleaseTbcp(false);
    }

    @Override
    public void hideSoftKeyboard(Activity activity, MotionEvent ev) {
        this.hideInputWhenTouchOtherView(activity, ev, activity.getCurrentFocus());
    }

    @Override
    public void startTalkAnimate(View target) {
        if (animator == null) {
            PropertyValuesHolder scaleX = PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{0.85f, 1.03f, 1.08f});
            PropertyValuesHolder scaleY = PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{0.85f, 1.03f, 1.08f});
            PropertyValuesHolder alpha = PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{1.0f, 0.7f, 0.4f});
            animator = ObjectAnimator.ofPropertyValuesHolder((Object)target, (PropertyValuesHolder[])new PropertyValuesHolder[]{scaleX, scaleY, alpha}).setDuration(1600L);
            animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            animator.setRepeatCount(-1);
            animator.setRepeatMode(1);
            animator.start();
        } else {
            this.releaseTalkAnimate(target);
            animator.start();
        }
    }

    @Override
    public void releaseTalkAnimate(View target) {
        if (animator != null) {
            animator.cancel();
            target.setScaleX(1.0f);
            target.setScaleY(1.0f);
            target.setAlpha(1.0f);
        }
    }

    @Override
    public void resetButton(final String talkStatus) {
        ((Activity)this.mContext).runOnUiThread(new Runnable(){

            @Override
            public void run() {
                LogUtils.ILog((String)"resetButton: timeoutRunnable is  timeout ");
                POCConversationPersenter.this.resetControlParmeter();
                POCConversationPersenter.this.mView.setTalkStatus(talkStatus);
                POCConversationPersenter.this.mView.resetButton();
                POCClient.releaseTBCP(POCConversationPersenter.this.roomId);
            }
        });
    }

    @Override
    public void sortAdapter(RecyclerArrayAdapter<POCMemberInfo> mMemberInfoAdapter) {
        List allData = mMemberInfoAdapter.getAllData();
        for (POCMemberInfo info : allData) {
            if (!StringUtils.isEmpty((String)info.getPinyin())) continue;
            info.setPinyin(GroupUtils.generatePinYin(info.getName()));
        }
        this.generateSortData(allData);
        mMemberInfoAdapter.clear();
        mMemberInfoAdapter.addAll((Collection)allData);
        mMemberInfoAdapter.notifyDataSetChanged();
    }

    private void generateSortData(List<POCMemberInfo> allData) {
        Collections.sort(allData, new Comparator<POCMemberInfo>(){

            @Override
            public int compare(POCMemberInfo o1, POCMemberInfo o2) {
                if (o1.isOnLine() && o2.isOnLine()) {
                    if (o1.getPinyin().equals("#") && !o2.getPinyin().equals("#")) {
                        return 1;
                    }
                    if (!o1.getPinyin().equals("#") && o2.getPinyin().equals("#")) {
                        return -1;
                    }
                    return o1.getPinyin().compareToIgnoreCase(o2.getPinyin());
                }
                if (o1.isOnLine()) {
                    return -1;
                }
                if (o2.isOnLine()) {
                    return 1;
                }
                if (o1.getPinyin().equals("#") && !o2.getPinyin().equals("#")) {
                    return 1;
                }
                if (!o1.getPinyin().equals("#") && o2.getPinyin().equals("#")) {
                    return -1;
                }
                return o1.getPinyin().compareToIgnoreCase(o2.getPinyin());
            }
        });
        POCMemberInfo selfInfo = null;
        for (POCMemberInfo info : allData) {
            if (!info.getAccount().equals(this.mUserId)) continue;
            selfInfo = info;
            allData.remove(info);
            break;
        }
        if (selfInfo != null) {
            allData.add(0, selfInfo);
        }
    }

    @Override
    public void subscribeRoomTbcpStatusChange(POCConverationTbcpStatusEvent receiverMessage) {
        if (!receiverMessage.getRoomId().equals(this.roomId)) {
            return;
        }
        GroupUtils.signSelfSpeakStatus(this.roomId, false);
        LogUtils.DLog((String)"[POC_LOG]", (String)("receiverMessage.getUserBehavior():" + receiverMessage.getUserBehavior()));
        switch (receiverMessage.getUserBehavior()) {
            case 2: {
                this.removeTimeoutRunnable("PocBroadReceiver.ROOM_OTHER_REQUEST_TBCP_SUCCESS");
                this.talkingUserID = receiverMessage.getUserId();
                this.bPeopleTalking = true;
                String speakerId = receiverMessage.getUserId();
                String speakerName = this.generateUserName(speakerId);
                if (speakerId.equals(this.mUserId)) {
                    GroupUtils.signSelfSpeakStatus(this.roomId, true);
                } else {
                    GroupUtils.signSelfSpeakStatus(this.roomId, false);
                }
                this.mView.resetReleaseStatus(true);
                this.mView.showSpeakStatus(speakerId, speakerName);
                LogUtils.DLog((String)TAG, (String)("other_request_tbcp  speakerId:\u3000" + speakerId + " speakerName: " + speakerName + " releaseStaus: " + this.releaseStaus));
                this.mView.roomOtherRequestTbcpSuccess(this.talkingUserID);
                this.releaseStaus = true;
                LogUtils.DLog((String)TAG, (String)("bWaitingTakenTBCP: " + this.bWaitingTakenTBCP));
                this.resetControlParmeter();
                break;
            }
            case 1: {
                this.removeTimeoutRunnable("PocBroadReceiver.ROOM_OTHER_RELEASE_TBCP_SUCCESS");
                this.mView.resetReleaseStatus(true);
                this.bPeopleTalking = false;
                this.resetControlParmeter();
                this.releaseStaus = true;
                this.mView.roomOtherReleaseTbcpSuccess();
                this.mView.setTalkStatus(this.mContext.getString(R.string.poc_conversation_talk_status_free));
                break;
            }
            case 1006: {
                this.mView.resetReleaseStatus(true);
                this.removeTimeoutRunnable("PocBroadReceiver.ROOM_RELEASE_TBCP_FAILED");
                this.bPeopleTalking = false;
                this.resetControlParmeter();
                this.mView.setTalkStatus(this.mContext.getString(R.string.poc_conversation_talk_status_free));
                this.mView.roomSelfReleaseTbcpFailed();
                String speakerId_ = receiverMessage.getUserId();
                break;
            }
            case 1005: {
                this.mView.resetReleaseStatus(true);
                this.removeTimeoutRunnable("PocBroadReceiver.ROOM_RELEASE_TBCP_SUCCESS");
                this.bPeopleTalking = false;
                this.resetControlParmeter();
                this.mView.setTalkStatus(this.mContext.getString(R.string.poc_conversation_talk_status_free));
                this.mView.roomSelfReleaseTbcpSuccess();
                this.releaseStaus = true;
                break;
            }
            case 1007: {
                this.releaseStaus = false;
                if (this.bWaitingReleaseTBCP) {
                    this.bNeedReleaseTBCP = true;
                    this.bWaitingReleaseTBCP = false;
                }
                this.removeTimeoutRunnable("PocBroadReceiver.ROOM_REQUEST_TBCP_SUCCESS");
                this.talkingUserID = receiverMessage.getUserId();
                this.bPeopleTalking = false;
                this.bWaitingTakenTBCP = false;
                this.bPressTalk = false;
                this.bTakenTBCP = true;
                this.mView.resetReleaseStatus(true);
                if (this.againReleaseTbcp()) {
                    return;
                }
                this.mView.showSpeakStatus(this.mUserId, "\u60a8");
                this.mView.roomSelfRequestTbcpSuccess(this.talkingUserID);
                List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.parseLong(this.roomId));
                this.mView.setOnLineCount(onLineMemberList != null ? onLineMemberList.size() : 0, this.TotalCount);
                break;
            }
            case 1008: {
                this.removeTimeoutRunnable("PocBroadReceiver.ROOM_REQUEST_TBCP_FAILED");
                if (!this.bPeopleTalking) {
                    this.mView.setTalkStatus(this.mContext.getString(R.string.poc_conversation_talk_status_free));
                    this.mView.resetButton();
                }
                this.bPeopleTalking = false;
                this.resetControlParmeter();
                this.mView.roomSelfRequestTbcpFailed();
                break;
            }
        }
    }

    private boolean againReleaseTbcp() {
        LogUtils.DLog((String)TAG, (String)("againReleaseTbcp bNeedReleaseTBCP : " + this.bNeedReleaseTBCP + " lastKeyCode:" + this.lastKeyCode));
        if (this.bNeedReleaseTBCP) {
            this.bNeedReleaseTBCP = false;
            this.bWaitingReleaseTBCP = true;
            this.mView.setTalkStatus(this.mContext.getString(R.string.poc_conversation_talk_status_free));
            this.mView.resetButton();
            POCClient.releaseTBCP(this.roomId);
            this.removeTimeoutRunnable("PocBroadReceiver.ROOM_REQUEST_TBCP_SUCCESS====bNeedReleaseTBCP");
            this.handler.postDelayed(this.releaseTimeoutRunnable, 1000L);
            return true;
        }
        return false;
    }

    private void resetStatus(String speakerId, String speakerName, String roomId) {
        Map<String, String> allSpeakers = POCClient.getAllSpeakers();
        if (allSpeakers != null && allSpeakers.containsKey(roomId)) {
            for (String userId : allSpeakers.keySet()) {
                if (TextUtils.isEmpty((CharSequence)userId) || userId.equals(this.mUserId)) continue;
                this.mView.showSpeakStatus(speakerId, speakerName);
                break;
            }
        }
    }

    public void resetControlParmeter() {
        this.bWaitingReleaseTBCP = false;
        this.bWaitingTakenTBCP = false;
        this.bTakenTBCP = false;
        this.bPressVolumeDown = false;
        this.bPressTalk = false;
        this.bPressVolumeDown = false;
        this.releaseStaus = false;
    }

    private void roomMute() {
    }

    @Override
    public void startNewConversionActivity() {
    }

    public void delayCancel(boolean isDestroy) {
        if (animator != null) {
            animator.cancel();
        }
        if (isDestroy && this.tbcpTimeout != null && this.tbcpTimeout.isAlive()) {
            this.tbcpTimeout.getLooper().quit();
        }
        animator = null;
        if (this.mDisposable != null && !this.mDisposable.isDisposed()) {
            this.mDisposable.dispose();
            this.mDisposable = null;
        }
        if (this.handler != null) {
            this.handler.removeCallbacks(this.connectRunnable);
        }
        LogUtils.DLog((String)TAG, (String)"delayCancel: removeCallbacks(connectRunnable)");
        POCUiKitProxyImpl.getInstance().removePttKeyEventCallBack(this.pttEventCallBack);
    }

    @Override
    public void subscribeSelfLeaveEvent(POCSelfLeaveEvent selfLeaveEvent) {
        String eventRoomId = selfLeaveEvent.getRoomId();
        if (this.roomId.equalsIgnoreCase(eventRoomId)) {
            this.mView.setTalkStatus(this.mContext.getResources().getString(R.string.poc_conversation_network_interrupt));
            this.mView.subscribeSelfLeaveEvent();
        }
    }

    @Override
    public void onMyPause() {
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
        }
        if (this.bTakenTBCP) {
            this.releaseTbcp();
        }
        ToastUtils.cancleToast();
        this.bPressVolumeDown = false;
        this.mView.onMyPause();
    }

    @Override
    public void subscribeSelfEnterRoom(POCConversationMeIncomeRoom pocConversationMeIncomeRoom) {
        LogUtils.DLog((String)TAG, (String)"subscribeSelfEnterRoom: removeCallbacks(connectRunnable)");
        if (!pocConversationMeIncomeRoom.getRoomId().equals(this.roomId)) {
            return;
        }
        try {
            if (TextUtils.isEmpty((CharSequence)pocConversationMeIncomeRoom.getMemberInfos())) {
                return;
            }
            this.roomMute();
            JSONArray array = new JSONArray(pocConversationMeIncomeRoom.getMemberInfos());
            for (int i = 0; i < array.length(); ++i) {
                String s = array.optString(i);
                if (!s.equals(this.mUserId)) continue;
                this.mView.setTalkStatus(this.mContext.getString(R.string.poc_conversation_talk_status_free));
                if (this.group != null && this.group.getStatus() == 2) {
                    this.mView.showSpeakStatus(null, this.group.getSpeakerUserName());
                } else {
                    this.mView.resetButton();
                }
                this.mView.updateOnLineMember();
                this.mView.subscribeSelfEnterRoom();
                break;
            }
        }
        catch (JSONException e) {
            LogUtils.ELog((String)TAG, (String)("subscribeSelfEnterRoom: e: " + e.getLocalizedMessage()));
        }
    }

    @Override
    public void subscribeUserChange(POCConversationUserChangeEvent event) {
        if (event != null && !event.getRoomId().equals(this.roomId)) {
            return;
        }
        assert (event != null);
        if (1 == event.getStatus()) {
            String speakerId = event.getUserId();
            String speakerName = this.generateUserName(speakerId);
            if (!StringUtils.isEmpty((String)speakerName)) {
                ToastUtils.showToast((String)String.format(this.mContext.getString(R.string.poc_conversation_who_has_enter_the_room), speakerName));
                this.mView.removeFromCallList(speakerId, "");
            }
        } else if (event.getStatus() == 0) {
            String speakerName = this.generateUserName(event.getUserId());
            if (!StringUtils.isEmpty((String)speakerName)) {
                this.mView.leaveRoom(speakerName);
                this.mView.removeFromCallList(event.getUserId(), "");
            }
            if (event.getUserId().equals(this.talkingUserID)) {
                this.mView.setTalkStatus(this.mContext.getString(R.string.poc_conversation_talk_status_free));
                this.mView.resetButton();
                this.mView.subscribeUserChange();
                this.bPressVolumeDown = false;
            }
        }
    }

    @Override
    public String generateUserName(String speakerId) {
        String speakerName = speakerId;
        if (this.mAccountToName != null && this.mAccountToName.size() > 0 && this.mAccountToName.containsKey(speakerId)) {
            speakerName = StringUtils.splitDisplayName((int)6, (String)this.mAccountToName.get(speakerId).getName());
        } else if (UserConfig.userNameMap != null && UserConfig.userNameMap.containsKey(this.roomId) && UserConfig.userNameMap.get(this.roomId) != null && UserConfig.userNameMap.get(this.roomId).containsKey(speakerId)) {
            POCMemberInfo info = UserConfig.userNameMap.get(this.roomId).get(speakerId);
            speakerName = info.getName();
            this.mAccountToName.put(speakerId, info);
        }
        return speakerName;
    }

    @Override
    public void handleTimeOut(String roomId) {
        this.handler.removeCallbacks(this.connectRunnable);
        this.handler.postDelayed(this.connectRunnable, 60000L);
    }

    @Override
    public void cancelConnectTimeOut() {
        if (this.handler != null) {
            this.handler.removeCallbacks(this.connectRunnable);
        }
        LogUtils.DLog((String)TAG, (String)"cancelConnectTimeOut: removeCallbacks(connectRunnable)");
    }

    @Override
    public synchronized void updateOnLineMember(POCMemberEvent event, List<POCMemberInfo> infos) {
        if (event != null && !event.getRoomId().equals(this.roomId)) {
            return;
        }
        List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.parseLong(this.roomId));
        if (onLineMemberList != null && onLineMemberList.size() > 0) {
            this.mView.setOnlineNumerCount(String.format(this.mContext.getString(R.string.poc_conversation_participants_count), String.valueOf(onLineMemberList.size()), String.valueOf(this.TotalCount)));
            this.mView.setOnLineCount(onLineMemberList.size(), this.TotalCount);
            if (event != null && !TextUtils.isEmpty((CharSequence)event.getMemberInfos())) {
                try {
                    JSONArray jsonArray = new JSONArray(event.getMemberInfos());
                    if (event.getUserBehavior() == 1) {
                        this.updateMemberStatus(infos, jsonArray, true);
                    } else if (event.getUserBehavior() == 0) {
                        this.updateMemberStatus(infos, jsonArray, false);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else {
                this.updateMemberStatus(onLineMemberList, infos);
            }
            this.mView.updateOnLineMember();
        } else {
            this.mView.updateOnLineMember();
        }
    }

    @Override
    public void setAdapterData() {
        List<POCMemberInfo> pocMemberInfos = POCClient.getInstance().generateStringToList(this.group.getMemeberIds());
        for (POCMemberInfo memberInfo : pocMemberInfos) {
            memberInfo.setPinyin(GroupUtils.generatePinYin(memberInfo.getName()));
            if (this.mAccountToName == null || !this.mAccountToName.containsKey(memberInfo.getAccount())) continue;
            POCMemberInfo info = this.mAccountToName.get(memberInfo.getAccount());
            memberInfo.setName(info.getName());
            if (memberInfo.getAccount().equals(this.mUserId)) {
                if (this.group.getStatus() == 0) {
                    memberInfo.setOnLine(false);
                } else {
                    memberInfo.setOnLine(true);
                }
            }
            memberInfo.setPinyin(GroupUtils.generatePinYin(memberInfo.getName()));
            if (!memberInfo.getAccount().equals(this.mUserId) || StringUtils.isEmpty((String)info.getIcon())) continue;
            memberInfo.setIcon(info.getIcon());
        }
        this.generateSortData(pocMemberInfos);
        this.mView.setAdapterData(pocMemberInfos);
        List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.parseLong(this.roomId));
        int onLineCount = 0;
        if (onLineMemberList != null) {
            onLineCount = onLineMemberList.size();
        }
        this.refreshAdapter(onLineCount, pocMemberInfos);
    }

    public void refreshAdapter(int onLineCount, List<POCMemberInfo> pocMemberInfos) {
        this.updateOnLineMember(null, pocMemberInfos);
        this.TotalCount = pocMemberInfos.size();
        this.mView.setOnlineNumerCount(String.format(this.mContext.getString(R.string.poc_conversation_participants_count), String.valueOf(onLineCount), String.valueOf(this.TotalCount)));
        this.mView.setOnLineCount(onLineCount, this.TotalCount);
    }

    @Override
    public void netChanged() {
        if (this.mSelectedMemberList != null && this.mSelectedMemberList.size() > 0) {
            this.mSelectedMemberList.clear();
        }
    }

    @Override
    public void deleteRoom(DBGroupEntity entity) {
        if (entity == null || entity.getOwnerId().equals(this.mUserId)) {
            // empty if block
        }
    }

    @Override
    public void addMembers(GroupEvent event) {
    }

    @Override
    public void updateMemberInfo(DBGroupEntity entity) {
        this.group = entity;
    }

    @Override
    public void setUserInfo(Map<String, POCMemberInfo> userInfosCache) {
        this.mAccountToName = userInfosCache;
    }

    @Override
    public void doSearch(String searchKey, List<POCMemberInfo> data) {
        if (this.searchTask != null) {
            this.searchTask.cancel(true);
            this.searchTask = null;
        }
        this.searchTask = new SearchTask(this, data).execute(new String[]{searchKey});
    }

    public void updateTotalCount(int size) {
        this.TotalCount = size;
    }

    public void setLastCode() {
    }

    private void updateMemberStatus(List<String> onLineMemberList, List<POCMemberInfo> allData) {
        if (allData == null) {
            return;
        }
        int onLineCount = 0;
        if (onLineMemberList != null) {
            onLineCount = onLineMemberList.size();
            block0: for (int i = 0; i < onLineMemberList.size(); ++i) {
                for (int j = 0; j < allData.size(); ++j) {
                    if (!onLineMemberList.get(i).equals(allData.get(j).getAccount())) continue;
                    allData.get(j).setOnLine(true);
                    continue block0;
                }
            }
        }
        this.TotalCount = allData.size();
        this.mView.setOnlineNumerCount(String.format(this.mContext.getString(R.string.poc_conversation_participants_count), String.valueOf(onLineCount), String.valueOf(this.TotalCount)));
        this.mView.setOnLineCount(onLineCount, this.TotalCount);
    }

    private void updateMemberStatus(List<POCMemberInfo> allData, JSONArray jsonArray, boolean isOnline) throws JSONException {
        if (allData == null) {
            return;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            for (int j = 0; j < allData.size(); ++j) {
                if (!jsonArray.getString(i).equals(allData.get(j).getAccount())) continue;
                allData.get(j).setOnLine(isOnline);
                if (this.mAccountToName == null || !this.mAccountToName.containsKey(allData.get(j).getAccount())) continue;
                allData.get(j).setName(this.mAccountToName.get(allData.get(j).getAccount()).getName());
                allData.get(j).setPinyin(GroupUtils.generatePinYin(allData.get(j).getName()));
            }
        }
    }

    public void removeTimeoutRunnable(String reason) {
        Log.d((String)"zlq", (String)("zlq remove timeoutRunnable.=====" + reason));
        this.handler.removeCallbacks(this.requstTimeoutRunnable);
        this.handler.removeCallbacks(this.releaseTimeoutRunnable);
    }

    private void hideInputWhenTouchOtherView(Activity activity, MotionEvent ev, View excludeViews) {
        if (ev.getAction() == 0) {
            InputMethodManager inputMethodManager;
            if (excludeViews != null && this.isTouchView(excludeViews, ev)) {
                return;
            }
            View v = activity.getCurrentFocus();
            if (this.isShouldHideInput(v, ev) && (inputMethodManager = (InputMethodManager)activity.getSystemService("input_method")) != null) {
                inputMethodManager.hideSoftInputFromWindow(v.getWindowToken(), 0);
            }
        }
    }

    private boolean isTouchView(View view, MotionEvent event) {
        if (view == null || event == null) {
            return false;
        }
        int[] leftTop = new int[]{0, 0};
        view.getLocationInWindow(leftTop);
        int left = leftTop[0];
        int top = leftTop[1];
        int bottom = top + view.getHeight();
        int right = left + view.getWidth();
        return event.getRawX() > (float)left && event.getRawX() < (float)right && event.getRawY() > (float)top && event.getRawY() < (float)bottom;
    }

    private boolean isShouldHideInput(View v, MotionEvent event) {
        return v != null && v instanceof EditText && !this.isTouchView(v, event);
    }

    private synchronized boolean requestTbcp(boolean value, boolean isForce) {
        this.lastKeyCode = 1;
        if (!isForce && this.bWaitingReleaseTBCP || this.bWaitingTakenTBCP || this.bPressTalk) {
            LogUtils.DLog((String)"[POC_LOG]", (String)("bWaitingReleaseTBCP:" + this.bWaitingReleaseTBCP + ", bWaitingTakenTBCP:" + this.bWaitingTakenTBCP + ", bNeedReleaseTBCP:" + this.bNeedReleaseTBCP + ", bPressTalk:" + this.bPressTalk));
            return false;
        }
        this.bWaitingTakenTBCP = true;
        POCClient.takenTBCP(this.roomId, isForce ? 1 : 0);
        this.removeTimeoutRunnable("requestTbcp");
        this.handler.postDelayed(this.requstTimeoutRunnable, 1000L);
        return value;
    }

    private synchronized boolean requestReleaseTbcp(boolean value) {
        this.lastKeyCode = 2;
        if (this.bWaitingReleaseTBCP || this.bWaitingTakenTBCP) {
            if (this.bWaitingTakenTBCP) {
                this.bNeedReleaseTBCP = true;
            }
            LogUtils.DLog((String)"[POC_LOG]", (String)("requestReleaseTbcp bWaitingReleaseTBCP:" + this.bWaitingReleaseTBCP + ", bWaitingTakenTBCP:" + this.bWaitingTakenTBCP + ", bNeedReleaseTBCP:" + this.bNeedReleaseTBCP + ", bPressTalk:" + this.bPressTalk));
            this.mView.resetReleaseStatus(false);
            return false;
        }
        if (!this.bTakenTBCP) {
            if (this.bPressTalk) {
                this.bNeedReleaseTBCP = true;
            }
            LogUtils.DLog((String)"[POC_LOG]", (String)("--bWaitingReleaseTBCP:" + this.bWaitingReleaseTBCP + ", bWaitingTakenTBCP:" + this.bWaitingTakenTBCP + ", bPressTalk:" + this.bPressTalk + ", bTakenTBCP:" + this.bTakenTBCP + ", bNeedReleaseTBCP:" + this.bNeedReleaseTBCP));
            this.mView.setTalkStatus(this.mContext.getString(R.string.poc_conversation_talk_status_free));
            this.mView.resetButton();
            this.mView.resetReleaseStatus(false);
            return false;
        }
        this.bWaitingReleaseTBCP = true;
        this.bPressVolumeDown = false;
        POCClient.releaseTBCP(this.roomId);
        this.removeTimeoutRunnable("requestReleaseTbcp");
        this.handler.postDelayed(this.releaseTimeoutRunnable, 1000L);
        return value;
    }

    private void showProgressDialog() {
        this.mProgressDialog = new ProgressDialog(this.mContext);
        this.mProgressDialog.setIndeterminateDrawable(this.mContext.getResources().getDrawable(R.drawable.poc_progressbar));
        this.mProgressDialog.setMessage((CharSequence)this.mContext.getString(R.string.poc_conversation_creating_room));
        this.mProgressDialog.setIndeterminate(true);
        this.mProgressDialog.setCancelable(false);
        if (this.mProgressDialog != null && !this.mProgressDialog.isShowing()) {
            this.mProgressDialog.show();
        }
    }

    private void hideProgressDialog() {
        if (this.mProgressDialog != null) {
            this.mProgressDialog.cancel();
            this.mProgressDialog = null;
        }
    }

    public void setGroup(DBGroupEntity group) {
        this.group = group;
    }

    private static class SearchTask
    extends AsyncTask<String, Void, List<POCMemberInfo>> {
        private WeakReference<POCConversationPersenter> mWefs;
        private List<POCMemberInfo> mData;

        public SearchTask(POCConversationPersenter chooseFriendsPresenter, List<POCMemberInfo> data) {
            this.mWefs = new WeakReference<POCConversationPersenter>(chooseFriendsPresenter);
            this.mData = data;
        }

        protected List<POCMemberInfo> doInBackground(String ... strings) {
            if (this.mWefs != null && this.mWefs.get() != null) {
                return GroupUtils.getPocConversationSearchResult(this.mData, strings[0]);
            }
            return null;
        }

        protected void onPostExecute(List<POCMemberInfo> pocGroups) {
            super.onPostExecute(pocGroups);
            if (this.mWefs != null && this.mWefs.get() != null) {
                POCConversationPersenter mPocConversation = (POCConversationPersenter)this.mWefs.get();
                mPocConversation.mView.getSearchResult(pocGroups);
            }
        }
    }
}

