/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.ui.main.mvp;

import com.xdja.net.RetrofitUtil;
import com.xdja.net.observer.CommonObserver;
import com.xdja.net.throwable.HttpThrowable;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.greendao.HistoryMessageDBHelper;
import com.xdja.poc.sdk.record.api.RecordBusiness;
import com.xdja.poc.sdk.record.api.bean.BaseRecordResponse;
import com.xdja.poc.sdk.record.api.bean.SynctimeMessageRequest;
import com.xdja.poc.sdk.ui.history.POCHistoryMessage;
import com.xdja.poc.sdk.ui.main.mvp.POCHistoryMessageContract;
import io.reactivex.Observer;
import java.util.List;

public class POCHistoryMessagePresenter
implements POCHistoryMessageContract.IPresenter {
    private static final String TAG = POCHistoryMessagePresenter.class.getSimpleName();
    private POCHistoryMessageContract.IView view;

    public POCHistoryMessagePresenter(POCHistoryMessageContract.IView view) {
        this.view = view;
    }

    @Override
    public void loadLocalMessage(String room, int pageSize, long synctime) {
        LogUtils.DLog((String)TAG, (String)"loadLocalMessage");
        List<POCHistoryMessage> result = HistoryMessageDBHelper.getInstance().getAllData(room);
        if (this.view != null && this.view.isExist()) {
            this.view.loadMessageSuccess(result, -1, true, true);
        }
    }

    @Override
    public void syncHistoryMessage(final String order, int pageSize, String room, long syncTime) {
        LogUtils.DLog((String)TAG, (String)"syncHistoryMessage");
        LogUtils.DLog((String)TAG, (String)("room = " + room + " order= " + order));
        SynctimeMessageRequest request = new SynctimeMessageRequest();
        request.setOrder(order);
        request.setPageSize(pageSize);
        request.setGroupUri(room);
        request.setSyncTime(syncTime);
        RetrofitUtil.request(RecordBusiness.gettTalkGroupMessageBySynctime(request), (Observer)new CommonObserver<BaseRecordResponse<List<POCHistoryMessage>>>(){

            public void onResult(BaseRecordResponse<List<POCHistoryMessage>> result) {
                if ("success".equals(result.getResult())) {
                    HistoryMessageDBHelper.getInstance().insertOrUpdate(result.getData());
                    if (POCHistoryMessagePresenter.this.view != null && POCHistoryMessagePresenter.this.view.isExist()) {
                        boolean isToBottom = !order.equals("up");
                        boolean isHasServerData = result.getData() != null && result.getData().size() > 0;
                        POCHistoryMessagePresenter.this.view.loadMessageSuccess(result.getData(), result.getTotalRecord(), isHasServerData, isToBottom);
                    }
                    return;
                }
                if (POCHistoryMessagePresenter.this.view != null && POCHistoryMessagePresenter.this.view.isExist()) {
                    POCHistoryMessagePresenter.this.view.loadMessageFailed();
                }
            }

            public void onError(HttpThrowable httpThrowable) {
                if (POCHistoryMessagePresenter.this.view != null && POCHistoryMessagePresenter.this.view.isExist()) {
                    POCHistoryMessagePresenter.this.view.loadMessageFailed();
                }
            }
        });
    }
}

