/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.utils;

import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PinyinUtil;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.db.entity.User;
import com.xdja.poc.sdk.proxy.POCUiKitProxyImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GroupUtils {
    @Deprecated
    public static int[] getMemberOnLineCount(String memeberIds) {
        List<POCMemberInfo> memberList;
        int[] mm = new int[2];
        int totalMemberCount = 0;
        int onLineMembersCount = 0;
        if (!StringUtils.isEmpty((String)memeberIds) && (memberList = POCClient.getInstance().generateStringToList(memeberIds)) != null && memberList.size() > 0) {
            totalMemberCount = memberList.size();
            for (POCMemberInfo info : memberList) {
                if (!info.isOnLine()) continue;
                ++onLineMembersCount;
            }
        }
        mm[0] = onLineMembersCount;
        mm[1] = totalMemberCount;
        return mm;
    }

    public static List<DBGroupEntity> getPocGroupMatchKey(List<DBGroupEntity> data, String keyWords) {
        ArrayList<DBGroupEntity> result = new ArrayList<DBGroupEntity>();
        try {
            for (DBGroupEntity group : data) {
                if (StringUtils.isEmpty((String)group.getRoomName()) || StringUtils.isEmpty((String)keyWords) || !group.getRoomName().contains(keyWords)) continue;
                result.add(group);
            }
            return result;
        }
        catch (Throwable throwable) {
            LogUtils.ELog((Throwable)throwable);
            return null;
        }
    }

    public static List<POCMemberInfo> getPocConversationSearchResult(List<POCMemberInfo> data, String keyWords) {
        ArrayList<POCMemberInfo> result = new ArrayList<POCMemberInfo>();
        try {
            for (POCMemberInfo group : data) {
                if (TextUtils.isEmpty((CharSequence)group.getName()) || !group.getName().contains(keyWords) && !group.getAccount().contains(keyWords) && !PinyinUtil.getPingYin((String)group.getName()).contains(keyWords) && !PinyinUtil.getFirstSpell((String)group.getName()).contains(keyWords)) continue;
                result.add(group);
            }
            return result;
        }
        catch (Throwable throwable) {
            LogUtils.ELog((Throwable)throwable);
            return null;
        }
    }

    public static String generatePOCGroupDbKey(String userId, String roomId) {
        if (StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)roomId)) {
            return "";
        }
        return userId + "_" + roomId;
    }

    @Deprecated
    public static String generateMemberInfos(POCMemberInfo group, String memeberIds) {
        boolean isContains = false;
        List<Object> mList = new ArrayList<POCMemberInfo>();
        if (!StringUtils.isEmpty((String)memeberIds)) {
            mList = POCClient.getInstance().generateStringToList(memeberIds);
            for (POCMemberInfo pOCMemberInfo : mList) {
                if (!pOCMemberInfo.getId().equalsIgnoreCase(group.getId())) continue;
                isContains = true;
                pOCMemberInfo.setOnLine(group.isOnLine());
            }
            if (!isContains) {
                mList.add(group);
            }
        } else {
            mList.add(group);
        }
        return POCClient.getInstance().generateListString(mList);
    }

    public static String generateMemberInfosListring(String memberIds, String roomId) {
        String result;
        if (StringUtils.isEmpty((String)memberIds)) {
            result = "";
        } else {
            String[] split;
            ArrayList memberInfoList = new ArrayList();
            ArrayList<POCMemberInfo> mList = new ArrayList<POCMemberInfo>();
            for (String string2 : split = memberIds.split(",")) {
                POCMemberInfo info = new POCMemberInfo();
                for (POCMemberInfo memberInfo : memberInfoList) {
                    if (!string2.equalsIgnoreCase(memberInfo.getAccount())) continue;
                    info.setMobile(memberInfo.getMobile());
                    info.setIcon(memberInfo.getIcon());
                    info.setDeptName(memberInfo.getDeptName());
                    info.setName(memberInfo.getName());
                    info.setImei(memberInfo.getImei());
                    break;
                }
                info.setId(string2);
                info.setRoomId(roomId);
                mList.add(info);
            }
            result = POCClient.getInstance().generateListString(mList);
        }
        LogUtils.ILog((String)("createRoom members: " + result));
        return result;
    }

    public static String generateTempGroupRoomId() {
        String timeStemp = String.valueOf(System.currentTimeMillis());
        return timeStemp;
    }

    public static String[] generateGroupMemberIdsAndTempRoomId(String mUserId, ArrayList<POCMemberInfo> mSelectedMemberList) {
        String[] strings = new String[2];
        StringBuilder sbUserId = new StringBuilder();
        StringBuilder roomNameSb = new StringBuilder();
        sbUserId.append(mUserId);
        String userName = PreferenceHelper.getString((String)"pref_key_userinfo_name", (String)"");
        roomNameSb.append(StringUtils.isEmpty((String)userName) ? mUserId : userName);
        if (mSelectedMemberList != null && mSelectedMemberList.size() > 0) {
            sbUserId.append(",");
            roomNameSb.append(",");
            for (int m = 0; m < mSelectedMemberList.size(); ++m) {
                sbUserId.append(mSelectedMemberList.get(m).getAccount());
                roomNameSb.append(mSelectedMemberList.get(m).getName());
                if (m >= mSelectedMemberList.size() - 1) continue;
                sbUserId.append(",");
                roomNameSb.append(",");
            }
        }
        strings[0] = sbUserId.toString();
        strings[1] = roomNameSb.toString();
        return strings;
    }

    public static String generateGroupMemberTempRoomName(ArrayList<POCMemberInfo> mSelectedMemberList) {
        Map<String, POCMemberInfo> userInfo = POCUiKitProxyImpl.getInstance().getUserInfosCache();
        StringBuilder roomNameSb = new StringBuilder();
        int size = mSelectedMemberList.size();
        if (size > 3) {
            size = 3;
        }
        for (int m = 0; m < size; ++m) {
            String name = userInfo != null && userInfo.containsKey(mSelectedMemberList.get(m).getAccount()) ? userInfo.get(mSelectedMemberList.get(m).getAccount()).getName() : mSelectedMemberList.get(m).getName();
            roomNameSb.append(name);
            if (m >= size - 1) continue;
            roomNameSb.append(",");
        }
        return roomNameSb.toString();
    }

    public static Map<String, String> generateStringToMap(String userNames) {
        return (Map)new Gson().fromJson(userNames, new TypeToken<Map<String, String>>(){}.getType());
    }

    public static Map<String, String> generateUserMap(List<User> usersList) {
        if (usersList == null) {
            return null;
        }
        HashMap<String, String> userMaps = new HashMap<String, String>();
        for (User user : usersList) {
            if (user == null) continue;
            if (!StringUtils.isEmpty((String)user.getNickName())) {
                userMaps.put(user.getAccount(), user.getNickName());
                continue;
            }
            userMaps.put(user.getAccount(), user.getName());
        }
        return userMaps;
    }

    public static boolean resetGroupStatus(DBGroupEntity entity) {
        List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.valueOf(entity.getRooomId()));
        entity.setStatus(0);
        return onLineMemberList != null && onLineMemberList.size() > 0;
    }

    public static List<String> jsonToList(String json) {
        if (TextUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            JSONArray array = new JSONArray(json);
            ArrayList<String> strings = new ArrayList<String>();
            for (int i = 0; i < array.length(); ++i) {
                JSONObject pub = array.getJSONObject(i);
                String userid = pub.getString("display");
                strings.add(userid);
            }
            return strings;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isMaxRoomCount() {
        List<String> onLineRoomCount = POCClient.getReconnectRoom();
        return onLineRoomCount != null && onLineRoomCount.size() >= 5;
    }

    public static String generatePinYin(DBGroupEntity entity) {
        String channelName = entity.getRoomName();
        String pinyin = PinyinUtil.getPingYin((String)channelName);
        if (StringUtils.isEmpty((String)pinyin)) {
            pinyin = "#";
        } else {
            String first = pinyin.substring(0, 1);
            if (!first.matches("[A-Za-z]")) {
                pinyin = "#";
            }
        }
        return pinyin;
    }

    public static String generatePinYin(String content) {
        String pinyin = PinyinUtil.getPingYin((String)content);
        if (StringUtils.isEmpty((String)pinyin)) {
            pinyin = "#";
        } else {
            String first = pinyin.substring(0, 1);
            if (!first.matches("[A-Za-z]")) {
                pinyin = "#";
            }
        }
        return pinyin;
    }

    public static String convertString(String content) {
        if (StringUtils.isEmpty((String)content)) {
            return "";
        }
        if (content.contains("\"null\"")) {
            String string2 = content.replaceAll("\"null\"", "null");
            return string2;
        }
        return content;
    }

    public static boolean isSelfSpeakButOnlyLisener(String roomId) {
        return Constants.isSelfRequestOnOtherDevice;
    }

    public static void signSelfSpeakStatus(String roomId, boolean b) {
        Constants.isSelfRequestOnOtherDevice = b;
    }
}

