/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.utils;

import android.app.Notification;
import android.content.Context;
import android.graphics.Color;
import android.support.v4.app.NotificationCompat;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.TextView;
import java.util.LinkedList;

public class POCNotificationUtils {
    private static final POCNotificationUtils INSTANCE = new POCNotificationUtils();

    private POCNotificationUtils() {
    }

    public static POCNotificationUtils getInstance() {
        return INSTANCE;
    }

    public boolean isDarkNotificationTheme(Context context) {
        return !this.isSimilarColor(-16777216, this.getNotificationColor(context));
    }

    private int getNotificationColor(Context context) {
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context);
        Notification notification = builder.build();
        int layoutId = notification.contentView.getLayoutId();
        ViewGroup viewGroup = (ViewGroup)LayoutInflater.from((Context)context).inflate(layoutId, null, false);
        if (viewGroup.findViewById(16908310) != null) {
            return ((TextView)viewGroup.findViewById(16908310)).getCurrentTextColor();
        }
        return POCNotificationUtils.findColor(viewGroup);
    }

    private boolean isSimilarColor(int baseColor, int color2) {
        int baseBlue;
        int baseGreen;
        int simpleBaseColor = baseColor | 0xFF000000;
        int simpleColor = color2 | 0xFF000000;
        int baseRed = Color.red((int)simpleBaseColor) - Color.red((int)simpleColor);
        double value = Math.sqrt(baseRed * baseRed + (baseGreen = Color.green((int)simpleBaseColor) - Color.green((int)simpleColor)) * baseGreen + (baseBlue = Color.blue((int)simpleBaseColor) - Color.blue((int)simpleColor)) * baseBlue);
        return value < 180.0;
    }

    private static int findColor(ViewGroup viewGroupSource) {
        int color2 = 0;
        LinkedList<ViewGroup> viewGroups = new LinkedList<ViewGroup>();
        viewGroups.add(viewGroupSource);
        while (viewGroups.size() > 0) {
            ViewGroup viewGroup1 = (ViewGroup)viewGroups.getFirst();
            for (int i = 0; i < viewGroup1.getChildCount(); ++i) {
                if (viewGroup1.getChildAt(i) instanceof ViewGroup) {
                    viewGroups.add((ViewGroup)viewGroup1.getChildAt(i));
                    continue;
                }
                if (!(viewGroup1.getChildAt(i) instanceof TextView) || ((TextView)viewGroup1.getChildAt(i)).getCurrentTextColor() == -1) continue;
                color2 = ((TextView)viewGroup1.getChildAt(i)).getCurrentTextColor();
            }
            viewGroups.remove(viewGroup1);
        }
        return color2;
    }
}

