package com.xdja.poc.sdk.business;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.Nullable;
import android.text.TextUtils;

import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.bean.GroupList;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.config.GroupConfig;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.db.manager.PocDaoGroupManager;
import com.xdja.poc.sdk.event.POCMuteEvent;
import com.xdja.poc.sdk.proxy.POCUiKitProxyImpl;
import com.xdja.poc.sdk.utils.GroupUtils;
import com.xdja.poc.sdk.utils.IPHost;

import org.greenrobot.eventbus.EventBus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * janus-gateway-android-master
 * 功能
 * 描述
 * created by Wwq : 2018/8/30
 */

@SuppressWarnings("ALL")
public class POCHandlerService extends IntentService {
    //    private static final String INSERT_OR_REPLACE_GROUP_DATA = "insert_or_replace_group_data";
    private static final String INSERT_OR_REPLACE_GROUP_DATA_LIST = "insert_or_replace_group_data_list";
    private static final String INSERT_OR_REPLACE_SINGLE_DATA = "insert_or_replace_single_data";
    //    private static final String INSERT_OR_REPLACE_TEMP_GROUP_DATA_LIST = "insert_or_replace_temp_group_data_list";
    private static final String UPDATE_MEMBER_INFOS = "update_member_infos";
    private static final String GET_ALL_POC_ROOM = "get_all_poc_room";
    private static final String UPDATE_GROUP_IS_SILENCE = "update_group_is_silence";
    public static final String UPDATE_GROUP_IS_TOP_STICK = "update_group_is_top_stick";
    private static final String DELETE_ROOM_BY_KEY = "delete_room_by_key";
    private static final String GROUP_TEMP_ENTITY = "group_temp_entity";

    private static final String DELETE_ROOM_BY_KEY_WITH_NOTIFY_UI = "delete_room_by_key_with_notify_ui";
    private static final String OWNERID = "owner_id";
    private static final String GROUP_DB_KEY = "group_db_key";
    private static final String GROUP_UI_POSITION = "group_ui_position";
    private static final String GROUP_SERVER_LIST = "group_server_list";
    private static final String DB_GROUP_LIST = "db_group_list";
    private static final String IS_PTT = "is_ptt";
    private static final String UPDATE_GROUP_IS_PTT = "update_group_is_ptt";
    private static final String UPDATE_GROUP_NAME = "update_group_name";
    private static final String GROUP_PWD = "group_pwd";
    private static final String UPDATE_GROUP_PWD = "update_group_pwd";
    private static final String GROUP_PWD_MODE = "group_pwd_mode";
    private static final String UPDATE_GROUP_PWD_MODE = "update_group_pwd_mode";
    private static final String INTENT_DB_CLEAR_CHANNEL_INFO = "intent_db_clear_channel_info";
    private static String TAG = "POCHandlerService";
    private static String USERID = "userId";
    private static String ROOMID = "roomId";
    private static String GROUP_NAME = "group_name";
    private static String IS_SILENCE = "isSilence";
    private static String IS_TOP_STICK = "is_top_stick";
    private static String GROUP = "group";
    private static String GROUP_JSON = "group_json";
    private static String MEMBER_INFOS = "member_infos";

    public POCHandlerService() {
        super("DBHandlerService");
    }

    @Override
    protected void onHandleIntent(@Nullable Intent intent) {
        if (intent == null || StringUtils.isEmpty(intent.getAction())) {
            return;
        }
        String userId = PreferenceHelper.getString(UserConfig.LOGIN_ACCOUNT, "");
        String roomId = intent.getStringExtra(ROOMID);
        switch (intent.getAction()) {
            case INSERT_OR_REPLACE_SINGLE_DATA:
                String groupJson = intent.getStringExtra(GROUP_JSON);
                break;
            case INSERT_OR_REPLACE_GROUP_DATA_LIST:
                ArrayList<GroupList.GroupData> severData = (ArrayList<GroupList.GroupData>) intent.getSerializableExtra(GROUP_SERVER_LIST);
                List<POCMemberInfo> memberInfoListTemp = new ArrayList<>();
                List<DBGroupEntity> mLocalList;
                ArrayList<DBGroupEntity> mDbEntity = new ArrayList<>();
                // 1 现获取本地数据
                mLocalList = PocDaoGroupManager.getInstance(POCHandlerService.this).getAllPocGroup(userId);
                // 2 服务端数据组装
                String mUserId = PreferenceHelper.getString(UserConfig.LOGIN_ACCOUNT, "");
                if (severData != null && severData.size() > 0) {
                    for (GroupList.GroupData groupData : severData) {
                        memberInfoListTemp.clear();
                        DBGroupEntity entity = new DBGroupEntity();
                        entity.setUserId(userId);
                        String roomId_ = groupData.getGroupUri();
                        entity.setRooomId(roomId_);
                        entity.setIsSilence(0);
                        entity.setGroupType(GroupConfig.STICK_GROUP);
                        entity.setOnLineCount(0);
                        entity.setMaxInviteMembersCount(StringUtils.isEmpty(groupData.getMaxInviteMembersCount()) ? 0 : Integer.valueOf(groupData.getMaxInviteMembersCount()));
                        entity.setChannelPwdMode(groupData.getIsPassword().equals("Y") ? 1 : 0);
                        entity.setChannelPwd(StringUtils.generateContent(groupData.getPassword()));
                        entity.setKey(GroupUtils.generatePOCGroupDbKey(userId, roomId_));
                        entity.setOwnerId(groupData.getOwner());
                        DBGroupEntity localEntity = null;
                        if (mLocalList != null && mLocalList.size() > 0) {
                            for (DBGroupEntity _entity : mLocalList) {
                                if (_entity.getRooomId().equals(entity.getRooomId())) {
                                    localEntity = _entity;
                                }
                            }
                        }
                        /**
                         *  3 本地数据不为空时,重新对服务端数据赋值
                         */
                        if (localEntity != null) {
                            entity.setIsSilence(localEntity.getIsSilence() ? 1 : 0);
                            entity.setTopStickTime(localEntity.getTopStickTime());
                            entity.setIsTopStick(localEntity.getIsTopStick() ? 1 : 0);
                            entity.setStatus(localEntity.getStatus());
                            entity.setIsPttKey(localEntity.getIsPttKey() ? 1 : 0);
                        }
                        for (GroupList.GroupMember member : groupData.getTalkGroupMembers()) {
                            POCMemberInfo memberInfo_ = new POCMemberInfo();
                            memberInfo_.setId(member.getMember());
                            memberInfo_.setOnLine(false);
                            memberInfo_.setRoomId(roomId_);
                            memberInfo_.setName(member.getName());
                            memberInfo_.setAccount(member.getMember());
                            memberInfo_.setRealName(member.getName());
                            if (!TextUtils.isEmpty(member.getIcon())) {
                                if (member.getIcon().startsWith("http")) {
                                    memberInfo_.setIcon(member.getIcon());
                                } else {
                                    memberInfo_.setIcon(IPHost.getMisServer() + member.getIcon());
                                }
                            } else {
                                memberInfo_.setIcon("");
                            }
                            memberInfoListTemp.add(memberInfo_);
                        }
                        entity.setRoomName(GroupUtils.convertString(groupData.getDisplayName()));
                        if (memberInfoListTemp.size() > 0) {
                            String s = POCClient.getInstance().generateListString(memberInfoListTemp);
                            entity.setMemeberIds(s);
                        }
                        mDbEntity.add(entity);
                    }
                } else {
                    if (mLocalList != null && mLocalList.size() > 0) {
                        mDbEntity = (ArrayList<DBGroupEntity>) mLocalList;
                    }
                }
                Map<String, POCMemberInfo> memberNameMaps = new HashMap<>();
                for (DBGroupEntity entity : mDbEntity) {
                    String memeberIds = entity.getMemeberIds();
                    List<POCMemberInfo> memberInfoList = POCClient.getInstance().generateStringToList(memeberIds);
                    for (POCMemberInfo info : memberInfoList) {
                        memberNameMaps.put(info.getAccount(), info);

                    }
                    UserConfig.userNameMap.put(entity.getRooomId(), memberNameMaps);
                    entity.setUserNames("");
                    entity.setPinyin(GroupUtils.generatePinYin(entity));
                    List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.parseLong(entity.getRooomId()));
                    entity.setOnLineCount(onLineMemberList == null ? 0 : onLineMemberList.size());
                    boolean b = GroupUtils.resetGroupStatus(entity);
                    entity.setStatus(b ? GroupConfig.GROUP_FREE : GroupConfig.GROUP_HANGUP);
                }
                /**
                 * 5 删除本地的数据
                 */
                if (mLocalList != null && mLocalList.size() > 0) {
                    for (DBGroupEntity entity : mLocalList) {
                        boolean isDelete = true;
                        for (DBGroupEntity _entity : mDbEntity) {
                            if (_entity.getRooomId().equals(entity.getRooomId())) {
                                isDelete = false;
                            }
                        }
                        if (isDelete) {
                            mDbEntity.remove(entity);
                            PocDaoGroupManager.getInstance(POCHandlerService.this).deleteGroup(entity.getKey());
                            LogUtils.DLog(TAG, "POCHandleService: removeFromReconnectCache roomId: " + roomId);
                            POCClient.removeFromReconnectCache(entity.getRooomId());
                            POCClient.leaveRoom(mUserId, entity.getRooomId());
                        }
                    }
                }
                /**
                 *  4 直接UI展示,其他耗时操作后续再做
                 */
                MessageProxy.sendGetPocAllRoom(mDbEntity);
                /**
                 *  6 插入/更新服务端数据
                 */
                if (mDbEntity.size() > 0) {
                    PocDaoGroupManager.getInstance(POCHandlerService.this).insertOrReplaceGroup(mDbEntity);
                }
                POCUiKitProxyImpl.getInstance().notifySubscribeTopic(mDbEntity);
                POCUiKitProxyImpl.getInstance().notifyChannelInfoInsertToDBFinished();
                break;
            case UPDATE_MEMBER_INFOS:
                break;
            case DELETE_ROOM_BY_KEY:
                String key1 = intent.getStringExtra(GROUP_DB_KEY);
                PocDaoGroupManager.getInstance(POCHandlerService.this).deleteGroup(key1);
                break;
            case DELETE_ROOM_BY_KEY_WITH_NOTIFY_UI:
                break;
            case GET_ALL_POC_ROOM:
                break;
            case UPDATE_GROUP_IS_SILENCE:
                boolean isSilence = intent.getBooleanExtra(IS_SILENCE, false);
                PocDaoGroupManager.getInstance(POCHandlerService.this).updateGroupIsSilence(userId, roomId, isSilence);
                POCMuteEvent pocMuteEvent = new POCMuteEvent();
                pocMuteEvent.setRoomId(roomId);
                pocMuteEvent.setSilence(isSilence);
                EventBus.getDefault().post(pocMuteEvent);
                break;
            case UPDATE_GROUP_IS_PTT:
                ArrayList<DBGroupEntity> entities = (ArrayList<DBGroupEntity>) intent.getSerializableExtra(DB_GROUP_LIST);
                boolean isPtt = intent.getBooleanExtra(IS_PTT, false);
                PocDaoGroupManager.getInstance(POCHandlerService.this).updateGroupIsPttKey(entities, userId, roomId, isPtt);
                break;
            case UPDATE_GROUP_IS_TOP_STICK:
                boolean isTopStick = intent.getBooleanExtra(IS_TOP_STICK, false);
                PocDaoGroupManager.getInstance(POCHandlerService.this).updateGroupIsTopStick(userId, roomId, isTopStick);
                break;
            case UPDATE_GROUP_NAME:
                String groupName = intent.getStringExtra(GROUP_NAME);
                PocDaoGroupManager.getInstance(POCHandlerService.this).updateGroupNanme(userId, roomId, groupName);
                break;
            case UPDATE_GROUP_PWD:
                String pwd = intent.getStringExtra(GROUP_PWD);
                PocDaoGroupManager.getInstance(POCHandlerService.this).updateGroupPwd(userId, roomId, pwd);
                break;
            case UPDATE_GROUP_PWD_MODE:
                boolean channelPwdMode = intent.getBooleanExtra(GROUP_PWD_MODE, false);
                PocDaoGroupManager.getInstance(POCHandlerService.this).updateGroupPwdMode(userId, roomId, channelPwdMode);
                break;
            case INTENT_DB_CLEAR_CHANNEL_INFO:
                PocDaoGroupManager.getInstance(POCHandlerService.this).clearChannelInfo(userId);
                break;
        }
    }

    /**
     * 异步数据库插入或更新频道数据
     *
     * @param context
     * @param json
     */
    public static void insertOrReplaceGroupData(Context context, String json) {
        LogUtils.ILog(TAG, "启动 insertOrReplaceGroupData service");
        Intent intent = new Intent(context.getApplicationContext(), POCHandlerService.class);
        intent.setAction(INSERT_OR_REPLACE_SINGLE_DATA);
        intent.putExtra(GROUP_JSON, json);
        context.startService(intent);
    }

    /**
     * 频道初始化插入数据到db
     *
     * @param context
     * @param groupEntities
     */
    public static void insertOrReplaceGroupData(Context context, ArrayList<GroupList.GroupData> groupEntities) {
        LogUtils.ILog(TAG, "启动 insertOrReplaceGroupData service");
        Intent intent = new Intent(context.getApplicationContext(), POCHandlerService.class);
        intent.setAction(INSERT_OR_REPLACE_GROUP_DATA_LIST);
        intent.putExtra(GROUP_SERVER_LIST, groupEntities);
        context.startService(intent);
    }

//    /**
//     * 异步数据库
//     * @param context
//     * @param userId
//     * @param roomId
//     * @param isJoin
//     */
//    public static void updateGoupJoinStatus(Context context, String userId, String roomId, boolean isJoin) {
//        LogUtils.ILog(TAG, "启动 updateGoupJoinStatus  service");
//        Intent intent = new Intent(context.getApplicationContext(), POCHandlerService.class);
//        intent.setAction(UPDATE_ISJOIN_GROUP_DATA);
//        intent.putExtra(USERID, userId);
//        intent.putExtra(ROOMID, roomId);
//        intent.putExtra("isJoin", isJoin);
//        context.startService(intent);
//    }

    //    /**
//     * 异步数据库更新成员状态信息
//     *
//     * @param context
//     * @param mUserId
//     * @param roomId
//     * @param memberInfo
//     */
//    public static void updateMemberInfos(Context context, String mUserId, String roomId, POCMemberInfo memberInfo, boolean event) {
//        LogUtils.ILog(TAG, "启动 updateMemberInfos  service" + memberInfo.isOnLine());
//        Intent intent = new Intent(context.getApplicationContext(), POCHandlerService.class);
//        intent.setAction(UPDATE_MEMBER_INFOS);
//        intent.putExtra(USERID, mUserId);
//        intent.putExtra(ROOMID, roomId);
//        intent.putExtra("userEvent", event);
//        intent.putExtra(MEMBER_INFOS, memberInfo);
//        context.startService(intent);
//    }
    public static void updateMemberInfos(Context context, String mUserId, String roomId, String memberInfos) {
        Intent intent = new Intent(context.getApplicationContext(), POCHandlerService.class);
        intent.setAction(UPDATE_MEMBER_INFOS);
        intent.putExtra(USERID, mUserId);
        intent.putExtra(ROOMID, roomId);
        String MEMBER_INFOS_STRING = "member_infos_string";
        intent.putExtra(MEMBER_INFOS_STRING, memberInfos);
        context.startService(intent);
    }


    /**
     * 获取该用户下的所有本地数据库的频道
     *
     * @param context
     * @param mUserId
     */
    public static void getAllPocRoom(Context context, String mUserId) {
//        Intent intent = new Intent(context.getApplicationContext(), POCHandlerService.class);
//        intent.setAction(GET_ALL_POC_ROOM);
//        intent.putExtra(USERID, mUserId);
//        context.startService(intent);
    }

    /**
     * 更新频道是否静音到数据库
     *
     * @param mContext
     * @param mUserId
     * @param rooomId
     * @param isSilence
     */
    public static void updateGroupIsSilence(Context mContext, String mUserId, String rooomId, boolean isSilence) {
        Intent intent = new Intent(mContext.getApplicationContext(), POCHandlerService.class);
        intent.setAction(UPDATE_GROUP_IS_SILENCE);
        intent.putExtra(USERID, mUserId);
        intent.putExtra(ROOMID, rooomId);
        intent.putExtra(IS_SILENCE, isSilence);
        mContext.startService(intent);
    }

    public static void updateGroupPttKey(Context mContext, ArrayList<DBGroupEntity> entityList, String mUserId, String channelId, boolean isPtt) {
        Intent intent = new Intent(mContext.getApplicationContext(), POCHandlerService.class);
        intent.setAction(UPDATE_GROUP_IS_PTT);
        intent.putExtra(USERID, mUserId);
        intent.putExtra(DB_GROUP_LIST, entityList);
        intent.putExtra(ROOMID, channelId);
        intent.putExtra(IS_PTT, isPtt);
        mContext.startService(intent);
    }

    /**
     * 更新频道是否置顶到数据库
     *
     * @param mContext
     * @param mUserId
     * @param rooomId
     * @param isStick
     */
    public static void updateGroupIsTopStick(Context mContext, String mUserId, String rooomId, boolean isStick) {
        Intent intent = new Intent(mContext.getApplicationContext(), POCHandlerService.class);
        intent.setAction(UPDATE_GROUP_IS_TOP_STICK);
        intent.putExtra(USERID, mUserId);
        intent.putExtra(ROOMID, rooomId);
        intent.putExtra(IS_TOP_STICK, isStick);
        mContext.startService(intent);
    }

//    public static void insertTempGroupData(Context context, DBGroupEntity entity) {
//        Intent intent = new Intent(context.getApplicationContext(), POCHandlerService.class);
//        intent.setAction(INSERT_OR_REPLACE_TEMP_GROUP_DATA_LIST);
//        intent.putExtra(GROUP_TEMP_ENTITY, entity);
//        context.startService(intent);
//
//    }

    /**
     * 通过主键删除本地频道数据
     *
     * @param key
     */
    public static void deleteRoomByRoomId(Context context, String key) {
        Intent intent = new Intent(context.getApplicationContext(), POCHandlerService.class);
        intent.setAction(DELETE_ROOM_BY_KEY);
        intent.putExtra(GROUP_DB_KEY, key);
        context.startService(intent);
    }

    public static void deleteRoomByIdWithNotifyUI(Context context, String userId, String roomId, int position) {
        Intent intent = new Intent(context.getApplicationContext(), POCHandlerService.class);
        intent.setAction(DELETE_ROOM_BY_KEY_WITH_NOTIFY_UI);
        intent.putExtra(GROUP_DB_KEY, GroupUtils.generatePOCGroupDbKey(userId, roomId));
        intent.putExtra(ROOMID, roomId);
        intent.putExtra(GROUP_UI_POSITION, position);
        context.startService(intent);
    }

    public static void updateGroupName(Context mContext, String mUserId, String channelId, String channelName) {
        Intent intent = new Intent(mContext, POCHandlerService.class);
        intent.setAction(UPDATE_GROUP_NAME);
        intent.putExtra(USERID, mUserId);
        intent.putExtra(GROUP_NAME, channelName);
        intent.putExtra(ROOMID, channelId);
        mContext.startService(intent);
    }

    public static void updateGroupPwd(Context mContext, String mUserId, String channelId, String channelPwd) {
        Intent intent = new Intent(mContext, POCHandlerService.class);
        intent.setAction(UPDATE_GROUP_PWD);
        intent.putExtra(USERID, mUserId);
        intent.putExtra(GROUP_PWD, channelPwd);
        intent.putExtra(ROOMID, channelId);
        mContext.startService(intent);
    }

    public static void updateGroupPwdMode(Context mContext, String mUserId, String channelId, boolean channelPwdMode) {
        Intent intent = new Intent(mContext, POCHandlerService.class);
        intent.setAction(UPDATE_GROUP_PWD_MODE);
        intent.putExtra(USERID, mUserId);
        intent.putExtra(GROUP_PWD_MODE, channelPwdMode);
        intent.putExtra(ROOMID, channelId);
        mContext.startService(intent);
    }

    /**
     * 清空该用户的频道信息
     *
     * @param mContext
     * @param mUserId
     */
    public static void clearChannelInfo(Context mContext, String mUserId) {
        Intent intent = new Intent(mContext, POCHandlerService.class);
        intent.setAction(INTENT_DB_CLEAR_CHANNEL_INFO);
        intent.putExtra(USERID, mUserId);
        mContext.startService(intent);

    }
}
