/*
 * Decompiled with CFR 0.152.
 */
package com.parfoismeng.slidebacklib;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.parfoismeng.slidebacklib.callback.SlideBackCallBack;
import com.parfoismeng.slidebacklib.widget.SlideBackIconView;

public class SlideBackManager {
    private Activity activity;
    private SlideBackCallBack callBack;
    private boolean isSideSlide = false;
    private float maxSlideLength;
    private SlideBackIconView slideBackIconView;

    @SuppressLint(value={"ClickableViewAccessibility"})
    SlideBackManager register(Activity activity, SlideBackCallBack callBack) {
        this.activity = activity;
        this.callBack = callBack;
        DisplayMetrics dm = activity.getResources().getDisplayMetrics();
        float screenWidth = dm.widthPixels;
        float screenHeight = dm.heightPixels;
        this.maxSlideLength = screenWidth / 13.0f;
        this.slideBackIconView = new SlideBackIconView((Context)activity);
        this.slideBackIconView.setBackViewColor(-16777216);
        this.slideBackIconView.setBackViewHeight(screenHeight / 4.0f);
        this.slideBackIconView.setArrowSize(this.dp2px(5.0f));
        this.slideBackIconView.setMaxSlideLength(this.maxSlideLength);
        FrameLayout container = (FrameLayout)activity.getWindow().getDecorView();
        container.addView((View)this.slideBackIconView);
        container.setOnTouchListener(new View.OnTouchListener(){
            private float downX = 0.0f;

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        this.downX = event.getRawX();
                        if (!(this.downX <= SlideBackManager.this.maxSlideLength)) break;
                        SlideBackManager.this.isSideSlide = true;
                        break;
                    }
                    case 2: {
                        if (this.downX == 0.0f) {
                            this.downX = event.getRawX();
                        }
                        if (this.downX <= SlideBackManager.this.maxSlideLength) {
                            SlideBackManager.this.isSideSlide = true;
                        }
                        if (!SlideBackManager.this.isSideSlide) break;
                        float moveX = event.getRawX() - this.downX;
                        if (Math.abs(moveX) <= SlideBackManager.this.maxSlideLength * 2.0f) {
                            SlideBackManager.this.slideBackIconView.updateSlideLength(Math.abs(moveX) / 2.0f);
                        }
                        SlideBackManager.this.setSlideBackPosition(SlideBackManager.this.slideBackIconView, (int)event.getRawY());
                        break;
                    }
                    case 1: {
                        if (SlideBackManager.this.isSideSlide && (double)event.getRawX() >= (double)SlideBackManager.this.maxSlideLength * 1.1 && null != SlideBackManager.this.callBack) {
                            SlideBackManager.this.callBack.onSlideBack();
                        }
                        SlideBackManager.this.isSideSlide = false;
                        SlideBackManager.this.slideBackIconView.updateSlideLength(0.0f);
                        this.downX = 0.0f;
                    }
                }
                return SlideBackManager.this.isSideSlide;
            }
        });
        return this;
    }

    void unregister() {
        this.activity = null;
        this.callBack = null;
        this.maxSlideLength = 0.0f;
        this.slideBackIconView = null;
    }

    public void setSlideBackPosition(SlideBackIconView view, int position) {
        int topMargin = (int)((float)position - view.getBackViewHeight() / 2.0f);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(view.getLayoutParams());
        layoutParams.topMargin = topMargin;
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public SlideBackIconView getSlideView() {
        return this.slideBackIconView;
    }

    public void updatePosition(float position) {
        if (this.slideBackIconView != null) {
            this.slideBackIconView.updateSlideLength(position);
        }
    }

    private float dp2px(float dpValue) {
        return dpValue * this.activity.getResources().getDisplayMetrics().density + 0.5f;
    }

    public void setSlideStatus(boolean status) {
        this.isSideSlide = status;
    }
}

