
package com.fri;

import android.util.Log;


public class ZDTokenApi {  
    

	final static boolean DBG = true;
	final static String TAG = "ZDTokenApi";
	
	static {
		try {
	        System.loadLibrary("ZDTokenApi");	
		} catch (UnsatisfiedLinkError e) {
			e.printStackTrace();
		}
    }
			    		
	public native String getVersion();
	
	// 初始化接口
	public native int Initialize();
	
	// 关闭接口
	public native int UnInitialize();
		
	public native String GetTFName();
	
	public native String GetDeviceId();
	
	// 读证书，
	public native byte[] LoadCert();
	
	// 私钥签名，要求已经完成填充，目前支持1024bitrsa，
	public native byte[] PrivateEncrypt(byte[] from, int nKeyLength, int padding);
	
	boolean mInit = false;
	
	public void TestApi()
	{
		// 要求首先进行初始化，否则会导致接口工作失败
		Initialize();
		
		log( "Initialize" );
		
		String name = GetTFName();

		log( "GetTFName " + name  );
		
		String deviceid = GetDeviceId();
		
		log( "Deviceid " + deviceid  );
	
		byte[] cert = LoadCert();

		log( "LoadCert " + cert.length  );
	
		byte[] hash = new byte[128];
		
		for( int i=0; i<128; i++ ){
			hash[i] = (byte)i;
		}
		
		byte[] sign = PrivateEncrypt( hash, 128, 0 );
		
		log( "PrivateEncrypt " + sign.length  );
		
		// 关闭接口
		UnInitialize();
	}
	
	
    private void log(String s) {
    	Log.d( TAG, s);
    }

    private void loge(String s) {
    	Log.e( TAG, s);
    }
    
    private static void slog(String s) {
    	Log.d( TAG, s);
    }

    private void loge(String s, Throwable e) {
    	Log.e( TAG, s);
    	e.printStackTrace();
    }
	
};